/*
 * Decompiled with CFR 0.152.
 */
package ru.untaba.utils.zip.core;

import ru.untaba.utils.zip.core.DeflaterEngine;
import ru.untaba.utils.zip.core.DeflaterPending;

public class Deflater {
    public static final int BEST_COMPRESSION = 9;
    public static final int BEST_SPEED = 1;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int NO_COMPRESSION = 0;
    public static final int DEFAULT_STRATEGY = 0;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int DEFLATED = 8;
    private int a;
    private boolean b;
    private int c;
    private long d;
    private DeflaterPending e;
    private DeflaterEngine f;

    public Deflater() {
        this(-1, false);
    }

    public Deflater(int n) {
        this(n, false);
    }

    public Deflater(int n, boolean bl) {
        if (n == -1) {
            n = 6;
        } else if (n < 0 || n > 9) {
            throw new IllegalArgumentException();
        }
        this.e = new DeflaterPending();
        this.f = new DeflaterEngine(this.e);
        this.b = bl;
        this.setStrategy(0);
        this.setLevel(n);
        this.reset();
    }

    public void reset() {
        this.c = this.b ? 16 : 0;
        this.d = 0L;
        this.e.reset();
        this.f.reset();
    }

    public void end() {
        this.f = null;
        this.e = null;
        this.c = 127;
    }

    public int getAdler() {
        return this.f.getAdler();
    }

    public int getTotalIn() {
        return (int)this.f.getTotalIn();
    }

    public long getBytesRead() {
        return this.f.getTotalIn();
    }

    public int getTotalOut() {
        return (int)this.d;
    }

    public long getBytesWritten() {
        return this.d;
    }

    void flush() {
        this.c |= 4;
    }

    public void finish() {
        this.c |= 0xC;
    }

    public boolean finished() {
        return this.c == 30 && this.e.isFlushed();
    }

    public boolean needsInput() {
        return this.f.needsInput();
    }

    public void setInput(byte[] byArray) {
        this.setInput(byArray, 0, byArray.length);
    }

    public void setInput(byte[] byArray, int n, int n2) {
        if ((this.c & 8) != 0) {
            throw new IllegalStateException("finish()/end() already called");
        }
        this.f.setInput(byArray, n, n2);
    }

    public void setLevel(int n) {
        if (n == -1) {
            n = 6;
        } else if (n < 0 || n > 9) {
            throw new IllegalArgumentException();
        }
        if (this.a != n) {
            this.a = n;
            this.f.setLevel(n);
        }
    }

    public void setStrategy(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        this.f.setStrategy(n);
    }

    public int deflate(byte[] byArray) {
        return this.deflate(byArray, 0, byArray.length);
    }

    public int deflate(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n2;
        if (this.c == 127) {
            throw new IllegalStateException("Deflater closed");
        }
        if (this.c < 16) {
            n3 = 0;
            n3 = this.a - 1 >> 1;
            if (n3 < 0 || n3 > 3) {
                n3 = 3;
            }
            n3 = 0x7800 | n3 << 6;
            if ((this.c & 1) != 0) {
                n3 |= 0x20;
            }
            n3 += 31 - n3 % 31;
            this.e.writeShortMSB(n3);
            if ((this.c & 1) != 0) {
                n3 = this.f.getAdler();
                this.f.resetAdler();
                this.e.writeShortMSB(n3 >> 16);
                this.e.writeShortMSB(n3 & 0xFFFF);
            }
            this.c = 0x10 | this.c & 0xC;
        }
        while (true) {
            n3 = this.e.flush(byArray, n, n2);
            n += n3;
            this.d += (long)n3;
            if ((n2 -= n3) == 0 || this.c == 30) break;
            if (this.f.deflate((this.c & 4) != 0, (this.c & 8) != 0)) continue;
            if (this.c == 16) {
                return n4 - n2;
            }
            if (this.c == 20) {
                if (this.a != 0) {
                    for (n3 = 8 + (-this.e.getBitCount() & 7); n3 > 0; n3 -= 10) {
                        this.e.writeBits(2, 10);
                    }
                }
                this.c = 16;
                continue;
            }
            if (this.c != 28) continue;
            this.e.alignToByte();
            if (!this.b) {
                n3 = this.f.getAdler();
                this.e.writeShortMSB(n3 >> 16);
                this.e.writeShortMSB(n3 & 0xFFFF);
            }
            this.c = 30;
        }
        return n4 - n2;
    }

    public void setDictionary(byte[] byArray) {
        this.setDictionary(byArray, 0, byArray.length);
    }

    public void setDictionary(byte[] byArray, int n, int n2) {
        if (this.c != 0) {
            throw new IllegalStateException();
        }
        this.c = 1;
        this.f.setDictionary(byArray, n, n2);
    }
}

