/*
 * Decompiled with CFR 0.152.
 */
package ru.untaba.utils.zip.core;

import java.io.OutputStream;
import ru.untaba.utils.zip.core.CRC32;
import ru.untaba.utils.zip.core.Deflater;
import ru.untaba.utils.zip.core.DeflaterOutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc = new CRC32();

    public GZIPOutputStream(OutputStream outputStream) {
        this(outputStream, 4096);
    }

    public GZIPOutputStream(OutputStream outputStream, int n) {
        super(outputStream, new Deflater(-1, true), n);
        int n2 = (int)(System.currentTimeMillis() / 1000L);
        byte[] byArray = new byte[]{31, -117, 8, 0, (byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), n2 >> 24, 0, -1};
        outputStream.write(byArray);
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        super.write(byArray, n, n2);
        this.crc.update(byArray, n, n2);
    }

    public void close() {
        this.finish();
        this.out.close();
    }

    public void finish() {
        super.finish();
        int n = this.def.getTotalIn();
        int n2 = (int)this.crc.getValue();
        byte[] byArray = new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), n2 >> 24, (byte)n, (byte)(n >> 8), (byte)(n >> 16), n >> 24};
        this.out.write(byArray);
    }
}

