/*
 * Decompiled with CFR 0.152.
 */
package athan.src.Client;

import athan.src.Client.Main;
import athan.src.Client.Menu;
import athan.src.Client.OptionForm;
import athan.src.Factory.ResourceReader;
import athan.src.Factory.ServiceFactory;
import athan.src.Outils.StringOutilClient;
import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.table.TableLayout;
import java.io.InputStream;
import java.util.Date;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class MainForm
extends Menu {
    private static final int HAUTEUR_LABEL_DATE = 18;
    private static final int HAUTEUR_LABEL_PRIERE = 12;
    private static final int HAUTEUR_LABEL_HEADER_PRIERE = 10;
    private static final int INTERVALLE_PREC_SUIV = 86400000;
    private static final int SCALE_GAP_UNITAIRE = 30;
    private static final int LABEL_GAP_UNITAIRE = 3;
    private static final int HEADER_LABEL_GAP_UNITAIRE = 3;
    private static final int HAUTEUR_BANNIERE = 160;
    private int mLabelGap = 0;
    private Date mHeureCourante;
    private Label mLabelLieu;
    private Command mCmdHomeHeureCourante;
    private Command mCmdDatePrecedente;
    private Label mLabelLibelleDate;
    private Label mLabelLibelleJourSemaine;
    private Label mLabelLibelleHeure;
    private Command mCmdDateSuivante;
    private Label mLabelHoraireImsak;
    private Label mLabelHoraireSohb;
    private Label mLabelHoraireChourouk;
    private Label mLabelHoraireDohr;
    private Label mLabelHoraireAsr;
    private Label mLabelHoraireMaghreb;
    private Label mLabelHoraireIshaa;
    private Main mMain;
    private Form currentForm;
    private ResourceReader RESOURCES = ServiceFactory.getFactory().getResourceReader();
    public boolean timerHeureCourante = true;

    private TableLayout.Constraint nouvelleContrainteListePrieres(TableLayout pTB) {
        return this.nouvelleContrainteListePrieres(pTB, 12 + this.mLabelGap);
    }

    private TableLayout.Constraint nouvelleContrainteListePrieres(TableLayout pTB, int pHauteur) {
        TableLayout.Constraint contrainte = pTB.createConstraint();
        contrainte.setHeightPercentage(pHauteur);
        contrainte.setWidthPercentage(50);
        return contrainte;
    }

    public MainForm(Main pMain) {
        this.mMain = pMain;
    }

    public static void setOptionForm(boolean pShow) {
        OptionForm optionForm = new OptionForm(Main.getMainForm());
        if (Main.getOptionForm() != null) {
            optionForm.setTransitionInAnimator(Main.getOptionForm().getTransitionInAnimator());
            optionForm.setTransitionOutAnimator(Main.getOptionForm().getTransitionOutAnimator());
        } else {
            optionForm.setTransitionOutAnimator(CommonTransitions.createFade(400));
        }
        optionForm.setMainForm(Main.icons);
        Main.setOptionForm(optionForm);
        if (pShow) {
            Main.getOptionForm().show();
        }
    }

    public String getName() {
        return ServiceFactory.getFactory().getResourceReader().get("ApplicationTitle");
    }

    public String getIconBaseName() {
        return "MenuAffichageCompas";
    }

    private void editerLabelLibelleDate(Label la) {
        la.setAlignment(4);
        la.setUIID("LabelCurrentDate");
        la.setFocusable(false);
        la.setPreferredH(18);
    }

    protected void execute(Form f) {
        f.setLayout(new BoxLayout(2));
        this.applyTactileSettings(f);
        this.mLabelLieu = new Label("");
        this.mLabelLieu.setAlignment(1);
        this.mLabelLieu.setFocusable(true);
        this.mLabelLieu.setUIID("LabelCurrentCity");
        this.mLabelLieu.getUnselectedStyle().setBgTransparency(0);
        this.mLabelLieu.getSelectedStyle().setBgTransparency(0);
        Container ctnVilleHome = new Container(new BorderLayout());
        ctnVilleHome.addComponent("West", (Component)this.mLabelLieu);
        ctnVilleHome.setPreferredH(30);
        this.mLabelLibelleDate = new Label();
        this.mLabelLibelleJourSemaine = new Label();
        this.mLabelLibelleHeure = new Label();
        this.editerLabelLibelleDate(this.mLabelLibelleDate);
        this.editerLabelLibelleDate(this.mLabelLibelleJourSemaine);
        this.editerLabelLibelleDate(this.mLabelLibelleHeure);
        Container ctnDates = new Container(new BoxLayout(2));
        ctnDates.addComponent(this.mLabelLibelleDate);
        ctnDates.addComponent(this.mLabelLibelleJourSemaine);
        ctnDates.addComponent(this.mLabelLibelleHeure);
        ctnDates.setPreferredH(69);
        this.mCmdHomeHeureCourante = new Command(this.RESOURCES.get("CurrentDay")){

            public void actionPerformed(ActionEvent ae) {
                try {
                    ServiceFactory.getFactory().getVuePrincipale().rafraichir(new Date(), true, true);
                    Main.demarrerTimer();
                    MainForm.this.cacherCmdHeureCourante();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        };
        this.mCmdDatePrecedente = new Command(this.RESOURCES.get("PrevDay")){

            public void actionPerformed(ActionEvent ae) {
                try {
                    Main.arreterTimer();
                    Date jourPrecedent = new Date(MainForm.this.mHeureCourante.getTime() - 86400000L);
                    if (StringOutilClient.isDateMemeJour(jourPrecedent, new Date())) {
                        ServiceFactory.getFactory().getVuePrincipale().rafraichir(new Date(), true, true);
                        Main.demarrerTimer();
                        MainForm.this.cacherCmdHeureCourante();
                    } else {
                        ServiceFactory.getFactory().getVuePrincipale().rafraichir(jourPrecedent, false, true);
                        MainForm.this.montrerCmdHeureCourante();
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        };
        this.mCmdDateSuivante = new Command(this.RESOURCES.get("NextDay")){

            public void actionPerformed(ActionEvent ae) {
                try {
                    Main.arreterTimer();
                    Date jourSuivant = new Date(MainForm.this.mHeureCourante.getTime() + 86400000L);
                    if (StringOutilClient.isDateMemeJour(jourSuivant, new Date())) {
                        ServiceFactory.getFactory().getVuePrincipale().rafraichir(new Date(), true, true);
                        Main.demarrerTimer();
                        MainForm.this.cacherCmdHeureCourante();
                    } else {
                        ServiceFactory.getFactory().getVuePrincipale().rafraichir(jourSuivant, false, true);
                        MainForm.this.montrerCmdHeureCourante();
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        };
        TableLayout tbCtnPrieres = new TableLayout(8, 2);
        Container ctnPrieres = new Container();
        ctnPrieres.setLayout(tbCtnPrieres);
        this.mLabelHoraireImsak = new Label("");
        this.mLabelHoraireImsak.setAlignment(3);
        this.mLabelHoraireSohb = new Label("");
        this.mLabelHoraireSohb.setAlignment(3);
        this.mLabelHoraireChourouk = new Label("");
        this.mLabelHoraireChourouk.setAlignment(3);
        this.mLabelHoraireDohr = new Label("");
        this.mLabelHoraireDohr.setAlignment(3);
        this.mLabelHoraireAsr = new Label("");
        this.mLabelHoraireAsr.setAlignment(3);
        this.mLabelHoraireMaghreb = new Label("");
        this.mLabelHoraireMaghreb.setAlignment(3);
        this.mLabelHoraireIshaa = new Label("");
        this.mLabelHoraireIshaa.setAlignment(3);
        boolean isImsakSelected = this.isImsakSelected();
        boolean isChouroukSelected = this.isChouroukSelected();
        int scaleGap = 0;
        this.mLabelGap = 0;
        int headerGap = 0;
        if (!isImsakSelected) {
            scaleGap += 30;
            this.mLabelGap += 3;
            headerGap += 3;
        }
        if (!isChouroukSelected) {
            scaleGap += 30;
            this.mLabelGap += 3;
            headerGap += 3;
        }
        ctnPrieres.addComponent(this.nouvelleContrainteListePrieres(tbCtnPrieres, 10 - headerGap), (Component)new Label());
        ctnPrieres.addComponent(this.nouvelleContrainteListePrieres(tbCtnPrieres, 10 - headerGap), (Component)new Label());
        if (isImsakSelected) {
            ctnPrieres.addComponent(this.nouvelleContrainteListePrieres(tbCtnPrieres), (Component)this.renvoyerLabelNomPriere(this.RESOURCES.get("Imsak")));
            ctnPrieres.addComponent(this.nouvelleContrainteListePrieres(tbCtnPrieres), (Component)this.mLabelHoraireImsak);
        }
        ctnPrieres.addComponent(this.nouvelleContrainteListePrieres(tbCtnPrieres), (Component)this.renvoyerLabelNomPriere(this.RESOURCES.get("Sobh")));
        ctnPrieres.addComponent(this.nouvelleContrainteListePrieres(tbCtnPrieres), (Component)this.mLabelHoraireSohb);
        if (isChouroukSelected) {
            ctnPrieres.addComponent(this.nouvelleContrainteListePrieres(tbCtnPrieres), (Component)this.renvoyerLabelNomPriere(this.RESOURCES.get("Chourouk")));
            ctnPrieres.addComponent(this.nouvelleContrainteListePrieres(tbCtnPrieres), (Component)this.mLabelHoraireChourouk);
        }
        ctnPrieres.addComponent(this.nouvelleContrainteListePrieres(tbCtnPrieres), (Component)this.renvoyerLabelNomPriere(this.RESOURCES.get("Dohr")));
        ctnPrieres.addComponent(this.nouvelleContrainteListePrieres(tbCtnPrieres), (Component)this.mLabelHoraireDohr);
        ctnPrieres.addComponent(this.nouvelleContrainteListePrieres(tbCtnPrieres), (Component)this.renvoyerLabelNomPriere(this.RESOURCES.get("Asr")));
        ctnPrieres.addComponent(this.nouvelleContrainteListePrieres(tbCtnPrieres), (Component)this.mLabelHoraireAsr);
        ctnPrieres.addComponent(this.nouvelleContrainteListePrieres(tbCtnPrieres), (Component)this.renvoyerLabelNomPriere(this.RESOURCES.get("Maghreb")));
        ctnPrieres.addComponent(this.nouvelleContrainteListePrieres(tbCtnPrieres), (Component)this.mLabelHoraireMaghreb);
        ctnPrieres.addComponent(this.nouvelleContrainteListePrieres(tbCtnPrieres), (Component)this.renvoyerLabelNomPriere(this.RESOURCES.get("Ishaa")));
        ctnPrieres.addComponent(this.nouvelleContrainteListePrieres(tbCtnPrieres), (Component)this.mLabelHoraireIshaa);
        ctnPrieres.setPreferredH(100);
        Image imgBdLeft = Main.icons.getImage("Border_left").scaled(-1, 160 - scaleGap);
        Image imgBdRight = Main.icons.getImage("Border_right").scaled(-1, 160 - scaleGap);
        Container ctnPrieresEtContour = new Container(new BorderLayout());
        ctnPrieresEtContour.addComponent("West", (Component)new Label(imgBdLeft));
        ctnPrieresEtContour.addComponent("Center", (Component)ctnPrieres);
        ctnPrieresEtContour.addComponent("East", (Component)new Label(imgBdRight));
        f.addComponent(ctnVilleHome);
        f.addComponent(ctnDates);
        f.addComponent(ctnPrieresEtContour);
        if (!Main.isTactile()) {
            // empty if block
        }
        int posCmd = 0;
        f.addCommand(this.mCmdDatePrecedente, posCmd++);
        f.addCommand(this.mCmdDateSuivante, posCmd++);
        f.addCommand(Main.optionsCommand, posCmd++);
        f.addCommand(Main.minimizeCommand, posCmd++);
        f.addCommand(Main.websiteCommand, posCmd++);
        f.addCommand(Main.exitCommand, posCmd++);
        f.setBackCommand(Main.exitCommand);
        this.currentForm = f;
    }

    public void montrerCmdHeureCourante() {
        this.currentForm.addCommand(this.mCmdHomeHeureCourante, 0);
    }

    public void cacherCmdHeureCourante() {
        this.currentForm.removeCommand(this.mCmdHomeHeureCourante);
    }

    private boolean isImsakSelected() {
        boolean ret = false;
        try {
            ret = StringOutilClient.getValeurBooleenne(Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("displayImsak")));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return ret;
    }

    private boolean isChouroukSelected() {
        boolean ret = false;
        try {
            ret = StringOutilClient.getValeurBooleenne(Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("displayChourouk")));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return ret;
    }

    private Label renvoyerLabelNomPriere(String pNomPriere) {
        Label retour = new Label(pNomPriere);
        retour.setUIID("LabelPrayerName");
        retour.getUnselectedStyle().setBgTransparency(0);
        retour.getSelectedStyle().setBgTransparency(0);
        retour.setFocusable(true);
        return retour;
    }

    public void traiterAlarme(String pPreferenceKey) {
        String alertMode = ServiceFactory.getFactory().getPreferences().get("alertMode");
        if (!alertMode.equals("N")) {
            if (alertMode.equals("V")) {
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        for (int nbFlashs = 0; nbFlashs < 5; ++nbFlashs) {
                            try {
                                Display.getInstance().flashBacklight(500);
                                4 var2_2 = this;
                                synchronized (var2_2) {
                                    this.wait(1000L);
                                    continue;
                                }
                            }
                            catch (Exception exc) {
                                exc.printStackTrace();
                            }
                        }
                    }
                }).start();
            } else if (alertMode.equals("S")) {
                String urlSon = ServiceFactory.getFactory().getPreferences().get("alertFile");
                if (StringOutilClient.isEmpty(urlSon)) {
                    return;
                }
                String musicEncoding = "";
                musicEncoding = urlSon.endsWith(".wav") ? "audio/x-wav" : "audio/mp3";
                try {
                    FileConnection fc = (FileConnection)Connector.open((String)urlSon, (int)1);
                    InputStream inputStream = fc.openInputStream();
                    final Player musicPlayer = Manager.createPlayer((InputStream)inputStream, (String)musicEncoding);
                    musicPlayer.prefetch();
                    musicPlayer.addPlayerListener(new PlayerListener(){

                        public void playerUpdate(Player player, String event, Object eventData) {
                            if (event.equals("endOfMedia")) {
                                MainForm.this.currentForm.showBack();
                            }
                        }
                    });
                    VolumeControl volumeControl = (VolumeControl)musicPlayer.getControl("VolumeControl");
                    if (volumeControl != null) {
                        volumeControl.setLevel(100);
                    }
                    musicPlayer.start();
                    volumeControl = (VolumeControl)musicPlayer.getControl("VolumeControl");
                    volumeControl.setLevel(100);
                    inputStream.close();
                    inputStream = null;
                    Form stopForm = new Form(this.RESOURCES.get("Window.PrayerTime"));
                    stopForm.setLayout(new BorderLayout());
                    Button btnStop = new Button(Main.icons.getImage("Stop"));
                    btnStop.setAlignment(4);
                    btnStop.setPreferredW(90);
                    btnStop.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            try {
                                musicPlayer.stop();
                                MainForm.this.currentForm.showBack();
                            }
                            catch (Exception exc) {
                                exc.printStackTrace();
                            }
                        }
                    });
                    Image imgAllahAkbar = Main.icons.getImage("AllahAkbar");
                    Label lblAllahAkbar = new Label(imgAllahAkbar);
                    lblAllahAkbar.setAlignment(4);
                    lblAllahAkbar.getStyle().setPadding(0, 6);
                    Label lLabelPrayerRinging = new Label(this.retournerNomPriereAlerte(pPreferenceKey));
                    lLabelPrayerRinging.setUIID("LabelRingingPrayerName");
                    lLabelPrayerRinging.setAlignment(4);
                    lLabelPrayerRinging.getUnselectedStyle().setBgTransparency(0);
                    lLabelPrayerRinging.getSelectedStyle().setBgTransparency(0);
                    if (!Main.isTactile()) {
                        lLabelPrayerRinging.setFocusable(true);
                    }
                    stopForm.addComponent("North", (Component)lLabelPrayerRinging);
                    stopForm.addComponent("Center", (Component)btnStop);
                    stopForm.addComponent("South", (Component)lblAllahAkbar);
                    stopForm.setScrollable(false);
                    Command fermer = new Command(this.RESOURCES.get("Command.Stop")){

                        public void actionPerformed(ActionEvent evt) {
                            try {
                                musicPlayer.stop();
                                MainForm.this.currentForm.showBack();
                            }
                            catch (Exception exc) {
                                exc.printStackTrace();
                            }
                        }
                    };
                    stopForm.addCommand(fermer);
                    stopForm.setBackCommand(fermer);
                    stopForm.show();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
    }

    private String retournerNomPriereAlerte(String pPreferenceKey) {
        String retour = "";
        if ("alertSobh".equals(pPreferenceKey)) {
            retour = this.RESOURCES.get("Sobh");
        } else if ("alertDohr".equals(pPreferenceKey)) {
            retour = this.RESOURCES.get("Dohr");
        } else if ("alertAsr".equals(pPreferenceKey)) {
            retour = this.RESOURCES.get("Asr");
        } else if ("alertMaghreb".equals(pPreferenceKey)) {
            retour = this.RESOURCES.get("Maghreb");
        } else if ("alertIshaa".equals(pPreferenceKey)) {
            retour = this.RESOURCES.get("Ihsaa");
        }
        return retour;
    }

    public Main getMain() {
        return this.mMain;
    }

    public Label getLabelLieu() {
        return this.mLabelLieu;
    }

    public Label getLabelLibelleDate() {
        return this.mLabelLibelleDate;
    }

    public Label getLabelLibelleJourSemaine() {
        return this.mLabelLibelleJourSemaine;
    }

    public Label getLabelLibelleHeure() {
        return this.mLabelLibelleHeure;
    }

    public Label getLabelHoraireImsak() {
        return this.mLabelHoraireImsak;
    }

    public Label getLabelHoraireSohb() {
        return this.mLabelHoraireSohb;
    }

    public Label getLabelHoraireChourouk() {
        return this.mLabelHoraireChourouk;
    }

    public Label getLabelHoraireDohr() {
        return this.mLabelHoraireDohr;
    }

    public Label getLabelHoraireAsr() {
        return this.mLabelHoraireAsr;
    }

    public Label getLabelHoraireMaghreb() {
        return this.mLabelHoraireMaghreb;
    }

    public Label getLabelHoraireIshaa() {
        return this.mLabelHoraireIshaa;
    }

    public void setHeureCourante(Date pHeureCourante) {
        this.mHeureCourante = pHeureCourante;
    }

    public boolean isTimerHeureCourante() {
        return this.timerHeureCourante;
    }

    public void setTimerHeureCourante(boolean timerHeureCourante) {
        this.timerHeureCourante = timerHeureCourante;
    }

    protected String getHelp() {
        return "";
    }
}

