/*
 * Decompiled with CFR 0.152.
 */
package athan.src.Client;

import athan.src.Client.Main;
import athan.src.Client.MainForm;
import athan.src.Client.Menu;
import athan.src.Factory.ResourceReader;
import athan.src.Factory.ServiceFactory;
import athan.src.options.MenuAlerts;
import athan.src.options.MenuCalculationMethod;
import athan.src.options.MenuCompass;
import athan.src.options.MenuLanguage;
import athan.src.options.MenuLocalTime;
import athan.src.options.MenuLocation;
import athan.src.options.MenuPrayers;
import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Painter;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.animations.Motion;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.Resources;
import java.util.Hashtable;
import java.util.Vector;

public class OptionForm
extends Form
implements ActionListener {
    private static final String ABOUT_VERSION_ENTRY = "Version : ";
    private static final int EXIT_COMMAND = 1;
    private static final int BACK_COMMAND = 3;
    private static final int ABOUT_COMMAND = 4;
    private static final Command exitCommand = new Command("", 1);
    private static final Command backCommand = new Command("", 3);
    private static final Command aboutCommand = new Command("", 4);
    private static Transition sComponentTransitions;
    private static final Menu[] DEMOS;
    private Hashtable mDemosHash = new Hashtable();
    private int mCols = 0;
    private int mElementWidth;
    private Component dragged;
    private int oldx;
    private int oldy;
    private int draggedx;
    private int draggedy;
    private Image draggedImage;
    private Vector cmps;
    private Transition cmpTransition;
    private MainForm parent;
    private boolean dragMode;
    private Menu mCurrentMenu;
    private ResourceReader RESOURCES;

    public static void setTransition(Transition in, Transition out) {
    }

    public static void setMenuTransition(Transition in, Transition out) {
        UIManager.getInstance().getLookAndFeel().setDefaultMenuTransitionIn(in);
        UIManager.getInstance().getLookAndFeel().setDefaultMenuTransitionOut(out);
    }

    public static void setComponentTransition(Transition t) {
        if (t != null && Main.getOptionForm() != null) {
            Main.getOptionForm().setSmoothScrolling(false);
        }
        sComponentTransitions = t;
    }

    public static Transition getComponentTransition() {
        return sComponentTransitions;
    }

    public OptionForm(MainForm parent) {
        this.parent = parent;
        this.RESOURCES = ServiceFactory.getFactory().getResourceReader();
        this.setTitle(this.RESOURCES.get("OptionForm"));
    }

    public void setDragMode(boolean dragMode) {
        this.dragMode = dragMode;
        this.setSmoothScrolling(!dragMode);
    }

    protected void sizeChanged(int w, int h) {
        super.sizeChanged(w, h);
        try {
            MainForm.setOptionForm(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.dragMode) {
            super.pointerDragged(x, y);
            return;
        }
        if (this.draggedImage == null) {
            this.dragged = this.getComponentAt(x, y);
            if (this.dragged == null || !this.getContentPane().contains(this.dragged)) {
                super.pointerDragged(x, y);
                return;
            }
            this.draggedImage = Image.createImage(this.dragged.getWidth(), this.dragged.getHeight());
            Graphics g = this.draggedImage.getGraphics();
            g.setClip(0, 0, this.dragged.getWidth(), this.dragged.getHeight());
            g.setColor(0xFF7777);
            g.fillRect(0, 0, this.dragged.getWidth(), this.dragged.getHeight());
            g.translate(-this.dragged.getX(), -this.dragged.getY());
            this.dragged.paint(g);
            g.translate(this.dragged.getX(), this.dragged.getY());
            this.draggedImage = this.draggedImage.modifyAlpha((byte)85, 0xFF7777);
            this.oldx = x;
            this.oldy = y;
            this.draggedx = this.dragged.getAbsoluteX();
            this.draggedy = this.dragged.getAbsoluteY();
            this.dragged.setVisible(false);
            Painter glassPane = new Painter(){

                public void paint(Graphics g, Rectangle rect) {
                    if (OptionForm.this.draggedImage != null) {
                        g.drawImage(OptionForm.this.draggedImage, OptionForm.this.draggedx, OptionForm.this.draggedy);
                    }
                }
            };
            this.setGlassPane(glassPane);
            this.cmpTransition = OptionForm.getComponentTransition();
            OptionForm.setComponentTransition(null);
            return;
        }
        this.repaint(this.draggedx, this.draggedy, this.dragged.getWidth(), this.dragged.getHeight());
        this.draggedx += x - this.oldx;
        this.draggedy += y - this.oldy;
        this.oldx = x;
        this.oldy = y;
        this.repaint(this.draggedx, this.draggedy, this.dragged.getWidth(), this.dragged.getHeight());
        super.pointerDragged(x, y);
    }

    public void pointerReleased(int x, int y) {
        LayoutAnimation la;
        int draggedIndex;
        if (!this.dragMode) {
            super.pointerReleased(x, y);
            return;
        }
        if (this.draggedImage == null) {
            super.pointerReleased(x, y);
            return;
        }
        this.setVisible(false);
        this.oldx = 0;
        this.oldy = 0;
        Component cmp = this.getFocused();
        final int index = this.getContentPane().getComponentIndex(cmp);
        this.cmps = new Vector();
        if (index >= 0) {
            int startIndex;
            draggedIndex = this.getContentPane().getComponentIndex(this.dragged);
            for (int i = startIndex = Math.min(index, draggedIndex); i < this.getContentPane().getComponentCount(); ++i) {
                Component toMove = this.getContentPane().getComponentAt(i);
                LayoutAnimation la2 = new LayoutAnimation(toMove);
                la2.setFrom(new Dimension(toMove.getX(), toMove.getY()));
                this.cmps.addElement(la2);
            }
            this.removeComponent(this.dragged);
            this.addComponent(index, this.dragged);
            this.layoutContainer();
            la = new LayoutAnimation(this.dragged);
            int dx = Math.max(0, this.draggedx - (this.dragged.getAbsoluteX() - this.dragged.getX()));
            int dy = Math.max(0, this.draggedy - (this.dragged.getAbsoluteY() - this.dragged.getY()));
            dx = Math.min(dx, this.getContentPane().getPreferredW() - this.dragged.getWidth());
            dy = Math.min(dy, this.getContentPane().getPreferredH() - this.dragged.getHeight());
            la.setFrom(new Dimension(dx, dy));
            la.setTo(new Dimension(this.dragged.getX(), this.dragged.getY()));
            la.init();
            for (int i = 0; i < this.cmps.size(); ++i) {
                LayoutAnimation l = (LayoutAnimation)this.cmps.elementAt(i);
                l.setTo(new Dimension(l.toAnimate.getX(), l.toAnimate.getY()));
                l.init();
            }
        } else {
            this.finishDrag();
            return;
        }
        this.cmps.addElement(la);
        this.removeComponent(this.dragged);
        this.addComponent(draggedIndex, this.dragged);
        this.layoutContainer();
        la.init();
        this.registerAnimated(new Animation(){

            public boolean animate() {
                boolean retVal = false;
                for (int i = 0; i < OptionForm.this.cmps.size(); ++i) {
                    LayoutAnimation la = (LayoutAnimation)OptionForm.this.cmps.elementAt(i);
                    if (!la.animate()) continue;
                    retVal = true;
                }
                if (!retVal) {
                    OptionForm.this.deregisterAnimated(this);
                    if (OptionForm.this.getContentPane().contains(OptionForm.this.dragged)) {
                        OptionForm.this.removeComponent(OptionForm.this.dragged);
                        OptionForm.this.addComponent(index, OptionForm.this.dragged);
                    }
                    OptionForm.this.finishDrag();
                }
                return retVal;
            }

            public void paint(Graphics g) {
                for (int i = 0; i < OptionForm.this.cmps.size(); ++i) {
                    LayoutAnimation la = (LayoutAnimation)OptionForm.this.cmps.elementAt(i);
                    la.paint(g);
                    OptionForm.this.repaint(la.toAnimate.getAbsoluteX(), la.toAnimate.getAbsoluteY(), la.toAnimate.getWidth(), la.toAnimate.getHeight());
                }
                if (!OptionForm.this.dragged.isVisible()) {
                    OptionForm.this.dragged.setVisible(true);
                }
            }
        });
        this.setVisible(true);
        this.repaint();
        this.setGlassPane(null);
    }

    private void finishDrag() {
        this.setGlassPane(null);
        if (this.dragged != null) {
            this.dragged.requestFocus();
            if (!this.dragged.isVisible()) {
                this.dragged.setVisible(true);
                this.dragged.requestFocus();
            }
            this.dragged = null;
        }
        this.draggedImage = null;
        OptionForm.setComponentTransition(this.cmpTransition);
        this.repaint();
    }

    public void actionPerformed(ActionEvent evt) {
        Command cmd = evt.getCommand();
        switch (cmd.getId()) {
            case 1: {
                Main.getMainForm().run(Main.exitCommand, Main.getMainForm().getMain(), false);
                Main.demarrerTimer();
                break;
            }
            case 3: {
                this.mCurrentMenu.cleanup();
                this.show();
                break;
            }
            case 4: {
                Form aboutForm = new Form(this.RESOURCES.get("Menu.About"));
                aboutForm.setScrollable(false);
                aboutForm.setLayout(new BorderLayout());
                TextArea aboutText = new TextArea(this.getAboutText(), 5, 10);
                aboutText.setEditable(false);
                aboutForm.addComponent("Center", (Component)aboutText);
                final OptionForm self = this;
                aboutForm.addCommand(new Command(this.RESOURCES.get("Menu.Back")){

                    public void actionPerformed(ActionEvent evt) {
                        self.show();
                    }
                });
                aboutForm.show();
            }
        }
    }

    public void setMainForm(Resources pResource) {
        int rows;
        int width = Display.getInstance().getDisplayWidth();
        this.mElementWidth = 0;
        Image[] selectedImages = new Image[DEMOS.length];
        Image[] unselectedImages = new Image[DEMOS.length];
        ButtonActionListener bAListner = new ButtonActionListener();
        for (int i = 0; i < DEMOS.length; ++i) {
            selectedImages[i] = pResource.getImage(DEMOS[i].getIconBaseName() + "_sel");
            unselectedImages[i] = pResource.getImage(DEMOS[i].getIconBaseName() + "_unsel");
            Image imgSelectionnee = selectedImages[i];
            Image imgDeselectionnee = unselectedImages[i];
            imgDeselectionnee = imgSelectionnee;
            final Button b = new Button(DEMOS[i].getName(), imgDeselectionnee);
            b.setUIID("DemoButton");
            b.setRolloverIcon(imgSelectionnee);
            b.setAlignment(4);
            b.setTextPosition(2);
            this.addComponent(b);
            b.addActionListener(bAListner);
            final OptionForm self = this;
            b.addFocusListener(new FocusListener(){

                public void focusGained(Component cmp) {
                    if (sComponentTransitions != null) {
                        self.replace(b, b, sComponentTransitions);
                    }
                }

                public void focusLost(Component cmp) {
                }
            });
            this.mDemosHash.put(b, DEMOS[i]);
            this.mElementWidth = Math.max(b.getPreferredW(), this.mElementWidth);
        }
        if (this.mCols == 0) {
            this.mCols = width / this.mElementWidth;
        }
        if ((rows = DEMOS.length / this.mCols) == 0) {
            rows = 1;
        }
        this.setLayout(new GridLayout(rows, this.mCols));
        exitCommand.setCommandName(this.RESOURCES.get("Command.Back"));
        aboutCommand.setCommandName(this.RESOURCES.get("Command.About"));
        backCommand.setCommandName(this.RESOURCES.get("Command.Back"));
        this.addCommand(exitCommand);
        this.addCommand(aboutCommand);
        this.setBackCommand(exitCommand);
        this.addCommandListener(this);
    }

    private String getAboutText() {
        try {
            StringBuffer helpContentSb = new StringBuffer(this.RESOURCES.getContenu_About());
            String helpContent = this.RESOURCES.getContenu_About();
            helpContentSb.insert(helpContent.indexOf(ABOUT_VERSION_ENTRY) + ABOUT_VERSION_ENTRY.length(), Main.getMidletVersion());
            return helpContentSb.toString();
        }
        catch (Exception exc) {
            return this.RESOURCES.getContenu_About();
        }
    }

    static {
        DEMOS = new Menu[]{new MenuAlerts(), new MenuLocation(), new MenuCompass(), new MenuLocalTime(), new MenuLanguage(), new MenuCalculationMethod(), new MenuPrayers()};
    }

    class LayoutAnimation
    implements Animation {
        private Component toAnimate;
        private Dimension from;
        private Dimension to;
        private Motion xMotion;
        private Motion yMotion;

        LayoutAnimation(Component toAnimate) {
            this.toAnimate = toAnimate;
        }

        public void setFrom(Dimension from) {
            this.from = from;
        }

        public void setTo(Dimension to) {
            this.to = to;
        }

        public void init() {
            this.toAnimate.setX(this.from.getWidth());
            this.toAnimate.setY(this.from.getHeight());
            this.xMotion = Motion.createSplineMotion(this.from.getWidth(), this.to.getWidth(), 500);
            this.yMotion = Motion.createSplineMotion(this.from.getHeight(), this.to.getHeight(), 500);
            this.xMotion.start();
            this.yMotion.start();
        }

        public boolean animate() {
            this.toAnimate.setX(this.xMotion.getValue());
            this.toAnimate.setY(this.yMotion.getValue());
            return !this.xMotion.isFinished() && !this.yMotion.isFinished();
        }

        public void paint(Graphics g) {
            this.toAnimate.paintComponent(g);
        }
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            OptionForm.this.mCurrentMenu = (Menu)OptionForm.this.mDemosHash.get(evt.getSource());
            OptionForm.this.mCurrentMenu.run(backCommand, OptionForm.this, true);
        }
    }
}

