/*
 * Decompiled with CFR 0.152.
 */
package athan.src.Factory;

import athan.src.SalaahCalc.CalculationCustomParams;
import athan.src.SalaahCalc.SalaahTimeCalculator;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Preferences {
    public static final String LANGUE_FR = "fr";
    public static final String LANGUE_EN = "en";
    public static final String MODE_NONE = "N";
    public static final String MODE_FLASH = "V";
    public static final String MODE_SONG = "S";
    public static final String RECORD_STORE_NAME = "preferences";
    public static final String sCountryName = "countryName";
    public static final String sRegionName = "regionName";
    public static final String sCityName = "cityName";
    public static final String sLatitude = "latitude";
    public static final String sLongitude = "longitude";
    public static final String sTimeZone = "timeZone";
    public static final String sDecalageHoraire = "decalageHoraire";
    public static final String sFormatHoraire = "formatHoraire";
    public static final String sMethodeJuridiqueAsr = "methodeJuristiqueAsr";
    public static final String sCalculationMethod = "methodeCalcul";
    public static final String sCustomFajrAngle = "customFajrAngle";
    public static final String sCustomImsakSelector = "customImsakSelector";
    public static final String sCustomImsakValue = "customImsakValue";
    public static final String sCustomMaghrebSelector = "customMaghrebSelector";
    public static final String sCustomMaghrebValue = "customMaghrebValue";
    public static final String sCustomIshaaSelector = "customIshaaSelector";
    public static final String sCustomIshaaValue = "customIshaaValue";
    public static final String sDisplayImsak = "displayImsak";
    public static final String sDisplayChourouk = "displayChourouk";
    public static final String sLangue = "langue";
    public static final String sAlertSobh = "alertSobh";
    public static final String sAlertDohr = "alertDohr";
    public static final String sAlertAsr = "alertAsr";
    public static final String sAlertMaghreb = "alertMaghreb";
    public static final String sAlertIshaa = "alertIshaa";
    public static final String sAlertMode = "alertMode";
    public static final String sAlertFile = "alertFile";
    private String mRecordStoreName;
    private Hashtable mHashtable;

    public Preferences(String recordStoreName) throws RecordStoreException {
        this.mRecordStoreName = recordStoreName;
        this.mHashtable = new Hashtable();
        this.loadDefaults();
        this.load();
    }

    public String get(String key) {
        return (String)this.mHashtable.get(key);
    }

    public CalculationCustomParams getCalculationCustomParams() {
        CalculationCustomParams retour = new CalculationCustomParams();
        double lFajrAngle = Double.parseDouble(this.get(sCustomFajrAngle));
        int lImsakSelector = Integer.parseInt(this.get(sCustomImsakSelector));
        double lImsakValue = Double.parseDouble(this.get(sCustomImsakValue));
        int lMaghrebSelector = Integer.parseInt(this.get(sCustomMaghrebSelector));
        double lMaghrebValue = Double.parseDouble(this.get(sCustomMaghrebValue));
        int lIshaaSelector = Integer.parseInt(this.get(sCustomIshaaSelector));
        double lIshaaValue = Double.parseDouble(this.get(sCustomIshaaValue));
        retour.setFajrAngle(lFajrAngle);
        retour.setImsakSelector(lImsakSelector);
        retour.setMaghrebSelector(lMaghrebSelector);
        retour.setImsakValue(lImsakValue);
        retour.setMaghrebValue(lMaghrebValue);
        retour.setIshaaSelector(lIshaaSelector);
        retour.setIshaaValue(lIshaaValue);
        return retour;
    }

    public void set(String key, String value) {
        if (value == null) {
            value = "";
        }
        this.mHashtable.put(key, value);
    }

    public void put(String key, String value) {
        this.mHashtable.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws RecordStoreException {
        RecordStore rs = null;
        RecordEnumeration re = null;
        try {
            rs = RecordStore.openRecordStore((String)this.mRecordStoreName, (boolean)true);
            re = rs.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                byte[] raw = re.nextRecord();
                String pref = new String(raw);
                int index = pref.indexOf(124);
                String name = pref.substring(0, index);
                String value = pref.substring(index + 1);
                this.put(name, value);
            }
        }
        finally {
            if (re != null) {
                re.destroy();
            }
            if (rs != null) {
                rs.closeRecordStore();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws RecordStoreException {
        RecordStore rs = null;
        RecordEnumeration re = null;
        try {
            rs = RecordStore.openRecordStore((String)this.mRecordStoreName, (boolean)true);
            re = rs.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                int id = re.nextRecordId();
                rs.deleteRecord(id);
            }
            Enumeration keys = this.mHashtable.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = this.get(key);
                String pref = key + "|" + value;
                byte[] raw = pref.getBytes();
                rs.addRecord(raw, 0, raw.length);
            }
        }
        finally {
            if (re != null) {
                re.destroy();
            }
            if (rs != null) {
                rs.closeRecordStore();
            }
        }
    }

    private void loadDefaults() throws RecordStoreException {
        this.put(sCountryName, "France");
        this.put(sRegionName, "Rh\u00f4ne-Alpes");
        this.put(sCityName, "Lyon");
        this.put(sLatitude, "45.75");
        this.put(sLongitude, "4.85");
        this.put(sTimeZone, String.valueOf(SalaahTimeCalculator.getTimeZone()));
        this.put(sDecalageHoraire, "0");
        this.put(sFormatHoraire, "0");
        this.put(sMethodeJuridiqueAsr, "0");
        this.put(sCalculationMethod, "6");
        this.put(sCustomFajrAngle, "13");
        this.put(sCustomImsakSelector, "1");
        this.put(sCustomImsakValue, "15");
        this.put(sCustomMaghrebSelector, "1");
        this.put(sCustomMaghrebValue, "0");
        this.put(sCustomIshaaSelector, "0");
        this.put(sCustomIshaaValue, "12");
        this.put(sDisplayImsak, Integer.toString(0));
        this.put(sDisplayChourouk, Integer.toString(0));
        this.put(sLangue, LANGUE_EN);
        this.put(sAlertSobh, Integer.toString(1));
        this.put(sAlertDohr, Integer.toString(0));
        this.put(sAlertAsr, Integer.toString(0));
        this.put(sAlertMaghreb, Integer.toString(0));
        this.put(sAlertIshaa, Integer.toString(0));
        this.put(sAlertMode, MODE_FLASH);
        this.put(sAlertFile, "");
    }

    public String getLangue() {
        String retour = LANGUE_EN;
        if (this.mHashtable.containsKey(sLangue) && this.get(sLangue) != null) {
            retour = this.get(sLangue);
        }
        return retour;
    }
}

