/*
 * Decompiled with CFR 0.152.
 */
package athan.src.SalaahCalc;

import athan.src.Factory.ResourceReader;
import athan.src.Factory.ServiceFactory;
import athan.src.SalaahCalc.CalculationCustomParams;
import athan.src.SalaahCalc.CalculationMethods;
import athan.src.SalaahCalc.JuristicMethods;
import athan.src.SalaahCalc.TimeFormat;
import athan.src.microfloat.Real;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class SalaahTimeCalculator {
    public static final int IMSAK = 0;
    public static final int FAJR = 1;
    public static final int SUNRISE = 2;
    public static final int DOHR = 3;
    public static final int ASR = 4;
    public static final int SUNSET = 5;
    public static final int MAGHRIB = 6;
    public static final int ISHAA = 7;
    public static final int POS_FAJR_ANGLE = 0;
    public static final int POS_IMSAK_SELECTOR = 1;
    public static final int POS_IMSAK_VALUE = 2;
    public static final int POS_MAGHRIB_SELECTOR = 3;
    public static final int POS_MAGHRIB_VALUE = 4;
    public static final int POS_ISHAA_SELECTOR = 5;
    public static final int POS_ISHAA_VALUE = 6;
    private static final int NONE = 0;
    private static final int MIDNIGHT = 1;
    private static final int ONE_SEVENTH = 2;
    private static final int ANGLE_BASED = 3;
    private static final int SELECTOR_ANGLE = 0;
    private static final int SELECTOR_MINUTE = 1;
    private static final String[] TIME_NAMES = new String[]{"Imsak", "Fajr", "Sunrise", "Dhuhr", "Asr", "Sunset", "Maghrib", "Isha"};
    private static final int PRAYERS_COUNT = TIME_NAMES.length;
    private int calcMethod = 4;
    private int asrJuristic = 0;
    private int dhuhrMinutes = 0;
    private int adjustHighLats = 1;
    private int timeFormat = TimeFormat.H24.getValue();
    private double lat;
    private double lng;
    private int timeZone;
    private double JDate;
    private int numIterations = 1;
    private ResourceReader RESSOURCE = ServiceFactory.getFactory().getResourceReader();
    private double[][] methodParams = new double[][]{{16.0, 0.0, 19.5, 0.0, 4.0, 0.0, 14.0}, {18.0, 0.0, 19.5, 1.0, 0.0, 0.0, 18.0}, {15.0, 0.0, 19.5, 1.0, 0.0, 0.0, 15.0}, {18.0, 0.0, 19.5, 1.0, 0.0, 0.0, 17.0}, {18.5, 0.0, 19.5, 1.0, 0.0, 1.0, 90.0}, {19.5, 0.0, 19.5, 1.0, 0.0, 0.0, 17.5}, {12.0, 1.0, 15.0, 1.0, 0.0, 0.0, 12.0}};
    private int paramsCount = this.methodParams[0].length;

    private String[] getDatePrayerTimes(int year, int month, int day, double latitude, double longitude, Integer timeZone) {
        this.lat = latitude;
        this.lng = longitude;
        this.timeZone = this.effectiveTimeZone(timeZone);
        this.JDate = this.julianDate(year, month, day) - longitude / 360.0;
        return this.computeDayTimes();
    }

    public String[] getPrayerTimes(Date date, double latitude, double longitude, Integer timeZone) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return this.getDatePrayerTimes(cal.get(1), cal.get(2) + 1, cal.get(5), latitude, longitude, timeZone);
    }

    public void setCalculationMethod(CalculationMethods methodToUse, CalculationCustomParams params) {
        this.calcMethod = methodToUse.getValue();
        if (CalculationMethods.Custom.getValue() == methodToUse.getValue()) {
            this.setFajrAngle(params.getFajrAngle());
            if (params.getImsakSelector() == 0) {
                this.setImsakAngle(params.getImsakValue());
            } else {
                this.setImsakMinutes(params.getImsakValue());
            }
            if (params.getMaghrebSelector() == 0) {
                this.setMaghribAngle(params.getMaghrebValue());
            } else {
                this.setMaghribMinutes(params.getMaghrebValue());
            }
            if (params.getIshaaSelector() == 0) {
                this.setIshaAngle(params.getIshaaValue());
            } else {
                this.setIshaMinutes(params.getIshaaValue());
            }
        }
    }

    public void setAsrJurusticType(JuristicMethods selectedJuristicion) {
        this.asrJuristic = selectedJuristicion.getValue();
    }

    public void setFajrAngle(double angle) {
        this.setCustomParams(new Double[]{new Double(angle), null, null, null, null, null, null});
    }

    public void setImsakAngle(double angle) {
        this.setCustomParams(new Double[]{null, new Double(0.0), new Double(angle), null, null, null, null});
    }

    public void setMaghribAngle(double angle) {
        this.setCustomParams(new Double[]{null, null, null, new Double(0.0), new Double(angle), null, null});
    }

    public void setIshaAngle(double angle) {
        this.setCustomParams(new Double[]{null, null, null, null, null, new Double(0.0), new Double(angle)});
    }

    private void setDhuhrMinutes(int minutes) {
        this.dhuhrMinutes = minutes;
    }

    public void setImsakMinutes(double minutes) {
        this.setCustomParams(new Double[]{null, new Double(1.0), new Double(minutes), null, null, null, null});
    }

    public void setMaghribMinutes(double minutes) {
        this.setCustomParams(new Double[]{null, null, null, new Double(1.0), new Double(minutes), null, null});
    }

    public void setIshaMinutes(double minutes) {
        this.setCustomParams(new Double[]{null, null, null, null, null, new Double(1.0), new Double(minutes)});
    }

    private void setCustomParams(Double[] userParams) {
        for (int i = 0; i < this.paramsCount; ++i) {
            this.methodParams[CalculationMethods.Custom.getValue()][i] = userParams[i] == null ? this.methodParams[this.calcMethod][i] : userParams[i];
        }
        this.calcMethod = CalculationMethods.Custom.getValue();
    }

    private void setHighLatsMethod(int methodID) {
        this.adjustHighLats = methodID;
    }

    public void setTimeFormat(int timeFormat) {
        this.timeFormat = timeFormat;
    }

    private String floatToTime24(Double time) {
        if (time == null) {
            return "";
        }
        double _time = time;
        _time = this.fixhour(_time + 0.008333333333333333);
        double hours = Math.floor(_time);
        double minutes = Math.floor((_time - hours) * 60.0);
        return this.twoDigitsFormat(new Double(hours).intValue()) + ":" + this.twoDigitsFormat(new Double(minutes).intValue());
    }

    private String floatToTime12NS(double time) {
        return this.floatToTime12(new Double(time), true);
    }

    private String floatToTime12(Double time, boolean noSuffix) {
        if (time == null) {
            return "";
        }
        double _time = time;
        _time = this.fixhour(_time + 0.008333333333333333);
        double hours = Math.floor(_time);
        double minutes = Math.floor((_time - hours) * 60.0);
        String suffix = hours >= 12.0 ? " " + this.RESSOURCE.get("PM") : " " + this.RESSOURCE.get("AM");
        hours = (hours + 12.0 - 1.0) % 12.0 + 1.0;
        return this.twoDigitsFormat(new Double(hours).intValue()) + ":" + this.twoDigitsFormat(new Double(minutes).intValue()) + (noSuffix ? "" : suffix);
    }

    private double[] sunPosition(double jd) {
        double D = jd - 2451545.0;
        double g = this.fixangle(357.529 + 0.98560028 * D);
        double q = this.fixangle(280.459 + 0.98564736 * D);
        double L = this.fixangle(q + 1.915 * this.dsin(g) + 0.02 * this.dsin(2.0 * g));
        double R = 1.00014 - 0.01671 * this.dcos(g) - 1.4E-4 * this.dcos(2.0 * g);
        double e = 23.439 - 3.6E-7 * D;
        double d = this.darcsin(this.dsin(e) * this.dsin(L));
        double RA = this.darctan2(this.dcos(e) * this.dsin(L), this.dcos(L)) / 15.0;
        RA = this.fixhour(RA);
        double EqT = q / 15.0 - RA;
        return new double[]{d, EqT};
    }

    private double equationOfTime(double jd) {
        return this.sunPosition(jd)[1];
    }

    private double sunDeclination(double jd) {
        return this.sunPosition(jd)[0];
    }

    private double computeMidDay(double t) {
        double T = this.equationOfTime(this.JDate + t);
        double Z = this.fixhour(12.0 - T);
        return Z;
    }

    private double computeTime(double G, double t) {
        double D = this.sunDeclination(this.JDate + t);
        double Z = this.computeMidDay(t);
        double V = 0.06666666666666667 * this.darccos((-this.dsin(G) - this.dsin(D) * this.dsin(this.lat)) / (this.dcos(D) * this.dcos(this.lat)));
        return Z + (G > 90.0 ? -V : V);
    }

    private double computeAsr(int step, double t) {
        double D = this.sunDeclination(this.JDate + t);
        double G = -this.darccot((double)step + this.dtan(Math.abs(this.lat - D)));
        return this.computeTime(G, t);
    }

    private Double[] computeTimes(Double[] times) {
        Double[] t = this.dayPortion(times);
        double Imsak = 0.0;
        if (this.methodParams[this.calcMethod][1] == 0.0) {
            Imsak = this.computeTime(180.0 - this.methodParams[this.calcMethod][2], t[0]);
        }
        double Fajr = this.computeTime(180.0 - this.methodParams[this.calcMethod][0], t[1]);
        double Sunrise = this.computeTime(179.167, t[2]);
        double Dhuhr = this.computeMidDay(t[3]);
        double Asr = this.computeAsr(1 + this.asrJuristic, t[4]);
        double Sunset = this.computeTime(0.833, t[5]);
        double Maghrib = 0.0;
        double Isha = 0.0;
        if (this.methodParams[this.calcMethod][3] == 0.0) {
            Maghrib = this.computeTime(this.methodParams[this.calcMethod][4], t[6]);
        }
        if (this.methodParams[this.calcMethod][5] == 0.0) {
            Isha = this.computeTime(this.methodParams[this.calcMethod][6], t[7]);
        }
        return new Double[]{new Double(Imsak), new Double(Fajr), new Double(Sunrise), new Double(Dhuhr), new Double(Asr), new Double(Sunset), new Double(Maghrib), new Double(Isha)};
    }

    private String[] computeDayTimes() {
        Double[] times = new Double[]{new Double(5.0), new Double(5.0), new Double(6.0), new Double(12.0), new Double(13.0), new Double(18.0), new Double(18.0), new Double(18.0)};
        for (double i = 1.0; i <= (double)this.numIterations; i += 1.0) {
            times = this.computeTimes(times);
        }
        times = this.adjustTimes(times);
        return this.adjustTimesFormat(times);
    }

    private Double[] adjustTimes(Double[] times) {
        for (int i = 0; i < PRAYERS_COUNT; ++i) {
            times[i] = new Double(times[i] + (double)this.timeZone - this.lng / 15.0);
        }
        if (this.methodParams[this.calcMethod][1] == 1.0) {
            times[0] = new Double(times[1] - this.methodParams[this.calcMethod][2] / 60.0);
        }
        times[3] = new Double(times[3] + (double)(this.dhuhrMinutes / 60));
        if (this.methodParams[this.calcMethod][3] == 1.0) {
            times[6] = new Double(times[5] + this.methodParams[this.calcMethod][4] / 60.0);
        }
        if (this.methodParams[this.calcMethod][5] == 1.0) {
            times[7] = new Double(times[6] + this.methodParams[this.calcMethod][6] / 60.0);
        }
        if (this.adjustHighLats != 0) {
            times = this.adjustHighLatTimes(times);
        }
        return times;
    }

    private String[] adjustTimesFormat(Double[] times) {
        String[] returnData = new String[times.length];
        for (int i = 0; i < PRAYERS_COUNT; ++i) {
            returnData[i] = this.timeFormat == TimeFormat.H12.getValue() ? this.floatToTime12(times[i], false) : this.floatToTime24(times[i]);
        }
        return returnData;
    }

    private Double[] adjustHighLatTimes(Double[] times) {
        double nightTime = this.timeDiff(times[5], times[2]);
        double FajrDiff = this.nightPortion(this.methodParams[this.calcMethod][0]) * nightTime;
        if (times[1].isNaN() || this.timeDiff(times[1], times[2]) > FajrDiff) {
            times[1] = new Double(times[2] - FajrDiff);
            times[0] = new Double(times[1] - FajrDiff);
        }
        double IshaAngle = this.methodParams[this.calcMethod][5] == 0.0 ? this.methodParams[this.calcMethod][6] : 18.0;
        double IshaDiff = this.nightPortion(IshaAngle) * nightTime;
        if (times[7].isNaN() || this.timeDiff(times[5], times[7]) > IshaDiff) {
            times[7] = new Double(times[5] + IshaDiff);
        }
        double MaghribAngle = this.methodParams[this.calcMethod][3] == 0.0 ? this.methodParams[this.calcMethod][4] : 4.0;
        double MaghribDiff = this.nightPortion(MaghribAngle) * nightTime;
        if (times[6].isNaN() || this.timeDiff(times[5], times[6]) > MaghribDiff) {
            times[6] = new Double(times[5] + MaghribDiff);
        }
        return times;
    }

    private double nightPortion(double angle) {
        if (this.adjustHighLats == 3) {
            return 0.0 * angle;
        }
        if (this.adjustHighLats == 1) {
            return 0.5;
        }
        if (this.adjustHighLats == 2) {
            return 0.14285714285714285;
        }
        return 0.0;
    }

    private Double[] dayPortion(Double[] times) {
        for (int i = 0; i < PRAYERS_COUNT; ++i) {
            times[i] = new Double(times[i] / 24.0);
        }
        return times;
    }

    private double timeDiff(int time1, int time2) {
        return this.fixhour(time2 - time1);
    }

    private double timeDiff(double time1, double time2) {
        return this.fixhour(time2 - time1);
    }

    private String twoDigitsFormat(int num) {
        return num < 10 ? "0" + new Integer(num).toString() : new Integer(num).toString();
    }

    private double julianDate(int year, int month, int day) {
        double A = Math.floor(year / 100);
        double B = Math.floor(A / 4.0);
        double C2 = 2.0 - A + B;
        double Dd = day;
        double Ee = Math.floor(365.25 * (double)(year + 4716));
        double F = Math.floor(30.6001 * (double)(month + 1));
        double JD = C2 + Dd + Ee + F - 1524.5;
        return JD;
    }

    private Date createDate(int year, int month, int day) {
        return this.createDate(year, month, day, TimeZone.getDefault());
    }

    private Date createDate(int year, int month, int day, TimeZone timeZone) {
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        return cal.getTime();
    }

    private double calcJD(int year, int month, int day) {
        double J1970 = 2440588.0;
        Date date = this.createDate(year, month - 1, day);
        long ms = date.getTime();
        double days = Math.floor((double)ms / 8.64E7);
        return J1970 + days - 0.5;
    }

    public static int getTimeZone() {
        int diff = TimeZone.getDefault().getRawOffset();
        diff /= 1000;
        return diff /= 3600;
    }

    public double[][] getMethodParams() {
        return this.methodParams;
    }

    private int getBaseTimeZone() {
        return SalaahTimeCalculator.getTimeZone();
    }

    private boolean detectDaylightSaving() {
        return TimeZone.getDefault().useDaylightTime();
    }

    private int effectiveTimeZone(Integer timeZone) {
        if (timeZone == null) {
            timeZone = new Integer(SalaahTimeCalculator.getTimeZone());
        }
        return timeZone;
    }

    private double dsin(double d) {
        return Math.sin(this.dtr(d));
    }

    private double dcos(double d) {
        return Math.cos(this.dtr(d));
    }

    private double dtan(double d) {
        return Math.tan(this.dtr(d));
    }

    private double darcsin(double x) {
        Real r = new Real(Double.toString(x));
        r.asin();
        r = this.rtd(r);
        return Double.parseDouble(r.toString());
    }

    private double darccos(double x) {
        Real r = new Real(Double.toString(x));
        r.acos();
        r = this.rtd(r);
        return Double.parseDouble(r.toString());
    }

    private double darctan(double x) {
        Real r = new Real(Double.toString(x));
        r.atan();
        return Double.parseDouble(r.toString());
    }

    private double darctan2(double y, double x) {
        double absx;
        double M_PI = Math.PI;
        double M_PI_2 = M_PI / 2.0;
        if (x == 0.0 && y == 0.0) {
            return this.rtd(0.0);
        }
        double absy = y < 0.0 ? -y : y;
        double d = absx = x < 0.0 ? -x : x;
        if (absy - absx == absy) {
            return this.rtd(y < 0.0 ? -M_PI_2 : M_PI_2);
        }
        double val = absx - absy == absx ? 0.0 : this.darctan(y / x);
        if (x > 0.0) {
            return this.rtd(val);
        }
        if (y < 0.0) {
            return this.rtd(val - M_PI);
        }
        return this.rtd(val + M_PI);
    }

    private double darccot(double x) {
        Real r = new Real(Double.toString(1.0 / x));
        r.atan();
        r = this.rtd(r);
        return Double.parseDouble(r.toString());
    }

    private double dtr(double d) {
        return d * Math.PI / 180.0;
    }

    private double rtd(double r) {
        return r * 180.0 / Math.PI;
    }

    private Real rtd(Real r) {
        r.mul(new Real("180"));
        r.div(Real.PI);
        return r;
    }

    private double fixangle(double a) {
        a = (a -= 360.0 * Math.floor(a / 360.0)) < 0.0 ? a + 360.0 : a;
        return a;
    }

    private double fixhour(double a) {
        a = (a -= 24.0 * Math.floor(a / 24.0)) < 0.0 ? a + 24.0 : a;
        return a;
    }
}

