/*
 * Decompiled with CFR 0.152.
 */
package athan.src.options;

import athan.src.Client.Main;
import athan.src.Client.Menu;
import athan.src.Factory.ResourceReader;
import athan.src.Factory.ServiceFactory;
import athan.src.Outils.FileTreeModel;
import athan.src.Outils.StringOutilClient;
import com.sun.lwuit.Button;
import com.sun.lwuit.CheckBox;
import com.sun.lwuit.ComboBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextField;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.tree.Tree;
import java.util.Date;

public class MenuAlerts
extends Menu {
    private static final int HAUTEUR_LABEL = 22;
    private static final int HAUTEUR_LABEL_TOUS = 130;
    private static final String IMAGE_BROWSE_SONG = "BrowseSong";
    private static final String IMAGE_FOLDER = "Folder";
    private static final String IMAGE_FOLDER_CLOSED = "FolderClosed";
    private static final String IMAGE_FILE = "File";
    private CheckBox mAlerterSobh;
    private CheckBox mAlerterDohr;
    private CheckBox mAlerterAsr;
    private CheckBox mAlerterMaghreb;
    private CheckBox mAlerterIshaa;
    private ComboBox mChoixAlerte;
    private TextField mFichierSon;
    private Button mChoixFichier;
    private Command mOK;
    private Container mCtnPrieres;
    private final ResourceReader RESSOURCE = ServiceFactory.getFactory().getResourceReader();

    protected String getHelp() {
        return ServiceFactory.getFactory().getResourceReader().getHelpMenuAlerts();
    }

    protected String getName() {
        return ServiceFactory.getFactory().getResourceReader().get("MenuAlerts");
    }

    protected String getIconBaseName() {
        return "MenuAlarmes";
    }

    protected void execute(final Form f) {
        this.applyTactileSettings(f);
        Label lLabelSobh = new Label(this.RESSOURCE.get("Sobh"));
        this.editerLabel(lLabelSobh);
        Label lLabelDohr = new Label(this.RESSOURCE.get("Dohr"));
        this.editerLabel(lLabelDohr);
        Label lLabelAsr = new Label(this.RESSOURCE.get("Asr"));
        this.editerLabel(lLabelAsr);
        Label lLabelMaghreb = new Label(this.RESSOURCE.get("Maghreb"));
        this.editerLabel(lLabelMaghreb);
        Label lLabelIshaa = new Label(this.RESSOURCE.get("Ishaa"));
        this.editerLabel(lLabelIshaa);
        this.mAlerterSobh = new CheckBox();
        this.mAlerterDohr = new CheckBox();
        this.mAlerterAsr = new CheckBox();
        this.mAlerterMaghreb = new CheckBox();
        this.mAlerterIshaa = new CheckBox();
        Label lLabelAlertType = new Label(this.RESSOURCE.get("AlertType"));
        this.editerLabel(lLabelAlertType);
        Object[] choixAlertes = new String[]{this.RESSOURCE.get("AlertNone"), this.RESSOURCE.get("AlertSong"), this.RESSOURCE.get("AlertFlashing")};
        this.mChoixAlerte = new ComboBox(choixAlertes);
        this.mChoixAlerte.addSelectionListener(new SelectionListener(){

            public void selectionChanged(int oldSelected, int newSelected) {
                MenuAlerts.this.handlerChoixAlerte(newSelected);
            }
        });
        this.mFichierSon = new TextField();
        this.editerAlertSong(this.mFichierSon);
        this.mFichierSon.setEditable(false);
        this.mChoixFichier = new Button(Main.icons.getImage(IMAGE_BROWSE_SONG));
        this.mChoixFichier.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    MenuAlerts.this.renvoyerUrlFichier(f);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        });
        this.mCtnPrieres = new Container(new GridLayout(5, 2));
        this.mCtnPrieres.addComponent(lLabelSobh);
        this.mCtnPrieres.addComponent(this.mAlerterSobh);
        this.mCtnPrieres.addComponent(lLabelDohr);
        this.mCtnPrieres.addComponent(this.mAlerterDohr);
        this.mCtnPrieres.addComponent(lLabelAsr);
        this.mCtnPrieres.addComponent(this.mAlerterAsr);
        this.mCtnPrieres.addComponent(lLabelMaghreb);
        this.mCtnPrieres.addComponent(this.mAlerterMaghreb);
        this.mCtnPrieres.addComponent(lLabelIshaa);
        this.mCtnPrieres.addComponent(this.mAlerterIshaa);
        this.mCtnPrieres.setPreferredH(130);
        Container ctnChoix = new Container(new GridLayout(1, 2));
        ctnChoix.addComponent(lLabelAlertType);
        ctnChoix.addComponent(this.mChoixAlerte);
        Container ctnFichierSon = new Container(new BorderLayout());
        ctnFichierSon.addComponent("Center", (Component)this.mFichierSon);
        ctnFichierSon.addComponent("East", (Component)this.mChoixFichier);
        f.setLayout(new BoxLayout(2));
        f.addComponent(ctnChoix);
        f.addComponent(ctnFichierSon);
        f.addComponent(new Label());
        f.addComponent(this.mCtnPrieres);
        this.mOK = new Command(this.RESSOURCE.get("Command.OK")){

            public void actionPerformed(ActionEvent ae) {
                boolean contenuOk = true;
                try {
                    ServiceFactory.getFactory().getPreferences().set("alertSobh", Integer.toString(StringOutilClient.getValeurBooleenne(MenuAlerts.this.mAlerterSobh.isSelected())));
                    ServiceFactory.getFactory().getPreferences().set("alertDohr", Integer.toString(StringOutilClient.getValeurBooleenne(MenuAlerts.this.mAlerterDohr.isSelected())));
                    ServiceFactory.getFactory().getPreferences().set("alertAsr", Integer.toString(StringOutilClient.getValeurBooleenne(MenuAlerts.this.mAlerterAsr.isSelected())));
                    ServiceFactory.getFactory().getPreferences().set("alertMaghreb", Integer.toString(StringOutilClient.getValeurBooleenne(MenuAlerts.this.mAlerterMaghreb.isSelected())));
                    ServiceFactory.getFactory().getPreferences().set("alertIshaa", Integer.toString(StringOutilClient.getValeurBooleenne(MenuAlerts.this.mAlerterIshaa.isSelected())));
                    if (MenuAlerts.this.mChoixAlerte.getSelectedIndex() == 0) {
                        ServiceFactory.getFactory().getPreferences().set("alertMode", "N");
                    } else if (MenuAlerts.this.mChoixAlerte.getSelectedIndex() == 1) {
                        ServiceFactory.getFactory().getPreferences().set("alertMode", "S");
                    } else if (MenuAlerts.this.mChoixAlerte.getSelectedIndex() == 2) {
                        ServiceFactory.getFactory().getPreferences().set("alertMode", "V");
                    }
                    ServiceFactory.getFactory().getPreferences().set("alertFile", MenuAlerts.this.mFichierSon.getText());
                    if (MenuAlerts.this.mChoixAlerte.getSelectedIndex() == 1 && StringOutilClient.isEmpty(MenuAlerts.this.mFichierSon.getText())) {
                        contenuOk = false;
                    }
                    if (!contenuOk) {
                        Command okCommand = new Command(MenuAlerts.this.RESSOURCE.get("Command.OK"));
                        Dialog.show(MenuAlerts.this.RESSOURCE.get("errorTitle"), MenuAlerts.this.RESSOURCE.get("errorSongAlertNoFile"), okCommand, new Command[]{okCommand}, 3, null, 0L, (Transition)CommonTransitions.createSlide(1, true, 1000));
                        return;
                    }
                    ServiceFactory.getFactory().getPreferences().save();
                    ServiceFactory.getFactory().getVuePrincipale().rafraichir(new Date(), true, true);
                    Command okCommand = new Command(MenuAlerts.this.RESSOURCE.get("Command.OK"));
                    Dialog.show(MenuAlerts.this.RESSOURCE.get("propertiesSavedTitle"), MenuAlerts.this.RESSOURCE.get("propertiesSavedContent"), okCommand, new Command[]{okCommand}, 4, null, 2000L, (Transition)CommonTransitions.createSlide(1, true, 1000));
                    f.showBack();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        };
        f.addCommand(this.mOK);
        this.initialiserInfosSelections();
    }

    private void renvoyerUrlFichier(final Form pFormCourante) {
        Tree.setFolderIcon(Main.icons.getImage(IMAGE_FOLDER_CLOSED));
        Tree.setFolderOpenIcon(Main.icons.getImage(IMAGE_FOLDER));
        Tree.setNodeIcon(Main.icons.getImage(IMAGE_FILE));
        final FileTreeModel model = new FileTreeModel();
        final Tree tree = new Tree(model){

            protected String childToDisplayLabel(Object child) {
                if (((String)child).endsWith("/")) {
                    return ((String)child).substring(((String)child).lastIndexOf(47, ((String)child).length() - 2));
                }
                return ((String)child).substring(((String)child).lastIndexOf(47));
            }
        };
        Form treeForm = new Form(this.RESSOURCE.get("FormSongFileSelection"));
        treeForm.setLayout(new BorderLayout());
        treeForm.setScrollable(false);
        treeForm.addComponent("Center", (Component)tree);
        Command back = new Command(this.RESSOURCE.get("Command.Back")){

            public void actionPerformed(ActionEvent evt) {
                pFormCourante.showBack();
            }
        };
        Command ok = new Command(this.RESSOURCE.get("Command.Select")){

            public void actionPerformed(ActionEvent evt) {
                boolean ok = true;
                Object elem = tree.getSelectedItem();
                if (model.isLeaf(elem)) {
                    if (!((String)elem).endsWith(".wav") && !((String)elem).endsWith(".mp3")) {
                        ok = false;
                    }
                } else {
                    ok = false;
                }
                if (ok) {
                    MenuAlerts.this.mFichierSon.setText((String)tree.getSelectedItem());
                    pFormCourante.showBack();
                } else {
                    Command okCommand = new Command(MenuAlerts.this.RESSOURCE.get("Command.OK"));
                    Dialog.show(MenuAlerts.this.RESSOURCE.get("errorTitle"), MenuAlerts.this.RESSOURCE.get("errorSongFileFormat"), okCommand, new Command[]{okCommand}, 3, null, 0L, (Transition)CommonTransitions.createSlide(1, true, 1000));
                }
            }
        };
        tree.addLeafListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
            }
        });
        treeForm.addCommand(back);
        treeForm.addCommand(ok);
        treeForm.setBackCommand(back);
        treeForm.show();
    }

    private void initialiserInfosSelections() {
        boolean isSobhSelected = false;
        boolean isDohrSelected = false;
        boolean isAsrSelected = false;
        boolean isMaghrebSelected = false;
        boolean isIshaaSelected = false;
        String urlFichier = "";
        String mode = "";
        try {
            isSobhSelected = StringOutilClient.getValeurBooleenne(Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("alertSobh")));
            isDohrSelected = StringOutilClient.getValeurBooleenne(Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("alertDohr")));
            isAsrSelected = StringOutilClient.getValeurBooleenne(Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("alertAsr")));
            isMaghrebSelected = StringOutilClient.getValeurBooleenne(Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("alertMaghreb")));
            isIshaaSelected = StringOutilClient.getValeurBooleenne(Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("alertIshaa")));
            urlFichier = ServiceFactory.getFactory().getPreferences().get("alertFile");
            mode = ServiceFactory.getFactory().getPreferences().get("alertMode");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.mAlerterSobh.setSelected(isSobhSelected);
        this.mAlerterDohr.setSelected(isDohrSelected);
        this.mAlerterAsr.setSelected(isAsrSelected);
        this.mAlerterMaghreb.setSelected(isMaghrebSelected);
        this.mAlerterIshaa.setSelected(isIshaaSelected);
        this.mFichierSon.setText(urlFichier);
        if ("N".equals(mode)) {
            this.mChoixAlerte.setSelectedIndex(0);
        } else if ("S".equals(mode)) {
            this.mChoixAlerte.setSelectedIndex(1);
        } else if ("V".equals(mode)) {
            this.mChoixAlerte.setSelectedIndex(2);
        } else {
            this.mChoixAlerte.setSelectedIndex(0);
        }
    }

    private void handlerChoixAlerte(int index) {
        if (index == 0) {
            this.afficherPrieres(false);
            this.mChoixFichier.setVisible(false);
            this.mFichierSon.setVisible(false);
        } else if (index == 1) {
            this.afficherPrieres(true);
            this.mChoixFichier.setVisible(true);
            this.mFichierSon.setVisible(true);
        } else if (index == 2) {
            this.afficherPrieres(true);
            this.mChoixFichier.setVisible(false);
            this.mFichierSon.setVisible(false);
        }
    }

    private void afficherPrieres(boolean afficher) {
        for (int i = 0; i < this.mCtnPrieres.getComponentCount(); ++i) {
            this.mCtnPrieres.getComponentAt(i).setVisible(afficher);
        }
    }

    private void editerLabel(Label pLabel) {
        pLabel.setUIID("LabelInfoName");
        pLabel.getUnselectedStyle().setBgTransparency(0);
        pLabel.getSelectedStyle().setBgTransparency(0);
        pLabel.setFocusable(true);
        pLabel.setAlignment(1);
    }

    private void editerAlertSong(TextField pTextField) {
        pTextField.setUIID("LabelAlertSongInfo");
        pTextField.setAlignment(1);
        pTextField.setRows(1);
        pTextField.setFocusable(true);
        pTextField.setPreferredH(22);
        pTextField.setWidth(40);
    }

    public class FichierSon {
        public String mFichierSon;

        public String getFichierSon() {
            return this.mFichierSon;
        }

        public void setFichierSon(String pFichierSon) {
            this.mFichierSon = pFichierSon;
        }

        public boolean isAssigned() {
            return !StringOutilClient.isEmpty(this.mFichierSon);
        }
    }
}

