/*
 * Decompiled with CFR 0.152.
 */
package athan.src.options;

import athan.src.Client.AthanConstantes;
import athan.src.Client.AthanException;
import athan.src.Client.Main;
import athan.src.Client.Menu;
import athan.src.Factory.ResourceReader;
import athan.src.Factory.ServiceFactory;
import athan.src.location.LocationProvider;
import athan.web.Location;
import athan.web.LocationFetcher;
import com.sun.lwuit.ComboBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.impl.midp.VirtualKeyboard;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.table.TableLayout;
import java.rmi.RemoteException;
import java.util.Date;

public class MenuLocation
extends Menu {
    private static final int HAUTEUR_LABEL = 15;
    private static final int HAUTEUR_LABEL_TOUS = 70;
    private TextField mTextFieldNomVille;
    private TextField mTextFieldNomRegion;
    private TextField mTextFieldNomPays;
    private TextField mTextFieldLat;
    private TextField mTextFieldLng;
    private Command mGpsSearch;
    private Command mApiSearch;
    private Command mManualSearch;
    private Command mOK;
    private Command mAnnuler;
    private boolean utiliserGPS;
    private ResourceReader RESSOURCE = ServiceFactory.getFactory().getResourceReader();

    protected String getHelp() {
        return ServiceFactory.getFactory().getResourceReader().getHelpMenuLocation();
    }

    protected String getName() {
        return ServiceFactory.getFactory().getResourceReader().get("MenuLocation");
    }

    protected String getIconBaseName() {
        return "MenuChoisirVille";
    }

    private void editerTypeLabel(Label pLabel) {
        pLabel.setUIID("LabelInfoName");
        pLabel.getUnselectedStyle().setBgTransparency(0);
        pLabel.getSelectedStyle().setBgTransparency(0);
        pLabel.setFocusable(true);
        pLabel.setAlignment(1);
    }

    private void editerTextField(TextField pTextField, int pAlignment) {
        pTextField.setUIID("LabelLocalisationInfo");
        pTextField.setAlignment(pAlignment);
        pTextField.setRows(1);
        pTextField.setFocusable(true);
        pTextField.setPreferredH(15);
    }

    private void verfierGPS() {
        try {
            LocationProvider.getProvider();
            this.utiliserGPS = true;
        }
        catch (ClassNotFoundException cnfe) {
            this.utiliserGPS = false;
        }
    }

    protected void execute(final Form f) {
        this.applyTactileSettings(f);
        this.verfierGPS();
        TableLayout tblLayoutInfosLocalisation = new TableLayout(5, 4);
        Container ctnInfosLocalisation = new Container();
        ctnInfosLocalisation.setLayout(tblLayoutInfosLocalisation);
        Label lLabelNomVille = new Label(this.RESSOURCE.get("CityName"));
        this.editerTypeLabel(lLabelNomVille);
        Label lLabelNomRegion = new Label(this.RESSOURCE.get("RegionName"));
        this.editerTypeLabel(lLabelNomRegion);
        Label lLabelNomPays = new Label(this.RESSOURCE.get("CountryName"));
        this.editerTypeLabel(lLabelNomPays);
        Label lLabelLatLng = new Label(this.RESSOURCE.get("LatLng"));
        this.editerTypeLabel(lLabelLatLng);
        this.mTextFieldNomVille = new TextField();
        this.editerTextField(this.mTextFieldNomVille, 1);
        this.mTextFieldNomRegion = new TextField();
        this.editerTextField(this.mTextFieldNomRegion, 1);
        this.mTextFieldNomPays = new TextField();
        this.editerTextField(this.mTextFieldNomPays, 1);
        this.mTextFieldLat = new TextField();
        this.editerTextField(this.mTextFieldLat, 3);
        this.mTextFieldLng = new TextField();
        this.editerTextField(this.mTextFieldLng, 3);
        ctnInfosLocalisation.addComponent(this.getCtnLayoutLocalisation(tblLayoutInfosLocalisation, 100, 4), (Component)new Label());
        ctnInfosLocalisation.addComponent(this.getCtnLayoutLocalisation(tblLayoutInfosLocalisation, 30, 1), (Component)lLabelLatLng);
        ctnInfosLocalisation.addComponent(this.getCtnLayoutLocalisation(tblLayoutInfosLocalisation, 34, 1), (Component)this.mTextFieldLat);
        ctnInfosLocalisation.addComponent(this.getCtnLayoutLocalisation(tblLayoutInfosLocalisation, 2, 1), (Component)new Label());
        ctnInfosLocalisation.addComponent(this.getCtnLayoutLocalisation(tblLayoutInfosLocalisation, 34, 1), (Component)this.mTextFieldLng);
        ctnInfosLocalisation.addComponent(this.getCtnLayoutLocalisation(tblLayoutInfosLocalisation, 30, 1), (Component)lLabelNomVille);
        ctnInfosLocalisation.addComponent(this.getCtnLayoutLocalisation(tblLayoutInfosLocalisation, 70, 3), (Component)this.mTextFieldNomVille);
        ctnInfosLocalisation.addComponent(this.getCtnLayoutLocalisation(tblLayoutInfosLocalisation, 30, 1), (Component)lLabelNomRegion);
        ctnInfosLocalisation.addComponent(this.getCtnLayoutLocalisation(tblLayoutInfosLocalisation, 70, 3), (Component)this.mTextFieldNomRegion);
        ctnInfosLocalisation.addComponent(this.getCtnLayoutLocalisation(tblLayoutInfosLocalisation, 30, 1), (Component)lLabelNomPays);
        ctnInfosLocalisation.addComponent(this.getCtnLayoutLocalisation(tblLayoutInfosLocalisation, 70, 3), (Component)this.mTextFieldNomPays);
        ctnInfosLocalisation.setPreferredH(70);
        this.mGpsSearch = new Command(this.RESSOURCE.get("GPSSearch")){

            public void actionPerformed(ActionEvent ae) {
                MenuLocation.this.handlerGpsSearch(f);
            }
        };
        this.mApiSearch = new Command(this.RESSOURCE.get("CitySearch")){

            public void actionPerformed(ActionEvent ae) {
                MenuLocation.this.handlerApiSearch(f);
            }
        };
        this.mManualSearch = new Command(this.RESSOURCE.get("ManualSearch")){

            public void actionPerformed(ActionEvent ae) {
                MenuLocation.this.changerModeEdition(true, f);
            }
        };
        this.mOK = new Command(this.RESSOURCE.get("Command.OK")){

            public void actionPerformed(ActionEvent ae) {
                if (MenuLocation.this.sauvegarderParametresEcran(f)) {
                    MenuLocation.this.changerModeEdition(false, f);
                    MenuLocation.this.initialiserInfosLocalisation();
                }
            }
        };
        this.mAnnuler = new Command(this.RESSOURCE.get("Command.Cancel")){

            public void actionPerformed(ActionEvent ae) {
                MenuLocation.this.changerModeEdition(false, f);
                MenuLocation.this.initialiserInfosLocalisation();
            }
        };
        f.setLayout(new BorderLayout());
        f.addComponent("Center", (Component)ctnInfosLocalisation);
        if (!Main.isTactile()) {
            this.mTextFieldNomVille.setFocusable(true);
            this.mTextFieldNomRegion.setFocusable(true);
            this.mTextFieldNomPays.setFocusable(true);
            this.mTextFieldLat.setFocusable(true);
            this.mTextFieldLng.setFocusable(true);
        }
        this.changerModeEdition(false, f);
        this.initialiserInfosLocalisation();
        this.initialiserClaviers();
        int posCmd = 0;
        if (this.utiliserGPS) {
            f.addCommand(this.mGpsSearch, posCmd++);
        }
        f.addCommand(this.mApiSearch, posCmd++);
        f.addCommand(this.mManualSearch, posCmd++);
        this.replacerCommandesPrincipales();
    }

    private void selectionnerComboParDefautApiSearch(ComboBox lCbIndicatif) {
        if (ServiceFactory.getFactory().getPreferences().getLangue().equals("en")) {
            lCbIndicatif.setSelectedIndex(2, true);
        } else if (ServiceFactory.getFactory().getPreferences().getLangue().equals("en")) {
            lCbIndicatif.setSelectedIndex(4, true);
        } else {
            lCbIndicatif.setSelectedIndex(2, true);
        }
    }

    private void handlerApiSearch(final Form f) {
        final Form parametersForm = new Form(this.RESSOURCE.get("GeocodingWindowTitle"));
        parametersForm.setLayout(new BorderLayout());
        parametersForm.setFocusable(true);
        TableLayout tbGrid = new TableLayout(4, 2);
        Container grid = new Container(tbGrid);
        grid.setLayout(tbGrid);
        Label lLabelNomVille = new Label(this.RESSOURCE.get("CityName"));
        lLabelNomVille.setUIID("LabelInfoName");
        lLabelNomVille.getUnselectedStyle().setBgTransparency(0);
        lLabelNomVille.getSelectedStyle().setBgTransparency(0);
        lLabelNomVille.setFocusable(true);
        lLabelNomVille.setAlignment(1);
        Label lLabelNomRegion = new Label(this.RESSOURCE.get("RegionName"));
        lLabelNomRegion.setUIID("LabelInfoName");
        lLabelNomRegion.getUnselectedStyle().setBgTransparency(0);
        lLabelNomRegion.getSelectedStyle().setBgTransparency(0);
        lLabelNomRegion.setFocusable(true);
        lLabelNomRegion.setAlignment(1);
        Label lLabelNomPays = new Label(this.RESSOURCE.get("CountryName"));
        lLabelNomPays.setUIID("LabelInfoName");
        lLabelNomPays.getUnselectedStyle().setBgTransparency(0);
        lLabelNomPays.getSelectedStyle().setBgTransparency(0);
        lLabelNomPays.setFocusable(true);
        lLabelNomPays.setAlignment(1);
        Label lLabelLanguage = new Label(this.RESSOURCE.get("GeocodingIndicative"));
        lLabelLanguage.setUIID("LabelInfoName");
        lLabelLanguage.getUnselectedStyle().setBgTransparency(0);
        lLabelLanguage.getSelectedStyle().setBgTransparency(0);
        lLabelLanguage.setFocusable(true);
        lLabelLanguage.setAlignment(1);
        final TextField lTextFieldNomVille = new TextField();
        lTextFieldNomVille.setUIID("LabelLocalisationInfo");
        lTextFieldNomVille.setAlignment(1);
        lTextFieldNomVille.setText(this.mTextFieldNomVille.getText());
        lTextFieldNomVille.setEditable(true);
        lTextFieldNomVille.setRows(1);
        final TextField lTextFieldNomRegion = new TextField();
        lTextFieldNomRegion.setUIID("LabelLocalisationInfo");
        lTextFieldNomRegion.setAlignment(1);
        lTextFieldNomRegion.setText(this.mTextFieldNomRegion.getText());
        lTextFieldNomRegion.setEditable(true);
        lTextFieldNomRegion.setRows(1);
        final TextField lTextFieldNomPays = new TextField();
        lTextFieldNomPays.setUIID("LabelLocalisationInfo");
        lTextFieldNomPays.setAlignment(1);
        lTextFieldNomPays.setText(this.mTextFieldNomPays.getText());
        lTextFieldNomPays.setEditable(true);
        lTextFieldNomPays.setRows(1);
        final ComboBox lCbIndicatif = new ComboBox(INDICATIF_PAYS);
        this.selectionnerComboParDefautApiSearch(lCbIndicatif);
        VirtualKeyboard.bindVirtualKeyboard(lTextFieldNomVille, VirtualKeyboard.getVirtualKeyboard(this.mTextFieldNomVille));
        VirtualKeyboard.bindVirtualKeyboard(lTextFieldNomRegion, VirtualKeyboard.getVirtualKeyboard(this.mTextFieldNomRegion));
        VirtualKeyboard.bindVirtualKeyboard(lTextFieldNomPays, VirtualKeyboard.getVirtualKeyboard(this.mTextFieldNomPays));
        grid.addComponent(this.getCtnLayoutGeocoding(tbGrid, 50, 1), (Component)lLabelNomVille);
        grid.addComponent(this.getCtnLayoutGeocoding(tbGrid, 50, 1), (Component)lTextFieldNomVille);
        grid.addComponent(this.getCtnLayoutGeocoding(tbGrid, 50, 1), (Component)lLabelNomRegion);
        grid.addComponent(this.getCtnLayoutGeocoding(tbGrid, 50, 1), (Component)lTextFieldNomRegion);
        grid.addComponent(this.getCtnLayoutGeocoding(tbGrid, 50, 1), (Component)lLabelNomPays);
        grid.addComponent(this.getCtnLayoutGeocoding(tbGrid, 50, 1), (Component)lTextFieldNomPays);
        grid.addComponent(this.getCtnLayoutGeocoding(tbGrid, 50, 1), (Component)lLabelLanguage);
        grid.addComponent(this.getCtnLayoutGeocoding(tbGrid, 50, 1), (Component)lCbIndicatif);
        parametersForm.addComponent("Center", (Component)grid);
        Command reinitChampsCommand = new Command(this.RESSOURCE.get("Command.Reset")){

            public void actionPerformed(ActionEvent evt) {
                MenuLocation.this.resetFields(lTextFieldNomVille, lTextFieldNomRegion, lTextFieldNomPays, lCbIndicatif);
            }
        };
        Command searchCommand = new Command(this.RESSOURCE.get("Command.Search")){

            public void actionPerformed(ActionEvent evt) {
                boolean peutChercher = false;
                if (lTextFieldNomVille.getText() != null && lTextFieldNomVille.getText().trim().length() > 0 || lTextFieldNomRegion.getText() != null && lTextFieldNomRegion.getText().trim().length() > 0 || lTextFieldNomPays.getText() != null && lTextFieldNomPays.getText().trim().length() > 0) {
                    peutChercher = true;
                }
                if (!peutChercher) {
                    Command annulerCommand = new Command(MenuLocation.this.RESSOURCE.get("Command.OK")){

                        public void actionPerformed(ActionEvent evt) {
                        }
                    };
                    Dialog.show(MenuLocation.this.RESSOURCE.get("GeocodingWindowParametersLackTitle"), MenuLocation.this.RESSOURCE.get("GeocodingWindowParametersLackContent"), annulerCommand, new Command[]{annulerCommand}, 4, null, 0L, (Transition)CommonTransitions.createSlide(1, true, 1000));
                    return;
                }
                final LocationFetcher service = new LocationFetcher();
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            Location lLocation = service.geoname(lTextFieldNomVille.getText(), lTextFieldNomRegion.getText(), lTextFieldNomPays.getText(), AthanConstantes.INDICATIF_PAYS[lCbIndicatif.getSelectedIndex()]);
                            MenuLocation.this.mTextFieldNomVille.setText(lLocation.getCityName());
                            MenuLocation.this.mTextFieldNomRegion.setText(lLocation.getRegionName());
                            MenuLocation.this.mTextFieldNomPays.setText(lLocation.getCountryName());
                            if (lLocation.getCoordinates() != null) {
                                MenuLocation.this.mTextFieldLat.setText(new Double(lLocation.getCoordinates().getLat()).toString());
                                MenuLocation.this.mTextFieldLng.setText(new Double(lLocation.getCoordinates().getLng()).toString());
                            }
                            MenuLocation.this.changerModeEdition(true, f);
                        }
                        catch (RemoteException exc) {
                            Command annulerCommand = new Command(MenuLocation.this.RESSOURCE.get("Command.OK")){

                                public void actionPerformed(ActionEvent evt) {
                                }
                            };
                            Dialog.show(MenuLocation.this.RESSOURCE.get("errorTitle"), MenuLocation.this.RESSOURCE.get("GeocodingWindowRemoteException"), annulerCommand, new Command[]{annulerCommand}, 3, null, 0L, (Transition)CommonTransitions.createSlide(1, true, 1000));
                            return;
                        }
                        catch (AthanException exc) {
                            Command annulerCommand = new Command(MenuLocation.this.RESSOURCE.get("Command.OK")){

                                public void actionPerformed(ActionEvent evt) {
                                }
                            };
                            Dialog.show(MenuLocation.this.RESSOURCE.get("errorTitle"), MenuLocation.this.RESSOURCE.get("GeocodingWindowCustomException") + "\n" + exc.getMessage(), annulerCommand, new Command[]{annulerCommand}, 3, null, 0L, (Transition)CommonTransitions.createSlide(1, true, 1000));
                            return;
                        }
                        catch (Exception exc) {
                            Command annulerCommand = new Command(MenuLocation.this.RESSOURCE.get("Command.OK")){

                                public void actionPerformed(ActionEvent evt) {
                                }
                            };
                            Dialog.show(MenuLocation.this.RESSOURCE.get("errorTitle"), MenuLocation.this.RESSOURCE.get("GeocodingWindowUnknownException"), annulerCommand, new Command[]{annulerCommand}, 3, null, 0L, (Transition)CommonTransitions.createSlide(1, true, 1000));
                            return;
                        }
                        f.showBack();
                    }
                }).start();
            }
        };
        Command cancelCommand = new Command(this.RESSOURCE.get("Command.Cancel")){

            public void actionPerformed(ActionEvent evt) {
                f.showBack();
            }
        };
        Command helpCommand = new Command(this.RESSOURCE.get("Command.Help")){

            public void actionPerformed(ActionEvent evt) {
                Form helpForm = new Form(MenuLocation.this.RESSOURCE.get("Window.Help"));
                helpForm.setLayout(new BorderLayout());
                TextArea helpText = new TextArea(MenuLocation.this.RESSOURCE.getContenu_ConsignesGeocoding(), 5, 10);
                helpText.setUIID("TextAreaHelp");
                helpText.setEditable(false);
                helpForm.setScrollable(true);
                helpText.setFocusable(true);
                helpForm.addComponent("Center", (Component)helpText);
                Command c = new Command(MenuLocation.this.RESSOURCE.get("Menu.Back")){

                    public void actionPerformed(ActionEvent evt) {
                        parametersForm.showBack();
                    }
                };
                helpForm.addCommand(c);
                helpForm.setBackCommand(c);
                helpForm.show();
            }
        };
        this.resetFields(lTextFieldNomVille, lTextFieldNomRegion, lTextFieldNomPays, lCbIndicatif);
        parametersForm.addCommand(searchCommand, 0);
        parametersForm.addCommand(reinitChampsCommand, 1);
        parametersForm.addCommand(helpCommand, 2);
        parametersForm.addCommand(cancelCommand, 3);
        parametersForm.setBackCommand(cancelCommand);
        parametersForm.show();
    }

    private void resetFields(TextField lTextFieldNomVille, TextField lTextFieldNomRegion, TextField lTextFieldNomPays, ComboBox lCbIndicatif) {
        lTextFieldNomVille.setText("");
        lTextFieldNomRegion.setText("");
        lTextFieldNomPays.setText("");
        this.selectionnerComboParDefautApiSearch(lCbIndicatif);
    }

    private void handlerGpsSearch(final Form f) {
        boolean success = true;
        final String[] latLng = new String[]{"0.0", "0.0"};
        try {
            LocationProvider lp = LocationProvider.getProvider();
            double lat = lp.getLatitude();
            double lon = lp.getLongitude();
            latLng[0] = Double.toString(lat);
            latLng[1] = Double.toString(lon);
        }
        catch (ClassNotFoundException cnex) {
            cnex.printStackTrace();
            success = false;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            success = false;
        }
        Command okCommand = new Command(this.RESSOURCE.get("Command.OK")){

            public void actionPerformed(ActionEvent evt) {
                MenuLocation.this.okGpsPerformed(latLng, f);
            }
        };
        Command annulerCommand = new Command(this.RESSOURCE.get("Command.Cancel")){

            public void actionPerformed(ActionEvent evt) {
            }
        };
        if (success) {
            int dialogType = 4;
            String contenuDialogue = this.RESSOURCE.get("fetchGPSContent");
            contenuDialogue = contenuDialogue + "\n";
            contenuDialogue = contenuDialogue + this.RESSOURCE.get("Latitude") + " " + latLng[0];
            contenuDialogue = contenuDialogue + "\n";
            contenuDialogue = contenuDialogue + this.RESSOURCE.get("Longitude") + " " + latLng[1];
            Dialog.show(this.RESSOURCE.get("fetchGPSTitle"), contenuDialogue, annulerCommand, new Command[]{annulerCommand, okCommand}, dialogType, null, 0L, (Transition)CommonTransitions.createSlide(1, true, 1000));
        } else {
            int dialogType = 3;
            String contenuDialogue = this.RESSOURCE.get("ErrorFetchGPS");
            Dialog.show(this.RESSOURCE.get("fetchGPSTitle"), contenuDialogue, annulerCommand, new Command[]{annulerCommand}, dialogType, null, 0L, (Transition)CommonTransitions.createSlide(1, true, 1000));
        }
    }

    private void changerModeEdition(boolean editable, Form form) {
        this.mTextFieldLat.setEditable(editable);
        this.mTextFieldLng.setEditable(editable);
        this.mTextFieldNomPays.setEditable(editable);
        this.mTextFieldNomRegion.setEditable(editable);
        this.mTextFieldNomVille.setEditable(editable);
        int posCmd = 0;
        if (editable) {
            form.addCommand(this.mOK, posCmd++);
            form.addCommand(this.mAnnuler, posCmd++);
            form.removeCommand(this.mGpsSearch);
            form.removeCommand(this.mApiSearch);
            form.removeCommand(this.mManualSearch);
        } else {
            if (this.utiliserGPS) {
                form.addCommand(this.mGpsSearch, posCmd++);
            }
            form.addCommand(this.mApiSearch, posCmd++);
            form.addCommand(this.mManualSearch, posCmd++);
            form.removeCommand(this.mOK);
            form.removeCommand(this.mAnnuler);
        }
        this.replacerCommandesPrincipales();
        form.repaint();
    }

    private boolean sauvegarderParametresEcran(Form pFormAppelante) {
        double latitude = 0.0;
        double longitude = 0.0;
        boolean okDonnees = true;
        try {
            latitude = Double.valueOf(this.mTextFieldLat.getText());
            longitude = Double.valueOf(this.mTextFieldLng.getText());
            if (latitude < 0.0 || latitude > 90.0) {
                okDonnees = false;
            }
            if (longitude < -180.0 || longitude > 180.0) {
                okDonnees = false;
            }
        }
        catch (Exception exc) {
            okDonnees = false;
        }
        if (!okDonnees) {
            Command okCommand = new Command(this.RESSOURCE.get("Command.OK"));
            Dialog.show(this.RESSOURCE.get("errorTitle"), this.RESSOURCE.get("errorLocationParameters"), okCommand, new Command[]{okCommand}, 3, null, 0L, (Transition)CommonTransitions.createSlide(1, true, 1000));
            return false;
        }
        try {
            ServiceFactory.getFactory().getPreferences().set("latitude", Double.toString(latitude));
            ServiceFactory.getFactory().getPreferences().set("longitude", Double.toString(longitude));
            ServiceFactory.getFactory().getPreferences().set("cityName", this.mTextFieldNomVille.getText());
            ServiceFactory.getFactory().getPreferences().set("regionName", this.mTextFieldNomRegion.getText());
            ServiceFactory.getFactory().getPreferences().set("countryName", this.mTextFieldNomPays.getText());
            ServiceFactory.getFactory().getPreferences().save();
            ServiceFactory.getFactory().getVuePrincipale().rafraichir(new Date(), true, true);
            Command okCommand = new Command(this.RESSOURCE.get("Command.OK"));
            Dialog.show(this.RESSOURCE.get("propertiesSavedTitle"), this.RESSOURCE.get("propertiesSavedContent"), okCommand, new Command[]{okCommand}, 4, null, 2000L, (Transition)CommonTransitions.createSlide(1, true, 1000));
            pFormAppelante.showBack();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return true;
    }

    private void initialiserInfosLocalisation() {
        String lLat = "";
        String lLng = "";
        String lVille = "";
        String lRegion = "";
        String lPays = "";
        try {
            lLat = ServiceFactory.getFactory().getPreferences().get("latitude");
            lLng = ServiceFactory.getFactory().getPreferences().get("longitude");
            lVille = ServiceFactory.getFactory().getPreferences().get("cityName");
            lRegion = ServiceFactory.getFactory().getPreferences().get("regionName");
            lPays = ServiceFactory.getFactory().getPreferences().get("countryName");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.mTextFieldLat.setText(lLat);
        this.mTextFieldLng.setText(lLng);
        this.mTextFieldNomVille.setText(lVille);
        this.mTextFieldNomRegion.setText(lRegion);
        this.mTextFieldNomPays.setText(lPays);
    }

    private TableLayout.Constraint getCtnLayoutLocalisation(TableLayout pTB, int pPourcentage, int pHorizontalSpan) {
        TableLayout.Constraint contrainte = pTB.createConstraint();
        if (pPourcentage == 100) {
            contrainte.setHeightPercentage(10);
        }
        contrainte.setHorizontalSpan(pHorizontalSpan);
        contrainte.setWidthPercentage(pPourcentage);
        return contrainte;
    }

    private TableLayout.Constraint getCtnLayoutGeocoding(TableLayout pTB, int pPourcentage, int pHorizontalSpan) {
        TableLayout.Constraint contrainte = pTB.createConstraint();
        if (pPourcentage == 100) {
            // empty if block
        }
        contrainte.setHorizontalSpan(pHorizontalSpan);
        contrainte.setWidthPercentage(pPourcentage);
        return contrainte;
    }

    private void okGpsPerformed(String[] pLatLng, Form pForm) {
        this.mTextFieldLat.setText(pLatLng[0]);
        this.mTextFieldLng.setText(pLatLng[1]);
        this.changerModeEdition(true, pForm);
    }

    private void initialiserClaviers() {
        VirtualKeyboard vkbCoordonnees = new VirtualKeyboard();
        vkbCoordonnees.addInputMode("Val.", KB_FLOATS);
        vkbCoordonnees.setInputModeOrder(new String[]{"Val."});
        VirtualKeyboard.bindVirtualKeyboard(this.mTextFieldLat, vkbCoordonnees);
        VirtualKeyboard.bindVirtualKeyboard(this.mTextFieldLng, vkbCoordonnees);
        VirtualKeyboard vkbNoms = new VirtualKeyboard();
        if (ServiceFactory.getFactory().getPreferences().getLangue().equals("en")) {
            vkbNoms.addInputMode("A-Z", KB_NOMS_US);
            vkbNoms.addInputMode("a-z", KB_NOMS_us);
            vkbNoms.addInputMode("?#-", KB_SYMBOLS);
            vkbNoms.setInputModeOrder(new String[]{"A-Z", "a-z", "123", "?#-"});
        } else if (ServiceFactory.getFactory().getPreferences().getLangue().equals("fr")) {
            vkbNoms.addInputMode("A-Z", KB_NOMS_FR);
            vkbNoms.addInputMode("a-z", KB_NOMS_fr);
            vkbNoms.addInputMode("?#-", KB_SYMBOLS);
            vkbNoms.setInputModeOrder(new String[]{"A-Z", "a-z", "123", "?#-"});
        } else {
            vkbNoms.addInputMode("A-Z", KB_NOMS_US);
            vkbNoms.addInputMode("a-z", KB_NOMS_us);
            vkbNoms.addInputMode("?#-", KB_SYMBOLS);
            vkbNoms.setInputModeOrder(new String[]{"A-Z", "a-z", "123", "?#-"});
        }
        VirtualKeyboard.bindVirtualKeyboard(this.mTextFieldNomVille, vkbNoms);
        VirtualKeyboard.bindVirtualKeyboard(this.mTextFieldNomRegion, vkbNoms);
        VirtualKeyboard.bindVirtualKeyboard(this.mTextFieldNomPays, vkbNoms);
    }
}

