/*
 * Decompiled with CFR 0.152.
 */
package org.ksoap2.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.ksoap2.SoapEnvelope;
import org.ksoap2.SoapFault;
import org.ksoap2.transport.ServiceConnection;
import org.ksoap2.transport.ServiceConnectionMidp;
import org.ksoap2.transport.Transport;
import org.xmlpull.v1.XmlPullParserException;

public class HttpTransport
extends Transport {
    ServiceConnection connection;
    OutputStream os;
    InputStream is;
    private boolean connected = false;

    public HttpTransport(String url) {
        super(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(String soapAction, SoapEnvelope envelope) throws IOException, XmlPullParserException {
        if (soapAction == null) {
            soapAction = "\"\"";
        }
        byte[] requestData = this.createRequestData(envelope);
        this.requestDump = this.debug ? new String(requestData) : null;
        this.responseDump = null;
        try {
            this.connected = true;
            this.connection = this.getServiceConnection();
            this.connection.setRequestProperty("SOAPAction", soapAction);
            this.connection.setRequestProperty("Content-Type", "text/xml");
            this.connection.setRequestProperty("Content-Length", "" + requestData.length);
            this.connection.setRequestProperty("User-Agent", "kSOAP/2.0");
            this.connection.setRequestMethod("POST");
            this.os = this.connection.openOutputStream();
            this.os.write(requestData, 0, requestData.length);
            this.os.close();
            requestData = null;
            this.is = this.connection.openInputStream();
            if (this.debug) {
                int rd;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buf = new byte[256];
                while ((rd = this.is.read(buf, 0, 256)) != -1) {
                    bos.write(buf, 0, rd);
                }
                bos.flush();
                buf = bos.toByteArray();
                this.responseDump = new String(buf);
                this.is.close();
                this.is = new ByteArrayInputStream(buf);
            }
            this.parseResponse(envelope, this.is);
        }
        finally {
            if (!this.connected) {
                throw new InterruptedIOException();
            }
            this.reset();
        }
        if (envelope.bodyIn instanceof SoapFault) {
            throw (SoapFault)envelope.bodyIn;
        }
    }

    public void reset() {
        this.connected = false;
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.is = null;
        }
        if (this.connection != null) {
            try {
                this.connection.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    protected ServiceConnection getServiceConnection() throws IOException {
        return new ServiceConnectionMidp(this.url);
    }
}

