/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.io;

import java.io.IOException;
import java.util.Hashtable;
import org.kxml.Attribute;
import org.kxml.PrefixMap;
import org.kxml.io.ParseException;
import org.kxml.io.State;

public abstract class AbstractXmlReader {
    protected int type;
    protected String name;
    protected String namespace;
    protected String text;
    protected Attribute[] attributes = new Attribute[8];
    protected int attributeCount;
    protected boolean degenerated;
    protected State current = new State(null, PrefixMap.DEFAULT, null);
    public Hashtable characterEntityTable;
    public boolean processNamespaces = true;
    public boolean relaxed;

    protected void adjustNamespace() throws IOException {
        Object object;
        boolean bl = false;
        int n = this.attributeCount - 1;
        while (n >= 0) {
            block21: {
                Object object2;
                Attribute attribute;
                block20: {
                    block19: {
                        attribute = this.attributes[n];
                        object = attribute.getName();
                        int n2 = ((String)object).indexOf(58);
                        if (n2 == -1) break block19;
                        object2 = ((String)object).substring(0, n2);
                        object = ((String)object).substring(n2 + 1);
                        break block20;
                    }
                    if (!((String)object).equals("xmlns")) break block21;
                    object2 = object;
                    object = "";
                }
                if (!((String)object2).equals("xmlns")) {
                    if (!((String)object2).equals("xml")) {
                        bl = true;
                    }
                } else {
                    this.current.prefixMap = new PrefixMap(this.current.prefixMap, (String)object, attribute.getValue());
                    --this.attributeCount;
                    int n3 = n;
                    while (n3 < this.attributeCount) {
                        this.attributes[n3] = this.attributes[n3 + 1];
                        ++n3;
                    }
                }
            }
            --n;
        }
        if (bl) {
            int n4 = 0;
            while (n4 < this.attributeCount) {
                String string;
                object = this.attributes[n4];
                String string2 = ((Attribute)object).getName();
                int n5 = string2.indexOf(58);
                if (n5 == 0) {
                    this.exception("illegal attribute name: " + string2);
                } else if (n5 != -1 && !(string = string2.substring(0, n5)).equals("xml")) {
                    string2 = string2.substring(n5 + 1);
                    String string3 = this.current.prefixMap.getNamespace(string);
                    if (string3 == null) {
                        this.exception("Undefined Prefix: " + string + " in ");
                    }
                    this.attributes[n4] = new Attribute(string3, string2, ((Attribute)object).getValue());
                }
                ++n4;
            }
        }
        int n6 = this.name.indexOf(58);
        object = "";
        if (n6 == 0) {
            this.exception("illegal tag name: " + this.name);
        } else if (n6 != -1) {
            object = this.name.substring(0, n6);
            this.name = this.name.substring(n6 + 1);
        }
        this.namespace = this.current.prefixMap.getNamespace((String)object);
        if (this.namespace == null) {
            if (((String)object).length() != 0) {
                this.exception("undefined prefix: " + (String)object + " in " + this.current.prefixMap);
            }
            this.namespace = "";
        }
    }

    public int getType() {
        return this.type;
    }

    public boolean getDegenerated() {
        return this.degenerated;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getText() {
        return this.text;
    }

    public PrefixMap getPrefixMap() {
        return this.current.prefixMap;
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public Attribute getAttribute(int n) {
        if (n < 0 || n >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[n];
    }

    public Attribute getAttribute(String string) {
        return this.getAttribute("", string);
    }

    public Attribute getAttribute(String string, String string2) {
        int n = 0;
        while (n < this.attributeCount) {
            if (this.attributes[n].getName().equals(string2) && (string == null || string.equals(this.attributes[n].getNamespace()))) {
                return this.attributes[n];
            }
            ++n;
        }
        return null;
    }

    public String getValue(String string) {
        Attribute attribute = this.getAttribute("", string);
        if (attribute == null) {
            throw new RuntimeException("Attribute " + string + " in " + this + " expected!");
        }
        return attribute.getValue();
    }

    public String getValueDefault(String string, String string2) {
        Attribute attribute = this.getAttribute("", string);
        return attribute == null ? string2 : attribute.getValue();
    }

    public int next() throws IOException {
        this.nextImpl();
        if (this.type == 64) {
            this.current = new State(this.current, this.current.prefixMap, this.name);
            if (this.namespace == null) {
                if (this.processNamespaces) {
                    this.adjustNamespace();
                } else {
                    this.namespace = "";
                }
            }
            this.current.name = this.name;
            this.current.namespace = this.namespace;
        } else if (this.type == 16) {
            while (true) {
                if (this.current.prev == null) {
                    this.exception("tagstack empty parsing </" + this.name + ">");
                }
                if (this.current.tag.equals(this.name)) break;
                if (!this.relaxed) {
                    this.exception("StartTag <" + this.current.tag + "> does not match end tag </" + this.name + ">");
                }
                if (this.current.tag.toLowerCase().equals(this.name.toLowerCase())) break;
                this.current = this.current.prev;
            }
            this.name = this.current.name;
            this.namespace = this.current.namespace;
            this.current = this.current.prev;
        }
        return this.type;
    }

    public int skip() throws IOException {
        while (true) {
            switch (this.next()) {
                case 8: 
                case 16: 
                case 64: 
                case 128: {
                    return this.type;
                }
            }
        }
    }

    public void require(int n, String string, String string2) throws IOException {
        if (this.type != n || string != null && !string.equals(this.namespace) || string2 != null && !string2.equals(this.name)) {
            this.exception("unexpected token!");
        }
    }

    public String readText() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            switch (this.type) {
                case 8: 
                case 16: 
                case 64: {
                    return stringBuffer.toString();
                }
                case 128: 
                case 256: {
                    stringBuffer.append(this.getText());
                }
            }
            this.next();
        }
    }

    protected abstract void nextImpl() throws IOException;

    protected void exception(String string) throws IOException {
        throw new ParseException(string, null, this.getLineNumber(), this.getColumnNumber());
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }
}

