/*
 * Decompiled with CFR 0.152.
 */
package athan.src.options;

import athan.src.Client.AthanException;
import athan.src.Client.Menu;
import athan.src.Factory.ResourceReader;
import athan.src.Factory.ServiceFactory;
import athan.src.Outils.StringOutilClient;
import athan.src.SalaahCalc.CalculationMethods;
import athan.src.SalaahCalc.SalaahTimeCalculator;
import athan.src.microfloat.Real;
import com.sun.lwuit.ComboBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.impl.midp.VirtualKeyboard;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.table.TableLayout;
import java.util.Date;

public class MenuCalculationMethod
extends Menu {
    private static final int HAUTEUR_LABEL = 20;
    private static final int HAUTEUR_LABEL_TOUS = 50;
    private Command mOK;
    private ComboBox mChoixMethode;
    private ComboBox mImsakSelector;
    private ComboBox mMaghrebSelector;
    private ComboBox mIshaaSelector;
    private ComboBox mAsrJuridiqueMethode;
    private TextField mFajrAngle;
    private TextField mImsakValue;
    private TextField mMaghrebValue;
    private TextField mIshaaValue;

    protected String getHelp() {
        return ServiceFactory.getFactory().getResourceReader().getHelpMenuCalculationMethod();
    }

    protected String getName() {
        return ServiceFactory.getFactory().getResourceReader().get("MenuCalculationMethod");
    }

    protected String getIconBaseName() {
        return "MenuMethodeCalcul";
    }

    private TableLayout.Constraint getCtnLayoutParams(TableLayout pTB, int pPourcentage, int pHorizontalSpan) {
        TableLayout.Constraint contrainte = pTB.createConstraint();
        if (pPourcentage == 100) {
            // empty if block
        }
        contrainte.setHorizontalSpan(pHorizontalSpan);
        contrainte.setWidthPercentage(pPourcentage);
        return contrainte;
    }

    private void choixSelectionChange() {
        if (this.mChoixMethode.getSelectedIndex() != CalculationMethods.Custom.getValue()) {
            this.mFajrAngle.setEditable(false);
            this.mImsakSelector.setEnabled(false);
            this.mImsakValue.setEditable(false);
            this.mMaghrebSelector.setEnabled(false);
            this.mMaghrebValue.setEditable(false);
            this.mIshaaSelector.setEnabled(false);
            this.mIshaaValue.setEditable(false);
            int methode = CalculationMethods.Jafari.getValue();
            switch (this.mChoixMethode.getSelectedIndex()) {
                case 0: {
                    methode = CalculationMethods.Jafari.getValue();
                    break;
                }
                case 1: {
                    methode = CalculationMethods.Karachi.getValue();
                    break;
                }
                case 2: {
                    methode = CalculationMethods.ISNA.getValue();
                    break;
                }
                case 3: {
                    methode = CalculationMethods.MWL.getValue();
                    break;
                }
                case 4: {
                    methode = CalculationMethods.Makkah.getValue();
                    break;
                }
                case 5: {
                    methode = CalculationMethods.Egypt.getValue();
                    break;
                }
                default: {
                    methode = CalculationMethods.Jafari.getValue();
                }
            }
            double[] valeurs = new SalaahTimeCalculator().getMethodParams()[methode];
            this.mFajrAngle.setText(Double.toString(valeurs[0]));
            this.mImsakSelector.setSelectedIndex((int)valeurs[1]);
            this.mImsakValue.setText(Double.toString(valeurs[2]));
            this.mMaghrebSelector.setSelectedIndex((int)valeurs[3]);
            this.mMaghrebValue.setText(Double.toString(valeurs[4]));
            this.mIshaaSelector.setSelectedIndex((int)valeurs[5]);
            this.mIshaaValue.setText(Double.toString(valeurs[6]));
        } else {
            this.mFajrAngle.setEditable(true);
            this.mImsakSelector.setEnabled(true);
            this.mImsakValue.setEditable(true);
            this.mMaghrebSelector.setEnabled(true);
            this.mMaghrebValue.setEditable(true);
            this.mIshaaSelector.setEnabled(true);
            this.mIshaaValue.setEditable(true);
            this.initialiserCustomParams();
        }
    }

    private void editerLabelCombo(Label pLabel) {
        pLabel.setUIID("LabelInfoName");
        pLabel.getUnselectedStyle().setBgTransparency(0);
        pLabel.getSelectedStyle().setBgTransparency(0);
        pLabel.setFocusable(true);
        pLabel.setAlignment(1);
        pLabel.setPreferredH(20);
    }

    protected void execute(final Form f) {
        final ResourceReader RESSOURCE = ServiceFactory.getFactory().getResourceReader();
        this.applyTactileSettings(f);
        Label lLabelChoixMethode = new Label(RESSOURCE.get("CalculationMethod"));
        this.editerLabelCombo(lLabelChoixMethode);
        Label lLabelAsrMethod = new Label(RESSOURCE.get("AsrJuristicMethod"));
        this.editerLabelCombo(lLabelAsrMethod);
        Object[] imsakValues = new String[]{RESSOURCE.get("Angle"), RESSOURCE.get("MinutesBF")};
        Object[] maghrebValues = new String[]{RESSOURCE.get("Angle"), RESSOURCE.get("MinutesAS")};
        Object[] ishaaValues = new String[]{RESSOURCE.get("Angle"), RESSOURCE.get("MinutesAM")};
        this.mChoixMethode = ServiceFactory.getFactory().getPreferences().getLangue().equals("en") ? new ComboBox(CALCULATION_METHOD_EN) : (ServiceFactory.getFactory().getPreferences().getLangue().equals("fr") ? new ComboBox(CALCULATION_METHOD_FR) : new ComboBox(CALCULATION_METHOD_EN));
        this.mChoixMethode.setSelectedIndex(0);
        this.mChoixMethode.addSelectionListener(new SelectionListener(){

            public void selectionChanged(int oldSelected, int newSelected) {
                if (oldSelected != newSelected) {
                    MenuCalculationMethod.this.choixSelectionChange();
                }
            }
        });
        this.mAsrJuridiqueMethode = new ComboBox(CALCULATION_ASR_METHOD);
        this.mAsrJuridiqueMethode.setSelectedIndex(0);
        this.mImsakSelector = new ComboBox(imsakValues);
        this.mImsakSelector.setSelectedIndex(0);
        this.mMaghrebSelector = new ComboBox(maghrebValues);
        this.mMaghrebSelector.setSelectedIndex(0);
        this.mIshaaSelector = new ComboBox(ishaaValues);
        this.mIshaaSelector.setSelectedIndex(0);
        this.mFajrAngle = new TextField();
        this.editerParametrerLabel(this.mFajrAngle);
        this.mImsakValue = new TextField();
        this.editerParametrerLabel(this.mImsakValue);
        this.mMaghrebValue = new TextField();
        this.editerParametrerLabel(this.mMaghrebValue);
        this.mIshaaValue = new TextField();
        this.editerParametrerLabel(this.mIshaaValue);
        Container ctnSaisie = new Container(new GridLayout(2, 2));
        ctnSaisie.addComponent(lLabelChoixMethode);
        ctnSaisie.addComponent(this.mChoixMethode);
        ctnSaisie.addComponent(lLabelAsrMethod);
        ctnSaisie.addComponent(this.mAsrJuridiqueMethode);
        ctnSaisie.setPreferredH(50);
        TableLayout tblLayoutParams = new TableLayout(4, 3);
        Container lCtnParams = new Container();
        lCtnParams.setLayout(tblLayoutParams);
        lCtnParams.addComponent(this.getCtnLayoutParams(tblLayoutParams, 60, 2), (Component)this.retournerLabelParam(RESSOURCE.get("fajrAngle")));
        lCtnParams.addComponent(this.getCtnLayoutParams(tblLayoutParams, 40, 1), (Component)this.mFajrAngle);
        lCtnParams.addComponent(this.getCtnLayoutParams(tblLayoutParams, 30, 1), (Component)this.retournerLabelParam(RESSOURCE.get("imsakParam")));
        lCtnParams.addComponent(this.getCtnLayoutParams(tblLayoutParams, 50, 1), (Component)this.mImsakSelector);
        lCtnParams.addComponent(this.getCtnLayoutParams(tblLayoutParams, 20, 1), (Component)this.mImsakValue);
        lCtnParams.addComponent(this.getCtnLayoutParams(tblLayoutParams, 30, 1), (Component)this.retournerLabelParam(RESSOURCE.get("maghrebParam")));
        lCtnParams.addComponent(this.getCtnLayoutParams(tblLayoutParams, 50, 1), (Component)this.mMaghrebSelector);
        lCtnParams.addComponent(this.getCtnLayoutParams(tblLayoutParams, 20, 1), (Component)this.mMaghrebValue);
        lCtnParams.addComponent(this.getCtnLayoutParams(tblLayoutParams, 30, 1), (Component)this.retournerLabelParam(RESSOURCE.get("ishaaParam")));
        lCtnParams.addComponent(this.getCtnLayoutParams(tblLayoutParams, 50, 1), (Component)this.mIshaaSelector);
        lCtnParams.addComponent(this.getCtnLayoutParams(tblLayoutParams, 20, 1), (Component)this.mIshaaValue);
        f.setLayout(new BoxLayout(2));
        f.addComponent(ctnSaisie);
        f.addComponent(lCtnParams);
        this.mOK = new Command(RESSOURCE.get("Command.OK")){

            public void actionPerformed(ActionEvent ae) {
                double ishaaValue;
                double maghrebValue;
                double imsakValue;
                int ishaaSelector;
                int maghrebSelector;
                int imsakSelector;
                double fajrAngle;
                int calculationMethod;
                boolean contenuOk;
                block9: {
                    contenuOk = true;
                    calculationMethod = MenuCalculationMethod.this.mChoixMethode.getSelectedIndex();
                    fajrAngle = 0.0;
                    imsakSelector = MenuCalculationMethod.this.mImsakSelector.getSelectedIndex();
                    maghrebSelector = MenuCalculationMethod.this.mMaghrebSelector.getSelectedIndex();
                    ishaaSelector = MenuCalculationMethod.this.mIshaaSelector.getSelectedIndex();
                    imsakValue = 0.0;
                    maghrebValue = 0.0;
                    ishaaValue = 0.0;
                    if (calculationMethod == CalculationMethods.Custom.getValue()) {
                        try {
                            String s_fajrAngle = MenuCalculationMethod.this.mFajrAngle.getText();
                            String s_imsakValue = MenuCalculationMethod.this.mImsakValue.getText();
                            String s_maghrebValue = MenuCalculationMethod.this.mMaghrebValue.getText();
                            String s_ishaaValue = MenuCalculationMethod.this.mIshaaValue.getText();
                            if (!(StringOutilClient.isEmpty(s_fajrAngle) || StringOutilClient.isEmpty(s_imsakValue) || StringOutilClient.isEmpty(s_maghrebValue) || StringOutilClient.isEmpty(s_ishaaValue))) {
                                fajrAngle = Double.parseDouble(s_fajrAngle);
                                imsakValue = Double.parseDouble(s_imsakValue);
                                maghrebValue = Double.parseDouble(s_maghrebValue);
                                ishaaValue = Double.parseDouble(s_ishaaValue);
                                if (!MenuCalculationMethod.this.estAngleCorrect(fajrAngle) || imsakSelector == 0 && !MenuCalculationMethod.this.estAngleCorrect(imsakValue) || imsakSelector == 1 && !MenuCalculationMethod.this.estMinutesCorrect(imsakValue) || maghrebSelector == 0 && !MenuCalculationMethod.this.estAngleCorrect(maghrebValue) || maghrebSelector == 1 && !MenuCalculationMethod.this.estMinutesCorrect(maghrebValue) || ishaaSelector == 0 && !MenuCalculationMethod.this.estAngleCorrect(ishaaValue) || ishaaSelector == 1 && !MenuCalculationMethod.this.estMinutesCorrect(ishaaValue)) {
                                    throw new AthanException("Out of bound values");
                                }
                                break block9;
                            }
                            throw new AthanException("Empty values");
                        }
                        catch (Exception exc) {
                            contenuOk = false;
                        }
                    }
                }
                if (!contenuOk) {
                    ResourceReader RESSOURCE2 = ServiceFactory.getFactory().getResourceReader();
                    Command okCommand = new Command(RESSOURCE2.get("Command.OK"));
                    Dialog.show(RESSOURCE2.get("errorTitle"), RESSOURCE2.get("errorCalculationParameters"), okCommand, new Command[]{okCommand}, 3, null, 0L, (Transition)CommonTransitions.createSlide(1, true, 1000));
                    return;
                }
                try {
                    ServiceFactory.getFactory().getPreferences().set("methodeCalcul", Integer.toString(calculationMethod));
                    if (calculationMethod == CalculationMethods.Custom.getValue()) {
                        ServiceFactory.getFactory().getPreferences().set("customFajrAngle", Double.toString(fajrAngle));
                        ServiceFactory.getFactory().getPreferences().set("customImsakSelector", Integer.toString(imsakSelector));
                        ServiceFactory.getFactory().getPreferences().set("customImsakValue", Double.toString(imsakValue));
                        ServiceFactory.getFactory().getPreferences().set("customMaghrebSelector", Integer.toString(maghrebSelector));
                        ServiceFactory.getFactory().getPreferences().set("customMaghrebValue", Double.toString(maghrebValue));
                        ServiceFactory.getFactory().getPreferences().set("customIshaaSelector", Integer.toString(ishaaSelector));
                        ServiceFactory.getFactory().getPreferences().set("customIshaaValue", Double.toString(ishaaValue));
                    }
                    ServiceFactory.getFactory().getPreferences().save();
                    ServiceFactory.getFactory().getVuePrincipale().rafraichir(new Date(), true, true);
                    Command okCommand = new Command(RESSOURCE.get("Command.OK"));
                    Dialog.show(RESSOURCE.get("propertiesSavedTitle"), RESSOURCE.get("propertiesSavedContent"), okCommand, new Command[]{okCommand}, 4, null, 2000L, (Transition)CommonTransitions.createSlide(1, true, 1000));
                    f.showBack();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        };
        f.addCommand(this.mOK);
        this.initialiserInfosParam();
        this.initialiserClaviers();
    }

    private boolean estAngleCorrect(double pAngle) {
        return pAngle >= 0.0 && pAngle <= 20.0;
    }

    private boolean estMinutesCorrect(double pMinutes) {
        return pMinutes - Math.floor(pMinutes) == 0.0 && pMinutes >= 0.0 && pMinutes <= 120.0;
    }

    private void editerParametrerLabel(TextArea pTextArea) {
        pTextArea.setUIID("LabelLocalisationInfo");
        pTextArea.setAlignment(1);
        pTextArea.setRows(1);
        pTextArea.setPreferredH(20);
    }

    private void initialiserInfosParam() {
        this.initialiserCustomParams();
        int lAsrMethod = 0;
        int lCalcMethod = 0;
        try {
            lAsrMethod = Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("methodeJuristiqueAsr"));
            lCalcMethod = Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("methodeCalcul"));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.mAsrJuridiqueMethode.setSelectedIndex(lAsrMethod);
        this.mChoixMethode.setSelectedIndex(lCalcMethod);
        this.choixSelectionChange();
    }

    private void initialiserCustomParams() {
        String lFajrValue = "0";
        int lImsakSelector = 0;
        int lMaghrebSelector = 0;
        int lIshaaSelector = 0;
        String lImsakValue = "0";
        String lMaghrebValue = "0";
        String lIshaaValue = "0";
        try {
            lFajrValue = ServiceFactory.getFactory().getPreferences().get("customFajrAngle");
            lImsakSelector = Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("customImsakSelector"));
            lImsakValue = ServiceFactory.getFactory().getPreferences().get("customImsakValue");
            lMaghrebSelector = Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("customMaghrebSelector"));
            lMaghrebValue = ServiceFactory.getFactory().getPreferences().get("customMaghrebValue");
            lIshaaSelector = Integer.parseInt(ServiceFactory.getFactory().getPreferences().get("customIshaaSelector"));
            lIshaaValue = ServiceFactory.getFactory().getPreferences().get("customIshaaValue");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        this.mFajrAngle.setText(lFajrValue);
        this.mImsakSelector.setSelectedIndex(lImsakSelector);
        if (lImsakSelector == 0) {
            this.mImsakValue.setText(lImsakValue);
        } else {
            Real rImsakValue = new Real(lImsakValue);
            this.mImsakValue.setText(new Integer(rImsakValue.toInteger()).toString());
        }
        this.mMaghrebSelector.setSelectedIndex(lMaghrebSelector);
        if (lMaghrebSelector == 0) {
            this.mMaghrebValue.setText(lMaghrebValue);
        } else {
            Real rMaghrebValue = new Real(lMaghrebValue);
            this.mMaghrebValue.setText(new Integer(rMaghrebValue.toInteger()).toString());
        }
        this.mIshaaSelector.setSelectedIndex(lIshaaSelector);
        if (lIshaaSelector == 0) {
            this.mIshaaValue.setText(lIshaaValue);
        } else {
            Real rIshaaValue = new Real(lIshaaValue);
            this.mIshaaValue.setText(new Integer(rIshaaValue.toInteger()).toString());
        }
    }

    private void initialiserClaviers() {
        VirtualKeyboard vkbAngles = new VirtualKeyboard();
        vkbAngles.addInputMode("Val.", KB_FLOATS);
        vkbAngles.setInputModeOrder(new String[]{"Val."});
        VirtualKeyboard.bindVirtualKeyboard(this.mFajrAngle, vkbAngles);
        VirtualKeyboard.bindVirtualKeyboard(this.mImsakValue, vkbAngles);
        VirtualKeyboard.bindVirtualKeyboard(this.mMaghrebValue, vkbAngles);
        VirtualKeyboard.bindVirtualKeyboard(this.mIshaaValue, vkbAngles);
    }

    private Label retournerLabelParam(String pTitle) {
        Label lLabel = new Label(pTitle);
        lLabel.setUIID("LabelInfoName");
        lLabel.getUnselectedStyle().setBgTransparency(0);
        lLabel.getSelectedStyle().setBgTransparency(0);
        lLabel.setFocusable(true);
        lLabel.setAlignment(1);
        lLabel.setPreferredH(20);
        return lLabel;
    }
}

