/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import java.io.IOException;
import javax.microedition.io.ConnectionNotFoundException;
import org.j4me.bluetoothgps.BluetoothGPS;
import org.j4me.bluetoothgps.Criteria;
import org.j4me.bluetoothgps.Location;
import org.j4me.bluetoothgps.LocationException;
import org.j4me.bluetoothgps.LocationListener;
import org.j4me.bluetoothgps.LocationProvider;
import org.j4me.logging.Log;

class BluetoothLocationProvider
extends LocationProvider {
    private static final String BLUETOOTH_PROTOCOL = "btspp://";
    private static final String BLUETOOTH_GPS_OPTIONS = ";master=false;encrypt=false;authenticate=false";
    private static BluetoothLocationProvider instance = null;
    private BluetoothGPS gps = null;
    private String bluetoothURL = null;
    private int state = 2;

    public static LocationProvider getInstance(Criteria criteria) throws LocationException, IOException {
        if (instance != null) {
            throw new LocationException("Bluetooth GPS socket already in use.");
        }
        if (BluetoothLocationProvider.matchesCriteria(criteria)) {
            String url = criteria.getRemoteDeviceAddress();
            return BluetoothLocationProvider.getInstance(url);
        }
        return null;
    }

    private BluetoothLocationProvider(String remoteDeviceBTAddress, String channelId) throws ConnectionNotFoundException, IOException, SecurityException {
        int maxTries = 2;
        if (channelId == null) {
            for (int i = 1; i <= 2; ++i) {
                try {
                    this.bluetoothURL = BluetoothLocationProvider.constructBTURL(remoteDeviceBTAddress, Integer.toString(i));
                    this.gps = this.connect(this.bluetoothURL);
                    break;
                }
                catch (IOException e) {
                    if (Log.isDebugEnabled()) {
                        Log.debug("Channel ID = " + i + " failed:  " + e.toString());
                    }
                    if (i != 2) continue;
                    throw e;
                }
            }
        } else {
            this.bluetoothURL = BluetoothLocationProvider.constructBTURL(remoteDeviceBTAddress, channelId);
            this.gps = this.connect(this.bluetoothURL);
        }
    }

    public static boolean matchesCriteria(Criteria criteria) {
        if (criteria.getHorizontalAccuracy() < 1) {
            return false;
        }
        if (criteria.isAltitudeRequired() && criteria.getVerticalAccuracy() < 1) {
            return false;
        }
        if (criteria.getPreferredResponseTime() > 500 && criteria.getPreferredResponseTime() < 500) {
            return false;
        }
        if (criteria.getPreferredPowerConsumption() == 1) {
            return false;
        }
        if (criteria.isAddressInfoRequired()) {
            return false;
        }
        return criteria.getRemoteDeviceAddress() != null;
    }

    public static BluetoothLocationProvider getInstance(String bturl) throws ConnectionNotFoundException, IOException, SecurityException {
        if (instance == null) {
            instance = new BluetoothLocationProvider(bturl, null);
        }
        return instance;
    }

    private BluetoothGPS connect(String bturl) throws ConnectionNotFoundException, IOException, SecurityException {
        BluetoothGPS gps = new BluetoothGPS(this, bturl);
        gps.start();
        return gps;
    }

    protected static String constructBTURL(String deviceBluetoothAddress, String channelId) {
        if (channelId == null || deviceBluetoothAddress == null) {
            return null;
        }
        StringBuffer url = new StringBuffer();
        if (!deviceBluetoothAddress.substring(0, BLUETOOTH_PROTOCOL.length()).equalsIgnoreCase(BLUETOOTH_PROTOCOL)) {
            url.append(BLUETOOTH_PROTOCOL);
        }
        url.append(deviceBluetoothAddress);
        if (deviceBluetoothAddress.indexOf(58, BLUETOOTH_PROTOCOL.length() + 1) < 0) {
            url.append(':');
            url.append(channelId);
        }
        if (deviceBluetoothAddress.indexOf(59) < 0) {
            url.append(BLUETOOTH_GPS_OPTIONS);
        }
        String bturl = url.toString();
        return bturl;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public Location getLocation(int timeout) throws LocationException, InterruptedException {
        Location loc;
        if (timeout == 0 || timeout < -1) {
            throw new IllegalArgumentException();
        }
        long start = System.currentTimeMillis();
        timeout *= 1000;
        do {
            if (this.state == 3 || this.gps == null) {
                throw new LocationException("Bluetooth location provider is out of service");
            }
            loc = this.gps.getLastKnownLocation();
            if (loc != null) continue;
            Thread.sleep(250L);
            if (System.currentTimeMillis() - start <= (long)timeout) continue;
            throw new LocationException("Timed out getting location from Bluetooth location provider");
        } while (loc == null);
        return loc;
    }

    protected Location getLastKnownLocationToProvider() {
        return this.gps.getLastKnownLocation();
    }

    public void setLocationListener(LocationListener locationlistener, int interval, int timeout, int maxAge) {
        this.gps.setLocationListener(locationlistener, interval, timeout, maxAge);
    }

    public String getBluetoothURL() {
        return this.bluetoothURL;
    }

    public void reset() throws IOException {
        if (this.gps != null) {
            this.gps.reacquireFix();
            this.gps.setProviderState(2);
        }
    }

    public void close() {
        if (this.gps != null) {
            this.gps.stop();
            this.state = 3;
            this.gps.setLocationListener(null, -1, -1, -1);
        }
    }
}

