/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.StreamConnection;
import org.j4me.bluetoothgps.BluetoothLocationProvider;
import org.j4me.bluetoothgps.BluetoothReadTimeoutThread;
import org.j4me.bluetoothgps.GPSRecord;
import org.j4me.bluetoothgps.Location;
import org.j4me.bluetoothgps.LocationImpl;
import org.j4me.bluetoothgps.LocationListener;
import org.j4me.bluetoothgps.NMEAParser;
import org.j4me.bluetoothgps.QualifiedCoordinates;
import org.j4me.logging.Log;
import org.j4me.util.ConnectorHelper;

class BluetoothGPS
implements Runnable {
    private static final short BLUETOOTH_TIMEOUT = 3000;
    private static final short BREAK = 500;
    private static final short DISCONNECT_WAIT = 1000;
    public static final short SLEEP_BEFORE_READ = 100;
    public static final short READ_TIMEOUT = 3100;
    public static final short BLUETOOTH_CONNECTION_INIT_SLEEP = 200;
    private static final float MS_PER_KNOT = 0.5144445f;
    private static final int[] MONTH_OFFSET = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private StreamConnection connection;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Thread runner;
    private boolean stop = false;
    private String url;
    private LocationListener locationListener;
    private final BluetoothLocationProvider locationProvider;
    private long locationUpdateInterval;
    private long lastLocationUpdateTime;
    private Location location;

    public BluetoothGPS(BluetoothLocationProvider provider, String url) {
        this.locationProvider = provider;
        this.url = url;
    }

    public Location getLastKnownLocation() {
        return this.location;
    }

    private synchronized void connect() throws ConnectionNotFoundException, IOException, SecurityException {
        if (!this.isConnected()) {
            Log.info("Connecting to Bluetooth device at " + this.url);
            this.connection = (StreamConnection)ConnectorHelper.open(this.url, 3, 3000);
            Log.debug("Bluetooth connection established");
            this.configureBluetoothGPSSettings(this.connection);
            this.inputStream = this.connection.openInputStream();
            this.outputStream = this.connection.openOutputStream();
        }
    }

    private void configureBluetoothGPSSettings(StreamConnection connection) {
        if (this.outputStream != null) {
            try {
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,00,00,01,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,02,00,01,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,04,00,01,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,01,00,00,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,03,00,00,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,05,00,00,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,06,00,00,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,07,00,00,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,08,00,00,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,09,00,00,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PSRF103,10,00,00,01"));
                this.outputStream.write(BluetoothGPS.createSentence("PGRMO,,2"));
                this.outputStream.write(BluetoothGPS.createSentence("PGRMO,GPGGA,1"));
                this.outputStream.write(BluetoothGPS.createSentence("PGRMO,GPGSA,1"));
                this.outputStream.write(BluetoothGPS.createSentence("PGRMO,GPRMC,1"));
                this.outputStream.flush();
                Log.debug("Configured GPS device settings");
            }
            catch (IOException e) {
                Log.warn("Could not send configuration sentences to Bluetooth GPS", e);
            }
        }
    }

    public static byte[] createSentence(String sentence) {
        byte[] input = sentence.getBytes();
        int checksum = 0;
        for (int i = 0; i < input.length; ++i) {
            checksum ^= input[i];
        }
        String hexChecksum = Integer.toHexString(checksum);
        hexChecksum = hexChecksum.toUpperCase();
        StringBuffer buffer = new StringBuffer();
        buffer.append('$');
        buffer.append(sentence);
        buffer.append('*');
        buffer.append(hexChecksum);
        buffer.append("\r\n");
        String packagedSentence = buffer.toString();
        byte[] data = packagedSentence.getBytes();
        return data;
    }

    private synchronized void disconnect() {
        Log.debug("Disconnecting from GPS device");
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (IOException e) {
            Log.warn("Problem closing GPS connection", e);
        }
        this.inputStream = null;
        this.outputStream = null;
        this.connection = null;
    }

    public synchronized boolean isConnected() {
        return this.connection != null && this.inputStream != null;
    }

    public void reacquireFix() {
        if (this.outputStream != null) {
            try {
                String sentence = "PSRF104,0,0,0,0,0,0,12,2";
                if (this.location != null && this.location.isValid()) {
                    QualifiedCoordinates coordinates = this.location.getQualifiedCoordinates();
                    long time = this.location.getTimestamp() - 936921587000L;
                    long oneWeek = 604800000L;
                    long weeks = time / 604800000L;
                    long seconds = time % 604800000L / 1000L;
                    StringBuffer sb = new StringBuffer();
                    sb.append("PSRF104,");
                    sb.append(coordinates.getLatitude());
                    sb.append(",");
                    sb.append(coordinates.getLongitude());
                    sb.append(",");
                    sb.append(Float.isNaN(coordinates.getAltitude()) ? 0.0f : coordinates.getAltitude());
                    sb.append(",0,");
                    sb.append(seconds);
                    sb.append(",");
                    sb.append(weeks);
                    sb.append(",12,3");
                    sentence = sb.toString();
                }
                this.outputStream.write(BluetoothGPS.createSentence(sentence));
            }
            catch (IOException e) {
                Log.warn("Could not re-acquire Bluetooth GPS fix", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean process = true;
        boolean processedGPRMC = false;
        byte[] outputBytes = null;
        int skipCnt = 0;
        int result = 0;
        NMEAParser parser = new NMEAParser();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        BluetoothReadTimeoutThread btrtt = new BluetoothReadTimeoutThread(this.runner, 3100);
        boolean firstItr = true;
        while (process) {
            BluetoothGPS bluetoothGPS;
            try {
                if (this.stop) {
                    this.stop();
                    return;
                }
                if (!this.isConnected()) {
                    this.connect();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                outputBytes = new byte[2048];
                if (firstItr) {
                    btrtt.start();
                    firstItr = false;
                } else {
                    btrtt.restart();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                result = this.inputStream.read(outputBytes, 0, 2048);
                if (result < 0) {
                    throw new IOException("Bluetooth device closed connection");
                }
                btrtt.setReadSuccess(true);
                if (processedGPRMC && result >= 2048 && skipCnt < 4) {
                    parser.flush();
                    skipCnt = (short)(skipCnt + 1);
                    continue;
                }
                processedGPRMC = false;
                skipCnt = 0;
                try {
                    int parseResult = parser.parse(outputBytes, result);
                    if ((parseResult & 1) != 0) {
                        processedGPRMC = true;
                        this.processRecord(parser.getRecordBuffer());
                        bluetoothGPS = this;
                        synchronized (bluetoothGPS) {
                            try {
                                this.wait(500L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            continue;
                        }
                    }
                    if (parseResult != -1) continue;
                    bluetoothGPS = this;
                    synchronized (bluetoothGPS) {
                        try {
                            this.wait(500L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable t) {
                    Log.warn("Problem parsing GPS data", t);
                }
            }
            catch (Throwable t) {
                if (t instanceof InterruptedIOException) {
                    Log.info("Bluetooth GPS stalled.  Disconnecting and reconnecting.");
                } else if (t instanceof IOException) {
                    Log.info("Bluetooth device dropped connection.  Reconnecting.");
                } else if (t instanceof InterruptedException) {
                    process = false;
                } else {
                    Log.warn("Unexpected GPS read error", t);
                }
                this.setProviderState(2);
                this.disconnect();
                bluetoothGPS = this;
                synchronized (bluetoothGPS) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                parser.flush();
            }
        }
    }

    private void processRecord(GPSRecord record) {
        block8: {
            if (record == null || record.quality == null) {
                return;
            }
            if (record.quality.equals("1") || record.quality.equals("2") || record.quality.equals("3")) {
                try {
                    long now;
                    float altitude = record.altitude == null ? Float.NaN : Float.parseFloat(record.altitude);
                    float horizontalAccuracy = Float.parseFloat(record.hdop);
                    float verticalAccuracy = Float.parseFloat(record.vdop);
                    float speed = Float.parseFloat(record.speed);
                    speed *= 0.5144445f;
                    float course = record.course == null ? Float.NaN : Float.parseFloat(record.course);
                    float lattitudeDegrees = BluetoothGPS.convertToDegress(record.lattitude, record.lattitudeDirection);
                    float longitudeDegrees = BluetoothGPS.convertToDegress(record.longitude, record.longitudeDirection);
                    QualifiedCoordinates qualifiedCoordinates = new QualifiedCoordinates(lattitudeDegrees, longitudeDegrees, altitude, horizontalAccuracy, verticalAccuracy);
                    long timestamp = BluetoothGPS.convertUTCTime(record.date, record.secondsSinceMidnight);
                    this.location = new LocationImpl(qualifiedCoordinates, speed, course, timestamp);
                    this.setProviderState(1);
                    if (this.locationListener == null || (now = System.currentTimeMillis()) - this.lastLocationUpdateTime < this.locationUpdateInterval) break block8;
                    this.lastLocationUpdateTime = now;
                    try {
                        this.locationListener.locationUpdated(this.locationProvider, this.location);
                    }
                    catch (Throwable userT) {
                        Log.warn("Unhandled exception in LocationProvider.locationUpdated\n" + this.location, userT);
                    }
                }
                catch (NumberFormatException e) {
                }
                catch (NullPointerException nullPointerException) {}
            } else {
                this.setProviderState(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProviderState(int newState) {
        if (this.locationProvider.getState() != newState) {
            this.locationProvider.setState(newState);
            if (this.locationListener != null) {
                try {
                    this.locationListener.providerStateChanged(this.locationProvider, newState);
                }
                catch (Throwable t) {
                    Log.warn("Unhandled exception in LocationProvider.providerStateChanged to " + newState, t);
                }
            }
            BluetoothGPS bluetoothGPS = this;
            synchronized (bluetoothGPS) {
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static float convertToDegress(String value, char direction) {
        int idx;
        if (value != null && (idx = value.indexOf(46)) > 0) {
            int mmstart = idx - 2;
            float dd = Float.parseFloat(value.substring(0, mmstart));
            float mmmmmm = Float.parseFloat(value.substring(mmstart));
            float val = mmmmmm / 60.0f;
            float result = dd + val;
            if (direction == 'S' || direction == 's') {
                return result * -1.0f;
            }
            if (direction == 'W' || direction == 'w') {
                return result * -1.0f;
            }
            return result;
        }
        return 0.0f;
    }

    public static long convertUTCTime(String date, String time) {
        if (date == null || time == null) {
            return System.currentTimeMillis();
        }
        double d = Double.parseDouble(time);
        int today = (int)(d *= 1000.0);
        int day = Integer.parseInt(date.substring(0, 2));
        int month = Integer.parseInt(date.substring(2, 4));
        int year = Integer.parseInt(date.substring(4, 6));
        long days = 10957L;
        days += (long)(year * 365);
        days += (long)((year - 1) / 4 + 1);
        days += (long)MONTH_OFFSET[month - 1];
        if (year % 4 == 0 && month >= 3) {
            ++days;
        }
        long milliseconds = (days += (long)day) * 86400000L;
        return milliseconds += (long)today;
    }

    public synchronized void start() throws IOException {
        this.connect();
        if (this.runner == null) {
            this.stop = false;
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.runner != null) {
            if (Thread.currentThread() == this.runner) {
                this.runner = null;
                this.disconnect();
                this.setProviderState(2);
            } else {
                this.stop = true;
                this.runner.interrupt();
            }
        } else {
            this.disconnect();
        }
        BluetoothGPS bluetoothGPS = this;
        synchronized (bluetoothGPS) {
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setLocationListener(LocationListener locationListener, int interval, int timeout, int maxAge) {
        this.locationListener = locationListener;
        this.locationUpdateInterval = interval < 1 ? 1000L : (long)(interval * 1000);
    }
}

