/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.tools.sensorsimulator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import org.openintents.tools.sensorsimulator.SensorSimulator;

public class SensorServerThread
implements Runnable {
    public SensorSimulator mSensorSimulator;
    public Thread mThread;
    public SensorServerThread nextThread;
    public SensorServerThread previousThread;
    public Socket mClientSocket;
    boolean talking;

    public SensorServerThread(SensorSimulator newSensorSimulator, Socket newClientSocket) {
        this.mSensorSimulator = newSensorSimulator;
        this.nextThread = null;
        this.previousThread = null;
        this.mClientSocket = newClientSocket;
        this.talking = true;
        this.mThread = new Thread(this);
        this.mThread.start();
    }

    public void run() {
        this.listenThread();
    }

    public void listenThread() {
        block65: {
            try {
                String inputLine;
                PrintWriter out = new PrintWriter(this.mClientSocket.getOutputStream(), true);
                BufferedReader in = new BufferedReader(new InputStreamReader(this.mClientSocket.getInputStream()));
                String outputLine = "SensorSimulator";
                out.println(outputLine);
                this.mSensorSimulator.addMessage("Incoming connection opened.");
                while ((inputLine = in.readLine()) != null) {
                    double updatesPerSecond;
                    if (inputLine.compareTo("getSupportedSensors()") == 0) {
                        String[] supportedSensors = this.getSupportedSensors();
                        out.println("" + supportedSensors.length);
                        for (int i = 0; i < supportedSensors.length; ++i) {
                            out.println(supportedSensors[i]);
                        }
                        continue;
                    }
                    if (inputLine.compareTo("disableSensor()") == 0 || inputLine.compareTo("enableSensor()") == 0) {
                        boolean enable = inputLine.compareTo("enableSensor()") == 0;
                        inputLine = in.readLine();
                        if (inputLine.compareTo("accelerometer") == 0 && this.mSensorSimulator.mSupportedAccelerometer.isSelected()) {
                            out.println("" + this.mSensorSimulator.mEnabledAccelerometer.isSelected());
                            this.mSensorSimulator.mEnabledAccelerometer.setSelected(enable);
                            this.mSensorSimulator.mRefreshEmulatorAccelerometerLabel.setText("-");
                            continue;
                        }
                        if (inputLine.compareTo("magnetic field") == 0 && this.mSensorSimulator.mSupportedMagneticField.isSelected()) {
                            out.println("" + this.mSensorSimulator.mEnabledMagneticField.isSelected());
                            this.mSensorSimulator.mEnabledMagneticField.setSelected(enable);
                            this.mSensorSimulator.mRefreshEmulatorCompassLabel.setText("-");
                            continue;
                        }
                        if (inputLine.compareTo("orientation") == 0 && this.mSensorSimulator.mSupportedOrientation.isSelected()) {
                            out.println("" + this.mSensorSimulator.mEnabledOrientation.isSelected());
                            this.mSensorSimulator.mEnabledOrientation.setSelected(enable);
                            this.mSensorSimulator.mRefreshEmulatorOrientationLabel.setText("-");
                            continue;
                        }
                        if (inputLine.compareTo("temperature") == 0 && this.mSensorSimulator.mSupportedTemperature.isSelected()) {
                            out.println("" + this.mSensorSimulator.mEnabledTemperature.isSelected());
                            this.mSensorSimulator.mEnabledTemperature.setSelected(enable);
                            this.mSensorSimulator.mRefreshEmulatorThermometerLabel.setText("-");
                            continue;
                        }
                        out.println("throw IllegalArgumentException");
                        continue;
                    }
                    if (inputLine.compareTo("getNumSensorValues()") == 0) {
                        inputLine = in.readLine();
                        if (inputLine.compareTo("accelerometer") == 0 && this.mSensorSimulator.mSupportedAccelerometer.isSelected()) {
                            out.println("3");
                            continue;
                        }
                        if (inputLine.compareTo("magnetic field") == 0 && this.mSensorSimulator.mSupportedMagneticField.isSelected()) {
                            out.println("3");
                            continue;
                        }
                        if (inputLine.compareTo("orientation") == 0 && this.mSensorSimulator.mSupportedOrientation.isSelected()) {
                            out.println("3");
                            continue;
                        }
                        if (inputLine.compareTo("temperature") == 0 && this.mSensorSimulator.mSupportedTemperature.isSelected()) {
                            out.println("1");
                            continue;
                        }
                        out.println("throw IllegalArgumentException");
                        continue;
                    }
                    if (inputLine.compareTo("readSensor()") == 0) {
                        inputLine = in.readLine();
                        if (inputLine.compareTo("accelerometer") == 0 && this.mSensorSimulator.mSupportedAccelerometer.isSelected()) {
                            if (this.mSensorSimulator.mEnabledAccelerometer.isSelected()) {
                                String sensorData = "3\n" + this.mSensorSimulator.mobile.read_accelx + "\n" + this.mSensorSimulator.mobile.read_accely + "\n" + this.mSensorSimulator.mobile.read_accelz;
                                out.println(sensorData);
                                this.mSensorSimulator.updateEmulatorAccelerometerRefresh();
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("magnetic field") == 0 && this.mSensorSimulator.mSupportedMagneticField.isSelected()) {
                            if (this.mSensorSimulator.mEnabledMagneticField.isSelected()) {
                                String sensorData = "3\n" + this.mSensorSimulator.mobile.read_compassx + "\n" + this.mSensorSimulator.mobile.read_compassy + "\n" + this.mSensorSimulator.mobile.read_compassz;
                                out.println(sensorData);
                                this.mSensorSimulator.updateEmulatorCompassRefresh();
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("orientation") == 0 && this.mSensorSimulator.mSupportedOrientation.isSelected()) {
                            if (this.mSensorSimulator.mEnabledOrientation.isSelected()) {
                                String sensorData = "3\n" + this.mSensorSimulator.mobile.read_yaw + "\n" + this.mSensorSimulator.mobile.read_pitch + "\n" + this.mSensorSimulator.mobile.read_roll;
                                out.println(sensorData);
                                this.mSensorSimulator.updateEmulatorOrientationRefresh();
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("temperature") == 0 && this.mSensorSimulator.mSupportedTemperature.isSelected()) {
                            if (this.mSensorSimulator.mEnabledTemperature.isSelected()) {
                                String sensorData = "1\n" + this.mSensorSimulator.mobile.read_temperature;
                                out.println(sensorData);
                                this.mSensorSimulator.updateEmulatorThermometerRefresh();
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        out.println("throw IllegalArgumentException");
                        continue;
                    }
                    if (inputLine.compareTo("getSensorUpdateRates()") == 0) {
                        int len;
                        double[] updatesList;
                        inputLine = in.readLine();
                        if (inputLine.compareTo("accelerometer") == 0 && this.mSensorSimulator.mSupportedAccelerometer.isSelected()) {
                            updatesList = this.mSensorSimulator.getSafeDoubleList(this.mSensorSimulator.mUpdateRatesAccelerometerText);
                            if (updatesList == null || updatesList.length < 1) {
                                out.println("0");
                                continue;
                            }
                            len = updatesList.length;
                            out.println("" + len);
                            for (int i = 0; i < len; ++i) {
                                out.println("" + updatesList[i]);
                            }
                            continue;
                        }
                        if (inputLine.compareTo("magnetic field") == 0 && this.mSensorSimulator.mSupportedMagneticField.isSelected()) {
                            updatesList = this.mSensorSimulator.getSafeDoubleList(this.mSensorSimulator.mUpdateRatesCompassText);
                            if (updatesList == null || updatesList.length < 1) {
                                out.println("0");
                                continue;
                            }
                            len = updatesList.length;
                            out.println("" + len);
                            for (int i = 0; i < len; ++i) {
                                out.println("" + updatesList[i]);
                            }
                            continue;
                        }
                        if (inputLine.compareTo("orientation") == 0 && this.mSensorSimulator.mSupportedOrientation.isSelected()) {
                            updatesList = this.mSensorSimulator.getSafeDoubleList(this.mSensorSimulator.mUpdateRatesOrientationText);
                            if (updatesList == null || updatesList.length < 1) {
                                out.println("0");
                                continue;
                            }
                            len = updatesList.length;
                            out.println("" + len);
                            for (int i = 0; i < len; ++i) {
                                out.println("" + updatesList[i]);
                            }
                            continue;
                        }
                        if (inputLine.compareTo("temperature") == 0 && this.mSensorSimulator.mSupportedTemperature.isSelected()) {
                            updatesList = this.mSensorSimulator.getSafeDoubleList(this.mSensorSimulator.mUpdateRatesThermometerText);
                            if (updatesList == null || updatesList.length < 1) {
                                out.println("0");
                                continue;
                            }
                            len = updatesList.length;
                            out.println("" + len);
                            for (int i = 0; i < len; ++i) {
                                out.println("" + updatesList[i]);
                            }
                            continue;
                        }
                        out.println("throw IllegalArgumentException");
                        continue;
                    }
                    if (inputLine.compareTo("getSensorUpdateRate()") == 0) {
                        inputLine = in.readLine();
                        if (inputLine.compareTo("accelerometer") == 0 && this.mSensorSimulator.mSupportedAccelerometer.isSelected()) {
                            if (this.mSensorSimulator.mEnabledAccelerometer.isSelected()) {
                                updatesPerSecond = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mCurrentUpdateRateAccelerometerText, 0.0);
                                out.println("" + updatesPerSecond);
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("magnetic field") == 0 && this.mSensorSimulator.mSupportedMagneticField.isSelected()) {
                            if (this.mSensorSimulator.mEnabledMagneticField.isSelected()) {
                                updatesPerSecond = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mCurrentUpdateRateCompassText, 0.0);
                                out.println("" + updatesPerSecond);
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("orientation") == 0 && this.mSensorSimulator.mSupportedOrientation.isSelected()) {
                            if (this.mSensorSimulator.mEnabledOrientation.isSelected()) {
                                updatesPerSecond = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mCurrentUpdateRateOrientationText, 0.0);
                                out.println("" + updatesPerSecond);
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("temperature") == 0 && this.mSensorSimulator.mSupportedTemperature.isSelected()) {
                            if (this.mSensorSimulator.mEnabledTemperature.isSelected()) {
                                updatesPerSecond = this.mSensorSimulator.getSafeDouble(this.mSensorSimulator.mCurrentUpdateRateThermometerText, 0.0);
                                out.println("" + updatesPerSecond);
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        out.println("throw IllegalArgumentException");
                        continue;
                    }
                    if (inputLine.compareTo("setSensorUpdateRate()") == 0) {
                        inputLine = in.readLine();
                        if (inputLine.compareTo("accelerometer") == 0 && this.mSensorSimulator.mSupportedAccelerometer.isSelected()) {
                            out.println("OK");
                            inputLine = in.readLine();
                            updatesPerSecond = Float.parseFloat(inputLine);
                            this.mSensorSimulator.mCurrentUpdateRateAccelerometerText.setText(inputLine);
                            continue;
                        }
                        if (inputLine.compareTo("magnetic field") == 0 && this.mSensorSimulator.mSupportedMagneticField.isSelected()) {
                            out.println("OK");
                            inputLine = in.readLine();
                            updatesPerSecond = Float.parseFloat(inputLine);
                            this.mSensorSimulator.mCurrentUpdateRateCompassText.setText(inputLine);
                            continue;
                        }
                        if (inputLine.compareTo("orientation") == 0 && this.mSensorSimulator.mSupportedOrientation.isSelected()) {
                            out.println("OK");
                            inputLine = in.readLine();
                            updatesPerSecond = Float.parseFloat(inputLine);
                            this.mSensorSimulator.mCurrentUpdateRateOrientationText.setText(inputLine);
                            continue;
                        }
                        if (inputLine.compareTo("temperature") == 0 && this.mSensorSimulator.mSupportedTemperature.isSelected()) {
                            out.println("OK");
                            inputLine = in.readLine();
                            updatesPerSecond = Float.parseFloat(inputLine);
                            this.mSensorSimulator.mCurrentUpdateRateThermometerText.setText(inputLine);
                            continue;
                        }
                        out.println("throw IllegalArgumentException");
                        continue;
                    }
                    if (inputLine.compareTo("unsetSensorUpdateRate()") == 0) {
                        inputLine = in.readLine();
                        if (inputLine.compareTo("accelerometer") == 0 && this.mSensorSimulator.mSupportedAccelerometer.isSelected()) {
                            if (this.mSensorSimulator.mEnabledAccelerometer.isSelected()) {
                                out.println("OK");
                                this.mSensorSimulator.mCurrentUpdateRateAccelerometerText.setText(this.mSensorSimulator.mDefaultUpdateRateAccelerometerText.getText());
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("magnetic field") == 0 && this.mSensorSimulator.mSupportedMagneticField.isSelected()) {
                            if (this.mSensorSimulator.mEnabledMagneticField.isSelected()) {
                                out.println("OK");
                                this.mSensorSimulator.mCurrentUpdateRateCompassText.setText(this.mSensorSimulator.mDefaultUpdateRateCompassText.getText());
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("orientation") == 0 && this.mSensorSimulator.mSupportedOrientation.isSelected()) {
                            if (this.mSensorSimulator.mEnabledOrientation.isSelected()) {
                                out.println("OK");
                                this.mSensorSimulator.mCurrentUpdateRateOrientationText.setText(this.mSensorSimulator.mDefaultUpdateRateOrientationText.getText());
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        if (inputLine.compareTo("temperature") == 0 && this.mSensorSimulator.mSupportedTemperature.isSelected()) {
                            if (this.mSensorSimulator.mEnabledTemperature.isSelected()) {
                                out.println("OK");
                                this.mSensorSimulator.mCurrentUpdateRateThermometerText.setText(this.mSensorSimulator.mDefaultUpdateRateThermometerText.getText());
                                continue;
                            }
                            out.println("throw IllegalStateException");
                            continue;
                        }
                        out.println("throw IllegalArgumentException");
                        continue;
                    }
                    this.mSensorSimulator.addMessage("WARNING: Client sent unexpected command: " + inputLine);
                }
                out.close();
                in.close();
                this.mClientSocket.close();
            }
            catch (IOException e) {
                if (!this.talking) break block65;
                System.err.println("IOException in SensorServerThread.");
                try {
                    if (this.mClientSocket != null) {
                        this.mClientSocket.close();
                    }
                }
                catch (IOException e2) {
                    System.err.println("Close failed as well.");
                }
            }
        }
        if (this.previousThread != null) {
            this.previousThread.nextThread = this.nextThread;
        }
        if (this.nextThread != null) {
            this.nextThread.previousThread = this.previousThread;
        }
        this.mSensorSimulator.addMessage("Incoming connection closed.");
    }

    public String[] getSupportedSensors() {
        String[] sensorList = new String[4];
        int sensorMax = 0;
        if (this.mSensorSimulator.mSupportedAccelerometer.isSelected()) {
            sensorList[sensorMax] = "accelerometer";
            ++sensorMax;
        }
        if (this.mSensorSimulator.mSupportedMagneticField.isSelected()) {
            sensorList[sensorMax] = "magnetic field";
            ++sensorMax;
        }
        if (this.mSensorSimulator.mSupportedOrientation.isSelected()) {
            sensorList[sensorMax] = "orientation";
            ++sensorMax;
        }
        if (this.mSensorSimulator.mSupportedTemperature.isSelected()) {
            sensorList[sensorMax] = "temperature";
            ++sensorMax;
        }
        String[] returnSensorList = new String[sensorMax];
        for (int i = 0; i < sensorMax; ++i) {
            returnSensorList[i] = sensorList[i];
        }
        return returnSensorList;
    }

    public void stop() {
        try {
            this.talking = false;
            this.mClientSocket.close();
        }
        catch (IOException e) {
            System.err.println("Close failed.");
            System.exit(1);
        }
    }
}

