/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthInternalFrameTitlePane;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JWindow;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InternalFrameUI;
import javax.swing.plaf.UIResource;

class SynthInternalFrameUI
extends InternalFrameUI
implements SynthUI,
LazyActionMap.Loader {
    private SynthStyle style;
    protected MouseInputAdapter borderListener;
    protected PropertyChangeListener propertyChangeListener;
    protected LayoutManager internalFrameLayout;
    protected ComponentListener componentListener;
    protected MouseInputListener glassPaneDispatcher;
    protected JComponent northPane;
    protected JComponent southPane;
    protected JComponent westPane;
    protected JComponent eastPane;
    protected SynthInternalFrameTitlePane titlePane;
    protected JInternalFrame frame;
    private static DesktopManager sharedDesktopManager;
    private boolean componentListenerAdded = false;
    private Rectangle parentBounds;
    private boolean dragging = false;
    private boolean keyBindingRegistered = false;
    private boolean keyBindingActive = false;
    private InternalFrameListener internalFrameListener = null;
    private static boolean isDragging;

    static {
        isDragging = false;
    }

    SynthInternalFrameUI() {
    }

    protected void createInternalFrameListener() {
        this.internalFrameListener = new BasicInternalFrameListener();
    }

    protected void installComponents() {
        this.setNorthPane(this.createNorthPane(this.frame));
        this.setSouthPane(this.createSouthPane(this.frame));
        this.setEastPane(this.createEastPane(this.frame));
        this.setWestPane(this.createWestPane(this.frame));
    }

    protected void installDefaults() {
        Color color;
        JComponent jComponent = (JComponent)this.frame.getContentPane();
        if (jComponent != null && (color = jComponent.getBackground()) instanceof UIResource) {
            jComponent.setBackground(null);
        }
    }

    protected void installKeyboardActions() {
        if (this.internalFrameListener == null) {
            this.createInternalFrameListener();
        }
        this.frame.addInternalFrameListener(this.internalFrameListener);
        LazyActionMap.installLazyActionMap(this.frame, this);
    }

    protected void installListeners() {
        this.borderListener = this.createBorderListener(this.frame);
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
        this.installMouseHandlers(this.frame);
        this.glassPaneDispatcher = this.createGlassPaneDispatcher();
        this.frame.getGlassPane().addMouseListener(this.glassPaneDispatcher);
        this.frame.getGlassPane().addMouseMotionListener(this.glassPaneDispatcher);
        this.componentListener = this.createComponentListener();
        if (this.frame.getParent() != null) {
            this.parentBounds = this.frame.getParent().getBounds();
        }
        if (this.frame.getParent() != null && !this.componentListenerAdded) {
            this.frame.getParent().addComponentListener(this.componentListener);
            this.componentListenerAdded = true;
        }
    }

    protected void setupMenuCloseKey() {
    }

    protected void setupMenuOpenKey() {
        InputMap inputMap = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this.frame, 2, inputMap);
    }

    protected void uninstallComponents() {
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
        this.titlePane = null;
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.frame, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        Icon icon = this.frame.getFrameIcon();
        if (icon instanceof UIResource) {
            this.frame.setFrameIcon(null);
        }
        this.style = null;
    }

    protected void uninstallKeyboardActions() {
        if (this.internalFrameListener != null) {
            this.frame.removeInternalFrameListener(this.internalFrameListener);
        }
        SwingUtilities.replaceUIInputMap(this.frame, 2, null);
        SwingUtilities.replaceUIActionMap(this.frame, null);
    }

    protected void uninstallListeners() {
        if (this.frame.getParent() != null && this.componentListenerAdded) {
            this.frame.getParent().removeComponentListener(this.componentListener);
            this.componentListenerAdded = false;
        }
        this.componentListener = null;
        this.frame.getGlassPane().removeMouseListener(this.glassPaneDispatcher);
        this.frame.getGlassPane().removeMouseMotionListener(this.glassPaneDispatcher);
        this.glassPaneDispatcher = null;
        this.deinstallMouseHandlers(this.frame);
        this.frame.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.borderListener = null;
    }

    public final boolean isKeyBindingActive() {
        return this.keyBindingActive;
    }

    protected final boolean isKeyBindingRegistered() {
        return this.keyBindingRegistered;
    }

    protected final void setKeyBindingActive(boolean bl2) {
        this.keyBindingActive = bl2;
    }

    protected final void setKeyBindingRegistered(boolean bl2) {
        this.keyBindingRegistered = bl2;
    }

    protected LayoutManager createLayoutManager() {
        return new InternalFrameLayout();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new InternalFramePropertyChangeListener();
    }

    protected DesktopManager createDesktopManager() {
        return new DefaultDesktopManager();
    }

    protected DesktopManager getDesktopManager() {
        if (this.frame.getDesktopPane() != null && this.frame.getDesktopPane().getDesktopManager() != null) {
            return this.frame.getDesktopPane().getDesktopManager();
        }
        if (sharedDesktopManager == null) {
            sharedDesktopManager = this.createDesktopManager();
        }
        return sharedDesktopManager;
    }

    InputMap createInputMap(int n2) {
        SynthContext synthContext;
        Object[] objectArray;
        if (n2 == 2 && (objectArray = (Object[])(synthContext = this.getContext(this.frame, 1)).getStyle().get(synthContext, "InternalFrame.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.frame, objectArray);
        }
        return null;
    }

    InputMap getInputMap(int n2) {
        if (n2 == 2) {
            return this.createInputMap(n2);
        }
        return null;
    }

    public JComponent getEastPane() {
        return this.eastPane;
    }

    public JComponent getNorthPane() {
        return this.northPane;
    }

    public JComponent getSouthPane() {
        return this.southPane;
    }

    public JComponent getWestPane() {
        return this.westPane;
    }

    public int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    protected void deinstallMouseHandlers(JComponent jComponent) {
        jComponent.removeMouseListener(this.borderListener);
        jComponent.removeMouseMotionListener(this.borderListener);
    }

    private void fetchStyle(JComponent jComponent) {
        Icon icon;
        SynthContext synthContext = this.getContext(jComponent, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle && ((icon = this.frame.getFrameIcon()) == null || icon instanceof UIResource)) {
            this.frame.setFrameIcon(synthContext.getStyle().getIcon(synthContext, "InternalFrame.icon"));
        }
        synthContext.dispose();
    }

    protected void installMouseHandlers(JComponent jComponent) {
        jComponent.addMouseListener(this.borderListener);
        jComponent.addMouseMotionListener(this.borderListener);
    }

    public void installUI(JComponent jComponent) {
        this.frame = (JInternalFrame)jComponent;
        this.fetchStyle(jComponent);
        this.internalFrameLayout = this.createLayoutManager();
        this.frame.setLayout(this.internalFrameLayout);
        this.installListeners();
        this.installComponents();
        this.installDefaults();
        this.installKeyboardActions();
    }

    public void setEastPane(JComponent jComponent) {
        this.eastPane = jComponent;
    }

    public void setNorthPane(JComponent jComponent) {
        if (this.northPane != null && this.northPane instanceof SynthInternalFrameTitlePane) {
            ((SynthInternalFrameTitlePane)this.northPane).uninstallListeners();
        }
        this.replacePane(this.northPane, jComponent);
        this.northPane = jComponent;
    }

    public void setSouthPane(JComponent jComponent) {
        this.southPane = jComponent;
    }

    public void setWestPane(JComponent jComponent) {
        this.westPane = jComponent;
    }

    public void uninstallUI(JComponent jComponent) {
        if (jComponent != this.frame) {
            throw new IllegalComponentStateException(this + " was asked to deinstall() " + jComponent + " when it only knows about " + this.frame + ".");
        }
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.frame.setCursor(Cursor.getPredefinedCursor(0));
        this.internalFrameLayout = null;
        this.frame.setLayout(null);
        this.frame = null;
    }

    protected void activateFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().activateFrame(jInternalFrame);
    }

    protected void closeFrame(JInternalFrame jInternalFrame) {
        SynthLookAndFeel.playSound(jInternalFrame, "InternalFrame.closeSound");
        this.getDesktopManager().closeFrame(jInternalFrame);
    }

    protected void deactivateFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().deactivateFrame(jInternalFrame);
    }

    protected void deiconifyFrame(JInternalFrame jInternalFrame) {
        if (!jInternalFrame.isMaximum()) {
            SynthLookAndFeel.playSound(jInternalFrame, "InternalFrame.restoreUpSound");
        }
        this.getDesktopManager().deiconifyFrame(jInternalFrame);
    }

    protected void iconifyFrame(JInternalFrame jInternalFrame) {
        SynthLookAndFeel.playSound(jInternalFrame, "InternalFrame.minimizeSound");
        this.getDesktopManager().iconifyFrame(jInternalFrame);
    }

    protected void maximizeFrame(JInternalFrame jInternalFrame) {
        SynthLookAndFeel.playSound(jInternalFrame, "InternalFrame.maximizeSound");
        this.getDesktopManager().maximizeFrame(jInternalFrame);
    }

    protected void minimizeFrame(JInternalFrame jInternalFrame) {
        if (!jInternalFrame.isIcon()) {
            SynthLookAndFeel.playSound(jInternalFrame, "InternalFrame.restoreDownSound");
        }
        this.getDesktopManager().minimizeFrame(jInternalFrame);
    }

    private InternalFrameListener getInternalFrameListener() {
        return this.internalFrameListener;
    }

    protected MouseInputListener createGlassPaneDispatcher() {
        return new GlassPaneDispatcher();
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.frame == jComponent) {
            return this.frame.getLayout().minimumLayoutSize(jComponent);
        }
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.frame == jComponent) {
            return this.frame.getLayout().preferredLayoutSize(jComponent);
        }
        return new Dimension(100, 100);
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    public void loadActionMap(JComponent jComponent, ActionMap actionMap) {
        actionMap.put("showSystemMenu", new AbstractAction(){

            public boolean isEnabled() {
                return SynthInternalFrameUI.this.isKeyBindingActive();
            }

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void replacePane(JComponent jComponent, JComponent jComponent2) {
        if (jComponent != null) {
            this.deinstallMouseHandlers(jComponent);
            this.frame.remove(jComponent);
        }
        if (jComponent2 != null) {
            this.frame.add(jComponent2);
            this.installMouseHandlers(jComponent2);
        }
    }

    protected JComponent createEastPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new SynthInternalFrameTitlePane(jInternalFrame);
        this.titlePane.setName("InternalFrame.northPane");
        return this.titlePane;
    }

    protected JComponent createSouthPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected JComponent createWestPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected MouseInputAdapter createBorderListener(JInternalFrame jInternalFrame) {
        return new BorderListener();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthInternalFrameUI();
    }

    protected class BasicInternalFrameListener
    implements InternalFrameListener {
        protected BasicInternalFrameListener() {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            if (!SynthInternalFrameUI.this.isKeyBindingRegistered()) {
                SynthInternalFrameUI.this.setKeyBindingRegistered(true);
                SynthInternalFrameUI.this.setupMenuOpenKey();
                SynthInternalFrameUI.this.setupMenuCloseKey();
            }
            if (SynthInternalFrameUI.this.isKeyBindingRegistered()) {
                SynthInternalFrameUI.this.setKeyBindingActive(true);
            }
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            SynthInternalFrameUI.this.frame.removeInternalFrameListener(SynthInternalFrameUI.this.internalFrameListener);
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            SynthInternalFrameUI.this.setKeyBindingActive(false);
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }
    }

    protected class BorderListener
    extends MouseInputAdapter
    implements SwingConstants {
        int _x;
        int _y;
        int __x;
        int __y;
        Rectangle startingBounds;
        int resizeDir;
        protected final int RESIZE_NONE = 0;
        private boolean discardRelease = false;
        int resizeCornerSize = 16;

        protected BorderListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1 && mouseEvent.getSource() == SynthInternalFrameUI.this.getNorthPane()) {
                if (SynthInternalFrameUI.this.frame.isIconifiable() && SynthInternalFrameUI.this.frame.isIcon()) {
                    try {
                        SynthInternalFrameUI.this.frame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else if (SynthInternalFrameUI.this.frame.isMaximizable()) {
                    if (!SynthInternalFrameUI.this.frame.isMaximum()) {
                        try {
                            SynthInternalFrameUI.this.frame.setMaximum(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    } else {
                        try {
                            SynthInternalFrameUI.this.frame.setMaximum(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.startingBounds == null) {
                return;
            }
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            int n2 = this._x - point.x;
            int n3 = this._y - point.y;
            Dimension dimension = SynthInternalFrameUI.this.frame.getMinimumSize();
            Dimension dimension2 = SynthInternalFrameUI.this.frame.getMaximumSize();
            if (SynthInternalFrameUI.this.dragging) {
                if (SynthInternalFrameUI.this.frame.isMaximum() || (mouseEvent.getModifiers() & 0x10) != 16) {
                    return;
                }
                Insets insets = SynthInternalFrameUI.this.frame.getInsets();
                Dimension dimension3 = SynthInternalFrameUI.this.frame.getParent().getSize();
                int n4 = dimension3.width;
                int n5 = dimension3.height;
                int n6 = this.startingBounds.x - n2;
                int n7 = this.startingBounds.y - n3;
                if (n6 + insets.left <= -this.__x) {
                    n6 = -this.__x - insets.left;
                }
                if (n7 + insets.top <= -this.__y) {
                    n7 = -this.__y - insets.top;
                }
                if (n6 + this.__x + insets.right > n4) {
                    n6 = n4 - this.__x - insets.right;
                }
                if (n7 + this.__y + insets.bottom > n5) {
                    n7 = n5 - this.__y - insets.bottom;
                }
                SynthInternalFrameUI.this.getDesktopManager().dragFrame(SynthInternalFrameUI.this.frame, n6, n7);
                return;
            }
            if (!SynthInternalFrameUI.this.frame.isResizable()) {
                return;
            }
            int n8 = SynthInternalFrameUI.this.frame.getX();
            int n9 = SynthInternalFrameUI.this.frame.getY();
            int n10 = SynthInternalFrameUI.this.frame.getWidth();
            int n11 = SynthInternalFrameUI.this.frame.getHeight();
            SynthInternalFrameUI.this.parentBounds = SynthInternalFrameUI.this.frame.getParent().getBounds();
            switch (this.resizeDir) {
                case 0: {
                    return;
                }
                case 1: {
                    if (this.startingBounds.height + n3 < dimension.height) {
                        n3 = -(this.startingBounds.height - dimension.height);
                    } else if (this.startingBounds.height + n3 > dimension2.height) {
                        n3 = dimension2.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - n3 < 0) {
                        n3 = this.startingBounds.y;
                    }
                    n8 = this.startingBounds.x;
                    n9 = this.startingBounds.y - n3;
                    n10 = this.startingBounds.width;
                    n11 = this.startingBounds.height + n3;
                    break;
                }
                case 2: {
                    if (this.startingBounds.height + n3 < dimension.height) {
                        n3 = -(this.startingBounds.height - dimension.height);
                    } else if (this.startingBounds.height + n3 > dimension2.height) {
                        n3 = dimension2.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - n3 < 0) {
                        n3 = this.startingBounds.y;
                    }
                    if (this.startingBounds.width - n2 < dimension.width) {
                        n2 = this.startingBounds.width - dimension.width;
                    } else if (this.startingBounds.width - n2 > dimension2.width) {
                        n2 = -(dimension2.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - n2 > ((SynthInternalFrameUI)SynthInternalFrameUI.this).parentBounds.width) {
                        n2 = this.startingBounds.x + this.startingBounds.width - ((SynthInternalFrameUI)SynthInternalFrameUI.this).parentBounds.width;
                    }
                    n8 = this.startingBounds.x;
                    n9 = this.startingBounds.y - n3;
                    n10 = this.startingBounds.width - n2;
                    n11 = this.startingBounds.height + n3;
                    break;
                }
                case 3: {
                    if (this.startingBounds.width - n2 < dimension.width) {
                        n2 = this.startingBounds.width - dimension.width;
                    } else if (this.startingBounds.width - n2 > dimension2.width) {
                        n2 = -(dimension2.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - n2 > ((SynthInternalFrameUI)SynthInternalFrameUI.this).parentBounds.width) {
                        n2 = this.startingBounds.x + this.startingBounds.width - ((SynthInternalFrameUI)SynthInternalFrameUI.this).parentBounds.width;
                    }
                    n10 = this.startingBounds.width - n2;
                    n11 = this.startingBounds.height;
                    break;
                }
                case 4: {
                    if (this.startingBounds.width - n2 < dimension.width) {
                        n2 = this.startingBounds.width - dimension.width;
                    } else if (this.startingBounds.width - n2 > dimension2.width) {
                        n2 = -(dimension2.width - this.startingBounds.width);
                    }
                    if (this.startingBounds.x + this.startingBounds.width - n2 > ((SynthInternalFrameUI)SynthInternalFrameUI.this).parentBounds.width) {
                        n2 = this.startingBounds.x + this.startingBounds.width - ((SynthInternalFrameUI)SynthInternalFrameUI.this).parentBounds.width;
                    }
                    if (this.startingBounds.height - n3 < dimension.height) {
                        n3 = this.startingBounds.height - dimension.height;
                    } else if (this.startingBounds.height - n3 > dimension2.height) {
                        n3 = -(dimension2.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - n3 > ((SynthInternalFrameUI)SynthInternalFrameUI.this).parentBounds.height) {
                        n3 = this.startingBounds.y + this.startingBounds.height - ((SynthInternalFrameUI)SynthInternalFrameUI.this).parentBounds.height;
                    }
                    n10 = this.startingBounds.width - n2;
                    n11 = this.startingBounds.height - n3;
                    break;
                }
                case 5: {
                    if (this.startingBounds.height - n3 < dimension.height) {
                        n3 = this.startingBounds.height - dimension.height;
                    } else if (this.startingBounds.height - n3 > dimension2.height) {
                        n3 = -(dimension2.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - n3 > ((SynthInternalFrameUI)SynthInternalFrameUI.this).parentBounds.height) {
                        n3 = this.startingBounds.y + this.startingBounds.height - ((SynthInternalFrameUI)SynthInternalFrameUI.this).parentBounds.height;
                    }
                    n10 = this.startingBounds.width;
                    n11 = this.startingBounds.height - n3;
                    break;
                }
                case 6: {
                    if (this.startingBounds.height - n3 < dimension.height) {
                        n3 = this.startingBounds.height - dimension.height;
                    } else if (this.startingBounds.height - n3 > dimension2.height) {
                        n3 = -(dimension2.height - this.startingBounds.height);
                    }
                    if (this.startingBounds.y + this.startingBounds.height - n3 > ((SynthInternalFrameUI)SynthInternalFrameUI.this).parentBounds.height) {
                        n3 = this.startingBounds.y + this.startingBounds.height - ((SynthInternalFrameUI)SynthInternalFrameUI.this).parentBounds.height;
                    }
                    if (this.startingBounds.width + n2 < dimension.width) {
                        n2 = -(this.startingBounds.width - dimension.width);
                    } else if (this.startingBounds.width + n2 > dimension2.width) {
                        n2 = dimension2.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - n2 < 0) {
                        n2 = this.startingBounds.x;
                    }
                    n8 = this.startingBounds.x - n2;
                    n9 = this.startingBounds.y;
                    n10 = this.startingBounds.width + n2;
                    n11 = this.startingBounds.height - n3;
                    break;
                }
                case 7: {
                    if (this.startingBounds.width + n2 < dimension.width) {
                        n2 = -(this.startingBounds.width - dimension.width);
                    } else if (this.startingBounds.width + n2 > dimension2.width) {
                        n2 = dimension2.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - n2 < 0) {
                        n2 = this.startingBounds.x;
                    }
                    n8 = this.startingBounds.x - n2;
                    n9 = this.startingBounds.y;
                    n10 = this.startingBounds.width + n2;
                    n11 = this.startingBounds.height;
                    break;
                }
                case 8: {
                    if (this.startingBounds.width + n2 < dimension.width) {
                        n2 = -(this.startingBounds.width - dimension.width);
                    } else if (this.startingBounds.width + n2 > dimension2.width) {
                        n2 = dimension2.width - this.startingBounds.width;
                    }
                    if (this.startingBounds.x - n2 < 0) {
                        n2 = this.startingBounds.x;
                    }
                    if (this.startingBounds.height + n3 < dimension.height) {
                        n3 = -(this.startingBounds.height - dimension.height);
                    } else if (this.startingBounds.height + n3 > dimension2.height) {
                        n3 = dimension2.height - this.startingBounds.height;
                    }
                    if (this.startingBounds.y - n3 < 0) {
                        n3 = this.startingBounds.y;
                    }
                    n8 = this.startingBounds.x - n2;
                    n9 = this.startingBounds.y - n3;
                    n10 = this.startingBounds.width + n2;
                    n11 = this.startingBounds.height + n3;
                    break;
                }
                default: {
                    return;
                }
            }
            SynthInternalFrameUI.this.getDesktopManager().resizeFrame(SynthInternalFrameUI.this.frame, n8, n9, n10, n11);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            SynthInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!SynthInternalFrameUI.this.frame.isResizable()) {
                return;
            }
            if (mouseEvent.getSource() == SynthInternalFrameUI.this.frame || mouseEvent.getSource() == SynthInternalFrameUI.this.getNorthPane()) {
                Insets insets = SynthInternalFrameUI.this.frame.getInsets();
                if (mouseEvent.getX() <= insets.left) {
                    if (mouseEvent.getY() < this.resizeCornerSize + insets.top) {
                        SynthInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(6));
                    } else if (mouseEvent.getY() > SynthInternalFrameUI.this.frame.getHeight() - this.resizeCornerSize - insets.bottom) {
                        SynthInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(4));
                    } else {
                        SynthInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(10));
                    }
                } else if (mouseEvent.getX() >= SynthInternalFrameUI.this.frame.getWidth() - insets.right) {
                    if (mouseEvent.getY() < this.resizeCornerSize + insets.top) {
                        SynthInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(7));
                    } else if (mouseEvent.getY() > SynthInternalFrameUI.this.frame.getHeight() - this.resizeCornerSize - insets.bottom) {
                        SynthInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        SynthInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(11));
                    }
                } else if (mouseEvent.getY() <= insets.top) {
                    if (mouseEvent.getX() < this.resizeCornerSize + insets.left) {
                        SynthInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(6));
                    } else if (mouseEvent.getX() > SynthInternalFrameUI.this.frame.getWidth() - this.resizeCornerSize - insets.right) {
                        SynthInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(7));
                    } else {
                        SynthInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(8));
                    }
                } else if (mouseEvent.getY() >= SynthInternalFrameUI.this.frame.getHeight() - insets.bottom) {
                    if (mouseEvent.getX() < this.resizeCornerSize + insets.left) {
                        SynthInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(4));
                    } else if (mouseEvent.getX() > SynthInternalFrameUI.this.frame.getWidth() - this.resizeCornerSize - insets.right) {
                        SynthInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        SynthInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(9));
                    }
                } else {
                    SynthInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(0));
                }
                return;
            }
            SynthInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Serializable serializable;
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            this.__x = mouseEvent.getX();
            this.__y = mouseEvent.getY();
            this._x = point.x;
            this._y = point.y;
            this.startingBounds = SynthInternalFrameUI.this.frame.getBounds();
            this.resizeDir = 0;
            if (!SynthInternalFrameUI.this.frame.isSelected()) {
                try {
                    SynthInternalFrameUI.this.frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            Insets insets = SynthInternalFrameUI.this.frame.getInsets();
            Point point2 = new Point(this.__x, this.__y);
            if (mouseEvent.getSource() == SynthInternalFrameUI.this.getNorthPane()) {
                serializable = SynthInternalFrameUI.this.getNorthPane().getLocation();
                point2.x += serializable.x;
                point2.y += serializable.y;
                if (point2.x > insets.left && point2.y > insets.top && point2.x < SynthInternalFrameUI.this.frame.getWidth() - insets.right) {
                    SynthInternalFrameUI.this.getDesktopManager().beginDraggingFrame(SynthInternalFrameUI.this.frame);
                    SynthInternalFrameUI.this.dragging = true;
                    return;
                }
            }
            if (!SynthInternalFrameUI.this.frame.isResizable()) {
                return;
            }
            if (mouseEvent.getSource() == SynthInternalFrameUI.this.frame || mouseEvent.getSource() == SynthInternalFrameUI.this.getNorthPane()) {
                if (point2.x <= insets.left) {
                    this.resizeDir = point2.y < this.resizeCornerSize + insets.top ? 8 : (point2.y > SynthInternalFrameUI.this.frame.getHeight() - this.resizeCornerSize - insets.bottom ? 6 : 7);
                } else if (point2.x >= SynthInternalFrameUI.this.frame.getWidth() - insets.right) {
                    this.resizeDir = point2.y < this.resizeCornerSize + insets.top ? 2 : (point2.y > SynthInternalFrameUI.this.frame.getHeight() - this.resizeCornerSize - insets.bottom ? 4 : 3);
                } else if (point2.y <= insets.top) {
                    this.resizeDir = point2.x < this.resizeCornerSize + insets.left ? 8 : (point2.x > SynthInternalFrameUI.this.frame.getWidth() - this.resizeCornerSize - insets.right ? 2 : 1);
                } else if (point2.y >= SynthInternalFrameUI.this.frame.getHeight() - insets.bottom) {
                    this.resizeDir = point2.x < this.resizeCornerSize + insets.left ? 6 : (point2.x > SynthInternalFrameUI.this.frame.getWidth() - this.resizeCornerSize - insets.right ? 4 : 5);
                } else {
                    this.discardRelease = true;
                    return;
                }
                serializable = Cursor.getPredefinedCursor(0);
                switch (this.resizeDir) {
                    case 5: {
                        serializable = Cursor.getPredefinedCursor(9);
                        break;
                    }
                    case 1: {
                        serializable = Cursor.getPredefinedCursor(8);
                        break;
                    }
                    case 7: {
                        serializable = Cursor.getPredefinedCursor(10);
                        break;
                    }
                    case 3: {
                        serializable = Cursor.getPredefinedCursor(11);
                        break;
                    }
                    case 4: {
                        serializable = Cursor.getPredefinedCursor(5);
                        break;
                    }
                    case 6: {
                        serializable = Cursor.getPredefinedCursor(4);
                        break;
                    }
                    case 8: {
                        serializable = Cursor.getPredefinedCursor(6);
                        break;
                    }
                    case 2: {
                        serializable = Cursor.getPredefinedCursor(7);
                    }
                }
                Container container = SynthInternalFrameUI.this.frame.getTopLevelAncestor();
                if (container instanceof JFrame) {
                    ((JFrame)container).getGlassPane().setVisible(true);
                    ((JFrame)container).getGlassPane().setCursor((Cursor)serializable);
                } else if (container instanceof JApplet) {
                    ((JApplet)container).getGlassPane().setVisible(true);
                    ((JApplet)container).getGlassPane().setCursor((Cursor)serializable);
                } else if (container instanceof JWindow) {
                    ((JWindow)container).getGlassPane().setVisible(true);
                    ((JWindow)container).getGlassPane().setCursor((Cursor)serializable);
                } else if (container instanceof JDialog) {
                    ((JDialog)container).getGlassPane().setVisible(true);
                    ((JDialog)container).getGlassPane().setCursor((Cursor)serializable);
                }
                SynthInternalFrameUI.this.getDesktopManager().beginResizingFrame(SynthInternalFrameUI.this.frame, this.resizeDir);
                return;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.discardRelease) {
                this.discardRelease = false;
                return;
            }
            if (this.resizeDir == 0) {
                SynthInternalFrameUI.this.getDesktopManager().endDraggingFrame(SynthInternalFrameUI.this.frame);
                SynthInternalFrameUI.this.dragging = false;
            } else {
                Container container = SynthInternalFrameUI.this.frame.getTopLevelAncestor();
                if (container instanceof JFrame) {
                    ((JFrame)SynthInternalFrameUI.this.frame.getTopLevelAncestor()).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JFrame)SynthInternalFrameUI.this.frame.getTopLevelAncestor()).getGlassPane().setVisible(false);
                } else if (container instanceof JApplet) {
                    ((JApplet)container).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JApplet)container).getGlassPane().setVisible(false);
                } else if (container instanceof JWindow) {
                    ((JWindow)container).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JWindow)container).getGlassPane().setVisible(false);
                } else if (container instanceof JDialog) {
                    ((JDialog)container).getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
                    ((JDialog)container).getGlassPane().setVisible(false);
                }
                SynthInternalFrameUI.this.getDesktopManager().endResizingFrame(SynthInternalFrameUI.this.frame);
            }
            this._x = 0;
            this._y = 0;
            this.__x = 0;
            this.__y = 0;
            this.startingBounds = null;
            this.resizeDir = 0;
        }
    }

    protected class ComponentHandler
    implements ComponentListener {
        protected ComponentHandler() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            Rectangle rectangle = ((Component)componentEvent.getSource()).getBounds();
            Component component = null;
            if (SynthInternalFrameUI.this.frame != null) {
                component = SynthInternalFrameUI.this.frame.getDesktopIcon();
                if (SynthInternalFrameUI.this.frame.isMaximum()) {
                    SynthInternalFrameUI.this.frame.setBounds(0, 0, rectangle.width, rectangle.height);
                }
            }
            if (component != null) {
                Rectangle rectangle2 = component.getBounds();
                int n2 = rectangle2.y + (rectangle.height - ((SynthInternalFrameUI)SynthInternalFrameUI.this).parentBounds.height);
                component.setBounds(rectangle2.x, n2, rectangle2.width, rectangle2.height);
            }
            if (!SynthInternalFrameUI.this.parentBounds.equals(rectangle)) {
                SynthInternalFrameUI.this.parentBounds = rectangle;
            }
            if (SynthInternalFrameUI.this.frame != null) {
                SynthInternalFrameUI.this.frame.validate();
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
        }
    }

    protected class GlassPaneDispatcher
    implements MouseInputListener {
        private Component mouseEventTarget = null;
        private Component dragSource = null;

        protected GlassPaneDispatcher() {
        }

        private void forwardMouseEvent(MouseEvent mouseEvent) {
            Component component = this.findComponentAt(SynthInternalFrameUI.this.frame.getRootPane().getLayeredPane(), mouseEvent.getX(), mouseEvent.getY());
            int n2 = mouseEvent.getID();
            switch (n2) {
                case 504: {
                    if (isDragging && !SynthInternalFrameUI.this.frame.isSelected()) {
                        return;
                    }
                    if (component != this.mouseEventTarget) {
                        this.mouseEventTarget = component;
                    }
                    this.retargetMouseEvent(n2, mouseEvent, this.mouseEventTarget);
                    break;
                }
                case 501: {
                    if (component != this.mouseEventTarget) {
                        this.mouseEventTarget = component;
                    }
                    this.retargetMouseEvent(n2, mouseEvent, this.mouseEventTarget);
                    this.dragSource = component;
                    break;
                }
                case 505: {
                    if (isDragging && !SynthInternalFrameUI.this.frame.isSelected()) {
                        return;
                    }
                    this.retargetMouseEvent(n2, mouseEvent, this.mouseEventTarget);
                    break;
                }
                case 500: {
                    this.retargetMouseEvent(n2, mouseEvent, this.mouseEventTarget);
                    break;
                }
                case 503: {
                    if (component != this.mouseEventTarget) {
                        this.retargetMouseEvent(505, mouseEvent, this.mouseEventTarget);
                        this.mouseEventTarget = component;
                        this.retargetMouseEvent(504, mouseEvent, this.mouseEventTarget);
                    }
                    this.retargetMouseEvent(n2, mouseEvent, this.mouseEventTarget);
                    break;
                }
                case 506: {
                    if (!isDragging) {
                        isDragging = true;
                    }
                    this.retargetMouseEvent(n2, mouseEvent, this.dragSource);
                    break;
                }
                case 502: {
                    if (isDragging) {
                        this.retargetMouseEvent(n2, mouseEvent, this.dragSource);
                        isDragging = false;
                        break;
                    }
                    this.retargetMouseEvent(n2, mouseEvent, this.mouseEventTarget);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SynthInternalFrameUI.this.borderListener != null) {
                SynthInternalFrameUI.this.borderListener.mousePressed(mouseEvent);
            }
            this.forwardMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.forwardMouseEvent(mouseEvent);
        }

        private Component findComponentAt(Container container, int n2, int n3) {
            if (!container.contains(n2, n3)) {
                return container;
            }
            int n4 = container.getComponentCount();
            Component[] componentArray = container.getComponents();
            for (int i2 = 0; i2 < n4; ++i2) {
                Component component = componentArray[i2];
                Point point = component.getLocation();
                if (component == null || !component.contains(n2 - point.x, n3 - point.y) || !(component.getPeer() instanceof LightweightPeer) || !component.isVisible()) continue;
                if (component instanceof Container) {
                    Container container2 = (Container)component;
                    Point point2 = container2.getLocation();
                    Component component2 = this.findComponentAt(container2, n2 - point2.x, n3 - point2.y);
                    if (component2 == null) continue;
                    return component2;
                }
                return component;
            }
            return container;
        }

        private void retargetMouseEvent(int n2, MouseEvent mouseEvent, Component component) {
            if (component == null) {
                return;
            }
            Point point = SwingUtilities.convertPoint(SynthInternalFrameUI.this.frame.getLayeredPane(), mouseEvent.getX(), mouseEvent.getY(), component);
            MouseEvent mouseEvent2 = new MouseEvent(component, n2, mouseEvent.getWhen(), mouseEvent.getModifiers() | mouseEvent.getModifiersEx(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            component.dispatchEvent(mouseEvent2);
        }
    }

    class InternalFrameLayout
    implements LayoutManager {
        InternalFrameLayout() {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Insets insets = SynthInternalFrameUI.this.frame.getInsets();
            int n2 = insets.left;
            int n3 = 0;
            int n4 = SynthInternalFrameUI.this.frame.getWidth() - insets.left - insets.right;
            int n5 = SynthInternalFrameUI.this.frame.getHeight() - insets.bottom;
            if (SynthInternalFrameUI.this.getNorthPane() != null) {
                dimension = SynthInternalFrameUI.this.getNorthPane().getPreferredSize();
                SynthInternalFrameUI.this.getNorthPane().setBounds(0, 0, SynthInternalFrameUI.this.frame.getWidth(), dimension.height);
                n3 += dimension.height;
                n5 -= dimension.height;
            }
            if (SynthInternalFrameUI.this.getSouthPane() != null) {
                dimension = SynthInternalFrameUI.this.getSouthPane().getPreferredSize();
                SynthInternalFrameUI.this.getSouthPane().setBounds(n2, SynthInternalFrameUI.this.frame.getHeight() - insets.bottom - dimension.height, n4, dimension.height);
                n5 -= dimension.height;
            }
            if (SynthInternalFrameUI.this.getWestPane() != null) {
                dimension = SynthInternalFrameUI.this.getWestPane().getPreferredSize();
                SynthInternalFrameUI.this.getWestPane().setBounds(n2, n3, dimension.width, n5);
                n4 -= dimension.width;
                n2 += dimension.width;
            }
            if (SynthInternalFrameUI.this.getEastPane() != null) {
                dimension = SynthInternalFrameUI.this.getEastPane().getPreferredSize();
                SynthInternalFrameUI.this.getEastPane().setBounds(n4 - dimension.width, n3, dimension.width, n5);
                n4 -= dimension.width;
            }
            if (SynthInternalFrameUI.this.frame.getRootPane() != null) {
                SynthInternalFrameUI.this.frame.getRootPane().setBounds(n2, n3, n4, n5);
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = new Dimension();
            if (SynthInternalFrameUI.this.getNorthPane() != null && SynthInternalFrameUI.this.getNorthPane() instanceof SynthInternalFrameTitlePane) {
                dimension = new Dimension(SynthInternalFrameUI.this.getNorthPane().getMinimumSize());
            }
            Insets insets = SynthInternalFrameUI.this.frame.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension;
            Insets insets = SynthInternalFrameUI.this.frame.getInsets();
            Dimension dimension2 = new Dimension(SynthInternalFrameUI.this.frame.getRootPane().getPreferredSize());
            dimension2.width += insets.left + insets.right;
            dimension2.height += insets.top + insets.bottom;
            if (SynthInternalFrameUI.this.getNorthPane() != null) {
                dimension = SynthInternalFrameUI.this.getNorthPane().getPreferredSize();
                dimension2.width = Math.max(dimension.width, dimension2.width);
                dimension2.height += dimension.height;
            }
            if (SynthInternalFrameUI.this.getSouthPane() != null) {
                dimension = SynthInternalFrameUI.this.getSouthPane().getPreferredSize();
                dimension2.width = Math.max(dimension.width, dimension2.width);
                dimension2.height += dimension.height;
            }
            if (SynthInternalFrameUI.this.getEastPane() != null) {
                dimension = SynthInternalFrameUI.this.getEastPane().getPreferredSize();
                dimension2.width += dimension.width;
                dimension2.height = Math.max(dimension.height, dimension2.height);
            }
            if (SynthInternalFrameUI.this.getWestPane() != null) {
                dimension = SynthInternalFrameUI.this.getWestPane().getPreferredSize();
                dimension2.width += dimension.width;
                dimension2.height = Math.max(dimension.height, dimension2.height);
            }
            return dimension2;
        }
    }

    class InternalFramePropertyChangeListener
    implements PropertyChangeListener {
        InternalFramePropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JInternalFrame jInternalFrame = (JInternalFrame)propertyChangeEvent.getSource();
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getOldValue();
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthInternalFrameUI.this.fetchStyle((JInternalFrame)propertyChangeEvent.getSource());
            }
            if ("closed".equals(string)) {
                if (object == Boolean.TRUE) {
                    if (SynthInternalFrameUI.this.frame.getParent() != null && SynthInternalFrameUI.this.componentListenerAdded) {
                        SynthInternalFrameUI.this.frame.getParent().removeComponentListener(SynthInternalFrameUI.this.componentListener);
                    }
                    SynthInternalFrameUI.this.closeFrame(jInternalFrame);
                }
            } else if ("maximum".equals(string)) {
                if (object == Boolean.TRUE) {
                    SynthInternalFrameUI.this.maximizeFrame(jInternalFrame);
                } else {
                    SynthInternalFrameUI.this.minimizeFrame(jInternalFrame);
                }
            } else if ("icon".equals(string)) {
                if (object == Boolean.TRUE) {
                    SynthInternalFrameUI.this.iconifyFrame(jInternalFrame);
                } else {
                    SynthInternalFrameUI.this.deiconifyFrame(jInternalFrame);
                }
            } else if ("selected".equals(string)) {
                Component component = jInternalFrame.getGlassPane();
                if (object == Boolean.TRUE && object2 == Boolean.FALSE) {
                    SynthInternalFrameUI.this.activateFrame(jInternalFrame);
                    component.setVisible(false);
                } else if (object == Boolean.FALSE && object2 == Boolean.TRUE) {
                    SynthInternalFrameUI.this.deactivateFrame(jInternalFrame);
                    component.setVisible(true);
                }
            } else if (string.equals("ancestor")) {
                if (SynthInternalFrameUI.this.frame.getParent() != null) {
                    SynthInternalFrameUI.this.parentBounds = jInternalFrame.getParent().getBounds();
                } else {
                    SynthInternalFrameUI.this.parentBounds = null;
                }
                if (SynthInternalFrameUI.this.frame.getParent() != null && !SynthInternalFrameUI.this.componentListenerAdded) {
                    jInternalFrame.getParent().addComponentListener(SynthInternalFrameUI.this.componentListener);
                    SynthInternalFrameUI.this.componentListenerAdded = true;
                } else if (object == null && SynthInternalFrameUI.this.componentListenerAdded) {
                    if (jInternalFrame.getParent() != null) {
                        jInternalFrame.getParent().removeComponentListener(SynthInternalFrameUI.this.componentListener);
                    }
                    SynthInternalFrameUI.this.componentListenerAdded = false;
                }
            } else if ("title".equals(string) || string.equals("closable") || string.equals("iconable") || string.equals("maximizable")) {
                Dimension dimension = SynthInternalFrameUI.this.frame.getMinimumSize();
                Dimension dimension2 = SynthInternalFrameUI.this.frame.getSize();
                if (dimension.width > dimension2.width) {
                    SynthInternalFrameUI.this.frame.setSize(dimension.width, dimension2.height);
                }
            }
        }
    }
}

