/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DisabledSecurity;
import com.sun.media.sound.JDK12;
import com.sun.media.sound.JDK12ConfigureThreadAction;
import com.sun.media.sound.JDK12NewMixerThreadAction;
import com.sun.media.sound.JDK12TopmostThreadGroupAction;
import com.sun.media.sound.JSSecurity;
import com.sun.media.sound.JSSecurityManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;

class MixerThread
extends Thread {
    private static Vector threadObjects = new Vector();
    private static ThreadGroup topmostThreadGroup = null;
    private static String threadName = "Headspace mixer frame proc thread";
    private static JSSecurity jsSecurity = null;
    private static boolean securityPrivilege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private boolean paused;
    private long frameProc;

    static {
        Method[] methodArray = new Method[1];
        Class[] classArray = new Class[1];
        Object[][] objectArray = new Object[1][0];
        securityPrivilege = true;
        try {
            jsSecurity = JSSecurityManager.getJSSecurity();
            if (jsSecurity != null && !(jsSecurity instanceof DisabledSecurity)) {
                jsSecurity.requestPermission(methodArray, classArray, objectArray, 32);
                methodArray[0].invoke(classArray[0], objectArray[0]);
            }
        }
        catch (Exception exception) {
            securityPrivilege = false;
        }
        if (securityPrivilege) {
            if (jsSecurity == null || !(jsSecurity instanceof DisabledSecurity)) {
                if (jsSecurity != null && jsSecurity.getName().startsWith("JDK12")) {
                    try {
                        Constructor constructor = JDK12TopmostThreadGroupAction.cons;
                        topmostThreadGroup = (ThreadGroup)JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(new Object[0])});
                    }
                    catch (Exception exception) {
                        topmostThreadGroup = MixerThread.getTopmostThreadGroup();
                    }
                } else {
                    topmostThreadGroup = MixerThread.getTopmostThreadGroup();
                }
            }
        } else {
            topmostThreadGroup = Thread.currentThread().getThreadGroup();
        }
    }

    protected MixerThread() {
        super(topmostThreadGroup, "");
        if (jsSecurity == null || !(jsSecurity instanceof DisabledSecurity)) {
            if (jsSecurity != null && jsSecurity.getName().startsWith("JDK12")) {
                try {
                    Constructor constructor = JDK12ConfigureThreadAction.cons;
                    JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(new Object[]{this, threadName})});
                }
                catch (Exception exception) {
                    this.configureThread();
                }
            } else {
                this.configureThread();
            }
        }
        this.paused = false;
    }

    private void configureThread() {
        this.setDaemon(true);
        this.setPriority(10);
        this.setName(threadName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            this.runNative(this.frameProc);
            MixerThread mixerThread = this;
            synchronized (mixerThread) {
                this.paused = true;
                while (this.paused) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private synchronized void unpause() {
        this.paused = false;
        this.notify();
    }

    private native void runNative(long var1);

    private void setFrameProc(long l2) {
        this.frameProc = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MixerThread getExistingThreadObject(long l2) {
        Vector vector = threadObjects;
        synchronized (vector) {
            for (int i2 = 0; i2 < threadObjects.size(); ++i2) {
                MixerThread mixerThread = (MixerThread)threadObjects.elementAt(i2);
                if (mixerThread.frameProc != l2) continue;
                return mixerThread;
            }
        }
        return null;
    }

    private static MixerThread getNewThreadObject(long l2) {
        Method[] methodArray = new Method[1];
        Class[] classArray = new Class[1];
        Object[][] objectArray = new Object[1][0];
        MixerThread mixerThread = null;
        if (securityPrivilege && jsSecurity != null) {
            if (jsSecurity.getName().startsWith("JDK12")) {
                try {
                    Constructor constructor = JDK12NewMixerThreadAction.cons;
                    mixerThread = (MixerThread)JDK12.doPrivM.invoke(JDK12.ac, new Object[]{constructor.newInstance(new Object[0])});
                }
                catch (Exception exception) {
                    mixerThread = new MixerThread();
                    mixerThread.setFrameProc(l2);
                }
                mixerThread.setFrameProc(l2);
            } else {
                try {
                    jsSecurity.requestPermission(methodArray, classArray, objectArray, 16);
                    methodArray[0].invoke(classArray[0], objectArray[0]);
                    jsSecurity.requestPermission(methodArray, classArray, objectArray, 32);
                    methodArray[0].invoke(classArray[0], objectArray[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mixerThread = new MixerThread();
                mixerThread.setFrameProc(l2);
            }
        } else {
            mixerThread = new MixerThread();
            mixerThread.setFrameProc(l2);
        }
        threadObjects.addElement(mixerThread);
        return mixerThread;
    }

    private static ThreadGroup getTopmostThreadGroup() {
        ThreadGroup threadGroup = MixerThread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null && threadGroup.getParent().getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }
}

