/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.ScrollPaneConstants;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class BasicScrollPaneUI
extends ScrollPaneUI
implements ScrollPaneConstants {
    protected JScrollPane scrollpane;
    protected ChangeListener vsbChangeListener;
    protected ChangeListener hsbChangeListener;
    protected ChangeListener viewportChangeListener;
    protected PropertyChangeListener spPropertyChangeListener;
    private MouseWheelListener mouseScrollListener;
    private PropertyChangeListener vsbPropertyChangeListener;
    private PropertyChangeListener hsbPropertyChangeListener;
    private PropertyChangeListener sbPropertyChangeListener;
    private boolean setValueCalled = false;

    protected void syncScrollPaneWithViewport() {
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        JViewport jViewport2 = this.scrollpane.getRowHeader();
        JViewport jViewport3 = this.scrollpane.getColumnHeader();
        boolean bl2 = this.scrollpane.getComponentOrientation().isLeftToRight();
        if (jViewport != null) {
            int n2;
            int n3;
            int n4;
            Dimension dimension = jViewport.getExtentSize();
            Dimension dimension2 = jViewport.getViewSize();
            Point point = jViewport.getViewPosition();
            if (jScrollBar != null) {
                n4 = dimension.height;
                n3 = dimension2.height;
                n2 = Math.max(0, Math.min(point.y, n3 - n4));
                jScrollBar.setValues(n2, n4, 0, n3);
            }
            if (jScrollBar2 != null) {
                n4 = dimension.width;
                n3 = dimension2.width;
                if (bl2) {
                    n2 = Math.max(0, Math.min(point.x, n3 - n4));
                } else {
                    int n5 = jScrollBar2.getValue();
                    if (this.setValueCalled && n3 - n5 == point.x) {
                        n2 = Math.max(0, Math.min(n3 - n4, n5));
                        if (n4 != 0) {
                            this.setValueCalled = false;
                        }
                    } else if (n4 > n3) {
                        point.x = n3 - n4;
                        jViewport.setViewPosition(point);
                        n2 = 0;
                    } else {
                        n2 = Math.max(0, Math.min(n3 - n4, n3 - n4 - point.x));
                    }
                }
                jScrollBar2.setValues(n2, n4, 0, n3);
            }
            if (jViewport2 != null) {
                Point point2 = jViewport2.getViewPosition();
                point2.y = jViewport.getViewPosition().y;
                point2.x = 0;
                jViewport2.setViewPosition(point2);
            }
            if (jViewport3 != null) {
                Point point3 = jViewport3.getViewPosition();
                point3.x = bl2 ? jViewport.getViewPosition().x : Math.max(0, jViewport.getViewPosition().x);
                point3.y = 0;
                jViewport3.setViewPosition(point3);
            }
        }
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler();
    }

    protected void updateColumnHeader(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            JViewport jViewport2 = this.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            point.x = jViewport2 == null ? 0 : (this.scrollpane.getComponentOrientation().isLeftToRight() ? jViewport2.getViewPosition().x : Math.max(0, jViewport2.getViewPosition().x));
            jViewport.setViewPosition(point);
            this.scrollpane.add((Component)jViewport, "COLUMN_HEADER");
        }
    }

    private void updateHorizontalScrollBar(PropertyChangeEvent propertyChangeEvent) {
        this.updateScrollBar(propertyChangeEvent, this.hsbChangeListener, this.hsbPropertyChangeListener);
    }

    protected void updateRowHeader(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            JViewport jViewport2 = this.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            point.y = jViewport2 != null ? jViewport2.getViewPosition().y : 0;
            jViewport.setViewPosition(point);
        }
    }

    protected void updateScrollBarDisplayPolicy(PropertyChangeEvent propertyChangeEvent) {
        this.scrollpane.revalidate();
        this.scrollpane.repaint();
    }

    private void updateVerticalScrollBar(PropertyChangeEvent propertyChangeEvent) {
        this.updateScrollBar(propertyChangeEvent, this.vsbChangeListener, this.vsbPropertyChangeListener);
    }

    protected void updateViewport(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getOldValue();
        JViewport jViewport2 = (JViewport)propertyChangeEvent.getNewValue();
        if (jViewport != null) {
            jViewport.removeChangeListener(this.viewportChangeListener);
        }
        if (jViewport2 != null) {
            int n2;
            int n3;
            Point point = jViewport2.getViewPosition();
            point.x = this.scrollpane.getComponentOrientation().isLeftToRight() ? Math.max(point.x, 0) : ((n3 = jViewport2.getExtentSize().width) > (n2 = jViewport2.getViewSize().width) ? n2 - n3 : Math.max(0, Math.min(n2 - n3, point.x)));
            point.y = Math.max(point.y, 0);
            jViewport2.setViewPosition(point);
            jViewport2.addChangeListener(this.viewportChangeListener);
        }
    }

    private PropertyChangeListener createHSBPropertyChangeListener() {
        return this.getSBPropertyChangeListener();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    private PropertyChangeListener createVSBPropertyChangeListener() {
        return this.getSBPropertyChangeListener();
    }

    private PropertyChangeListener getSBPropertyChangeListener() {
        if (this.sbPropertyChangeListener == null) {
            this.sbPropertyChangeListener = new ScrollBarPropertyChangeHandler();
        }
        return this.sbPropertyChangeListener;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("scrollUp", new ScrollAction("scrollUp", 1, -1, true));
        actionMapUIResource.put("scrollDown", new ScrollAction("scrollDown", 1, 1, true));
        actionMapUIResource.put("scrollHome", new ScrollHomeAction("ScrollHome"));
        actionMapUIResource.put("scrollEnd", new ScrollEndAction("ScrollEnd"));
        actionMapUIResource.put("unitScrollUp", new ScrollAction("UnitScrollUp", 1, -1, false));
        actionMapUIResource.put("unitScrollDown", new ScrollAction("UnitScrollDown", 1, 1, false));
        if (this.scrollpane.getComponentOrientation().isLeftToRight()) {
            actionMapUIResource.put("scrollLeft", new ScrollAction("scrollLeft", 0, -1, true));
            actionMapUIResource.put("scrollRight", new ScrollAction("ScrollRight", 0, 1, true));
            actionMapUIResource.put("unitScrollRight", new ScrollAction("UnitScrollRight", 0, 1, false));
            actionMapUIResource.put("unitScrollLeft", new ScrollAction("UnitScrollLeft", 0, -1, false));
        } else {
            actionMapUIResource.put("scrollLeft", new ScrollAction("scrollLeft", 0, 1, true));
            actionMapUIResource.put("scrollRight", new ScrollAction("ScrollRight", 0, -1, true));
            actionMapUIResource.put("unitScrollRight", new ScrollAction("UnitScrollRight", 0, -1, false));
            actionMapUIResource.put("unitScrollLeft", new ScrollAction("UnitScrollLeft", 0, 1, false));
        }
        return actionMapUIResource;
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("ScrollPane.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("ScrollPane.actionMap", actionMap);
        }
        return actionMap;
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)UIManager.get("ScrollPane.ancestorInputMap");
            if (this.scrollpane.getComponentOrientation().isLeftToRight() || (inputMap = (InputMap)UIManager.get("ScrollPane.ancestorInputMap.RightToLeft")) == null) {
                return inputMap2;
            }
            inputMap.setParent(inputMap2);
            return inputMap;
        }
        return null;
    }

    public void installUI(JComponent jComponent) {
        this.scrollpane = (JScrollPane)jComponent;
        this.installDefaults(this.scrollpane);
        this.installListeners(this.scrollpane);
        this.installKeyboardActions(this.scrollpane);
    }

    protected void uninstallListeners(JComponent jComponent) {
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        if (jViewport != null) {
            jViewport.removeChangeListener(this.viewportChangeListener);
        }
        if (jScrollBar != null) {
            jScrollBar.getModel().removeChangeListener(this.vsbChangeListener);
            jScrollBar.removePropertyChangeListener(this.vsbPropertyChangeListener);
        }
        if (jScrollBar2 != null) {
            jScrollBar2.getModel().removeChangeListener(this.hsbChangeListener);
            jScrollBar2.removePropertyChangeListener(this.hsbPropertyChangeListener);
        }
        this.scrollpane.removePropertyChangeListener(this.spPropertyChangeListener);
        if (this.mouseScrollListener != null) {
            this.scrollpane.removeMouseWheelListener(this.mouseScrollListener);
        }
        this.vsbChangeListener = null;
        this.hsbChangeListener = null;
        this.viewportChangeListener = null;
        this.spPropertyChangeListener = null;
        this.mouseScrollListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults(this.scrollpane);
        this.uninstallListeners(this.scrollpane);
        this.uninstallKeyboardActions(this.scrollpane);
        this.scrollpane = null;
    }

    protected void installDefaults(JScrollPane jScrollPane) {
        LookAndFeel.installBorder(jScrollPane, "ScrollPane.border");
        LookAndFeel.installColorsAndFont(jScrollPane, "ScrollPane.background", "ScrollPane.foreground", "ScrollPane.font");
        Border border = jScrollPane.getViewportBorder();
        if (border == null || border instanceof UIResource) {
            border = UIManager.getBorder("ScrollPane.viewportBorder");
            jScrollPane.setViewportBorder(border);
        }
    }

    protected void installKeyboardActions(JScrollPane jScrollPane) {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(jScrollPane, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jScrollPane, actionMap);
    }

    protected void installListeners(JScrollPane jScrollPane) {
        this.vsbChangeListener = this.createVSBChangeListener();
        this.vsbPropertyChangeListener = this.createVSBPropertyChangeListener();
        this.hsbChangeListener = this.createHSBChangeListener();
        this.hsbPropertyChangeListener = this.createHSBPropertyChangeListener();
        this.viewportChangeListener = this.createViewportChangeListener();
        this.spPropertyChangeListener = this.createPropertyChangeListener();
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
        if (jViewport != null) {
            jViewport.addChangeListener(this.viewportChangeListener);
        }
        if (jScrollBar != null) {
            jScrollBar.getModel().addChangeListener(this.vsbChangeListener);
            jScrollBar.addPropertyChangeListener(this.vsbPropertyChangeListener);
        }
        if (jScrollBar2 != null) {
            jScrollBar2.getModel().addChangeListener(this.hsbChangeListener);
            jScrollBar2.addPropertyChangeListener(this.hsbPropertyChangeListener);
        }
        this.scrollpane.addPropertyChangeListener(this.spPropertyChangeListener);
        this.mouseScrollListener = this.createMouseWheelListener();
        this.scrollpane.addMouseWheelListener(this.mouseScrollListener);
    }

    protected void uninstallDefaults(JScrollPane jScrollPane) {
        LookAndFeel.uninstallBorder(this.scrollpane);
        if (this.scrollpane.getViewportBorder() instanceof UIResource) {
            this.scrollpane.setViewportBorder(null);
        }
    }

    protected void uninstallKeyboardActions(JScrollPane jScrollPane) {
        SwingUtilities.replaceUIActionMap(jScrollPane, null);
        SwingUtilities.replaceUIInputMap(jScrollPane, 1, null);
    }

    protected ChangeListener createHSBChangeListener() {
        return new HSBChangeListener();
    }

    protected ChangeListener createVSBChangeListener() {
        return new VSBChangeListener();
    }

    protected ChangeListener createViewportChangeListener() {
        return new ViewportChangeHandler();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Border border = this.scrollpane.getViewportBorder();
        if (border != null) {
            Rectangle rectangle = this.scrollpane.getViewportBorderBounds();
            border.paintBorder(this.scrollpane, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicScrollPaneUI();
    }

    private void updateScrollBar(PropertyChangeEvent propertyChangeEvent, ChangeListener changeListener, PropertyChangeListener propertyChangeListener) {
        JScrollBar jScrollBar = (JScrollBar)propertyChangeEvent.getOldValue();
        if (jScrollBar != null) {
            if (changeListener != null) {
                jScrollBar.getModel().removeChangeListener(changeListener);
            }
            if (propertyChangeListener != null) {
                jScrollBar.removePropertyChangeListener(propertyChangeListener);
            }
        }
        if ((jScrollBar = (JScrollBar)propertyChangeEvent.getNewValue()) != null) {
            if (changeListener != null) {
                jScrollBar.getModel().addChangeListener(changeListener);
            }
            if (propertyChangeListener != null) {
                jScrollBar.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    public class HSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
            if (jViewport != null) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
                Point point = jViewport.getViewPosition();
                int n2 = boundedRangeModel.getValue();
                if (BasicScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight()) {
                    point.x = n2;
                } else {
                    int n3 = jViewport.getViewSize().width;
                    int n4 = jViewport.getExtentSize().width;
                    int n5 = point.x;
                    point.x = n3 - n4 - n2;
                    if (n4 == 0 && n2 != 0 && n5 == n3) {
                        BasicScrollPaneUI.this.setValueCalled = true;
                    } else if (n4 != 0 && n5 < 0 && point.x == 0) {
                        point.x += n2;
                    }
                }
                jViewport.setViewPosition(point);
            }
        }
    }

    protected class MouseWheelHandler
    implements MouseWheelListener {
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (BasicScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && mouseWheelEvent.getScrollAmount() != 0) {
                JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                int n2 = 0;
                if (!(jScrollBar != null && jScrollBar.isVisible() || (jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) != null && jScrollBar.isVisible())) {
                    return;
                }
                int n3 = n2 = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
                if (mouseWheelEvent.getScrollType() == 0) {
                    BasicScrollBarUI.scrollByUnits(jScrollBar, n2, mouseWheelEvent.getScrollAmount());
                } else if (mouseWheelEvent.getScrollType() == 1) {
                    BasicScrollBarUI.scrollByBlock(jScrollBar, n2);
                }
            }
        }

        protected MouseWheelHandler() {
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("verticalScrollBarDisplayPolicy")) {
                BasicScrollPaneUI.this.updateScrollBarDisplayPolicy(propertyChangeEvent);
            } else if (string.equals("horizontalScrollBarDisplayPolicy")) {
                BasicScrollPaneUI.this.updateScrollBarDisplayPolicy(propertyChangeEvent);
            } else if (string.equals("viewport")) {
                BasicScrollPaneUI.this.updateViewport(propertyChangeEvent);
            } else if (string.equals("rowHeader")) {
                BasicScrollPaneUI.this.updateRowHeader(propertyChangeEvent);
            } else if (string.equals("columnHeader")) {
                BasicScrollPaneUI.this.updateColumnHeader(propertyChangeEvent);
            } else if (string.equals("verticalScrollBar")) {
                BasicScrollPaneUI.this.updateVerticalScrollBar(propertyChangeEvent);
            } else if (string.equals("horizontalScrollBar")) {
                BasicScrollPaneUI.this.updateHorizontalScrollBar(propertyChangeEvent);
            } else if (string.equals("componentOrientation")) {
                BasicScrollPaneUI.this.scrollpane.revalidate();
                BasicScrollPaneUI.this.scrollpane.repaint();
                InputMap inputMap = BasicScrollPaneUI.this.getInputMap(1);
                SwingUtilities.replaceUIInputMap(BasicScrollPaneUI.this.scrollpane, 1, inputMap);
                UIManager.getLookAndFeelDefaults().put("ScrollPane.actionMap", null);
                ActionMap actionMap = BasicScrollPaneUI.this.getActionMap();
                SwingUtilities.replaceUIActionMap(BasicScrollPaneUI.this.scrollpane, actionMap);
            }
        }
    }

    private static class ScrollAction
    extends AbstractAction {
        protected int orientation;
        protected int direction;
        private boolean block;

        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                Rectangle rectangle = jViewport.getViewRect();
                Dimension dimension = component.getSize();
                int n2 = component instanceof Scrollable ? (this.block ? ((Scrollable)((Object)component)).getScrollableBlockIncrement(rectangle, this.orientation, this.direction) : ((Scrollable)((Object)component)).getScrollableUnitIncrement(rectangle, this.orientation, this.direction)) : (this.block ? (this.orientation == 1 ? rectangle.height : rectangle.width) : 10);
                if (this.orientation == 1) {
                    rectangle.y += n2 * this.direction;
                    if (rectangle.y + rectangle.height > dimension.height) {
                        rectangle.y = Math.max(0, dimension.height - rectangle.height);
                    } else if (rectangle.y < 0) {
                        rectangle.y = 0;
                    }
                } else if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                    rectangle.x += n2 * this.direction;
                    if (rectangle.x + rectangle.width > dimension.width) {
                        rectangle.x = Math.max(0, dimension.width - rectangle.width);
                    } else if (rectangle.x < 0) {
                        rectangle.x = 0;
                    }
                } else {
                    rectangle.x -= n2 * this.direction;
                    rectangle.x = rectangle.width > dimension.width ? dimension.width - rectangle.width : Math.max(0, Math.min(dimension.width - rectangle.width, rectangle.x));
                }
                jViewport.setViewPosition(rectangle.getLocation());
            }
        }

        protected ScrollAction(String string, int n2, int n3, boolean bl2) {
            super(string);
            this.orientation = n2;
            this.direction = n3;
            this.block = bl2;
        }
    }

    private class ScrollBarPropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getSource();
            if ("model".equals(string)) {
                JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)propertyChangeEvent.getOldValue();
                ChangeListener changeListener = null;
                if (object == jScrollBar) {
                    changeListener = BasicScrollPaneUI.this.vsbChangeListener;
                } else if (object == BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                    jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    changeListener = BasicScrollPaneUI.this.hsbChangeListener;
                }
                if (changeListener != null) {
                    if (boundedRangeModel != null) {
                        boundedRangeModel.removeChangeListener(changeListener);
                    }
                    if (jScrollBar.getModel() != null) {
                        jScrollBar.getModel().addChangeListener(changeListener);
                    }
                }
            } else if ("componentOrientation".equals(string) && object == BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) {
                JScrollBar jScrollBar = BasicScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
                Point point = jViewport.getViewPosition();
                point.x = BasicScrollPaneUI.this.scrollpane.getComponentOrientation().isLeftToRight() ? jScrollBar.getValue() : jViewport.getViewSize().width - jViewport.getExtentSize().width - jScrollBar.getValue();
                jViewport.setViewPosition(point);
            }
        }

        private ScrollBarPropertyChangeHandler() {
        }
    }

    private static class ScrollEndAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                Rectangle rectangle = jViewport.getViewRect();
                Rectangle rectangle2 = component.getBounds();
                if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                    jViewport.setViewPosition(new Point(rectangle2.width - rectangle.width, rectangle2.height - rectangle.height));
                } else {
                    jViewport.setViewPosition(new Point(0, rectangle2.height - rectangle.height));
                }
            }
        }

        protected ScrollEndAction(String string) {
            super(string);
        }
    }

    private static class ScrollHomeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Component component;
            JScrollPane jScrollPane = (JScrollPane)actionEvent.getSource();
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport != null && (component = jViewport.getView()) != null) {
                if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                    jViewport.setViewPosition(new Point(0, 0));
                } else {
                    Rectangle rectangle = jViewport.getViewRect();
                    Rectangle rectangle2 = component.getBounds();
                    jViewport.setViewPosition(new Point(rectangle2.width - rectangle.width, 0));
                }
            }
        }

        protected ScrollHomeAction(String string) {
            super(string);
        }
    }

    public class VSBChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = BasicScrollPaneUI.this.scrollpane.getViewport();
            if (jViewport != null) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)changeEvent.getSource();
                Point point = jViewport.getViewPosition();
                point.y = boundedRangeModel.getValue();
                jViewport.setViewPosition(point);
            }
        }
    }

    public class ViewportChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicScrollPaneUI.this.syncScrollPaneWithViewport();
        }
    }
}

