/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.util.Enumeration;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.TraceManager;
import org.apache.xalan.transformer.ClonerToResultTree;
import org.apache.xalan.transformer.QueuedEvents;
import org.apache.xalan.transformer.SerializerSwitcher;
import org.apache.xalan.transformer.TransformState;
import org.apache.xalan.transformer.TransformerClient;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.ref.DTMNodeIterator;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTM;
import org.apache.xml.utils.MutableAttrListImpl;
import org.apache.xml.utils.NamespaceSupport2;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class ResultTreeHandler
extends QueuedEvents
implements ContentHandler,
LexicalHandler,
TransformState,
DOM2DTM.CharacterNodeHandler,
ErrorHandler {
    private static final boolean DEBUG = false;
    boolean m_nsContextPushed = false;
    boolean m_isTransformClient = false;
    NamespaceSupport m_nsSupport = new NamespaceSupport2();
    private TransformerImpl m_transformer;
    private ContentHandler m_contentHandler;
    private LexicalHandler m_lexicalHandler;
    private StylesheetRoot m_stylesheetRoot = null;
    private int m_uniqueNSValue = 0;
    private static final String S_NAMESPACEPREFIX = "ns";
    public ClonerToResultTree m_cloner;
    private TraceManager m_tracer;
    private QueuedStateSnapshot m_snapshot = new QueuedStateSnapshot();

    public int getUniqueNSValue() {
        return this.m_uniqueNSValue++;
    }

    public ResultTreeHandler() {
    }

    public void addNSDeclsToAttrs() {
        Enumeration enumeration = this.m_nsSupport.getDeclaredPrefixes();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            boolean bl2 = string.length() == 0;
            String string2 = bl2 ? "xmlns" : "xmlns:" + string;
            String string3 = this.m_nsSupport.getURI(string);
            if (null == string3) {
                string3 = "";
            }
            this.m_attributes.addAttribute("http://www.w3.org/2000/xmlns/", string, string2, "CDATA", string3);
            this.m_nsDeclsHaveBeenAdded = true;
        }
    }

    public void endCDATA() throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.endCDATA();
        }
    }

    public void endDTD() throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.endDTD();
        }
    }

    public void endDocument() throws SAXException {
        this.flushPending(true);
        if (!this.m_docEnded) {
            this.m_contentHandler.endDocument();
            if (null != this.m_tracer) {
                GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 2, null);
                this.m_tracer.fireGenerateEvent(generateEvent);
            }
            this.m_docEnded = true;
            this.m_docPending = false;
        }
    }

    void flushDocEvent() throws SAXException {
        if (this.m_docPending) {
            this.m_contentHandler.startDocument();
            if (null != this.m_tracer) {
                GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 1);
                this.m_tracer.fireGenerateEvent(generateEvent);
            }
            if (this.m_contentHandler instanceof TransformerClient) {
                ((TransformerClient)((Object)this.m_contentHandler)).setTransformState(this);
            }
            this.m_docPending = false;
        }
    }

    void flushElem() throws SAXException {
        if (this.m_elemIsPending) {
            if (null != this.m_name) {
                try {
                    this.m_contentHandler.startElement(this.m_url, this.m_localName, this.m_name, this.m_attributes);
                }
                catch (Exception exception) {
                    throw new SAXParseException(exception.getMessage(), this.m_transformer.getCurrentElement().getPublicId(), this.m_transformer.getCurrentElement().getSystemId(), this.m_transformer.getCurrentElement().getLineNumber(), this.m_transformer.getCurrentElement().getColumnNumber(), exception);
                }
                if (null != this.m_tracer) {
                    GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 3, this.m_name, this.m_attributes);
                    this.m_tracer.fireGenerateEvent(generateEvent);
                }
                if (this.m_isTransformClient) {
                    this.m_snapshot.m_currentNode = null;
                }
            }
            this.m_elemIsPending = false;
            this.m_attributes.clear();
            this.m_nsDeclsHaveBeenAdded = false;
            this.m_name = null;
            this.m_url = null;
            this.m_localName = null;
            this.m_namespaces = null;
        }
    }

    public final void flushPending() throws SAXException {
        this.flushPending(true);
    }

    protected void sendEndPrefixMappings() throws SAXException {
        Enumeration enumeration = this.m_nsSupport.getDeclaredPrefixes();
        ContentHandler contentHandler = this.m_contentHandler;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            contentHandler.endPrefixMapping(string);
        }
    }

    protected void sendStartPrefixMappings() throws SAXException {
        Enumeration enumeration = this.m_nsSupport.getDeclaredPrefixes();
        ContentHandler contentHandler = this.m_contentHandler;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            contentHandler.startPrefixMapping(string, this.m_nsSupport.getURI(string));
        }
    }

    protected void startAndAddPrefixMappings() throws SAXException {
        Enumeration enumeration = this.m_nsSupport.getDeclaredPrefixes();
        ContentHandler contentHandler = this.m_contentHandler;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.m_nsSupport.getURI(string);
            contentHandler.startPrefixMapping(string, string2);
            boolean bl2 = string.length() == 0;
            String string3 = bl2 ? "xmlns" : "xmlns:" + string;
            if (null == string2) {
                string2 = "";
            }
            this.m_attributes.addAttribute("http://www.w3.org/2000/xmlns/", string, string3, "CDATA", string2);
        }
        this.m_nsDeclsHaveBeenAdded = true;
    }

    public void startCDATA() throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.startCDATA();
        }
    }

    public void startDocument() throws SAXException {
    }

    public final boolean isElementPending() {
        return this.m_elemIsPending;
    }

    public void addAttribute(int n2) throws TransformerException {
        DTM dTM = this.m_transformer.getXPathContext().getDTM(n2);
        if (this.isDefinedNSDecl(n2, dTM)) {
            return;
        }
        String string = dTM.getNamespaceURI(n2);
        if (string == null) {
            string = "";
        }
        this.addAttribute(string, dTM.getLocalName(n2), dTM.getNodeName(n2), "CDATA", dTM.getNodeValue(n2));
    }

    public void addAttributes(int n2) throws TransformerException {
        DTM dTM = this.m_transformer.getXPathContext().getDTM(n2);
        int n3 = dTM.getFirstAttribute(n2);
        while (-1 != n3) {
            this.addAttribute(n3);
            n3 = dTM.getNextAttribute(n3);
        }
    }

    public boolean isDefinedNSDecl(int n2) {
        String string;
        String string2;
        DTM dTM = this.m_transformer.getXPathContext().getDTM(n2);
        return 13 == dTM.getNodeType(n2) && null != (string2 = this.getURI(string = dTM.getNodeNameX(n2))) && string2.equals(dTM.getStringValue(n2));
    }

    public final void flushPending(boolean bl2) throws SAXException {
        if (bl2 && this.m_docPending) {
            this.flushDocEvent();
        }
        if (this.m_elemIsPending) {
            if (!this.m_nsDeclsHaveBeenAdded) {
                this.startAndAddPrefixMappings();
            } else {
                this.sendStartPrefixMappings();
            }
            this.flushElem();
            this.m_nsContextPushed = false;
        }
    }

    public void setNSDeclsHaveBeenAdded(boolean bl2) {
        this.m_nsDeclsHaveBeenAdded = bl2;
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        this.flushPending(true);
        this.m_contentHandler.characters(cArray, n2, n3);
        if (null != this.m_tracer) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 5, cArray, n2, n3);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    public void comment(char[] cArray, int n2, int n3) throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.comment(cArray, n2, n3);
        }
        if (null != this.m_tracer) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 8, new String(cArray, n2, n3));
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        if (this.m_docPending && XMLCharacterRecognizer.isWhiteSpace(cArray, n2, n3)) {
            return;
        }
        this.flushPending(true);
        this.m_contentHandler.ignorableWhitespace(cArray, n2, n3);
        if (null != this.m_tracer) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 6, cArray, n2, n3);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    public String getNewUniqueNSPrefix() {
        return S_NAMESPACEPREFIX + String.valueOf(this.getUniqueNSValue());
    }

    public void comment(String string) throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.comment(string.toCharArray(), 0, string.length());
        }
        if (null != this.m_tracer) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 8, string);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    public void endEntity(String string) throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.endEntity(string);
        }
        if (null != this.m_tracer) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 9, string);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void entityReference(String string) throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.startEntity(string);
            this.m_lexicalHandler.endEntity(string);
        }
        if (null != this.m_tracer) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 9, string);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.startEntity(string);
        }
    }

    public Transformer getTransformer() {
        return this.m_transformer;
    }

    public ElemTemplate getCurrentTemplate() {
        if (this.m_elemIsPending) {
            return this.m_snapshot.m_currentTemplate;
        }
        return this.m_transformer.getCurrentTemplate();
    }

    public ElemTemplate getMatchedTemplate() {
        if (this.m_elemIsPending) {
            return this.m_snapshot.m_matchedTemplate;
        }
        return this.m_transformer.getMatchedTemplate();
    }

    public ElemTemplateElement getCurrentElement() {
        if (this.m_elemIsPending) {
            return this.m_snapshot.m_currentElement;
        }
        return this.m_transformer.getCurrentElement();
    }

    public void processNSDecls(int n2, int n3, DTM dTM) throws TransformerException {
        try {
            if (n3 == 1) {
                int n4 = dTM.getFirstNamespaceNode(n2, true);
                while (-1 != n4) {
                    String string = dTM.getNodeNameX(n4);
                    String string2 = this.getURI(string);
                    String string3 = dTM.getNodeValue(n4);
                    if (!string3.equalsIgnoreCase(string2)) {
                        this.startPrefixMapping(string, string3, false);
                    }
                    n4 = dTM.getNextNamespaceNode(n2, n4, true);
                }
            } else if (n3 == 13) {
                String string = dTM.getNodeNameX(n2);
                String string4 = this.getURI(string);
                String string5 = dTM.getNodeValue(n2);
                if (!string5.equalsIgnoreCase(string4)) {
                    this.startPrefixMapping(string, string5, false);
                }
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public boolean isDefinedNSDecl(int n2, DTM dTM) {
        String string;
        String string2;
        return 13 == dTM.getNodeType(n2) && null != (string2 = this.getURI(string = dTM.getNodeNameX(n2))) && string2.equals(dTM.getStringValue(n2));
    }

    public void ensureNamespaceDeclDeclared(DTM dTM, int n2) throws SAXException {
        String string;
        String string2 = dTM.getNodeValue(n2);
        String string3 = dTM.getNodeNameX(n2);
        if (!(string2 == null || string2.length() <= 0 || null == string3 || null != (string = this.m_nsSupport.getURI(string3)) && string.equals(string2))) {
            this.startPrefixMapping(string3, string2, false);
        }
    }

    public MutableAttrListImpl getPendingAttributes() {
        return this.m_attributes;
    }

    public Node getCurrentNode() {
        if (this.m_snapshot.m_currentNode != null) {
            return this.m_snapshot.m_currentNode;
        }
        DTM dTM = this.m_transformer.getXPathContext().getDTM(this.m_transformer.getCurrentNode());
        return dTM.getNode(this.m_transformer.getCurrentNode());
    }

    public Node getMatchedNode() {
        if (this.m_elemIsPending) {
            DTM dTM = this.m_transformer.getXPathContext().getDTM(this.m_snapshot.m_matchedNode);
            return dTM.getNode(this.m_snapshot.m_matchedNode);
        }
        DTM dTM = this.m_transformer.getXPathContext().getDTM(this.m_transformer.getMatchedNode());
        return dTM.getNode(this.m_transformer.getMatchedNode());
    }

    public void characters(Node node) throws SAXException {
        this.flushPending(true);
        if (this.m_isTransformClient) {
            this.m_snapshot.m_currentNode = node;
        }
        String string = node.getNodeValue();
        char[] cArray = null;
        int n2 = 0;
        if (string != null) {
            cArray = string.toCharArray();
            n2 = string.length();
            this.m_contentHandler.characters(cArray, 0, n2);
        }
        if (null != this.m_tracer) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 5, cArray, 0, n2);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
        if (this.m_isTransformClient) {
            this.m_snapshot.m_currentNode = null;
        }
    }

    public NodeIterator getContextNodeList() {
        if (this.m_elemIsPending) {
            return new DTMNodeIterator(this.m_snapshot.m_contextNodeList);
        }
        return new DTMNodeIterator(this.m_transformer.getContextNodeList());
    }

    public final ContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.m_contentHandler = contentHandler;
        this.m_isTransformClient = this.m_contentHandler instanceof TransformerClient;
        this.m_lexicalHandler = this.m_contentHandler instanceof LexicalHandler ? (LexicalHandler)((Object)this.m_contentHandler) : null;
        this.reInitEvents();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.m_contentHandler instanceof ErrorHandler) {
            ((ErrorHandler)((Object)this.m_contentHandler)).error(sAXParseException);
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.m_elemIsPending = false;
        this.m_docEnded = true;
        this.m_docPending = false;
        if (this.m_contentHandler instanceof ErrorHandler) {
            ((ErrorHandler)((Object)this.m_contentHandler)).fatalError(sAXParseException);
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.m_contentHandler instanceof ErrorHandler) {
            ((ErrorHandler)((Object)this.m_contentHandler)).warning(sAXParseException);
        }
    }

    public NamespaceSupport getNamespaceSupport() {
        return this.m_nsSupport;
    }

    public String getPrefix(String string) {
        Enumeration enumeration = this.m_nsSupport.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!this.m_nsSupport.getURI(string2).equals(string)) continue;
            return string2;
        }
        return null;
    }

    public String getURI(String string) {
        return this.m_nsSupport.getURI(string);
    }

    private void checkForSerializerSwitch(String string, String string2) throws SAXException {
        try {
            if (this.m_docPending) {
                SerializerSwitcher.switchSerializerIfHTML(this.m_transformer, string, string2);
            }
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void ensurePrefixIsDeclared(String string, String string2) throws SAXException {
        if (string != null && string.length() > 0) {
            String string3;
            String string4;
            int n2 = string2.indexOf(":");
            String string5 = string4 = n2 < 0 ? "" : string2.substring(0, n2);
            if (!(null == string4 || null != (string3 = this.m_nsSupport.getURI(string4)) && string3.equals(string))) {
                this.startPrefixMapping(string4, string, false);
                this.m_attributes.addAttribute("http://www.w3.org/2000/xmlns/", string4, "xmlns" + (string4.length() == 0 ? "" : ":") + string4, "CDATA", string);
            }
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushPending(true);
        this.m_contentHandler.processingInstruction(string, string2);
        if (null != this.m_tracer) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 7, string, string2);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.startPrefixMapping(string, string2, true);
    }

    public boolean isDefinedNSDecl(String string, String string2) {
        if (string.equals("xmlns") || string.startsWith("xmlns:")) {
            int n2 = string.indexOf(":");
            String string3 = n2 < 0 ? "" : string.substring(0, n2);
            String string4 = this.m_nsSupport.getURI(string3);
            if (null != string4) {
                return string4.equals(string2);
            }
            return false;
        }
        return false;
    }

    public void startPrefixMapping(String string, String string2, boolean bl2) throws SAXException {
        String string3;
        if (bl2) {
            this.flushPending(false);
        }
        if (!this.m_nsContextPushed) {
            this.m_nsSupport.pushContext();
            this.m_nsContextPushed = true;
        }
        if (null == string) {
            string = "";
        }
        if (null == (string3 = this.m_nsSupport.getURI(string))) {
            string3 = "";
        }
        if (null == string2) {
            string2 = "";
        }
        if (!string3.equals(string2)) {
            this.m_nsSupport.declarePrefix(string, string2);
        }
    }

    public void outputResultTreeFragment(XObject xObject, XPathContext xPathContext) throws SAXException {
        int n2 = xObject.rtf();
        DTM dTM = xPathContext.getDTM(n2);
        if (null != dTM) {
            int n3 = dTM.getFirstChild(n2);
            while (-1 != n3) {
                this.flushPending(true);
                this.startPrefixMapping("", "");
                dTM.dispatchToEvents(n3, this);
                n3 = dTM.getNextSibling(n3);
            }
        }
    }

    public ResultTreeHandler(TransformerImpl transformerImpl, ContentHandler contentHandler) {
        this.init(transformerImpl, contentHandler);
    }

    public void init(TransformerImpl transformerImpl, ContentHandler contentHandler) {
        this.m_transformer = transformerImpl;
        TraceManager traceManager = transformerImpl.getTraceManager();
        this.m_tracer = null != traceManager && traceManager.hasTraceListeners() ? traceManager : null;
        this.m_contentHandler = contentHandler;
        this.m_lexicalHandler = this.m_contentHandler instanceof LexicalHandler ? (LexicalHandler)((Object)this.m_contentHandler) : null;
        this.m_isTransformClient = this.m_contentHandler instanceof TransformerClient;
        this.m_cloner = new ClonerToResultTree(transformerImpl, this);
        if (null != this.m_transformer) {
            this.m_stylesheetRoot = this.m_transformer.getStylesheet();
        }
        this.pushDocumentEvent();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.flushPending(true);
        this.m_contentHandler.endElement(string, string2, string3);
        if (null != this.m_tracer) {
            GenerateEvent generateEvent = new GenerateEvent(this.m_transformer, 4, string3, (Attributes)null);
            this.m_tracer.fireGenerateEvent(generateEvent);
        }
        this.sendEndPrefixMappings();
        this.popEvent();
        this.m_nsSupport.popContext();
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.flushPending(true);
        if (null != this.m_lexicalHandler) {
            this.m_lexicalHandler.startDTD(string, string2, string3);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.m_docPending) {
            this.checkForSerializerSwitch(string, string2);
        }
        this.flushPending(true);
        if (!this.m_nsContextPushed) {
            this.m_nsSupport.pushContext();
            this.m_nsContextPushed = true;
        }
        if (string != null) {
            this.ensurePrefixIsDeclared(string, string3);
        }
        this.m_name = string3;
        this.m_url = string;
        this.m_localName = string2;
        if (null != attributes) {
            this.m_attributes.addAttributes(attributes);
        }
        this.m_elemIsPending = true;
        this.m_elemIsEnded = false;
        if (this.m_isTransformClient && null != this.m_transformer) {
            this.m_snapshot.m_currentElement = this.m_transformer.getCurrentElement();
            this.m_snapshot.m_currentTemplate = this.m_transformer.getCurrentTemplate();
            this.m_snapshot.m_matchedTemplate = this.m_transformer.getMatchedTemplate();
            int n2 = this.m_transformer.getCurrentNode();
            DTM dTM = this.m_transformer.getXPathContext().getDTM(n2);
            this.m_snapshot.m_currentNode = dTM.getNode(n2);
            this.m_snapshot.m_matchedNode = this.m_transformer.getMatchedNode();
            this.m_snapshot.m_contextNodeList = this.m_transformer.getContextNodeList();
        }
        ++this.m_eventCount;
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) throws TransformerException {
        if (this.m_elemIsPending) {
            this.addNSDeclsToAttrs();
            if (null == string) {
                string = "";
            }
            try {
                if (!string3.equals("xmlns")) {
                    this.ensurePrefixIsDeclared(string, string3);
                }
            }
            catch (SAXException sAXException) {
                throw new TransformerException(sAXException);
            }
            if (!this.isDefinedNSDecl(string3, string5)) {
                this.m_attributes.addAttribute(string, string2, string3, string4, string5);
            }
        } else {
            this.m_transformer.getMsgMgr().warn(this.m_stylesheetRoot, "WG_ILLEGAL_ATTRIBUTE_POSITION", new Object[]{string2});
        }
    }

    class QueuedStateSnapshot {
        ElemTemplateElement m_currentElement;
        Node m_currentNode;
        ElemTemplate m_currentTemplate;
        ElemTemplate m_matchedTemplate;
        int m_matchedNode;
        DTMIterator m_contextNodeList;

        QueuedStateSnapshot() {
        }
    }
}

