/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.geom;

import sun.awt.geom.Curve;

final class Edge {
    static final int INIT_PARTS = 4;
    static final int GROW_PARTS = 10;
    Curve curve;
    int ctag;
    int etag;
    double activey;
    int equivalence;
    private Edge lastEdge;
    private int lastResult;
    private double lastLimit;

    public int getCurveTag() {
        return this.ctag;
    }

    public int getEdgeTag() {
        return this.etag;
    }

    public int getEquivalence() {
        return this.equivalence;
    }

    public void record(double d2, int n2) {
        this.activey = d2;
        this.etag = n2;
    }

    public boolean isActiveFor(double d2, int n2) {
        return this.etag == n2 && this.activey >= d2;
    }

    public void setEdgeTag(int n2) {
        this.etag = n2;
    }

    public void setEquivalence(int n2) {
        this.equivalence = n2;
    }

    public String toString() {
        return "Edge[" + this.curve + ", " + (this.ctag == 0 ? "L" : "R") + ", " + (this.etag == 1 ? "I" : (this.etag == -1 ? "O" : "N")) + "]";
    }

    public Curve getCurve() {
        return this.curve;
    }

    public Edge(Curve curve, int n2) {
        this(curve, n2, 0);
    }

    public Edge(Curve curve, int n2, int n3) {
        this.curve = curve;
        this.ctag = n2;
        this.etag = n3;
    }

    public int compareTo(Edge edge, double[] dArray) {
        if (edge == this.lastEdge && dArray[0] < this.lastLimit) {
            if (dArray[1] > this.lastLimit) {
                dArray[1] = this.lastLimit;
            }
            return this.lastResult;
        }
        if (this == edge.lastEdge && dArray[0] < edge.lastLimit) {
            if (dArray[1] > edge.lastLimit) {
                dArray[1] = edge.lastLimit;
            }
            return 0 - edge.lastResult;
        }
        int n2 = this.curve.compareTo(edge.curve, dArray);
        this.lastEdge = edge;
        this.lastLimit = dArray[1];
        this.lastResult = n2;
        return n2;
    }
}

