/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

public abstract class SingleByteEncoder
extends CharsetEncoder {
    private final short[] index1;
    private final String index2;
    private final int mask1;
    private final int mask2;
    private final int shift;
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = !SingleByteEncoder.class.desiredAssertionStatus();
    }

    public byte encode(char c2) {
        return (byte)this.index2.charAt(this.index1[(c2 & this.mask1) >> this.shift] + (c2 & this.mask2));
    }

    public boolean canEncode(char c2) {
        char c3 = this.index2.charAt(this.index1[(c2 & this.mask1) >> this.shift] + (c2 & this.mask2));
        return c3 != '\u0000';
    }

    protected SingleByteEncoder(Charset charset, short[] sArray, String string, int n2, int n3, int n4) {
        super(charset, 1.0f, 1.0f);
        this.index1 = sArray;
        this.index2 = string;
        this.mask1 = n2;
        this.mask2 = n3;
        this.shift = n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        int n2;
        int n3;
        block15: {
            CoderResult coderResult2;
            block14: {
                CoderResult coderResult3;
                block13: {
                    CoderResult coderResult4;
                    block12: {
                        CoderResult coderResult5;
                        block11: {
                            CoderResult coderResult6;
                            block10: {
                                char[] cArray = charBuffer.array();
                                n3 = charBuffer.arrayOffset() + charBuffer.position();
                                int n4 = charBuffer.arrayOffset() + charBuffer.limit();
                                if (!$assertionsDisabled && n3 > n4) {
                                    throw new AssertionError();
                                }
                                byte[] byArray = byteBuffer.array();
                                n2 = byteBuffer.arrayOffset() + byteBuffer.position();
                                int n5 = byteBuffer.arrayOffset() + byteBuffer.limit();
                                if (!$assertionsDisabled && n2 > n5) {
                                    throw new AssertionError();
                                }
                                n2 = n2 <= n5 ? n2 : n5;
                                try {
                                    for (n3 = n3 <= n4 ? n3 : n4; n3 < n4; ++n3) {
                                        char c2 = cArray[n3];
                                        if (Surrogate.is(c2)) {
                                            if (this.sgp.parse(c2, cArray, n3, n4) < 0) {
                                                coderResult6 = this.sgp.error();
                                                Object var13_16 = null;
                                                break block10;
                                            }
                                            coderResult5 = this.sgp.unmappableResult();
                                            break block11;
                                        }
                                        if (c2 >= '\ufffe') {
                                            coderResult4 = CoderResult.unmappableForLength(1);
                                            break block12;
                                        }
                                        if (n5 - n2 < 1) {
                                            coderResult3 = CoderResult.OVERFLOW;
                                            break block13;
                                        }
                                        char c3 = this.index2.charAt(this.index1[(c2 & this.mask1) >> this.shift] + (c2 & this.mask2));
                                        if (c3 == '\u0000' && c2 != '\u0000') {
                                            coderResult2 = CoderResult.unmappableForLength(1);
                                            break block14;
                                        }
                                        byArray[n2++] = (byte)c3;
                                    }
                                    coderResult = CoderResult.UNDERFLOW;
                                    break block15;
                                }
                                catch (Throwable throwable) {
                                    Object var13_22 = null;
                                    charBuffer.position(n3 - charBuffer.arrayOffset());
                                    byteBuffer.position(n2 - byteBuffer.arrayOffset());
                                    throw throwable;
                                }
                            }
                            charBuffer.position(n3 - charBuffer.arrayOffset());
                            byteBuffer.position(n2 - byteBuffer.arrayOffset());
                            return coderResult6;
                        }
                        Object var13_17 = null;
                        charBuffer.position(n3 - charBuffer.arrayOffset());
                        byteBuffer.position(n2 - byteBuffer.arrayOffset());
                        return coderResult5;
                    }
                    Object var13_18 = null;
                    charBuffer.position(n3 - charBuffer.arrayOffset());
                    byteBuffer.position(n2 - byteBuffer.arrayOffset());
                    return coderResult4;
                }
                Object var13_19 = null;
                charBuffer.position(n3 - charBuffer.arrayOffset());
                byteBuffer.position(n2 - byteBuffer.arrayOffset());
                return coderResult3;
            }
            Object var13_20 = null;
            charBuffer.position(n3 - charBuffer.arrayOffset());
            byteBuffer.position(n2 - byteBuffer.arrayOffset());
            return coderResult2;
        }
        Object var13_21 = null;
        charBuffer.position(n3 - charBuffer.arrayOffset());
        byteBuffer.position(n2 - byteBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n2 = charBuffer.position();
        try {
            while (charBuffer.hasRemaining()) {
                char c2 = charBuffer.get();
                if (Surrogate.is(c2)) {
                    if (this.sgp.parse(c2, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c2 >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (!byteBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                char c3 = this.index2.charAt(this.index1[(c2 & this.mask1) >> this.shift] + (c2 & this.mask2));
                if (c3 == '\u0000' && c2 != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                ++n2;
                byteBuffer.put((byte)c3);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n2);
        }
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray()) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

