/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.i;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Engine;
import javax.microedition.m3g.Helpers;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Object3D;

public class Loader {
    int swerveHandle;
    static final int ERROR_NONE = -1;
    static final int ERROR_ABORT = -2;
    static final int ERROR_NOTFOUND = -3;
    static final int ERROR_READ = -4;
    static final int ERROR_UNABLETOCREATE = -5;
    static final int ERROR_UNABLETOFREE = -6;
    static final int ERROR_INVALIDHEADER = -7;
    static final int ERROR_INVALIDBODY = -8;
    static final int ERROR_INVALIDCHECKSUM = -9;
    static final int ERROR_UNKNOWN = -10;
    static final int ERROR_DATAPASTEOF = -11;
    static byte[] pngIdentifier;
    static int m3gIdentifierLength;
    static int BLOCK_SIZE;
    static Class class$javax$microedition$m3g$Loader;

    protected native void finalize();

    Loader() {
    }

    Loader(int n2) {
        this.swerveHandle = n2;
    }

    private static native int createImpl();

    native boolean getbContainsExtensions();

    native int onDataStart(boolean var1);

    native int onDataEnd();

    native int onData(byte[] var1, int var2, int var3);

    native void onError(int var1);

    native int getRootCount();

    private native int getRootImpl(int var1);

    native int getXREFName(byte[] var1);

    native void resolveXREF(Object3D var1);

    private static native int getImage2DEncoding(Image var0);

    native int getAuthoringField(byte[] var1);

    public static Object3D[] load(byte[] byArray, int n2) throws IOException {
        if (n2 < 0 || n2 >= byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        return Loader.loadHelper(byArray, n2, true);
    }

    private static Object3D[] loadHelper(byte[] byArray, int n2, boolean bl2) throws IOException {
        try {
            int n3;
            Loader loader = (Loader)Engine.instantiateJavaPeer(Loader.createImpl());
            int n4 = n2;
            byte[] byArray2 = new byte[m3gIdentifierLength];
            try {
                n3 = loader.onDataStart(bl2);
                int n5 = byArray.length - n2;
                if (n3 == -1 && n5 > m3gIdentifierLength) {
                    n3 = loader.onData(byArray, n2, m3gIdentifierLength);
                    if (n3 == -1) {
                        System.arraycopy(byArray, n2, byArray2, 0, m3gIdentifierLength);
                    }
                    n5 -= m3gIdentifierLength;
                    n2 += m3gIdentifierLength;
                }
                if (n3 == -1) {
                    n3 = loader.onData(byArray, n2, n5);
                }
                if (n3 >= 0) {
                    loader.processXREFs(null);
                    n2 += n3;
                    n5 -= n3;
                    n3 = loader.onData(byArray, n2, n5);
                }
                if (n3 == -11) {
                    n3 = -1;
                }
                if (n3 == -1) {
                    n3 = loader.onDataEnd();
                }
            }
            catch (SecurityException securityException) {
                loader.onError(-10);
                if (securityException.getMessage() != null) {
                    throw new SecurityException(securityException.getMessage());
                }
                throw new SecurityException();
            }
            catch (Exception exception) {
                loader.onError(-10);
                if (exception.getMessage() != null) {
                    throw new IOException(exception.getMessage());
                }
                throw new IOException();
            }
            if (n3 == -1) {
                Object3D[] object3DArray = loader.createRoots();
                if (object3DArray != null) {
                    Loader.adjustUserObject(object3DArray[0], "javax.microedition.m3g.Loader.Header", byArray2);
                }
                return object3DArray;
            }
            Image2D image2D = Loader.createPNGImage2D(byArray, n4, byArray.length);
            if (image2D == null) {
                image2D = Loader.createImage2D(byArray, n4, byArray.length);
            }
            if (image2D != null) {
                Object3D[] object3DArray = new Object3D[]{image2D};
                return object3DArray;
            }
            return null;
        }
        catch (SecurityException securityException) {
            SecurityException securityException2 = securityException;
            if (securityException.getMessage() != null) {
                throw new SecurityException(securityException2.getMessage());
            }
            throw new SecurityException();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception.getMessage() != null) {
                throw new IOException(exception2.getMessage());
            }
            throw new IOException();
        }
    }

    public static Object3D[] load(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        return Loader.loadHelper(string, true);
    }

    private static Object3D[] loadHelper(String string, boolean bl2) throws IOException {
        Object object;
        InputStream inputStream = null;
        try {
            Object object2;
            int n2;
            object = (Loader)Engine.instantiateJavaPeer(Loader.createImpl());
            byte[] byArray = new byte[m3gIdentifierLength];
            try {
                int n3;
                inputStream = object.getClass().getResourceAsStream(string);
                if (inputStream == null) {
                    inputStream = Loader.openInputStream(string);
                }
                n2 = ((Loader)object).onDataStart(bl2);
                object2 = new byte[BLOCK_SIZE];
                if (n2 == -1 && (n3 = inputStream.read((byte[])object2, 0, m3gIdentifierLength)) != -1 && (n2 = ((Loader)object).onData((byte[])object2, 0, n3)) == -1) {
                    System.arraycopy(object2, 0, byArray, 0, m3gIdentifierLength);
                }
                while (n2 == -1 && (n3 = inputStream.read((byte[])object2, 0, BLOCK_SIZE)) != -1) {
                    n2 = ((Loader)object).onData((byte[])object2, 0, n3);
                    if (n2 < 0) continue;
                    super.processXREFs(string);
                    n2 = ((Loader)object).onData((byte[])object2, n2, n3 - n2);
                }
                if (n2 == -1) {
                    n2 = ((Loader)object).onDataEnd();
                }
            }
            catch (SecurityException securityException) {
                ((Loader)object).onError(-10);
                if (securityException.getMessage() != null) {
                    throw new SecurityException(securityException.getMessage());
                }
                throw new SecurityException();
            }
            catch (Exception exception) {
                ((Loader)object).onError(-10);
                exception.printStackTrace();
                if (exception.getMessage() != null) {
                    throw new IOException(exception.getMessage());
                }
                throw new IOException();
            }
            if (n2 == -1) {
                Object3D[] object3DArray = super.createRoots();
                object2 = object3DArray;
                if (object3DArray != null) {
                    Loader.adjustUserObject((Object3D)object2[0], "javax.microedition.m3g.Loader.Header", byArray);
                }
                Object[] objectArray = object2;
                return objectArray;
            }
            if (inputStream != null) {
                inputStream.close();
                inputStream = null;
            }
            Image2D image2D = Loader.createPNGImage2D(string);
            object2 = image2D;
            if (image2D == null) {
                object2 = Loader.createImage2D(string);
            }
            if (object2 != null) {
                Object3D[] object3DArray = new Object3D[]{object2};
                Object3D[] object3DArray2 = object3DArray;
                return object3DArray2;
            }
            Object var7_12 = null;
            return null;
        }
        catch (SecurityException securityException) {
            object = securityException;
            if (securityException.getMessage() != null) {
                throw new SecurityException(((Throwable)object).getMessage());
            }
            throw new SecurityException();
        }
        catch (Exception exception) {
            object = exception;
            if (exception.getMessage() != null) {
                throw new IOException(((Throwable)object).getMessage());
            }
            throw new IOException();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void processXREFs(String string) throws IOException {
        int n2;
        byte[] byArray = null;
        do {
            Object3D[] object3DArray;
            if ((n2 = this.getXREFName(null)) == -1) continue;
            if (byArray == null || byArray.length != n2) {
                byArray = new byte[n2];
            }
            this.getXREFName(byArray);
            String string2 = new String(byArray, "UTF-8");
            if (Loader.isRelative(string2)) {
                if (string == null) {
                    throw new IOException("XREF resource [" + string2 + "] has relative URI.");
                }
                string2 = Loader.resolveURI(string, string2);
            }
            if ((object3DArray = Loader.loadHelper(string2, this.getbContainsExtensions())) == null) {
                throw new IOException("XREF resource [" + string2 + "] contained no roots.");
            }
            Loader.adjustUserObject(object3DArray[0], "javax.microedition.m3g.Loader.ExternalReference.URI", byArray);
            this.resolveXREF(object3DArray[0]);
        } while (n2 != -1);
    }

    private static boolean isRelative(String string) {
        char c2;
        int n2 = string.length();
        if (n2 == 0 || string.startsWith("//")) {
            return true;
        }
        if (string.startsWith("/")) {
            return false;
        }
        int n3 = 0;
        while ((c2 = string.charAt(n3)) != ':' && c2 != '/' && c2 != '?' && c2 != '#' && ++n3 != n2) {
        }
        return c2 != ':';
    }

    private static String resolveURI(String string, String string2) {
        int n2;
        for (n2 = string.length(); n2 > 0 && string.charAt(n2 - 1) != '/'; --n2) {
        }
        if (n2 > 0) {
            return string.substring(0, n2) + string2;
        }
        return '/' + string2;
    }

    private Object3D[] createRoots() {
        int n2 = this.getRootCount();
        if (n2 == 0) {
            return null;
        }
        Object3D[] object3DArray = new Object3D[n2];
        while (n2-- > 0) {
            object3DArray[n2] = (Object3D)Engine.instantiateJavaPeer(this.getRootImpl(n2));
        }
        int n3 = this.getAuthoringField(null);
        byte[] byArray = new byte[n3];
        this.getAuthoringField(byArray);
        Loader.adjustUserObject(object3DArray[0], "javax.microedition.m3g.Loader.HeaderObject.AuthoringField", byArray);
        return object3DArray;
    }

    static void adjustUserObject(Object3D object3D, String string, Object object) {
        Hashtable hashtable = object3D.getUserObject();
        if (hashtable == null) {
            hashtable = new Hashtable();
            object3D.setUserObject(hashtable);
        }
        ((Hashtable)hashtable).put(string, object);
    }

    static InputStream openInputStream(String string) throws IOException {
        return Helpers.openInputStream(string);
    }

    private static boolean hasPNGIdentifier(byte[] byArray, int n2, int n3) {
        if (pngIdentifier.length > n3) {
            return false;
        }
        for (int i2 = 0; i2 < pngIdentifier.length; ++i2) {
            if (pngIdentifier[i2] == byArray[n2 + i2]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Image2D createPNGImage2D(String string) throws IOException {
        InputStream inputStream = null;
        try {
            Object object;
            byte[] byArray;
            int n2;
            inputStream = (class$javax$microedition$m3g$Loader == null ? (class$javax$microedition$m3g$Loader = Loader.class$("javax.microedition.m3g.Loader")) : class$javax$microedition$m3g$Loader).getResourceAsStream(string);
            if (inputStream == null) {
                inputStream = Loader.openInputStream(string);
            }
            if ((n2 = inputStream.read(byArray = new byte[BLOCK_SIZE], 0, pngIdentifier.length)) != -1 && !Loader.hasPNGIdentifier(byArray, 0, n2)) {
                Object var4_4 = null;
                return null;
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            while ((n2 = inputStream.read(byArray, 0, BLOCK_SIZE)) != -1) {
                object = new byte[byArray2.length + n2];
                System.arraycopy(byArray2, 0, object, 0, byArray2.length);
                System.arraycopy(byArray, 0, object, byArray2.length, n2);
                byArray2 = object;
            }
            object = new Image2D(byArray2, 0, byArray2.length);
            return object;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    static Image2D createPNGImage2D(byte[] byArray, int n2, int n3) {
        if (!Loader.hasPNGIdentifier(byArray, n2, n3)) {
            return null;
        }
        return new Image2D(byArray, n2, n3);
    }

    static Image2D createImage2D(String string) throws IOException {
        Image image = Helpers.createImage(string);
        if (image != null) {
            return Loader.createImage2D(image);
        }
        return null;
    }

    static Image2D createImage2D(byte[] byArray, int n2, int n3) throws IOException {
        Image image = Helpers.createImage(byArray, n2, n3);
        if (image != null) {
            return Loader.createImage2D(image);
        }
        return null;
    }

    static Image2D createImage2D(Image image) {
        int n2 = Loader.getImage2DEncoding(image);
        return new Image2D(n2, image);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i.a("jsr184client");
        Engine.cacheFID(class$javax$microedition$m3g$Loader == null ? (class$javax$microedition$m3g$Loader = Loader.class$("javax.microedition.m3g.Loader")) : class$javax$microedition$m3g$Loader, 2);
        pngIdentifier = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        m3gIdentifierLength = 12;
        BLOCK_SIZE = 4096;
    }
}

