/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;

class StyledTextRenderer {
    Device device;
    StyledText styledText;
    StyledTextContent content;
    Font regularFont;
    Font boldFont;
    Font italicFont;
    Font boldItalicFont;
    int tabWidth;
    int ascent;
    int descent;
    int averageCharWidth;
    int topIndex = -1;
    TextLayout[] layouts;
    int lineCount;
    int[] lineWidth;
    int[] lineHeight;
    LineInfo[] lines;
    int maxWidth;
    int maxWidthLineIndex;
    boolean idleRunning;
    Bullet[] bullets;
    int[] bulletsIndices;
    int[] redrawLines;
    int[] ranges;
    int styleCount;
    StyleRange[] styles;
    StyleRange[] stylesSet;
    int stylesSetCount = 0;
    static final int BULLET_MARGIN = 8;
    static final boolean COMPACT_STYLES = true;
    static final boolean MERGE_STYLES = true;
    static final int GROW = 32;
    static final int IDLE_TIME = 50;
    static final int CACHE_SIZE = 128;
    static final int BACKGROUND = 1;
    static final int ALIGNMENT = 2;
    static final int INDENT = 4;
    static final int JUSTIFY = 8;
    static final int SEGMENTS = 32;

    StyledTextRenderer(Device device, StyledText styledText) {
        this.device = device;
        this.styledText = styledText;
    }

    int addMerge(int[] nArray, StyleRange[] styleRangeArray, int n2, int n3, int n4) {
        int n5;
        int n6 = this.styleCount << 1;
        StyleRange styleRange = null;
        int n7 = 0;
        int n8 = 0;
        if (n4 < n6) {
            styleRange = this.styles[n4 >> 1];
            n7 = this.ranges[n4];
            n8 = this.ranges[n4 + 1];
        }
        if (n6 + (n5 = n2 - (n4 - n3)) >= this.ranges.length) {
            int[] nArray2 = new int[this.ranges.length + n5 + 64];
            System.arraycopy(this.ranges, 0, nArray2, 0, n3);
            StyleRange[] styleRangeArray2 = new StyleRange[this.styles.length + (n5 >> 1) + 32];
            System.arraycopy(this.styles, 0, styleRangeArray2, 0, n3 >> 1);
            if (n6 > n4) {
                System.arraycopy(this.ranges, n4, nArray2, n3 + n2, n6 - n4);
                System.arraycopy(this.styles, n4 >> 1, styleRangeArray2, n3 + n2 >> 1, this.styleCount - (n4 >> 1));
            }
            this.ranges = nArray2;
            this.styles = styleRangeArray2;
        } else if (n6 > n4) {
            System.arraycopy(this.ranges, n4, this.ranges, n3 + n2, n6 - n4);
            System.arraycopy(this.styles, n4 >> 1, this.styles, n3 + n2 >> 1, this.styleCount - (n4 >> 1));
        }
        int n9 = n3;
        int n10 = 0;
        while (n10 < n2) {
            if (n9 > 0 && this.ranges[n9 - 2] + this.ranges[n9 - 1] == nArray[n10] && styleRangeArray[n10 >> 1].similarTo(this.styles[n9 - 2 >> 1])) {
                int n11 = n9 - 1;
                this.ranges[n11] = this.ranges[n11] + nArray[n10 + 1];
            } else {
                this.styles[n9 >> 1] = styleRangeArray[n10 >> 1];
                this.ranges[n9++] = nArray[n10];
                this.ranges[n9++] = nArray[n10 + 1];
            }
            n10 += 2;
        }
        if (styleRange != null && this.ranges[n9 - 2] + this.ranges[n9 - 1] == n7 && styleRange.similarTo(this.styles[n9 - 2 >> 1])) {
            int n12 = n9 - 1;
            this.ranges[n12] = this.ranges[n12] + n8;
            n4 += 2;
            n2 += 2;
        }
        if (n6 > n4) {
            System.arraycopy(this.ranges, n3 + n2, this.ranges, n9, n6 - n4);
            System.arraycopy(this.styles, n3 + n2 >> 1, this.styles, n9 >> 1, this.styleCount - (n4 >> 1));
        }
        n5 = n9 - n3 - (n4 - n3);
        this.styleCount += n5 >> 1;
        return n5;
    }

    /*
     * Unable to fully structure code
     */
    int addMerge(StyleRange[] var1_1, int var2_2, int var3_3, int var4_4) {
        var5_5 = var2_2 - (var4_4 - var3_3);
        var6_6 = null;
        if (var4_4 < this.styleCount) {
            var6_6 = this.styles[var4_4];
        }
        if (this.styleCount + var5_5 >= this.styles.length) {
            var7_7 = new StyleRange[this.styles.length + var5_5 + 32];
            System.arraycopy(this.styles, 0, var7_7, 0, var3_3);
            if (this.styleCount > var4_4) {
                System.arraycopy(this.styles, var4_4, var7_7, var3_3 + var2_2, this.styleCount - var4_4);
            }
            this.styles = var7_7;
        } else if (this.styleCount > var4_4) {
            System.arraycopy(this.styles, var4_4, this.styles, var3_3 + var2_2, this.styleCount - var4_4);
        }
        var7_8 = var3_3;
        var8_9 = 0;
        while (var8_9 < var2_2) {
            var9_11 = var1_1[var8_9];
            if (var7_8 <= 0) ** GOTO lbl-1000
            var10_12 = this.styles[var7_8 - 1];
            if (var10_12.start + var10_12.length == var9_11.start && var9_11.similarTo(var10_12)) {
                var10_12.length += var9_11.length;
            } else lbl-1000:
            // 2 sources

            {
                this.styles[var7_8++] = var9_11;
            }
            ++var8_9;
        }
        var8_10 = this.styles[var7_8 - 1];
        if (var6_6 != null && var8_10.start + var8_10.length == var6_6.start && var6_6.similarTo(var8_10)) {
            var8_10.length += var6_6.length;
            ++var4_4;
            ++var2_2;
        }
        if (this.styleCount > var4_4) {
            System.arraycopy(this.styles, var3_3 + var2_2, this.styles, var7_8, this.styleCount - var4_4);
        }
        var5_5 = var7_8 - var3_3 - (var4_4 - var3_3);
        this.styleCount += var5_5;
        return var5_5;
    }

    void calculate(int n2, int n3) {
        int n4 = n2 + n3;
        if (n2 < 0 || n4 > this.lineWidth.length) {
            return;
        }
        int n5 = this.styledText.leftMargin + this.styledText.rightMargin + this.styledText.getCaretWidth();
        int n6 = n2;
        while (n6 < n4) {
            if (this.lineWidth[n6] == -1 || this.lineHeight[n6] == -1) {
                TextLayout textLayout = this.getTextLayout(n6);
                Rectangle rectangle = textLayout.getBounds();
                this.lineWidth[n6] = rectangle.width + n5;
                this.lineHeight[n6] = rectangle.height;
                this.disposeTextLayout(textLayout);
            }
            if (this.lineWidth[n6] > this.maxWidth) {
                this.maxWidth = this.lineWidth[n6];
                this.maxWidthLineIndex = n6;
            }
            ++n6;
        }
    }

    void calculateClientArea() {
        int n2 = this.styledText.getTopIndex();
        int n3 = this.content.getLineCount();
        int n4 = this.styledText.getClientArea().height;
        int n5 = 0;
        while (n4 > n5 && n3 > n2) {
            this.calculate(n2, 1);
            n5 += this.lineHeight[n2++];
        }
    }

    void calculateIdle() {
        if (this.idleRunning) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (StyledTextRenderer.this.styledText == null) {
                    return;
                }
                long l2 = System.currentTimeMillis();
                int n2 = 0;
                while (n2 < StyledTextRenderer.this.lineCount) {
                    if (StyledTextRenderer.this.lineHeight[n2] == -1 || StyledTextRenderer.this.lineWidth[n2] == -1) {
                        StyledTextRenderer.this.calculate(n2, 1);
                        if (System.currentTimeMillis() - l2 > 50L) break;
                    }
                    ++n2;
                }
                if (n2 < StyledTextRenderer.this.lineCount) {
                    Display display = StyledTextRenderer.this.styledText.getDisplay();
                    display.asyncExec(this);
                } else {
                    StyledTextRenderer.this.idleRunning = false;
                    StyledTextRenderer.this.styledText.setScrollBars(true);
                    ScrollBar scrollBar = StyledTextRenderer.this.styledText.getVerticalBar();
                    if (scrollBar != null) {
                        scrollBar.setSelection(StyledTextRenderer.this.styledText.getVerticalScrollOffset());
                    }
                }
            }
        };
        Display display = this.styledText.getDisplay();
        display.asyncExec(runnable);
        this.idleRunning = true;
    }

    void clearLineBackground(int n2, int n3) {
        if (this.lines == null) {
            return;
        }
        int n4 = n2;
        while (n4 < n2 + n3) {
            LineInfo lineInfo = this.lines[n4];
            if (lineInfo != null) {
                lineInfo.flags &= 0xFFFFFFFE;
                lineInfo.background = null;
                if (lineInfo.flags == 0) {
                    this.lines[n4] = null;
                }
            }
            ++n4;
        }
    }

    void clearLineStyle(int n2, int n3) {
        if (this.lines == null) {
            return;
        }
        int n4 = n2;
        while (n4 < n2 + n3) {
            LineInfo lineInfo = this.lines[n4];
            if (lineInfo != null) {
                lineInfo.flags &= 0xFFFFFFF1;
                if (lineInfo.flags == 0) {
                    this.lines[n4] = null;
                }
            }
            ++n4;
        }
    }

    void copyInto(StyledTextRenderer styledTextRenderer) {
        int n2;
        Object[] objectArray;
        if (this.ranges != null) {
            styledTextRenderer.ranges = new int[this.styleCount << 1];
            objectArray = styledTextRenderer.ranges;
            System.arraycopy(this.ranges, 0, objectArray, 0, objectArray.length);
        }
        if (this.styles != null) {
            styledTextRenderer.styles = new StyleRange[this.styleCount];
            objectArray = styledTextRenderer.styles;
            n2 = 0;
            while (n2 < objectArray.length) {
                objectArray[n2] = (int)((StyleRange)this.styles[n2].clone());
                ++n2;
            }
            styledTextRenderer.styleCount = this.styleCount;
        }
        if (this.lines != null) {
            styledTextRenderer.lines = new LineInfo[this.lineCount];
            objectArray = styledTextRenderer.lines;
            n2 = 0;
            while (n2 < objectArray.length) {
                objectArray[n2] = (int)new LineInfo(this.lines[n2]);
                ++n2;
            }
            styledTextRenderer.lineCount = this.lineCount;
        }
    }

    void dispose() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        if (this.italicFont != null) {
            this.italicFont.dispose();
        }
        if (this.boldItalicFont != null) {
            this.boldItalicFont.dispose();
        }
        this.boldItalicFont = null;
        this.italicFont = null;
        this.boldFont = null;
        this.reset();
        this.content = null;
        this.device = null;
        this.styledText = null;
    }

    void disposeTextLayout(TextLayout textLayout) {
        if (this.layouts != null) {
            int n2 = 0;
            while (n2 < this.layouts.length) {
                if (this.layouts[n2] == textLayout) {
                    return;
                }
                ++n2;
            }
        }
        textLayout.dispose();
    }

    void drawBullet(Bullet bullet, GC gC, int n2, int n3, int n4, int n5, int n6) {
        StyleRange styleRange = bullet.style;
        GlyphMetrics glyphMetrics = styleRange.metrics;
        Color color = styleRange.foreground;
        if (color != null) {
            gC.setForeground(color);
        }
        if ((bullet.type & 1) != 0 && StyledText.IS_MOTIF) {
            int n7 = Math.max(4, (n5 + n6) / 4);
            if ((n7 & 1) == 0) {
                ++n7;
            }
            if (color == null) {
                Display display = this.styledText.getDisplay();
                color = display.getSystemColor(2);
            }
            gC.setBackground(color);
            int n8 = n2 + Math.max(0, glyphMetrics.width - n7 - 8);
            gC.fillArc(n8, n3 + n7, n7 + 1, n7 + 1, 0, 360);
            return;
        }
        Font font = styleRange.font;
        if (font != null) {
            gC.setFont(font);
        }
        String string = "";
        int n9 = bullet.type & 0xF;
        switch (n9) {
            case 1: {
                string = "\u2022";
                break;
            }
            case 2: {
                string = String.valueOf(n4);
                break;
            }
            case 4: {
                string = String.valueOf((char)(n4 % 26 + 97));
                break;
            }
            case 8: {
                string = String.valueOf((char)(n4 % 26 + 65));
            }
        }
        if ((bullet.type & 0x10) != 0) {
            string = String.valueOf(string) + bullet.text;
        }
        Display display = this.styledText.getDisplay();
        TextLayout textLayout = new TextLayout(display);
        textLayout.setText(string);
        textLayout.setAscent(n5);
        textLayout.setDescent(n6);
        styleRange = (StyleRange)styleRange.clone();
        styleRange.metrics = null;
        if (styleRange.font == null) {
            styleRange.font = this.getFont(styleRange.fontStyle);
        }
        textLayout.setStyle(styleRange, 0, string.length());
        int n10 = n2 + Math.max(0, glyphMetrics.width - textLayout.getBounds().width - 8);
        textLayout.draw(gC, n10, n3);
        textLayout.dispose();
    }

    int drawLine(int n2, int n3, int n4, GC gC, Color color, Color color2) {
        int n5;
        Object object;
        Object object2;
        int n6;
        TextLayout textLayout = this.getTextLayout(n2);
        String string = this.content.getLine(n2);
        int n7 = this.content.getOffsetAtLine(n2);
        int n8 = string.length();
        Point point = this.styledText.getSelection();
        int n9 = point.x - n7;
        int n10 = point.y - n7;
        Rectangle rectangle = this.styledText.getClientArea();
        Color color3 = this.getLineBackground(n2, color);
        StyledTextEvent styledTextEvent = this.styledText.getLineBackgroundData(n7, string);
        if (styledTextEvent != null && styledTextEvent.lineBackground != null) {
            color3 = styledTextEvent.lineBackground;
        }
        int n11 = textLayout.getBounds().height;
        gC.setBackground(color3);
        this.styledText.drawBackground(gC, rectangle.x, n4, rectangle.width, n11);
        gC.setForeground(color2);
        gC.setBackground(color3);
        if (n9 == n10 || n10 <= 0 && n9 > n8 - 1) {
            textLayout.draw(gC, n3, n4);
        } else {
            int n12 = Math.max(0, n9);
            n6 = Math.min(n8, n10);
            object2 = this.styledText.getSelectionForeground();
            object = this.styledText.getSelectionBackground();
            n5 = (this.styledText.getStyle() & 0x10000) != 0 ? 65536 : 131072;
            if (n9 <= n8 && n8 < n10) {
                n5 |= 0x100000;
            }
            textLayout.draw(gC, n3, n4, n12, n6 - 1, (Color)object2, (Color)object, n5);
        }
        Bullet bullet = null;
        n6 = -1;
        if (this.bullets != null) {
            if (this.bulletsIndices != null) {
                int n13 = n2 - this.topIndex;
                if (n13 >= 0 && n13 < 128) {
                    bullet = this.bullets[n13];
                    n6 = this.bulletsIndices[n13];
                }
            } else {
                int n14 = 0;
                while (n14 < this.bullets.length) {
                    bullet = this.bullets[n14];
                    n6 = bullet.indexOf(n2);
                    if (n6 != -1) break;
                    ++n14;
                }
            }
        }
        if (n6 != -1 && bullet != null) {
            object2 = textLayout.getLineMetrics(0);
            int n15 = ((FontMetrics)object2).getAscent() + ((FontMetrics)object2).getLeading();
            if (bullet.type == 32) {
                bullet.style.start = n7;
                this.styledText.paintObject(gC, n3, n4, n15, ((FontMetrics)object2).getDescent(), bullet.style, bullet, n6);
            } else {
                this.drawBullet(bullet, gC, n3, n4, n6, n15, ((FontMetrics)object2).getDescent());
            }
        }
        object2 = textLayout.getStyles();
        object = null;
        n5 = 0;
        while (n5 < ((Object)object2).length) {
            if (((TextStyle)object2[n5]).metrics != null) {
                if (object == null) {
                    object = textLayout.getRanges();
                }
                Object object3 = object[n5 << 1];
                reference var24_28 = object[(n5 << 1) + 1] - object3;
                Point point2 = textLayout.getLocation((int)object3, false);
                FontMetrics fontMetrics = textLayout.getLineMetrics(textLayout.getLineIndex((int)object3));
                StyleRange styleRange = (StyleRange)((StyleRange)object2[n5]).clone();
                styleRange.start = (int)(object3 + n7);
                styleRange.length = (int)var24_28;
                int n16 = fontMetrics.getAscent() + fontMetrics.getLeading();
                this.styledText.paintObject(gC, point2.x + n3, point2.y + n4, n16, fontMetrics.getDescent(), styleRange, null, 0);
            }
            ++n5;
        }
        this.disposeTextLayout(textLayout);
        return n11;
    }

    int getBaseline() {
        return this.ascent;
    }

    Font getFont(int n2) {
        switch (n2) {
            case 1: {
                if (this.boldFont != null) {
                    return this.boldFont;
                }
                this.boldFont = new Font(this.device, this.getFontData(n2));
                return this.boldFont;
            }
            case 2: {
                if (this.italicFont != null) {
                    return this.italicFont;
                }
                this.italicFont = new Font(this.device, this.getFontData(n2));
                return this.italicFont;
            }
            case 3: {
                if (this.boldItalicFont != null) {
                    return this.boldItalicFont;
                }
                this.boldItalicFont = new Font(this.device, this.getFontData(n2));
                return this.boldItalicFont;
            }
        }
        return this.regularFont;
    }

    FontData[] getFontData(int n2) {
        FontData[] fontDataArray = this.regularFont.getFontData();
        int n3 = 0;
        while (n3 < fontDataArray.length) {
            fontDataArray[n3].setStyle(n2);
            ++n3;
        }
        return fontDataArray;
    }

    int getHeight() {
        int n2 = this.getLineHeight();
        if (this.styledText.isFixedLineHeight()) {
            return this.lineCount * n2;
        }
        int n3 = 0;
        int n4 = this.styledText.getWrapWidth();
        int n5 = 0;
        while (n5 < this.lineCount) {
            int n6 = this.lineHeight[n5];
            if (n6 == -1) {
                if (n4 > 0) {
                    int n7 = this.content.getLine(n5).length();
                    n6 = (n7 * this.averageCharWidth / n4 + 1) * n2;
                } else {
                    n6 = n2;
                }
            }
            n3 += n6;
            ++n5;
        }
        return n3 + this.styledText.topMargin + this.styledText.bottomMargin;
    }

    int getLineAlignment(int n2, int n3) {
        if (this.lines == null) {
            return n3;
        }
        LineInfo lineInfo = this.lines[n2];
        if (lineInfo != null && (lineInfo.flags & 2) != 0) {
            return lineInfo.alignment;
        }
        return n3;
    }

    Color getLineBackground(int n2, Color color) {
        if (this.lines == null) {
            return color;
        }
        LineInfo lineInfo = this.lines[n2];
        if (lineInfo != null && (lineInfo.flags & 1) != 0) {
            return lineInfo.background;
        }
        return color;
    }

    Bullet getLineBullet(int n2, Bullet bullet) {
        if (this.bullets == null) {
            return bullet;
        }
        if (this.bulletsIndices != null) {
            return bullet;
        }
        int n3 = 0;
        while (n3 < this.bullets.length) {
            Bullet bullet2 = this.bullets[n3];
            if (bullet2.indexOf(n2) != -1) {
                return bullet2;
            }
            ++n3;
        }
        return bullet;
    }

    int getLineHeight() {
        return this.ascent + this.descent;
    }

    int getLineHeight(int n2) {
        if (this.lineHeight[n2] == -1) {
            this.calculate(n2, 1);
        }
        return this.lineHeight[n2];
    }

    int getLineIndent(int n2, int n3) {
        if (this.lines == null) {
            return n3;
        }
        LineInfo lineInfo = this.lines[n2];
        if (lineInfo != null && (lineInfo.flags & 4) != 0) {
            return lineInfo.indent;
        }
        return n3;
    }

    boolean getLineJustify(int n2, boolean bl2) {
        if (this.lines == null) {
            return bl2;
        }
        LineInfo lineInfo = this.lines[n2];
        if (lineInfo != null && (lineInfo.flags & 8) != 0) {
            return lineInfo.justify;
        }
        return bl2;
    }

    int[] getLineSegments(int n2, int[] nArray) {
        if (this.lines == null) {
            return nArray;
        }
        LineInfo lineInfo = this.lines[n2];
        if (lineInfo != null && (lineInfo.flags & 0x20) != 0) {
            return lineInfo.segments;
        }
        return nArray;
    }

    /*
     * Unable to fully structure code
     */
    int getRangeIndex(int var1_1, int var2_2, int var3_3) {
        block5: {
            if (this.styleCount == 0) {
                return 0;
            }
            if (this.ranges == null) ** GOTO lbl19
            while (var3_3 - var2_2 > 2) {
                var4_4 = (var3_3 + var2_2) / 2 / 2 * 2;
                var5_6 = this.ranges[var4_4] + this.ranges[var4_4 + 1];
                if (var5_6 > var1_1) {
                    var3_3 = var4_4;
                    continue;
                }
                var2_2 = var4_4;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                var4_5 = (var3_3 + var2_2) / 2;
                var5_7 = this.styles[var4_5].start + this.styles[var4_5].length;
                if (var5_7 > var1_1) {
                    var3_3 = var4_5;
                    continue;
                }
                var2_2 = var4_5;
lbl19:
                // 3 sources

                ** while (var3_3 - var2_2 > 1)
            }
        }
        return var3_3;
    }

    int[] getRanges(int n2, int n3) {
        int[] nArray;
        int n4 = n2 + n3 - 1;
        if (this.ranges != null) {
            int n5 = this.styleCount << 1;
            int n6 = this.getRangeIndex(n2, -1, n5);
            if (n6 >= n5) {
                return null;
            }
            if (this.ranges[n6] > n4) {
                return null;
            }
            int n7 = Math.min(n5 - 2, this.getRangeIndex(n4, n6 - 1, n5) + 1);
            nArray = new int[n7 - n6 + 2];
            System.arraycopy(this.ranges, n6, nArray, 0, nArray.length);
        } else {
            int n8 = this.getRangeIndex(n2, -1, this.styleCount);
            if (n8 >= this.styleCount) {
                return null;
            }
            if (this.styles[n8].start > n4) {
                return null;
            }
            int n9 = Math.min(this.styleCount - 1, this.getRangeIndex(n4, n8 - 1, this.styleCount));
            nArray = new int[n9 - n8 + 1 << 1];
            int n10 = n8;
            int n11 = 0;
            while (n10 <= n9) {
                StyleRange styleRange = this.styles[n10];
                nArray[n11] = styleRange.start;
                nArray[n11 + 1] = styleRange.length;
                ++n10;
                n11 += 2;
            }
        }
        if (n2 > nArray[0]) {
            nArray[1] = nArray[0] + nArray[1] - n2;
            nArray[0] = n2;
        }
        if (n4 < nArray[nArray.length - 2] + nArray[nArray.length - 1] - 1) {
            nArray[nArray.length - 1] = n4 - nArray[nArray.length - 2] + 1;
        }
        return nArray;
    }

    StyleRange[] getStyleRanges(int n2, int n3, boolean bl2) {
        StyleRange[] styleRangeArray;
        int n4;
        int n5 = n2 + n3 - 1;
        if (this.ranges != null) {
            n4 = this.styleCount << 1;
            int n6 = this.getRangeIndex(n2, -1, n4);
            if (n6 >= n4) {
                return null;
            }
            if (this.ranges[n6] > n5) {
                return null;
            }
            int n7 = Math.min(n4 - 2, this.getRangeIndex(n5, n6 - 1, n4) + 1);
            styleRangeArray = new StyleRange[(n7 - n6 >> 1) + 1];
            if (bl2) {
                int n8 = n6;
                int n9 = 0;
                while (n8 <= n7) {
                    styleRangeArray[n9] = (StyleRange)this.styles[n8 >> 1].clone();
                    styleRangeArray[n9].start = this.ranges[n8];
                    styleRangeArray[n9].length = this.ranges[n8 + 1];
                    n8 += 2;
                    ++n9;
                }
            } else {
                System.arraycopy(this.styles, n6 >> 1, styleRangeArray, 0, styleRangeArray.length);
            }
        } else {
            n4 = this.getRangeIndex(n2, -1, this.styleCount);
            if (n4 >= this.styleCount) {
                return null;
            }
            if (this.styles[n4].start > n5) {
                return null;
            }
            int n10 = Math.min(this.styleCount - 1, this.getRangeIndex(n5, n4 - 1, this.styleCount));
            styleRangeArray = new StyleRange[n10 - n4 + 1];
            System.arraycopy(this.styles, n4, styleRangeArray, 0, styleRangeArray.length);
        }
        StyleRange styleRange = styleRangeArray[0];
        if (n2 > styleRange.start) {
            if (!bl2 || this.ranges == null) {
                styleRangeArray[0] = styleRange = (StyleRange)styleRange.clone();
            }
            styleRange.length = styleRange.start + styleRange.length - n2;
            styleRange.start = n2;
        }
        styleRange = styleRangeArray[styleRangeArray.length - 1];
        if (n5 < styleRange.start + styleRange.length - 1) {
            if (!bl2 || this.ranges == null) {
                styleRangeArray[styleRangeArray.length - 1] = styleRange = (StyleRange)styleRange.clone();
            }
            styleRange.length = n5 - styleRange.start + 1;
        }
        return styleRangeArray;
    }

    StyleRange getStyleRange(StyleRange styleRange) {
        if (styleRange.start == 0 && styleRange.length == 0 && styleRange.fontStyle == 0) {
            return styleRange;
        }
        StyleRange styleRange2 = (StyleRange)styleRange.clone();
        styleRange2.length = 0;
        styleRange2.start = 0;
        styleRange2.fontStyle = 0;
        if (styleRange2.font == null) {
            styleRange2.font = this.getFont(styleRange.fontStyle);
        }
        return styleRange2;
    }

    TextLayout getTextLayout(int n2) {
        return this.getTextLayout(n2, this.styledText.getOrientation(), this.styledText.getWrapWidth(), this.styledText.lineSpacing);
    }

    TextLayout getTextLayout(int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        TextLayout textLayout = null;
        if (this.styledText != null) {
            int n12;
            int n13;
            int n14 = n13 = this.styledText.topIndex > 0 ? this.styledText.topIndex - 1 : 0;
            if (this.layouts == null || n13 != this.topIndex) {
                int n15;
                TextLayout[] textLayoutArray = new TextLayout[128];
                if (this.layouts != null) {
                    n15 = 0;
                    while (n15 < this.layouts.length) {
                        if (this.layouts[n15] != null) {
                            n11 = n15 + this.topIndex - n13;
                            if (n11 >= 0 && n11 < textLayoutArray.length) {
                                textLayoutArray[n11] = this.layouts[n15];
                            } else {
                                this.layouts[n15].dispose();
                            }
                        }
                        ++n15;
                    }
                }
                if (this.bullets != null && this.bulletsIndices != null && n13 != this.topIndex) {
                    n15 = n13 - this.topIndex;
                    if (n15 > 0) {
                        if (n15 < this.bullets.length) {
                            System.arraycopy(this.bullets, n15, this.bullets, 0, this.bullets.length - n15);
                            System.arraycopy(this.bulletsIndices, n15, this.bulletsIndices, 0, this.bulletsIndices.length - n15);
                        }
                        n10 = n11 = Math.max(0, this.bullets.length - n15);
                        while (n10 < this.bullets.length) {
                            this.bullets[n10] = null;
                            ++n10;
                        }
                    } else {
                        if (-n15 < this.bullets.length) {
                            System.arraycopy(this.bullets, 0, this.bullets, -n15, this.bullets.length + n15);
                            System.arraycopy(this.bulletsIndices, 0, this.bulletsIndices, -n15, this.bulletsIndices.length + n15);
                        }
                        n11 = Math.min(this.bullets.length, -n15);
                        n10 = 0;
                        while (n10 < n11) {
                            this.bullets[n10] = null;
                            ++n10;
                        }
                    }
                }
                this.topIndex = n13;
                this.layouts = textLayoutArray;
            }
            if (this.layouts != null && (n12 = n2 - n13) >= 0 && n12 < this.layouts.length) {
                textLayout = this.layouts[n12];
                if (textLayout != null) {
                    if (this.lineWidth[n2] != -1) {
                        return textLayout;
                    }
                } else {
                    textLayout = this.layouts[n12] = new TextLayout(this.device);
                }
            }
        }
        if (textLayout == null) {
            textLayout = new TextLayout(this.device);
        }
        String string = this.content.getLine(n2);
        int n16 = this.content.getOffsetAtLine(n2);
        int[] nArray = null;
        n11 = 0;
        n10 = 16384;
        boolean bl2 = false;
        Bullet bullet = null;
        int[] nArray2 = null;
        StyleRange[] styleRangeArray = null;
        int n17 = 0;
        int n18 = 0;
        StyledTextEvent styledTextEvent = null;
        if (this.styledText != null) {
            styledTextEvent = this.styledText.getLineStyleData(n16, string);
            nArray = this.styledText.getBidiSegments(n16, string);
            n11 = this.styledText.indent;
            n10 = this.styledText.alignment;
            bl2 = this.styledText.justify;
        }
        if (styledTextEvent != null) {
            int n19;
            n11 = styledTextEvent.indent;
            n10 = styledTextEvent.alignment;
            bl2 = styledTextEvent.justify;
            bullet = styledTextEvent.bullet;
            nArray2 = styledTextEvent.ranges;
            styleRangeArray = styledTextEvent.styles;
            if (styleRangeArray != null) {
                n18 = styleRangeArray.length;
                if (this.styledText.isFixedLineHeight()) {
                    n19 = 0;
                    while (n19 < n18) {
                        if (styleRangeArray[n19].isVariableHeight()) {
                            this.styledText.verticalScrollOffset = -1;
                            this.styledText.setVariableLineHeight();
                            this.styledText.redraw();
                            break;
                        }
                        ++n19;
                    }
                }
            }
            if (this.bullets == null || this.bulletsIndices == null) {
                this.bullets = new Bullet[128];
                this.bulletsIndices = new int[128];
            }
            if ((n19 = n2 - this.topIndex) >= 0 && n19 < 128) {
                this.bullets[n19] = bullet;
                this.bulletsIndices[n19] = styledTextEvent.bulletIndex;
            }
        } else {
            LineInfo lineInfo;
            if (this.lines != null && (lineInfo = this.lines[n2]) != null) {
                if ((lineInfo.flags & 4) != 0) {
                    n11 = lineInfo.indent;
                }
                if ((lineInfo.flags & 2) != 0) {
                    n10 = lineInfo.alignment;
                }
                if ((lineInfo.flags & 8) != 0) {
                    bl2 = lineInfo.justify;
                }
                if ((lineInfo.flags & 0x20) != 0) {
                    nArray = lineInfo.segments;
                }
            }
            if (this.bulletsIndices != null) {
                this.bullets = null;
                this.bulletsIndices = null;
            }
            if (this.bullets != null) {
                int n20 = 0;
                while (n20 < this.bullets.length) {
                    if (this.bullets[n20].indexOf(n2) != -1) {
                        bullet = this.bullets[n20];
                        break;
                    }
                    ++n20;
                }
            }
            nArray2 = this.ranges;
            styleRangeArray = this.styles;
            n18 = this.styleCount;
            n17 = nArray2 != null ? this.getRangeIndex(n16, -1, n18 << 1) : this.getRangeIndex(n16, -1, n18);
        }
        if (bullet != null) {
            StyleRange styleRange = bullet.style;
            GlyphMetrics glyphMetrics = styleRange.metrics;
            n11 += glyphMetrics.width;
        }
        textLayout.setFont(this.regularFont);
        textLayout.setAscent(this.ascent);
        textLayout.setDescent(this.descent);
        textLayout.setText(string);
        textLayout.setOrientation(n3);
        textLayout.setSegments(nArray);
        textLayout.setWidth(n4);
        textLayout.setSpacing(n5);
        textLayout.setTabs(new int[]{this.tabWidth});
        textLayout.setIndent(n11);
        textLayout.setAlignment(n10);
        textLayout.setJustify(bl2);
        int n21 = 0;
        int n22 = string.length();
        if (styleRangeArray != null) {
            if (nArray2 != null) {
                n9 = n18 << 1;
                n8 = n17;
                while (n8 < n9) {
                    if (n16 > nArray2[n8]) {
                        n7 = 0;
                        n6 = Math.min(n22, nArray2[n8 + 1] - n16 + nArray2[n8]);
                    } else {
                        n7 = nArray2[n8] - n16;
                        n6 = Math.min(n22, n7 + nArray2[n8 + 1]);
                    }
                    if (n7 < n22) {
                        if (n21 < n7) {
                            textLayout.setStyle(null, n21, n7 - 1);
                        }
                        textLayout.setStyle(this.getStyleRange(styleRangeArray[n8 >> 1]), n7, n6);
                        n21 = Math.max(n21, n6);
                        n8 += 2;
                        continue;
                    }
                    break;
                }
            } else {
                n9 = n17;
                while (n9 < n18) {
                    if (n16 > styleRangeArray[n9].start) {
                        n8 = 0;
                        n7 = Math.min(n22, styleRangeArray[n9].length - n16 + styleRangeArray[n9].start);
                    } else {
                        n8 = styleRangeArray[n9].start - n16;
                        n7 = Math.min(n22, n8 + styleRangeArray[n9].length);
                    }
                    if (n8 < n22) {
                        if (n21 < n8) {
                            textLayout.setStyle(null, n21, n8 - 1);
                        }
                        textLayout.setStyle(this.getStyleRange(styleRangeArray[n9]), n8, n7);
                        n21 = Math.max(n21, n7);
                        ++n9;
                        continue;
                    }
                    break;
                }
            }
        }
        if (n21 < n22) {
            textLayout.setStyle(null, n21, n22);
        }
        if (this.styledText != null && this.styledText.isFixedLineHeight()) {
            int n23;
            n9 = -1;
            n8 = textLayout.getLineCount();
            n7 = this.getLineHeight();
            n6 = 0;
            while (n6 < n8) {
                n23 = textLayout.getLineBounds((int)n6).height;
                if (n23 > n7) {
                    n7 = n23;
                    n9 = n6;
                }
                ++n6;
            }
            if (n9 != -1) {
                FontMetrics fontMetrics = textLayout.getLineMetrics(n9);
                this.ascent = fontMetrics.getAscent() + fontMetrics.getLeading();
                this.descent = fontMetrics.getDescent();
                if (this.layouts != null) {
                    n23 = 0;
                    while (n23 < this.layouts.length) {
                        if (this.layouts[n23] != null && this.layouts[n23] != textLayout) {
                            this.layouts[n23].setAscent(this.ascent);
                            this.layouts[n23].setDescent(this.descent);
                        }
                        ++n23;
                    }
                }
                if (this.styledText.verticalScrollOffset != 0) {
                    n23 = this.styledText.topIndex;
                    int n24 = this.styledText.topIndexY;
                    int n25 = this.getLineHeight();
                    this.styledText.verticalScrollOffset = n24 >= 0 ? (n23 - 1) * n25 + n25 - n24 : n23 * n25 - n24;
                }
                this.styledText.calculateScrollBars();
                if (this.styledText.isBidiCaret()) {
                    this.styledText.createCaretBitmaps();
                }
                this.styledText.caretDirection = 0;
                this.styledText.setCaretLocation();
                this.styledText.redraw();
            }
        }
        return textLayout;
    }

    int getWidth() {
        return this.maxWidth;
    }

    void reset() {
        if (this.layouts != null) {
            int n2 = 0;
            while (n2 < this.layouts.length) {
                TextLayout textLayout = this.layouts[n2];
                if (textLayout != null) {
                    textLayout.dispose();
                }
                ++n2;
            }
            this.layouts = null;
        }
        this.topIndex = -1;
        this.lineCount = 0;
        this.styleCount = 0;
        this.stylesSetCount = 0;
        this.ranges = null;
        this.styles = null;
        this.stylesSet = null;
        this.lines = null;
        this.lineWidth = null;
        this.lineHeight = null;
        this.bullets = null;
        this.bulletsIndices = null;
        this.redrawLines = null;
    }

    void reset(int n2, int n3) {
        int n4 = n2 + n3;
        if (n2 < 0 || n4 > this.lineWidth.length) {
            return;
        }
        int n5 = n2;
        while (n5 < n4) {
            this.lineWidth[n5] = -1;
            this.lineHeight[n5] = -1;
            ++n5;
        }
        if (n2 <= this.maxWidthLineIndex && this.maxWidthLineIndex < n4) {
            this.maxWidth = 0;
            this.maxWidthLineIndex = -1;
            if (n3 != this.lineCount) {
                n5 = 0;
                while (n5 < this.lineCount) {
                    if (this.lineWidth[n5] > this.maxWidth) {
                        this.maxWidth = this.lineWidth[n5];
                        this.maxWidthLineIndex = n5;
                    }
                    ++n5;
                }
            }
        }
    }

    void setContent(StyledTextContent styledTextContent) {
        this.reset();
        this.content = styledTextContent;
        this.lineCount = styledTextContent.getLineCount();
        this.lineWidth = new int[this.lineCount];
        this.lineHeight = new int[this.lineCount];
        this.reset(0, this.lineCount);
    }

    void setFont(Font font, int n2) {
        Object object;
        TextLayout textLayout = new TextLayout(this.device);
        textLayout.setFont(this.regularFont);
        if (font != null) {
            if (this.boldFont != null) {
                this.boldFont.dispose();
            }
            if (this.italicFont != null) {
                this.italicFont.dispose();
            }
            if (this.boldItalicFont != null) {
                this.boldItalicFont.dispose();
            }
            this.boldItalicFont = null;
            this.italicFont = null;
            this.boldFont = null;
            this.regularFont = font;
            textLayout.setText("    ");
            textLayout.setFont(font);
            textLayout.setStyle(new TextStyle(this.getFont(0), null, null), 0, 0);
            textLayout.setStyle(new TextStyle(this.getFont(1), null, null), 1, 1);
            textLayout.setStyle(new TextStyle(this.getFont(2), null, null), 2, 2);
            textLayout.setStyle(new TextStyle(this.getFont(3), null, null), 3, 3);
            object = textLayout.getLineMetrics(0);
            this.ascent = ((FontMetrics)object).getAscent() + ((FontMetrics)object).getLeading();
            this.descent = ((FontMetrics)object).getDescent();
            this.boldFont.dispose();
            this.italicFont.dispose();
            this.boldItalicFont.dispose();
            this.boldItalicFont = null;
            this.italicFont = null;
            this.boldFont = null;
        }
        textLayout.dispose();
        textLayout = new TextLayout(this.device);
        textLayout.setFont(this.regularFont);
        object = new StringBuffer(n2);
        int n3 = 0;
        while (n3 < n2) {
            ((StringBuffer)object).append(' ');
            ++n3;
        }
        textLayout.setText(((StringBuffer)object).toString());
        this.tabWidth = textLayout.getBounds().width;
        textLayout.dispose();
        if (this.styledText != null) {
            GC gC = new GC(this.styledText);
            this.averageCharWidth = gC.getFontMetrics().getAverageCharWidth();
            gC.dispose();
        }
    }

    void setLineAlignment(int n2, int n3, int n4) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int n5 = n2;
        while (n5 < n2 + n3) {
            if (this.lines[n5] == null) {
                this.lines[n5] = new LineInfo();
            }
            this.lines[n5].flags |= 2;
            this.lines[n5].alignment = n4;
            ++n5;
        }
    }

    void setLineBackground(int n2, int n3, Color color) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int n4 = n2;
        while (n4 < n2 + n3) {
            if (this.lines[n4] == null) {
                this.lines[n4] = new LineInfo();
            }
            this.lines[n4].flags |= 1;
            this.lines[n4].background = color;
            ++n4;
        }
    }

    void setLineBullet(int n2, int n3, Bullet bullet) {
        if (this.bulletsIndices != null) {
            this.bulletsIndices = null;
            this.bullets = null;
        }
        if (this.bullets == null) {
            if (bullet == null) {
                return;
            }
            this.bullets = new Bullet[1];
            this.bullets[0] = bullet;
        }
        int n4 = 0;
        while (n4 < this.bullets.length) {
            if (bullet == this.bullets[n4]) break;
            ++n4;
        }
        if (bullet != null) {
            if (n4 == this.bullets.length) {
                Bullet[] bulletArray = new Bullet[this.bullets.length + 1];
                System.arraycopy(this.bullets, 0, bulletArray, 0, this.bullets.length);
                bulletArray[n4] = bullet;
                this.bullets = bulletArray;
            }
            bullet.addIndices(n2, n3);
        } else {
            this.updateBullets(n2, n3, 0, false);
            this.styledText.redrawLinesBullet(this.redrawLines);
            this.redrawLines = null;
        }
    }

    void setLineIndent(int n2, int n3, int n4) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int n5 = n2;
        while (n5 < n2 + n3) {
            if (this.lines[n5] == null) {
                this.lines[n5] = new LineInfo();
            }
            this.lines[n5].flags |= 4;
            this.lines[n5].indent = n4;
            ++n5;
        }
    }

    void setLineJustify(int n2, int n3, boolean bl2) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int n4 = n2;
        while (n4 < n2 + n3) {
            if (this.lines[n4] == null) {
                this.lines[n4] = new LineInfo();
            }
            this.lines[n4].flags |= 8;
            this.lines[n4].justify = bl2;
            ++n4;
        }
    }

    void setLineSegments(int n2, int n3, int[] nArray) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        int n4 = n2;
        while (n4 < n2 + n3) {
            if (this.lines[n4] == null) {
                this.lines[n4] = new LineInfo();
            }
            this.lines[n4].flags |= 0x20;
            this.lines[n4].segments = nArray;
            ++n4;
        }
    }

    void setStyleRanges(int[] nArray, StyleRange[] styleRangeArray) {
        Object[] objectArray;
        int n2;
        int n3;
        int n4;
        if (styleRangeArray == null) {
            this.styleCount = 0;
            this.stylesSetCount = 0;
            this.ranges = null;
            this.styles = null;
            this.stylesSet = null;
            return;
        }
        if (nArray == null) {
            nArray = new int[styleRangeArray.length << 1];
            StyleRange[] styleRangeArray2 = new StyleRange[styleRangeArray.length];
            if (this.stylesSet == null) {
                this.stylesSet = new StyleRange[4];
            }
            n4 = 0;
            n3 = 0;
            while (n4 < styleRangeArray.length) {
                StyleRange styleRange = styleRangeArray[n4];
                nArray[n3++] = styleRange.start;
                nArray[n3++] = styleRange.length;
                n2 = 0;
                while (n2 < this.stylesSetCount) {
                    if (this.stylesSet[n2].similarTo(styleRange)) break;
                    ++n2;
                }
                if (n2 == this.stylesSetCount) {
                    if (this.stylesSetCount == this.stylesSet.length) {
                        objectArray = new StyleRange[this.stylesSetCount + 4];
                        System.arraycopy(this.stylesSet, 0, objectArray, 0, this.stylesSetCount);
                        this.stylesSet = (StyleRange[])objectArray;
                    }
                    this.stylesSet[this.stylesSetCount++] = styleRange;
                }
                styleRangeArray2[n4] = this.stylesSet[n2];
                ++n4;
            }
            styleRangeArray = styleRangeArray2;
        }
        if (this.styleCount == 0) {
            if (nArray != null) {
                this.ranges = new int[nArray.length];
                System.arraycopy(nArray, 0, this.ranges, 0, this.ranges.length);
            }
            this.styles = new StyleRange[styleRangeArray.length];
            System.arraycopy(styleRangeArray, 0, this.styles, 0, this.styles.length);
            this.styleCount = styleRangeArray.length;
            return;
        }
        if (nArray != null && this.ranges == null) {
            this.ranges = new int[this.styles.length << 1];
            int n5 = 0;
            n4 = 0;
            while (n5 < this.styleCount) {
                this.ranges[n4++] = this.styles[n5].start;
                this.ranges[n4++] = this.styles[n5].length;
                ++n5;
            }
        }
        if (nArray == null && this.ranges != null) {
            nArray = new int[styleRangeArray.length << 1];
            int n6 = 0;
            n4 = 0;
            while (n6 < styleRangeArray.length) {
                nArray[n4++] = styleRangeArray[n6].start;
                nArray[n4++] = styleRangeArray[n6].length;
                ++n6;
            }
        }
        if (this.ranges != null) {
            n4 = nArray[0];
            int n7 = this.styleCount << 1;
            n3 = this.getRangeIndex(n4, -1, n7);
            int n8 = n2 = n3 == n7 ? 1 : 0;
            if (n2 == 0) {
                int n9 = nArray[nArray.length - 2] + nArray[nArray.length - 1];
                int n10 = this.getRangeIndex(n9, n3 - 1, n7);
                int n11 = n2 = n3 == n10 && this.ranges[n3] >= n9 ? 1 : 0;
            }
            if (n2 != 0) {
                this.addMerge(nArray, styleRangeArray, nArray.length, n3, n3);
                return;
            }
            int n12 = n3;
            objectArray = new int[6];
            StyleRange[] styleRangeArray3 = new StyleRange[3];
            int n13 = 0;
            while (n13 < nArray.length) {
                int n14 = nArray[n13];
                int n15 = n14 + nArray[n13 + 1];
                if (n14 != n15) {
                    int n16 = 0;
                    int n17 = 0;
                    while (n12 < n7) {
                        if (n14 >= this.ranges[n3] + this.ranges[n3 + 1]) {
                            n3 += 2;
                        }
                        if (this.ranges[n12] + this.ranges[n12 + 1] > n15) break;
                        n12 += 2;
                    }
                    if (this.ranges[n3] < n14 && n14 < this.ranges[n3] + this.ranges[n3 + 1]) {
                        styleRangeArray3[n17 >> 1] = this.styles[n3 >> 1];
                        objectArray[n17] = this.ranges[n3];
                        objectArray[n17 + 1] = n14 - this.ranges[n3];
                        n17 += 2;
                    }
                    styleRangeArray3[n17 >> 1] = styleRangeArray[n13 >> 1];
                    objectArray[n17] = n14;
                    objectArray[n17 + 1] = nArray[n13 + 1];
                    n17 += 2;
                    if (n12 < n7 && this.ranges[n12] < n15 && n15 < this.ranges[n12] + this.ranges[n12 + 1]) {
                        styleRangeArray3[n17 >> 1] = this.styles[n12 >> 1];
                        objectArray[n17] = n15;
                        objectArray[n17 + 1] = this.ranges[n12] + this.ranges[n12 + 1] - n15;
                        n17 += 2;
                        n16 = 2;
                    }
                    int n18 = this.addMerge((int[])objectArray, styleRangeArray3, n17, n3, n12 + n16);
                    n7 += n18;
                    n3 = n12 += n18;
                }
                n13 += 2;
            }
        } else {
            boolean bl2;
            int n19 = styleRangeArray[0].start;
            n4 = this.getRangeIndex(n19, -1, this.styleCount);
            boolean bl3 = bl2 = n4 == this.styleCount;
            if (!bl2) {
                n2 = styleRangeArray[styleRangeArray.length - 1].start + styleRangeArray[styleRangeArray.length - 1].length;
                n3 = this.getRangeIndex(n2, n4 - 1, this.styleCount);
                boolean bl4 = bl2 = n4 == n3 && this.styles[n4].start >= n2;
            }
            if (bl2) {
                this.addMerge(styleRangeArray, styleRangeArray.length, n4, n4);
                return;
            }
            n3 = n4;
            StyleRange[] styleRangeArray4 = new StyleRange[3];
            int n20 = 0;
            while (n20 < styleRangeArray.length) {
                StyleRange styleRange = styleRangeArray[n20];
                int n21 = styleRange.start;
                int n22 = n21 + styleRange.length;
                if (n21 != n22) {
                    int n23 = 0;
                    int n24 = 0;
                    while (n3 < this.styleCount) {
                        if (n21 >= this.styles[n4].start + this.styles[n4].length) {
                            ++n4;
                        }
                        if (this.styles[n3].start + this.styles[n3].length > n22) break;
                        ++n3;
                    }
                    StyleRange styleRange2 = this.styles[n4];
                    if (styleRange2.start < n21 && n21 < styleRange2.start + styleRange2.length) {
                        int n25 = n24++;
                        StyleRange styleRange3 = (StyleRange)styleRange2.clone();
                        styleRangeArray4[n25] = styleRange3;
                        styleRange2 = styleRange3;
                        styleRange2.length = n21 - styleRange2.start;
                    }
                    styleRangeArray4[n24++] = styleRange;
                    if (n3 < this.styleCount) {
                        styleRange2 = this.styles[n3];
                        if (styleRange2.start < n22 && n22 < styleRange2.start + styleRange2.length) {
                            int n26 = n24++;
                            StyleRange styleRange4 = (StyleRange)styleRange2.clone();
                            styleRangeArray4[n26] = styleRange4;
                            styleRange2 = styleRange4;
                            styleRange2.length += styleRange2.start - n22;
                            styleRange2.start = n22;
                            n23 = 1;
                        }
                    }
                    int n27 = this.addMerge(styleRangeArray4, n24, n4, n3 + n23);
                    n4 = n3 += n27;
                }
                ++n20;
            }
        }
    }

    void textChanging(TextChangingEvent textChangingEvent) {
        int n2 = textChangingEvent.start;
        int n3 = textChangingEvent.newCharCount;
        int n4 = textChangingEvent.replaceCharCount;
        int n5 = textChangingEvent.newLineCount;
        int n6 = textChangingEvent.replaceLineCount;
        this.updateRanges(n2, n4, n3);
        int n7 = this.content.getLineAtOffset(n2);
        if (n4 == this.content.getCharCount()) {
            this.lines = null;
        }
        if (n6 == this.lineCount) {
            this.lineCount = n5;
            this.lineWidth = new int[this.lineCount];
            this.lineHeight = new int[this.lineCount];
            this.reset(0, this.lineCount);
        } else {
            int n8;
            Object[] objectArray;
            int n9 = n5 - n6;
            if (this.lineCount + n9 > this.lineWidth.length) {
                objectArray = new int[this.lineCount + n9 + 32];
                System.arraycopy(this.lineWidth, 0, objectArray, 0, this.lineCount);
                this.lineWidth = objectArray;
                int[] nArray = new int[this.lineCount + n9 + 32];
                System.arraycopy(this.lineHeight, 0, nArray, 0, this.lineCount);
                this.lineHeight = nArray;
            }
            if (this.lines != null && this.lineCount + n9 > this.lines.length) {
                objectArray = new LineInfo[this.lineCount + n9 + 32];
                System.arraycopy(this.lines, 0, objectArray, 0, this.lineCount);
                this.lines = (LineInfo[])objectArray;
            }
            int n10 = n7 + n6 + 1;
            int n11 = n7 + n5 + 1;
            System.arraycopy(this.lineWidth, n10, this.lineWidth, n11, this.lineCount - n10);
            System.arraycopy(this.lineHeight, n10, this.lineHeight, n11, this.lineCount - n10);
            int n12 = n7;
            while (n12 < n11) {
                this.lineHeight[n12] = -1;
                this.lineWidth[n12] = -1;
                ++n12;
            }
            n12 = this.lineCount + n9;
            while (n12 < this.lineCount) {
                this.lineHeight[n12] = -1;
                this.lineWidth[n12] = -1;
                ++n12;
            }
            if (this.layouts != null) {
                n12 = n7 - this.topIndex;
                n8 = n12 + n6 + 1;
                int n13 = n12;
                while (n13 < n8) {
                    if (n13 >= 0 && n13 < this.layouts.length) {
                        if (this.layouts[n13] != null) {
                            this.layouts[n13].dispose();
                        }
                        this.layouts[n13] = null;
                        if (this.bullets != null && this.bulletsIndices != null) {
                            this.bullets[n13] = null;
                        }
                    }
                    ++n13;
                }
                if (n9 > 0) {
                    n13 = this.layouts.length - 1;
                    while (n13 >= n8) {
                        if (n13 >= 0 && n13 < this.layouts.length) {
                            n11 = n13 + n9;
                            if (n11 >= 0 && n11 < this.layouts.length) {
                                this.layouts[n11] = this.layouts[n13];
                                this.layouts[n13] = null;
                                if (this.bullets != null && this.bulletsIndices != null) {
                                    this.bullets[n11] = this.bullets[n13];
                                    this.bulletsIndices[n11] = this.bulletsIndices[n13];
                                    this.bullets[n13] = null;
                                }
                            } else {
                                if (this.layouts[n13] != null) {
                                    this.layouts[n13].dispose();
                                }
                                this.layouts[n13] = null;
                                if (this.bullets != null && this.bulletsIndices != null) {
                                    this.bullets[n13] = null;
                                }
                            }
                        }
                        --n13;
                    }
                } else if (n9 < 0) {
                    n13 = n8;
                    while (n13 < this.layouts.length) {
                        if (n13 >= 0 && n13 < this.layouts.length) {
                            n11 = n13 + n9;
                            if (n11 >= 0 && n11 < this.layouts.length) {
                                this.layouts[n11] = this.layouts[n13];
                                this.layouts[n13] = null;
                                if (this.bullets != null && this.bulletsIndices != null) {
                                    this.bullets[n11] = this.bullets[n13];
                                    this.bulletsIndices[n11] = this.bulletsIndices[n13];
                                    this.bullets[n13] = null;
                                }
                            } else {
                                if (this.layouts[n13] != null) {
                                    this.layouts[n13].dispose();
                                }
                                this.layouts[n13] = null;
                                if (this.bullets != null && this.bulletsIndices != null) {
                                    this.bullets[n13] = null;
                                }
                            }
                        }
                        ++n13;
                    }
                }
            }
            if (n6 != 0 || n5 != 0) {
                n12 = this.content.getOffsetAtLine(n7);
                if (n12 != n2) {
                    ++n7;
                }
                this.updateBullets(n7, n6, n5, true);
                if (this.lines != null) {
                    n10 = n7 + n6;
                    n11 = n7 + n5;
                    System.arraycopy(this.lines, n10, this.lines, n11, this.lineCount - n10);
                    n8 = n7;
                    while (n8 < n11) {
                        this.lines[n8] = null;
                        ++n8;
                    }
                    n8 = this.lineCount + n9;
                    while (n8 < this.lineCount) {
                        this.lines[n8] = null;
                        ++n8;
                    }
                }
            }
            this.lineCount += n9;
            if (this.maxWidthLineIndex != -1 && n7 <= this.maxWidthLineIndex && this.maxWidthLineIndex <= n7 + n6) {
                this.maxWidth = 0;
                this.maxWidthLineIndex = -1;
                n12 = 0;
                while (n12 < this.lineCount) {
                    if (this.lineWidth[n12] > this.maxWidth) {
                        this.maxWidth = this.lineWidth[n12];
                        this.maxWidthLineIndex = n12;
                    }
                    ++n12;
                }
            }
        }
    }

    void updateBullets(int n2, int n3, int n4, boolean bl2) {
        if (this.bullets == null) {
            return;
        }
        if (this.bulletsIndices != null) {
            return;
        }
        int n5 = 0;
        while (n5 < this.bullets.length) {
            Bullet bullet = this.bullets[n5];
            int[] nArray = bullet.removeIndices(n2, n3, n4, bl2);
            if (nArray != null) {
                if (this.redrawLines == null) {
                    this.redrawLines = nArray;
                } else {
                    int[] nArray2 = new int[this.redrawLines.length + nArray.length];
                    System.arraycopy(this.redrawLines, 0, nArray2, 0, this.redrawLines.length);
                    System.arraycopy(nArray, 0, nArray2, this.redrawLines.length, nArray.length);
                    this.redrawLines = nArray2;
                }
            }
            ++n5;
        }
        n5 = 0;
        int n6 = 0;
        while (n6 < this.bullets.length) {
            if (this.bullets[n6].size() == 0) {
                ++n5;
            }
            ++n6;
        }
        if (n5 > 0) {
            if (n5 == this.bullets.length) {
                this.bullets = null;
            } else {
                Bullet[] bulletArray = new Bullet[this.bullets.length - n5];
                int n7 = 0;
                int n8 = 0;
                while (n7 < this.bullets.length) {
                    Bullet bullet = this.bullets[n7];
                    if (bullet.size() > 0) {
                        bulletArray[n8++] = bullet;
                    }
                    ++n7;
                }
                this.bullets = bulletArray;
            }
        }
    }

    void updateRanges(int n2, int n3, int n4) {
        if (this.styleCount == 0 || n3 == 0 && n4 == 0) {
            return;
        }
        if (this.ranges != null) {
            int n5 = this.styleCount << 1;
            int n6 = this.getRangeIndex(n2, -1, n5);
            if (n6 == n5) {
                return;
            }
            int n7 = n2 + n3;
            int n8 = this.getRangeIndex(n7, n6 - 1, n5);
            int n9 = n4 - n3;
            if (n6 == n8 && this.ranges[n6] < n2 && n7 < this.ranges[n8] + this.ranges[n8 + 1]) {
                if (n4 == 0) {
                    int n10 = n6 + 1;
                    this.ranges[n10] = this.ranges[n10] - n3;
                    n8 += 2;
                } else {
                    if (n5 + 2 > this.ranges.length) {
                        int[] nArray = new int[this.ranges.length + 64];
                        System.arraycopy(this.ranges, 0, nArray, 0, n5);
                        this.ranges = nArray;
                        StyleRange[] styleRangeArray = new StyleRange[this.styles.length + 32];
                        System.arraycopy(this.styles, 0, styleRangeArray, 0, this.styleCount);
                        this.styles = styleRangeArray;
                    }
                    System.arraycopy(this.ranges, n6 + 2, this.ranges, n6 + 4, n5 - (n6 + 2));
                    System.arraycopy(this.styles, n6 + 2 >> 1, this.styles, n6 + 4 >> 1, this.styleCount - (n6 + 2 >> 1));
                    this.ranges[n6 + 3] = this.ranges[n6] + this.ranges[n6 + 1] - n7;
                    this.ranges[n6 + 2] = n2 + n4;
                    this.ranges[n6 + 1] = n2 - this.ranges[n6];
                    this.styles[(n6 >> 1) + 1] = this.styles[n6 >> 1];
                    n5 += 2;
                    ++this.styleCount;
                    n8 += 4;
                }
                if (n9 != 0) {
                    int n11 = n8;
                    while (n11 < n5) {
                        int n12 = n11;
                        this.ranges[n12] = this.ranges[n12] + n9;
                        n11 += 2;
                    }
                }
            } else {
                if (this.ranges[n6] < n2 && n2 < this.ranges[n6] + this.ranges[n6 + 1]) {
                    this.ranges[n6 + 1] = n2 - this.ranges[n6];
                    n6 += 2;
                }
                if (n8 < n5 && this.ranges[n8] < n7 && n7 < this.ranges[n8] + this.ranges[n8 + 1]) {
                    this.ranges[n8 + 1] = this.ranges[n8] + this.ranges[n8 + 1] - n7;
                    this.ranges[n8] = n7;
                }
                if (n9 != 0) {
                    int n13 = n8;
                    while (n13 < n5) {
                        int n14 = n13;
                        this.ranges[n14] = this.ranges[n14] + n9;
                        n13 += 2;
                    }
                }
                System.arraycopy(this.ranges, n8, this.ranges, n6, n5 - n8);
                System.arraycopy(this.styles, n8 >> 1, this.styles, n6 >> 1, this.styleCount - (n8 >> 1));
                this.styleCount -= n8 - n6 >> 1;
            }
        } else {
            int n15 = this.getRangeIndex(n2, -1, this.styleCount);
            if (n15 == this.styleCount) {
                return;
            }
            int n16 = n2 + n3;
            int n17 = this.getRangeIndex(n16, n15 - 1, this.styleCount);
            int n18 = n4 - n3;
            if (n15 == n17 && this.styles[n15].start < n2 && n16 < this.styles[n17].start + this.styles[n17].length) {
                if (n4 == 0) {
                    this.styles[n15].length -= n3;
                    ++n17;
                } else {
                    if (this.styleCount + 1 > this.styles.length) {
                        StyleRange[] styleRangeArray = new StyleRange[this.styles.length + 32];
                        System.arraycopy(this.styles, 0, styleRangeArray, 0, this.styleCount);
                        this.styles = styleRangeArray;
                    }
                    System.arraycopy(this.styles, n15 + 1, this.styles, n15 + 2, this.styleCount - (n15 + 1));
                    this.styles[n15 + 1] = (StyleRange)this.styles[n15].clone();
                    this.styles[n15 + 1].length = this.styles[n15].start + this.styles[n15].length - n16;
                    this.styles[n15 + 1].start = n2 + n4;
                    this.styles[n15].length = n2 - this.styles[n15].start;
                    ++this.styleCount;
                    n17 += 2;
                }
                if (n18 != 0) {
                    int n19 = n17;
                    while (n19 < this.styleCount) {
                        this.styles[n19].start += n18;
                        ++n19;
                    }
                }
            } else {
                if (this.styles[n15].start < n2 && n2 < this.styles[n15].start + this.styles[n15].length) {
                    this.styles[n15].length = n2 - this.styles[n15].start;
                    ++n15;
                }
                if (n17 < this.styleCount && this.styles[n17].start < n16 && n16 < this.styles[n17].start + this.styles[n17].length) {
                    this.styles[n17].length = this.styles[n17].start + this.styles[n17].length - n16;
                    this.styles[n17].start = n16;
                }
                if (n18 != 0) {
                    int n20 = n17;
                    while (n20 < this.styleCount) {
                        this.styles[n20].start += n18;
                        ++n20;
                    }
                }
                System.arraycopy(this.styles, n17, this.styles, n15, this.styleCount - n17);
                this.styleCount -= n17 - n15;
            }
        }
    }

    static class LineInfo {
        int flags;
        Color background;
        int alignment;
        int indent;
        boolean justify;
        int[] segments;

        public LineInfo() {
        }

        public LineInfo(LineInfo lineInfo) {
            if (lineInfo != null) {
                this.flags = lineInfo.flags;
                this.background = lineInfo.background;
                this.alignment = lineInfo.alignment;
                this.indent = lineInfo.indent;
                this.justify = lineInfo.justify;
                this.segments = lineInfo.segments;
            }
        }
    }
}

