/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.PointF;
import org.eclipse.swt.internal.gdip.RectF;
import org.eclipse.swt.internal.win32.OS;

public class Path
extends Resource {
    public int handle;
    PointF currentPoint = new PointF();
    PointF startPoint = new PointF();

    public Path(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        device.checkGDIP();
        this.handle = Gdip.GraphicsPath_new(0);
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void addArc(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (f4 < 0.0f) {
            f2 += f4;
            f4 = -f4;
        }
        if (f5 < 0.0f) {
            f3 += f5;
            f5 = -f5;
        }
        if (f4 == 0.0f || f5 == 0.0f || f7 == 0.0f) {
            return;
        }
        if (f4 == f5) {
            Gdip.GraphicsPath_AddArc(this.handle, f2, f3, f4, f5, -f6, -f7);
        } else {
            int n2;
            int n3 = Gdip.GraphicsPath_new(0);
            if (n3 == 0) {
                SWT.error(2);
            }
            if ((n2 = Gdip.Matrix_new(f4, 0.0f, 0.0f, f5, f2, f3)) == 0) {
                SWT.error(2);
            }
            Gdip.GraphicsPath_AddArc(n3, 0.0f, 0.0f, 1.0f, 1.0f, -f6, -f7);
            Gdip.GraphicsPath_Transform(n3, n2);
            Gdip.GraphicsPath_AddPath(this.handle, n3, true);
            Gdip.Matrix_delete(n2);
            Gdip.GraphicsPath_delete(n3);
        }
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        Gdip.GraphicsPath_AddPath(this.handle, path.handle, false);
        this.currentPoint.X = path.currentPoint.X;
        this.currentPoint.Y = path.currentPoint.Y;
    }

    public void addRectangle(float f2, float f3, float f4, float f5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        RectF rectF = new RectF();
        rectF.X = f2;
        rectF.Y = f3;
        rectF.Width = f4;
        rectF.Height = f5;
        Gdip.GraphicsPath_AddRectangle(this.handle, rectF);
        this.currentPoint.X = f2;
        this.currentPoint.Y = f3;
    }

    public void addString(String string, float f2, float f3, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        int n3 = this.device.internal_new_GC(null);
        int n4 = GC.createGdipFont(n3, font.handle);
        PointF pointF = new PointF();
        pointF.X = f2 - Gdip.Font_GetSize(n4) / 6.0f;
        pointF.Y = f3;
        int n5 = Gdip.FontFamily_new();
        Gdip.Font_GetFamily(n4, n5);
        int n6 = Gdip.Font_GetStyle(n4);
        float f4 = Gdip.Font_GetSize(n4);
        Gdip.GraphicsPath_AddString(this.handle, cArray, n2, n5, n6, f4, pointF, 0);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
        Gdip.FontFamily_delete(n5);
        Gdip.Font_delete(n4);
        this.device.internal_dispose_GC(n3, null);
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_CloseFigure(this.handle);
        this.currentPoint.X = this.startPoint.X;
        this.currentPoint.Y = this.startPoint.Y;
    }

    public boolean contains(float f2, float f3, GC gC, boolean bl2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        gC.initGdip();
        gC.checkGC(120);
        int n2 = OS.GetPolyFillMode(gC.handle) == 2 ? 1 : 0;
        Gdip.GraphicsPath_SetFillMode(this.handle, n2);
        if (bl2) {
            return Gdip.GraphicsPath_IsOutlineVisible(this.handle, f2, f3, gC.data.gdipPen, gC.data.gdipGraphics);
        }
        return Gdip.GraphicsPath_IsVisible(this.handle, f2, f3, gC.data.gdipGraphics);
    }

    public void cubicTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_AddBezier(this.handle, this.currentPoint.X, this.currentPoint.Y, f2, f3, f4, f5, f6, f7);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        Gdip.GraphicsPath_delete(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void getBounds(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 4) {
            SWT.error(5);
        }
        RectF rectF = new RectF();
        Gdip.GraphicsPath_GetBounds(this.handle, rectF, 0, 0);
        fArray[0] = rectF.X;
        fArray[1] = rectF.Y;
        fArray[2] = rectF.Width;
        fArray[3] = rectF.Height;
    }

    public void getCurrentPoint(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 2) {
            SWT.error(5);
        }
        fArray[0] = this.currentPoint.X;
        fArray[1] = this.currentPoint.Y;
    }

    public PathData getPathData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int n2 = Gdip.GraphicsPath_GetPointCount(this.handle);
        byte[] byArray = new byte[n2];
        float[] fArray = new float[n2 * 2];
        Gdip.GraphicsPath_GetPathTypes(this.handle, byArray, n2);
        Gdip.GraphicsPath_GetPathPoints(this.handle, fArray, n2);
        byte[] byArray2 = new byte[n2 * 2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            byte by2 = byArray[n3];
            boolean bl2 = false;
            switch (by2 & 7) {
                case 0: {
                    byArray2[n4++] = 1;
                    bl2 = (by2 & 0x80) != 0;
                    ++n3;
                    break;
                }
                case 1: {
                    byArray2[n4++] = 2;
                    bl2 = (by2 & 0x80) != 0;
                    ++n3;
                    break;
                }
                case 3: {
                    byArray2[n4++] = 4;
                    bl2 = (byArray[n3 + 2] & 0x80) != 0;
                    n3 += 3;
                    break;
                }
                default: {
                    ++n3;
                }
            }
            if (!bl2) continue;
            byArray2[n4++] = 5;
        }
        if (n4 != byArray2.length) {
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray2, 0, byArray3, 0, n4);
            byArray2 = byArray3;
        }
        PathData pathData = new PathData();
        pathData.types = byArray2;
        pathData.points = fArray;
        return pathData;
    }

    public void lineTo(float f2, float f3) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_AddLine(this.handle, this.currentPoint.X, this.currentPoint.Y, f2, f3);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void moveTo(float f2, float f3) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_StartFigure(this.handle);
        this.currentPoint.X = this.startPoint.X = f2;
        this.currentPoint.Y = this.startPoint.Y = f3;
    }

    public void quadTo(float f2, float f3, float f4, float f5) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        float f6 = this.currentPoint.X + 2.0f * (f2 - this.currentPoint.X) / 3.0f;
        float f7 = this.currentPoint.Y + 2.0f * (f3 - this.currentPoint.Y) / 3.0f;
        float f8 = f6 + (f4 - this.currentPoint.X) / 3.0f;
        float f9 = f7 + (f5 - this.currentPoint.Y) / 3.0f;
        Gdip.GraphicsPath_AddBezier(this.handle, this.currentPoint.X, this.currentPoint.Y, f6, f7, f8, f9, f4, f5);
        Gdip.GraphicsPath_GetLastPoint(this.handle, this.currentPoint);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

