/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public final class GridLayout
extends Layout {
    public int numColumns = 1;
    public boolean makeColumnsEqualWidth = false;
    public int marginWidth = 5;
    public int marginHeight = 5;
    public int marginLeft = 0;
    public int marginTop = 0;
    public int marginRight = 0;
    public int marginBottom = 0;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;

    public GridLayout() {
    }

    public GridLayout(int n2, boolean bl2) {
        this.numColumns = n2;
        this.makeColumnsEqualWidth = bl2;
    }

    protected Point computeSize(Composite composite, int n2, int n3, boolean bl2) {
        Point point = this.layout(composite, false, 0, 0, n2, n3, bl2);
        if (n2 != -1) {
            point.x = n2;
        }
        if (n3 != -1) {
            point.y = n3;
        }
        return point;
    }

    protected boolean flushCache(Control control) {
        Object object = control.getLayoutData();
        if (object != null) {
            ((GridData)object).flushCache();
        }
        return true;
    }

    GridData getData(Control[][] controlArray, int n2, int n3, int n4, int n5, boolean bl2) {
        Control control = controlArray[n2][n3];
        if (control != null) {
            int n6;
            GridData gridData = (GridData)control.getLayoutData();
            int n7 = Math.max(1, Math.min(gridData.horizontalSpan, n5));
            int n8 = Math.max(1, gridData.verticalSpan);
            int n9 = bl2 ? n2 + n8 - 1 : n2 - n8 + 1;
            int n10 = n6 = bl2 ? n3 + n7 - 1 : n3 - n7 + 1;
            if (n9 >= 0 && n9 < n4 && n6 >= 0 && n6 < n5 && control == controlArray[n9][n6]) {
                return gridData;
            }
        }
        return null;
    }

    protected void layout(Composite composite, boolean bl2) {
        Rectangle rectangle = composite.getClientArea();
        this.layout(composite, true, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl2);
    }

    Point layout(Composite composite, boolean bl2, int n2, int n3, int n4, int n5, boolean bl3) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        Object object;
        Control[][] controlArray;
        int n23;
        GridData gridData;
        Control control;
        if (this.numColumns < 1) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        Control[] controlArray2 = composite.getChildren();
        int n24 = 0;
        int n25 = 0;
        while (n25 < controlArray2.length) {
            control = controlArray2[n25];
            gridData = (GridData)control.getLayoutData();
            if (gridData == null || !gridData.exclude) {
                controlArray2[n24++] = controlArray2[n25];
            }
            ++n25;
        }
        if (n24 == 0) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        n25 = 0;
        while (n25 < n24) {
            control = controlArray2[n25];
            gridData = (GridData)control.getLayoutData();
            if (gridData == null) {
                gridData = new GridData();
                control.setLayoutData(gridData);
            }
            if (bl3) {
                gridData.flushCache();
            }
            gridData.computeSize(control, gridData.widthHint, gridData.heightHint, bl3);
            if (gridData.grabExcessHorizontalSpace && gridData.minimumWidth > 0 && gridData.cacheWidth < gridData.minimumWidth) {
                n23 = 0;
                if (control instanceof Scrollable) {
                    controlArray = ((Scrollable)control).computeTrim(0, 0, 0, 0);
                    n23 = controlArray.width;
                } else {
                    n23 = control.getBorderWidth() * 2;
                }
                gridData.cacheHeight = -1;
                gridData.cacheWidth = -1;
                gridData.computeSize(control, Math.max(0, gridData.minimumWidth - n23), gridData.heightHint, false);
            }
            if (gridData.grabExcessVerticalSpace && gridData.minimumHeight > 0) {
                gridData.cacheHeight = Math.max(gridData.cacheHeight, gridData.minimumHeight);
            }
            ++n25;
        }
        n25 = 0;
        int n26 = 0;
        int n27 = 0;
        n23 = this.numColumns;
        controlArray = new Control[4][n23];
        int n28 = 0;
        while (n28 < n24) {
            Control control2 = controlArray2[n28];
            object = (GridData)control2.getLayoutData();
            int n29 = Math.max(1, Math.min(((GridData)object).horizontalSpan, n23));
            int n30 = Math.max(1, ((GridData)object).verticalSpan);
            while (true) {
                if ((n22 = n25 + n30) >= controlArray.length) {
                    Control[][] controlArray3 = new Control[n22 + 4][n23];
                    System.arraycopy(controlArray, 0, controlArray3, 0, controlArray.length);
                    controlArray = controlArray3;
                }
                if (controlArray[n25] == null) {
                    controlArray[n25] = new Control[n23];
                }
                while (n26 < n23 && controlArray[n25][n26] != null) {
                    ++n26;
                }
                n21 = n26 + n29;
                if (n21 <= n23) {
                    int n31 = n26;
                    while (n31 < n21 && controlArray[n25][n31] == null) {
                        ++n31;
                    }
                    if (n31 == n21) break;
                    n26 = n31;
                }
                if (n26 + n29 < n23) continue;
                n26 = 0;
                ++n25;
            }
            n22 = 0;
            while (n22 < n30) {
                if (controlArray[n25 + n22] == null) {
                    controlArray[n25 + n22] = new Control[n23];
                }
                n21 = 0;
                while (n21 < n29) {
                    controlArray[n25 + n22][n26 + n21] = control2;
                    ++n21;
                }
                ++n22;
            }
            n27 = Math.max(n27, n25 + n30);
            n26 += n29;
            ++n28;
        }
        n28 = n4 - this.horizontalSpacing * (n23 - 1) - (this.marginLeft + this.marginWidth * 2 + this.marginRight);
        int n32 = 0;
        object = new int[n23];
        int[] nArray = new int[n23];
        boolean[] blArray = new boolean[n23];
        n22 = 0;
        while (n22 < n23) {
            n21 = 0;
            while (n21 < n27) {
                GridData gridData2 = this.getData(controlArray, n21, n22, n27, n23, true);
                if (gridData2 != null && (n20 = Math.max(1, Math.min(gridData2.horizontalSpan, n23))) == 1) {
                    n19 = gridData2.cacheWidth + gridData2.horizontalIndent;
                    object[n22] = Math.max((int)object[n22], n19);
                    if (gridData2.grabExcessHorizontalSpace) {
                        if (!blArray[n22]) {
                            ++n32;
                        }
                        blArray[n22] = true;
                    }
                    if (!gridData2.grabExcessHorizontalSpace || gridData2.minimumWidth != 0) {
                        n19 = !gridData2.grabExcessHorizontalSpace || gridData2.minimumWidth == -1 ? gridData2.cacheWidth : gridData2.minimumWidth;
                        nArray[n22] = Math.max(nArray[n22], n19 += gridData2.horizontalIndent);
                    }
                }
                ++n21;
            }
            n21 = 0;
            while (n21 < n27) {
                GridData gridData3 = this.getData(controlArray, n21, n22, n27, n23, false);
                if (gridData3 != null && (n20 = Math.max(1, Math.min(gridData3.horizontalSpan, n23))) > 1) {
                    n19 = 0;
                    n18 = 0;
                    n17 = 0;
                    int n33 = 0;
                    while (n33 < n20) {
                        n19 += object[n22 - n33];
                        n18 += nArray[n22 - n33];
                        if (blArray[n22 - n33]) {
                            ++n17;
                        }
                        ++n33;
                    }
                    if (gridData3.grabExcessHorizontalSpace && n17 == 0) {
                        ++n32;
                        blArray[n22] = true;
                    }
                    if ((n33 = gridData3.cacheWidth + gridData3.horizontalIndent - n19 - (n20 - 1) * this.horizontalSpacing) > 0) {
                        if (this.makeColumnsEqualWidth) {
                            n16 = (n33 + n19) / n20;
                            n15 = (n33 + n19) % n20;
                            n14 = -1;
                            n13 = 0;
                            while (n13 < n20) {
                                n14 = n22 - n13;
                                object[n14] = Math.max(n16, (int)object[n22 - n13]);
                                ++n13;
                            }
                            if (n14 > -1) {
                                Object object2 = object;
                                int n34 = n14;
                                object2[n34] = object2[n34] + n15;
                            }
                        } else if (n17 == 0) {
                            Object object3 = object;
                            int n35 = n22;
                            object3[n35] = object3[n35] + n33;
                        } else {
                            n16 = n33 / n17;
                            n15 = n33 % n17;
                            n14 = -1;
                            n13 = 0;
                            while (n13 < n20) {
                                if (blArray[n22 - n13]) {
                                    Object object4 = object;
                                    n14 = n22 - n13;
                                    object4[n14] = object4[n14] + n16;
                                }
                                ++n13;
                            }
                            if (n14 > -1) {
                                Object object5 = object;
                                int n36 = n14;
                                object5[n36] = object5[n36] + n15;
                            }
                        }
                    }
                    if (!gridData3.grabExcessHorizontalSpace || gridData3.minimumWidth != 0) {
                        int n37 = n33 = !gridData3.grabExcessHorizontalSpace || gridData3.minimumWidth == -1 ? gridData3.cacheWidth : gridData3.minimumWidth;
                        if ((n33 += gridData3.horizontalIndent - n18 - (n20 - 1) * this.horizontalSpacing) > 0) {
                            if (n17 == 0) {
                                int n38 = n22;
                                nArray[n38] = nArray[n38] + n33;
                            } else {
                                n16 = n33 / n17;
                                n15 = n33 % n17;
                                n14 = -1;
                                n13 = 0;
                                while (n13 < n20) {
                                    if (blArray[n22 - n13]) {
                                        n14 = n22 - n13;
                                        nArray[n14] = nArray[n14] + n16;
                                    }
                                    ++n13;
                                }
                                if (n14 > -1) {
                                    int n39 = n14;
                                    nArray[n39] = nArray[n39] + n15;
                                }
                            }
                        }
                    }
                }
                ++n21;
            }
            ++n22;
        }
        if (this.makeColumnsEqualWidth) {
            n22 = 0;
            n21 = 0;
            int n40 = 0;
            while (n40 < n23) {
                n22 = Math.max(n22, nArray[n40]);
                n21 = Math.max(n21, (int)object[n40]);
                ++n40;
            }
            n21 = n4 == -1 || n32 == 0 ? n21 : Math.max(n22, n28 / n23);
            n40 = 0;
            while (n40 < n23) {
                blArray[n40] = n32 > 0;
                object[n40] = n21;
                ++n40;
            }
        } else if (n4 != -1 && n32 > 0) {
            n22 = 0;
            n21 = 0;
            while (n21 < n23) {
                n22 += object[n21];
                ++n21;
            }
            n21 = n32;
            int n41 = (n28 - n22) / n21;
            n20 = (n28 - n22) % n21;
            n19 = -1;
            while (n22 != n28) {
                n18 = 0;
                while (n18 < n23) {
                    if (blArray[n18]) {
                        if (object[n18] + n41 > nArray[n18]) {
                            n19 = n18;
                            object[n19] = object[n18] + n41;
                        } else {
                            object[n18] = nArray[n18];
                            blArray[n18] = false;
                            --n21;
                        }
                    }
                    ++n18;
                }
                if (n19 > -1) {
                    Object object6 = object;
                    int n42 = n19;
                    object6[n42] = object6[n42] + n20;
                }
                n18 = 0;
                while (n18 < n23) {
                    n17 = 0;
                    while (n17 < n27) {
                        GridData gridData4 = this.getData(controlArray, n17, n18, n27, n23, false);
                        if (!(gridData4 == null || (n16 = Math.max(1, Math.min(gridData4.horizontalSpan, n23))) <= 1 || gridData4.grabExcessHorizontalSpace && gridData4.minimumWidth == 0)) {
                            n15 = 0;
                            n14 = 0;
                            n13 = 0;
                            while (n13 < n16) {
                                n15 += object[n18 - n13];
                                if (blArray[n18 - n13]) {
                                    ++n14;
                                }
                                ++n13;
                            }
                            int n43 = n13 = !gridData4.grabExcessHorizontalSpace || gridData4.minimumWidth == -1 ? gridData4.cacheWidth : gridData4.minimumWidth;
                            if ((n13 += gridData4.horizontalIndent - n15 - (n16 - 1) * this.horizontalSpacing) > 0) {
                                if (n14 == 0) {
                                    Object object7 = object;
                                    int n44 = n18;
                                    object7[n44] = object7[n44] + n13;
                                } else {
                                    n12 = n13 / n14;
                                    n11 = n13 % n14;
                                    n10 = -1;
                                    n9 = 0;
                                    while (n9 < n16) {
                                        if (blArray[n18 - n9]) {
                                            Object object8 = object;
                                            n10 = n18 - n9;
                                            object8[n10] = object8[n10] + n12;
                                        }
                                        ++n9;
                                    }
                                    if (n10 > -1) {
                                        Object object9 = object;
                                        int n45 = n10;
                                        object9[n45] = object9[n45] + n11;
                                    }
                                }
                            }
                        }
                        ++n17;
                    }
                    ++n18;
                }
                if (n21 != 0) {
                    n22 = 0;
                    n18 = 0;
                    while (n18 < n23) {
                        n22 += object[n18];
                        ++n18;
                    }
                    n41 = (n28 - n22) / n21;
                    n20 = (n28 - n22) % n21;
                    n19 = -1;
                    continue;
                }
                break;
            }
        }
        GridData[] gridDataArray = null;
        n21 = 0;
        if (n4 != -1) {
            int n46 = 0;
            while (n46 < n23) {
                n20 = 0;
                while (n20 < n27) {
                    GridData gridData5 = this.getData(controlArray, n20, n46, n27, n23, false);
                    if (gridData5 != null && gridData5.heightHint == -1) {
                        Control control3 = controlArray[n20][n46];
                        n17 = Math.max(1, Math.min(gridData5.horizontalSpan, n23));
                        int n47 = 0;
                        n16 = 0;
                        while (n16 < n17) {
                            n47 += object[n46 - n16];
                            ++n16;
                        }
                        if ((n47 += (n17 - 1) * this.horizontalSpacing - gridData5.horizontalIndent) != gridData5.cacheWidth && gridData5.horizontalAlignment == 4 || gridData5.cacheWidth > n47) {
                            n16 = 0;
                            if (control3 instanceof Scrollable) {
                                Rectangle rectangle = ((Scrollable)control3).computeTrim(0, 0, 0, 0);
                                n16 = rectangle.width;
                            } else {
                                n16 = control3.getBorderWidth() * 2;
                            }
                            gridData5.cacheHeight = -1;
                            gridData5.cacheWidth = -1;
                            gridData5.computeSize(control3, Math.max(0, n47 - n16), gridData5.heightHint, false);
                            if (gridData5.grabExcessVerticalSpace && gridData5.minimumHeight > 0) {
                                gridData5.cacheHeight = Math.max(gridData5.cacheHeight, gridData5.minimumHeight);
                            }
                            if (gridDataArray == null) {
                                gridDataArray = new GridData[n24];
                            }
                            gridDataArray[n21++] = gridData5;
                        }
                    }
                    ++n20;
                }
                ++n46;
            }
        }
        int n48 = n5 - this.verticalSpacing * (n27 - 1) - (this.marginTop + this.marginHeight * 2 + this.marginBottom);
        n32 = 0;
        int[] nArray2 = new int[n27];
        int[] nArray3 = new int[n27];
        boolean[] blArray2 = new boolean[n27];
        n17 = 0;
        while (n17 < n27) {
            int n49 = 0;
            while (n49 < n23) {
                int n50;
                GridData gridData6 = this.getData(controlArray, n17, n49, n27, n23, true);
                if (gridData6 != null && (n50 = Math.max(1, Math.min(gridData6.verticalSpan, n27))) == 1) {
                    n14 = gridData6.cacheHeight + gridData6.verticalIndent;
                    nArray2[n17] = Math.max(nArray2[n17], n14);
                    if (gridData6.grabExcessVerticalSpace) {
                        if (!blArray2[n17]) {
                            ++n32;
                        }
                        blArray2[n17] = true;
                    }
                    if (!gridData6.grabExcessVerticalSpace || gridData6.minimumHeight != 0) {
                        n14 = !gridData6.grabExcessVerticalSpace || gridData6.minimumHeight == -1 ? gridData6.cacheHeight : gridData6.minimumHeight;
                        nArray3[n17] = Math.max(nArray3[n17], n14 += gridData6.verticalIndent);
                    }
                }
                ++n49;
            }
            n49 = 0;
            while (n49 < n23) {
                int n51;
                GridData gridData7 = this.getData(controlArray, n17, n49, n27, n23, false);
                if (gridData7 != null && (n51 = Math.max(1, Math.min(gridData7.verticalSpan, n27))) > 1) {
                    n14 = 0;
                    n13 = 0;
                    n12 = 0;
                    n11 = 0;
                    while (n11 < n51) {
                        n14 += nArray2[n17 - n11];
                        n13 += nArray3[n17 - n11];
                        if (blArray2[n17 - n11]) {
                            ++n12;
                        }
                        ++n11;
                    }
                    if (gridData7.grabExcessVerticalSpace && n12 == 0) {
                        ++n32;
                        blArray2[n17] = true;
                    }
                    if ((n11 = gridData7.cacheHeight + gridData7.verticalIndent - n14 - (n51 - 1) * this.verticalSpacing) > 0) {
                        if (n12 == 0) {
                            int n52 = n17;
                            nArray2[n52] = nArray2[n52] + n11;
                        } else {
                            n10 = n11 / n12;
                            n9 = n11 % n12;
                            n8 = -1;
                            n7 = 0;
                            while (n7 < n51) {
                                if (blArray2[n17 - n7]) {
                                    n8 = n17 - n7;
                                    nArray2[n8] = nArray2[n8] + n10;
                                }
                                ++n7;
                            }
                            if (n8 > -1) {
                                int n53 = n8;
                                nArray2[n53] = nArray2[n53] + n9;
                            }
                        }
                    }
                    if (!gridData7.grabExcessVerticalSpace || gridData7.minimumHeight != 0) {
                        int n54 = n11 = !gridData7.grabExcessVerticalSpace || gridData7.minimumHeight == -1 ? gridData7.cacheHeight : gridData7.minimumHeight;
                        if ((n11 += gridData7.verticalIndent - n13 - (n51 - 1) * this.verticalSpacing) > 0) {
                            if (n12 == 0) {
                                int n55 = n17;
                                nArray3[n55] = nArray3[n55] + n11;
                            } else {
                                n10 = n11 / n12;
                                n9 = n11 % n12;
                                n8 = -1;
                                n7 = 0;
                                while (n7 < n51) {
                                    if (blArray2[n17 - n7]) {
                                        n8 = n17 - n7;
                                        nArray3[n8] = nArray3[n8] + n10;
                                    }
                                    ++n7;
                                }
                                if (n8 > -1) {
                                    int n56 = n8;
                                    nArray3[n56] = nArray3[n56] + n9;
                                }
                            }
                        }
                    }
                }
                ++n49;
            }
            ++n17;
        }
        if (n5 != -1 && n32 > 0) {
            n17 = 0;
            int n57 = 0;
            while (n57 < n27) {
                n17 += nArray2[n57];
                ++n57;
            }
            n57 = n32;
            int n58 = (n48 - n17) / n57;
            int n59 = (n48 - n17) % n57;
            n14 = -1;
            while (n17 != n48) {
                n13 = 0;
                while (n13 < n27) {
                    if (blArray2[n13]) {
                        if (nArray2[n13] + n58 > nArray3[n13]) {
                            n14 = n13;
                            nArray2[n14] = nArray2[n13] + n58;
                        } else {
                            nArray2[n13] = nArray3[n13];
                            blArray2[n13] = false;
                            --n57;
                        }
                    }
                    ++n13;
                }
                if (n14 > -1) {
                    int n60 = n14;
                    nArray2[n60] = nArray2[n60] + n59;
                }
                n13 = 0;
                while (n13 < n27) {
                    n12 = 0;
                    while (n12 < n23) {
                        GridData gridData8 = this.getData(controlArray, n13, n12, n27, n23, false);
                        if (!(gridData8 == null || (n10 = Math.max(1, Math.min(gridData8.verticalSpan, n27))) <= 1 || gridData8.grabExcessVerticalSpace && gridData8.minimumHeight == 0)) {
                            n9 = 0;
                            n8 = 0;
                            n7 = 0;
                            while (n7 < n10) {
                                n9 += nArray2[n13 - n7];
                                if (blArray2[n13 - n7]) {
                                    ++n8;
                                }
                                ++n7;
                            }
                            int n61 = n7 = !gridData8.grabExcessVerticalSpace || gridData8.minimumHeight == -1 ? gridData8.cacheHeight : gridData8.minimumHeight;
                            if ((n7 += gridData8.verticalIndent - n9 - (n10 - 1) * this.verticalSpacing) > 0) {
                                if (n8 == 0) {
                                    int n62 = n13;
                                    nArray2[n62] = nArray2[n62] + n7;
                                } else {
                                    n6 = n7 / n8;
                                    int n63 = n7 % n8;
                                    int n64 = -1;
                                    int n65 = 0;
                                    while (n65 < n10) {
                                        if (blArray2[n13 - n65]) {
                                            n64 = n13 - n65;
                                            nArray2[n64] = nArray2[n64] + n6;
                                        }
                                        ++n65;
                                    }
                                    if (n64 > -1) {
                                        int n66 = n64;
                                        nArray2[n66] = nArray2[n66] + n63;
                                    }
                                }
                            }
                        }
                        ++n12;
                    }
                    ++n13;
                }
                if (n57 == 0) break;
                n17 = 0;
                n13 = 0;
                while (n13 < n27) {
                    n17 += nArray2[n13];
                    ++n13;
                }
                n58 = (n48 - n17) / n57;
                n59 = (n48 - n17) % n57;
                n14 = -1;
            }
        }
        if (bl2) {
            n17 = n3 + this.marginTop + this.marginHeight;
            int n67 = 0;
            while (n67 < n27) {
                int n68 = n2 + this.marginLeft + this.marginWidth;
                int n69 = 0;
                while (n69 < n23) {
                    GridData gridData9 = this.getData(controlArray, n67, n69, n27, n23, true);
                    if (gridData9 != null) {
                        n13 = Math.max(1, Math.min(gridData9.horizontalSpan, n23));
                        n12 = Math.max(1, gridData9.verticalSpan);
                        int n70 = 0;
                        n10 = 0;
                        n9 = 0;
                        while (n9 < n13) {
                            n70 += object[n69 + n9];
                            ++n9;
                        }
                        n9 = 0;
                        while (n9 < n12) {
                            n10 += nArray2[n67 + n9];
                            ++n9;
                        }
                        n9 = n68 + gridData9.horizontalIndent;
                        n8 = Math.min(gridData9.cacheWidth, n70 += this.horizontalSpacing * (n13 - 1));
                        switch (gridData9.horizontalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                n9 += Math.max(0, (n70 - gridData9.horizontalIndent - n8) / 2);
                                break;
                            }
                            case 3: 
                            case 131072: 
                            case 0x1000008: {
                                n9 += Math.max(0, n70 - gridData9.horizontalIndent - n8);
                                break;
                            }
                            case 4: {
                                n8 = n70 - gridData9.horizontalIndent;
                            }
                        }
                        n7 = n17 + gridData9.verticalIndent;
                        n6 = Math.min(gridData9.cacheHeight, n10 += this.verticalSpacing * (n12 - 1));
                        switch (gridData9.verticalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                n7 += Math.max(0, (n10 - gridData9.verticalIndent - n6) / 2);
                                break;
                            }
                            case 3: 
                            case 1024: 
                            case 0x1000008: {
                                n7 += Math.max(0, n10 - gridData9.verticalIndent - n6);
                                break;
                            }
                            case 4: {
                                n6 = n10 - gridData9.verticalIndent;
                            }
                        }
                        Control control4 = controlArray[n67][n69];
                        if (control4 != null) {
                            control4.setBounds(n9, n7, n8, n6);
                        }
                    }
                    n68 += object[n69] + this.horizontalSpacing;
                    ++n69;
                }
                n17 += nArray2[n67] + this.verticalSpacing;
                ++n67;
            }
        }
        n17 = 0;
        while (n17 < n21) {
            gridDataArray[n17].cacheHeight = -1;
            gridDataArray[n17].cacheWidth = -1;
            ++n17;
        }
        n17 = 0;
        int n71 = 0;
        int n72 = 0;
        while (n72 < n23) {
            n17 += object[n72];
            ++n72;
        }
        n72 = 0;
        while (n72 < n27) {
            n71 += nArray2[n72];
            ++n72;
        }
        return new Point(n17 += this.horizontalSpacing * (n23 - 1) + this.marginLeft + this.marginWidth * 2 + this.marginRight, n71 += this.verticalSpacing * (n27 - 1) + this.marginTop + this.marginHeight * 2 + this.marginBottom);
    }

    String getName() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1, string.length());
    }

    public String toString() {
        String string = String.valueOf(this.getName()) + " {";
        if (this.numColumns != 1) {
            string = String.valueOf(string) + "numColumns=" + this.numColumns + " ";
        }
        if (this.makeColumnsEqualWidth) {
            string = String.valueOf(string) + "makeColumnsEqualWidth=" + this.makeColumnsEqualWidth + " ";
        }
        if (this.marginWidth != 0) {
            string = String.valueOf(string) + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = String.valueOf(string) + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.marginLeft != 0) {
            string = String.valueOf(string) + "marginLeft=" + this.marginLeft + " ";
        }
        if (this.marginRight != 0) {
            string = String.valueOf(string) + "marginRight=" + this.marginRight + " ";
        }
        if (this.marginTop != 0) {
            string = String.valueOf(string) + "marginTop=" + this.marginTop + " ";
        }
        if (this.marginBottom != 0) {
            string = String.valueOf(string) + "marginBottom=" + this.marginBottom + " ";
        }
        if (this.horizontalSpacing != 0) {
            string = String.valueOf(string) + "horizontalSpacing=" + this.horizontalSpacing + " ";
        }
        if (this.verticalSpacing != 0) {
            string = String.valueOf(string) + "verticalSpacing=" + this.verticalSpacing + " ";
        }
        string = string.trim();
        string = String.valueOf(string) + "}";
        return string;
    }
}

