/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICS;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSA;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class ExpandBar
extends Composite {
    ExpandItem[] items;
    int itemCount;
    ExpandItem focusItem;
    int spacing = 4;
    int yCurrentScroll;
    int hFont;

    public ExpandBar(Composite composite, int n2) {
        super(composite, ExpandBar.checkStyle(n2));
    }

    public void addExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(expandListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.DefWindowProc(n2, n3, n4, n5);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n2) {
        return (n2 &= 0xFFFFFEFF) | 0x40000;
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        if ((n2 == -1 || n3 == -1) && this.itemCount > 0) {
            Object object;
            int n6 = OS.GetDC(this.handle);
            int n7 = 0;
            if (this.isAppThemed()) {
                n7 = this.display.hExplorerBarTheme();
            }
            int n8 = 0;
            int n9 = 0;
            if (n7 == 0) {
                if (this.hFont != 0) {
                    n8 = this.hFont;
                } else if (!OS.IsWinCE) {
                    NONCLIENTMETRICS nONCLIENTMETRICS = OS.IsUnicode ? new NONCLIENTMETRICSW() : new NONCLIENTMETRICSA();
                    nONCLIENTMETRICS.cbSize = NONCLIENTMETRICS.sizeof;
                    if (OS.SystemParametersInfo(41, 0, nONCLIENTMETRICS, 0)) {
                        object = OS.IsUnicode ? nONCLIENTMETRICS.lfCaptionFont : ((NONCLIENTMETRICSA)nONCLIENTMETRICS).lfCaptionFont;
                        n8 = OS.CreateFontIndirect((LOGFONT)object);
                    }
                }
                if (n8 != 0) {
                    n9 = OS.SelectObject(n6, n8);
                }
            }
            n4 += this.spacing;
            int n10 = 0;
            while (n10 < this.itemCount) {
                object = this.items[n10];
                n4 += ((ExpandItem)object).getHeaderHeight();
                if (((ExpandItem)object).expanded) {
                    n4 += ((ExpandItem)object).height;
                }
                n4 += this.spacing;
                n5 = Math.max(n5, ((ExpandItem)object).getPreferredWidth(n7, n6));
                ++n10;
            }
            if (n8 != 0) {
                OS.SelectObject(n6, n9);
                if (n8 != this.hFont) {
                    OS.DeleteObject(n8);
                }
            }
            OS.ReleaseDC(this.handle, n6);
        }
        if (n5 == 0) {
            n5 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n2 != -1) {
            n5 = n2;
        }
        if (n3 != -1) {
            n4 = n3;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n5, n4);
        return new Point(rectangle.width, rectangle.height);
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFFFD;
        this.state |= 0x2000;
    }

    void createItem(ExpandItem expandItem, int n2, int n3) {
        Object object;
        if (n3 < 0 || n3 > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            object = new ExpandItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, object, 0, this.items.length);
            this.items = object;
        }
        System.arraycopy(this.items, n3, this.items, n3 + 1, this.itemCount - n3);
        this.items[n3] = expandItem;
        ++this.itemCount;
        if (this.focusItem == null) {
            this.focusItem = expandItem;
        }
        object = new RECT();
        OS.GetWindowRect(this.handle, (RECT)object);
        expandItem.width = Math.max(0, object.right - object.left - this.spacing * 2);
        this.layoutItems(n3, true);
    }

    void createWidget() {
        super.createWidget();
        this.items = new ExpandItem[4];
        if (!this.isAppThemed()) {
            this.backgroundMode = 1;
        }
    }

    int defaultBackground() {
        if (!this.isAppThemed()) {
            return OS.GetSysColor(OS.COLOR_WINDOW);
        }
        return super.defaultBackground();
    }

    void destroyItem(ExpandItem expandItem) {
        int n2 = 0;
        while (n2 < this.itemCount) {
            if (this.items[n2] == expandItem) break;
            ++n2;
        }
        if (n2 == this.itemCount) {
            return;
        }
        if (expandItem == this.focusItem) {
            int n3;
            int n4 = n3 = n2 > 0 ? n2 - 1 : 1;
            if (n3 < this.itemCount) {
                this.focusItem = this.items[n3];
                this.focusItem.redraw(true);
            } else {
                this.focusItem = null;
            }
        }
        System.arraycopy(this.items, n2 + 1, this.items, n2, --this.itemCount - n2);
        this.items[this.itemCount] = null;
        expandItem.redraw(true);
        this.layoutItems(n2, true);
    }

    void drawThemeBackground(int n2, int n3, RECT rECT) {
        RECT rECT2 = new RECT();
        OS.GetClientRect(this.handle, rECT2);
        OS.MapWindowPoints(this.handle, n3, rECT2, 2);
        OS.DrawThemeBackground(this.display.hExplorerBarTheme(), n2, 5, 0, rECT2, null);
    }

    void drawWidget(GC gC, RECT rECT) {
        Object object;
        int n2;
        int n3 = 0;
        if (this.isAppThemed()) {
            n3 = this.display.hExplorerBarTheme();
        }
        if (n3 != 0) {
            RECT rECT2 = new RECT();
            OS.GetClientRect(this.handle, rECT2);
            OS.DrawThemeBackground(n3, gC.handle, 1, 0, rECT2, rECT);
        } else {
            this.drawBackground(gC.handle);
        }
        boolean bl2 = false;
        if (this.handle == OS.GetFocus()) {
            n2 = OS.SendMessage(this.handle, 297, 0, 0);
            bl2 = (n2 & 1) == 0;
        }
        n2 = 0;
        int n4 = 0;
        if (n3 == 0 && !OS.IsWinCE && this.hFont == 0) {
            NONCLIENTMETRICS nONCLIENTMETRICS = OS.IsUnicode ? new NONCLIENTMETRICSW() : new NONCLIENTMETRICSA();
            nONCLIENTMETRICS.cbSize = NONCLIENTMETRICS.sizeof;
            if (OS.SystemParametersInfo(41, 0, nONCLIENTMETRICS, 0)) {
                object = OS.IsUnicode ? nONCLIENTMETRICS.lfCaptionFont : ((NONCLIENTMETRICSA)nONCLIENTMETRICS).lfCaptionFont;
                n2 = OS.CreateFontIndirect((LOGFONT)object);
                n4 = OS.SelectObject(gC.handle, n2);
            }
        }
        int n5 = 0;
        while (n5 < this.itemCount) {
            ((ExpandItem)object).drawItem(gC, n3, rECT, (object = this.items[n5]) == this.focusItem && bl2);
            ++n5;
        }
        if (n2 != 0) {
            OS.SelectObject(gC.handle, n4);
            OS.DeleteObject(n2);
        }
    }

    Control findBackgroundControl() {
        Control control = super.findBackgroundControl();
        if (!this.isAppThemed() && control == null) {
            control = this;
        }
        return control;
    }

    Control findThemeControl() {
        return this.isAppThemed() ? this : super.findThemeControl();
    }

    int getBandHeight() {
        if (this.hFont == 0) {
            return 24;
        }
        int n2 = OS.GetDC(this.handle);
        int n3 = OS.SelectObject(n2, this.hFont);
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(n2, tEXTMETRIC);
        OS.SelectObject(n2, n3);
        OS.ReleaseDC(this.handle, n2);
        return Math.max(24, tEXTMETRIC.tmHeight + 4);
    }

    public ExpandItem getItem(int n2) {
        this.checkWidget();
        if (n2 < 0 || n2 >= this.itemCount) {
            this.error(6);
        }
        return this.items[n2];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        ExpandItem[] expandItemArray = new ExpandItem[this.itemCount];
        System.arraycopy(this.items, 0, expandItemArray, 0, this.itemCount);
        return expandItemArray;
    }

    public int getSpacing() {
        this.checkWidget();
        return this.spacing;
    }

    public int indexOf(ExpandItem expandItem) {
        this.checkWidget();
        if (expandItem == null) {
            this.error(4);
        }
        int n2 = 0;
        while (n2 < this.itemCount) {
            if (this.items[n2] == expandItem) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    boolean isAppThemed() {
        if (this.background != -1) {
            return false;
        }
        if (this.foreground != -1) {
            return false;
        }
        if (this.hFont != 0) {
            return false;
        }
        return OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed();
    }

    void layoutItems(int n2, boolean bl2) {
        if (n2 < this.itemCount) {
            ExpandItem expandItem;
            int n3 = this.spacing - this.yCurrentScroll;
            int n4 = 0;
            while (n4 < n2) {
                expandItem = this.items[n4];
                if (expandItem.expanded) {
                    n3 += expandItem.height;
                }
                n3 += expandItem.getHeaderHeight() + this.spacing;
                ++n4;
            }
            n4 = n2;
            while (n4 < this.itemCount) {
                expandItem = this.items[n4];
                expandItem.setBounds(this.spacing, n3, 0, 0, true, false);
                if (expandItem.expanded) {
                    n3 += expandItem.height;
                }
                n3 += expandItem.getHeaderHeight() + this.spacing;
                ++n4;
            }
        }
        if (bl2) {
            this.setScrollbar();
        }
    }

    void releaseChildren(boolean bl2) {
        if (this.items != null) {
            int n2 = 0;
            while (n2 < this.items.length) {
                ExpandItem expandItem = this.items[n2];
                if (expandItem != null && !expandItem.isDisposed()) {
                    expandItem.release(false);
                }
                ++n2;
            }
            this.items = null;
        }
        this.focusItem = null;
        super.releaseChildren(bl2);
    }

    public void removeExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, expandListener);
        this.eventTable.unhook(18, expandListener);
    }

    void setBackgroundPixel(int n2) {
        super.setBackgroundPixel(n2);
        if (!OS.IsWinCE) {
            int n3 = 1157;
            OS.RedrawWindow(this.handle, null, 0, n3);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.hFont = font != null ? font.handle : 0;
        this.layoutItems(0, true);
    }

    void setForegroundPixel(int n2) {
        super.setForegroundPixel(n2);
        if (!OS.IsWinCE) {
            int n3 = 1157;
            OS.RedrawWindow(this.handle, null, 0, n3);
        }
    }

    void setScrollbar() {
        if (this.itemCount == 0) {
            return;
        }
        if ((this.style & 0x200) == 0) {
            return;
        }
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        int n2 = rECT.bottom - rECT.top;
        ExpandItem expandItem = this.items[this.itemCount - 1];
        int n3 = expandItem.y + this.getBandHeight() + this.spacing;
        if (expandItem.expanded) {
            n3 += expandItem.height;
        }
        if (this.yCurrentScroll > 0 && n2 > n3) {
            this.yCurrentScroll = Math.max(0, this.yCurrentScroll + n3 - n2);
            this.layoutItems(0, false);
        }
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 7;
        sCROLLINFO.nMin = 0;
        sCROLLINFO.nMax = n3 += this.yCurrentScroll;
        sCROLLINFO.nPage = n2;
        sCROLLINFO.nPos = Math.min(this.yCurrentScroll, sCROLLINFO.nMax);
        if (sCROLLINFO.nPage != 0) {
            ++sCROLLINFO.nPage;
        }
        OS.SetScrollInfo(this.handle, 1, sCROLLINFO, true);
    }

    public void setSpacing(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n2 == this.spacing) {
            return;
        }
        this.spacing = n2;
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        int n3 = Math.max(0, rECT.right - rECT.left - n2 * 2);
        int n4 = 0;
        while (n4 < this.itemCount) {
            ExpandItem expandItem = this.items[n4];
            if (expandItem.width != n3) {
                expandItem.setBounds(0, 0, n3, expandItem.height, false, true);
            }
            ++n4;
        }
        this.layoutItems(0, true);
        OS.InvalidateRect(this.handle, null, true);
    }

    void showItem(ExpandItem expandItem) {
        Control control = expandItem.control;
        if (control != null && !control.isDisposed()) {
            control.setVisible(expandItem.expanded);
        }
        expandItem.redraw(true);
        int n2 = this.indexOf(expandItem);
        this.layoutItems(n2 + 1, true);
    }

    TCHAR windowClass() {
        return this.display.windowClass;
    }

    int windowProc() {
        return this.display.windowProc;
    }

    LRESULT WM_KEYDOWN(int n2, int n3) {
        LRESULT lRESULT = super.WM_KEYDOWN(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.focusItem == null) {
            return lRESULT;
        }
        switch (n2) {
            case 13: 
            case 32: {
                Event event = new Event();
                event.item = this.focusItem;
                this.sendEvent(this.focusItem.expanded ? 18 : 17, event);
                this.focusItem.expanded = !this.focusItem.expanded;
                this.showItem(this.focusItem);
                return LRESULT.ZERO;
            }
            case 38: {
                int n4 = this.indexOf(this.focusItem);
                if (n4 <= 0) break;
                this.focusItem.redraw(true);
                this.focusItem = this.items[n4 - 1];
                this.focusItem.redraw(true);
                return LRESULT.ZERO;
            }
            case 40: {
                int n5 = this.indexOf(this.focusItem);
                if (n5 >= this.itemCount - 1) break;
                this.focusItem.redraw(true);
                this.focusItem = this.items[n5 + 1];
                this.focusItem.redraw(true);
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT WM_KILLFOCUS(int n2, int n3) {
        LRESULT lRESULT = super.WM_KILLFOCUS(n2, n3);
        if (this.focusItem != null) {
            this.focusItem.redraw(true);
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONDOWN(int n2, int n3) {
        LRESULT lRESULT = super.WM_LBUTTONDOWN(n2, n3);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        short s2 = (short)(n3 & 0xFFFF);
        short s3 = (short)(n3 >> 16);
        int n4 = 0;
        while (n4 < this.itemCount) {
            ExpandItem expandItem = this.items[n4];
            boolean bl2 = expandItem.isHover(s2, s3);
            if (bl2 && this.focusItem != expandItem) {
                this.focusItem.redraw(true);
                this.focusItem = expandItem;
                this.focusItem.redraw(true);
                this.forceFocus();
                break;
            }
            ++n4;
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONUP(int n2, int n3) {
        LRESULT lRESULT = super.WM_LBUTTONUP(n2, n3);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if (this.focusItem == null) {
            return lRESULT;
        }
        short s2 = (short)(n3 & 0xFFFF);
        short s3 = (short)(n3 >> 16);
        boolean bl2 = this.focusItem.isHover(s2, s3);
        if (bl2) {
            Event event = new Event();
            event.item = this.focusItem;
            this.sendEvent(this.focusItem.expanded ? 18 : 17, event);
            this.focusItem.expanded = !this.focusItem.expanded;
            this.showItem(this.focusItem);
        }
        return lRESULT;
    }

    LRESULT WM_MOUSELEAVE(int n2, int n3) {
        LRESULT lRESULT = super.WM_MOUSELEAVE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n4 = 0;
        while (n4 < this.itemCount) {
            ExpandItem expandItem = this.items[n4];
            if (expandItem.hover) {
                expandItem.hover = false;
                expandItem.redraw(false);
                break;
            }
            ++n4;
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEMOVE(int n2, int n3) {
        LRESULT lRESULT = super.WM_MOUSEMOVE(n2, n3);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        short s2 = (short)(n3 & 0xFFFF);
        short s3 = (short)(n3 >> 16);
        int n4 = 0;
        while (n4 < this.itemCount) {
            ExpandItem expandItem = this.items[n4];
            boolean bl2 = expandItem.isHover(s2, s3);
            if (expandItem.hover != bl2) {
                expandItem.hover = bl2;
                expandItem.redraw(false);
            }
            ++n4;
        }
        return lRESULT;
    }

    LRESULT WM_PAINT(int n2, int n3) {
        PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
        GCData gCData = new GCData();
        gCData.ps = pAINTSTRUCT;
        gCData.hwnd = this.handle;
        GC gC = this.new_GC(gCData);
        if (gC != null) {
            int n4 = pAINTSTRUCT.right - pAINTSTRUCT.left;
            int n5 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
            if (n4 != 0 && n5 != 0) {
                RECT rECT = new RECT();
                OS.SetRect(rECT, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right, pAINTSTRUCT.bottom);
                this.drawWidget(gC, rECT);
                if (this.hooks(9) || this.filters(9)) {
                    Event event = new Event();
                    event.gc = gC;
                    event.x = rECT.left;
                    event.y = rECT.top;
                    event.width = n4;
                    event.height = n5;
                    this.sendEvent(9, event);
                    event.gc = null;
                }
            }
            gC.dispose();
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PRINTCLIENT(int n2, int n3) {
        LRESULT lRESULT = super.WM_PRINTCLIENT(n2, n3);
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        GCData gCData = new GCData();
        gCData.device = this.display;
        gCData.foreground = this.getForegroundPixel();
        GC gC = GC.win32_new(n2, gCData);
        this.drawWidget(gC, rECT);
        gC.dispose();
        return lRESULT;
    }

    LRESULT WM_SETCURSOR(int n2, int n3) {
        LRESULT lRESULT = super.WM_SETCURSOR(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n4 = n3 & 0xFFFF;
        if (n4 == 1) {
            int n5 = 0;
            while (n5 < this.itemCount) {
                ExpandItem expandItem = this.items[n5];
                if (expandItem.hover) {
                    int n6 = OS.LoadCursor(0, 32649);
                    OS.SetCursor(n6);
                    return LRESULT.ONE;
                }
                ++n5;
            }
        }
        return lRESULT;
    }

    LRESULT WM_SETFOCUS(int n2, int n3) {
        LRESULT lRESULT = super.WM_SETFOCUS(n2, n3);
        if (this.focusItem != null) {
            this.focusItem.redraw(true);
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(int n2, int n3) {
        LRESULT lRESULT = super.WM_SIZE(n2, n3);
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        int n4 = Math.max(0, rECT.right - rECT.left - this.spacing * 2);
        int n5 = 0;
        while (n5 < this.itemCount) {
            ExpandItem expandItem = this.items[n5];
            if (expandItem.width != n4) {
                expandItem.setBounds(0, 0, n4, expandItem.height, false, true);
            }
            ++n5;
        }
        this.setScrollbar();
        OS.InvalidateRect(this.handle, null, true);
        return lRESULT;
    }

    LRESULT wmScroll(ScrollBar scrollBar, boolean bl2, int n2, int n3, int n4, int n5) {
        LRESULT lRESULT = super.wmScroll(scrollBar, true, n2, n3, n4, n5);
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 4;
        OS.GetScrollInfo(this.handle, 1, sCROLLINFO);
        int n6 = this.yCurrentScroll - sCROLLINFO.nPos;
        OS.ScrollWindowEx(this.handle, 0, n6, null, null, 0, null, 3);
        this.yCurrentScroll = sCROLLINFO.nPos;
        if (n6 != 0) {
            int n7 = 0;
            while (n7 < this.itemCount) {
                this.items[n7].y += n6;
                ++n7;
            }
        }
        return lRESULT;
    }
}

