/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.RenderTexture;
import org.lwjgl.opengl.k;
import org.lwjgl.opengl.v;

public final class Pbuffer
implements Drawable {
    public static final int PBUFFER_SUPPORTED = 1;
    public static final int RENDER_TEXTURE_SUPPORTED = 2;
    public static final int RENDER_TEXTURE_RECTANGLE_SUPPORTED = 4;
    public static final int RENDER_DEPTH_TEXTURE_SUPPORTED = 8;
    public static final int MIPMAP_LEVEL = 8315;
    public static final int CUBE_MAP_FACE = 8316;
    public static final int TEXTURE_CUBE_MAP_POSITIVE_X = 8317;
    public static final int TEXTURE_CUBE_MAP_NEGATIVE_X = 8318;
    public static final int TEXTURE_CUBE_MAP_POSITIVE_Y = 8319;
    public static final int TEXTURE_CUBE_MAP_NEGATIVE_Y = 8320;
    public static final int TEXTURE_CUBE_MAP_POSITIVE_Z = 8321;
    public static final int TEXTURE_CUBE_MAP_NEGATIVE_Z = 8322;
    public static final int FRONT_LEFT_BUFFER = 8323;
    public static final int FRONT_RIGHT_BUFFER = 8324;
    public static final int BACK_LEFT_BUFFER = 8325;
    public static final int BACK_RIGHT_BUFFER = 8326;
    public static final int DEPTH_BUFFER = 8359;
    private final v peer_info;
    private final int width;
    private final int height;
    private final k context;
    private boolean destroyed;

    public Pbuffer(int n2, int n3, PixelFormat pixelFormat, Drawable drawable) throws LWJGLException {
        this(n2, n3, pixelFormat, null, drawable);
    }

    public Pbuffer(int n2, int n3, PixelFormat pixelFormat, RenderTexture renderTexture, Drawable drawable) throws LWJGLException {
        k k2;
        block6: {
            Drawable drawable2;
            block5: {
                block4: {
                    if (pixelFormat == null) {
                        throw new NullPointerException("Pixel format must be non-null");
                    }
                    this.width = n2;
                    this.height = n3;
                    this.peer_info = Pbuffer.createPbuffer(n2, n3, pixelFormat, renderTexture);
                    k2 = null;
                    if (drawable == null) break block4;
                    drawable2 = drawable;
                    break block5;
                }
                Drawable drawable3 = Display.getDrawable();
                if (drawable3 == null) break block6;
                drawable2 = drawable3;
            }
            k2 = drawable2.getContext();
        }
        this.context = new k(this.peer_info, k2);
    }

    private static v createPbuffer(int n2, int n3, PixelFormat pixelFormat, RenderTexture renderTexture) throws LWJGLException {
        if (renderTexture == null) {
            IntBuffer intBuffer = BufferUtils.createIntBuffer(1);
            return Display.getImplementation().createPbuffer(n2, n3, pixelFormat, null, intBuffer);
        }
        return Display.getImplementation().createPbuffer(n2, n3, pixelFormat, renderTexture.pixelFormatCaps, renderTexture.pBufferAttribs);
    }

    public final k getContext() {
        return this.context;
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("Pbuffer is destroyed");
        }
    }

    public final synchronized boolean isBufferLost() {
        this.checkDestroyed();
        return Display.getImplementation().isBufferLost(this.peer_info);
    }

    public final synchronized void makeCurrent() throws LWJGLException {
        this.checkDestroyed();
        this.context.e();
    }

    public final synchronized void release() {
        this.checkDestroyed();
        try {
            k.a();
            return;
        }
        catch (LWJGLException lWJGLException) {
            return;
        }
    }

    public static int getCapabilities() {
        return Display.getImplementation().getPbufferCapabilities();
    }

    public final synchronized void destroy() {
        if (this.destroyed) {
            return;
        }
        try {
            this.context.f();
            this.peer_info.c();
            this.destroyed = true;
            return;
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Exception occurred while destroying pbuffer: " + lWJGLException);
            return;
        }
    }

    public final synchronized void setAttrib(int n2, int n3) {
        this.checkDestroyed();
        Display.getImplementation().setPbufferAttrib(this.peer_info, n2, n3);
    }

    public final synchronized void bindTexImage(int n2) {
        this.checkDestroyed();
        Display.getImplementation().bindTexImageToPbuffer(this.peer_info, n2);
    }

    public final synchronized void releaseTexImage(int n2) {
        this.checkDestroyed();
        Display.getImplementation().releaseTexImageFromPbuffer(this.peer_info, n2);
    }

    public final synchronized int getHeight() {
        this.checkDestroyed();
        return this.height;
    }

    public final synchronized int getWidth() {
        this.checkDestroyed();
        return this.width;
    }

    static {
        Sys.initialize();
    }
}

