/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.WindowsDisplayPeerInfo;
import org.lwjgl.opengl.WindowsPbufferPeerInfo;
import org.lwjgl.opengl.WindowsRegistry;
import org.lwjgl.opengl.p;
import org.lwjgl.opengl.v;
import org.lwjgl.opengl.w;

final class WindowsDisplay
implements p {
    private static final int GAMMA_LENGTH = 256;
    private static final int WM_MOUSEMOVE = 512;
    private static final int WM_LBUTTONDOWN = 513;
    private static final int WM_LBUTTONUP = 514;
    private static final int WM_RBUTTONDOWN = 516;
    private static final int WM_RBUTTONUP = 517;
    private static final int WM_MBUTTONDOWN = 519;
    private static final int WM_MBUTTONUP = 520;
    private static final int WM_MOUSEWHEEL = 522;
    private static final int WM_QUIT = 18;
    private static final int WM_SYSCOMMAND = 274;
    private static final int WM_PAINT = 15;
    private static final int SC_CLOSE = 61536;
    private static final int SC_MOUSEMENU = 61584;
    private static final int SC_KEYMENU = 61696;
    private static final int SC_SCREENSAVE = 61760;
    private static final int SC_MONITORPOWER = 61808;
    private static final int SM_CXCURSOR = 13;
    private static final int SIZE_RESTORED = 0;
    private static final int SIZE_MINIMIZED = 1;
    private static final int SIZE_MAXIMIZED = 2;
    private static final int WM_SIZE = 5;
    private static final int WM_ACTIVATE = 6;
    private static final int WA_INACTIVE = 0;
    private static final int WA_ACTIVE = 1;
    private static final int WA_CLICKACTIVE = 2;
    private static final int SW_SHOWMINNOACTIVE = 7;
    private static final int SW_RESTORE = 9;
    private WindowsDisplayPeerInfo peer_info;
    private boolean close_requested;
    private boolean is_dirty;
    private ByteBuffer current_gamma;
    private ByteBuffer saved_gamma;
    private DisplayMode current_mode;
    private boolean mode_set;
    private boolean isFullscreen;
    private boolean isMinimized;
    private boolean isFocused;
    private boolean did_maximize;
    private boolean inAppActivate;

    public final void createWindow(DisplayMode displayMode, boolean bl2, int n2, int n3) throws LWJGLException {
        this.close_requested = false;
        this.is_dirty = false;
        this.isFullscreen = bl2;
        this.isMinimized = false;
        this.isFocused = false;
        this.did_maximize = false;
        this.nCreateWindow(displayMode, bl2, n2, n3);
        this.peer_info.e();
    }

    private native void nCreateWindow(DisplayMode var1, boolean var2, int var3, int var4) throws LWJGLException;

    public final void destroyWindow() {
        WindowsDisplay.nDestroyWindow();
        if (this.isFullscreen) {
            WindowsDisplay.resetCursorClipping();
        }
    }

    private static native void nDestroyWindow();

    private static native void resetCursorClipping();

    private static native void setupCursorClipping(long var0) throws LWJGLException;

    public final void switchDisplayMode(DisplayMode displayMode) throws LWJGLException {
        WindowsDisplay.nSwitchDisplayMode(displayMode);
        this.current_mode = displayMode;
        this.mode_set = true;
    }

    private static native void nSwitchDisplayMode(DisplayMode var0) throws LWJGLException;

    private void appActivate(boolean bl2) {
        if (this.inAppActivate) {
            return;
        }
        this.inAppActivate = true;
        this.isFocused = bl2;
        if (bl2) {
            if (this.isFullscreen) {
                this.restoreDisplayMode();
            }
            WindowsDisplay.showWindow(WindowsDisplay.getHwnd(), 9);
            WindowsDisplay.setForegroundWindow(WindowsDisplay.getHwnd());
            WindowsDisplay.setFocus(WindowsDisplay.getHwnd());
            this.did_maximize = true;
        } else if (this.isFullscreen) {
            WindowsDisplay.showWindow(WindowsDisplay.getHwnd(), 7);
            this.resetDisplayMode();
        }
        this.inAppActivate = false;
    }

    private static native void showWindow(long var0, int var2);

    private static native void setForegroundWindow(long var0);

    private static native void setFocus(long var0);

    private void restoreDisplayMode() {
        try {
            this.doSetGammaRamp(this.current_gamma);
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Failed to restore gamma: " + lWJGLException.getMessage());
        }
        if (!this.mode_set) {
            this.mode_set = true;
            try {
                WindowsDisplay.nSwitchDisplayMode(this.current_mode);
                return;
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Failed to restore display mode: " + lWJGLException.getMessage());
            }
        }
    }

    public final void resetDisplayMode() {
        try {
            this.doSetGammaRamp(this.saved_gamma);
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Failed to reset gamma ramp: " + lWJGLException.getMessage());
        }
        this.current_gamma = this.saved_gamma;
        if (this.mode_set) {
            this.mode_set = false;
            WindowsDisplay.nResetDisplayMode();
        }
        WindowsDisplay.resetCursorClipping();
    }

    private static native void nResetDisplayMode();

    public final int getGammaRampLength() {
        return 256;
    }

    public final void setGammaRamp(FloatBuffer floatBuffer) throws LWJGLException {
        this.doSetGammaRamp(WindowsDisplay.convertToNativeRamp(floatBuffer));
    }

    private static native ByteBuffer convertToNativeRamp(FloatBuffer var0) throws LWJGLException;

    private static native ByteBuffer getCurrentGammaRamp() throws LWJGLException;

    private void doSetGammaRamp(ByteBuffer byteBuffer) throws LWJGLException {
        WindowsDisplay.nSetGammaRamp(byteBuffer);
        this.current_gamma = byteBuffer;
    }

    private static native void nSetGammaRamp(ByteBuffer var0) throws LWJGLException;

    public final String getAdapter() {
        try {
            String string = WindowsRegistry.a(3, "HARDWARE\\DeviceMap\\Video", "\\Device\\Video0");
            String string2 = "\\registry\\machine\\";
            if (string.toLowerCase().startsWith(string2)) {
                String string3 = WindowsRegistry.a(3, string.substring(string2.length()), "InstalledDisplayDrivers");
                return string3;
            }
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Exception occurred while querying registry: " + lWJGLException);
        }
        return null;
    }

    public final String getVersion() {
        w w2;
        String string = this.getAdapter();
        if (string != null && (w2 = this.nGetVersion(string + ".dll")) != null) {
            return w2.toString();
        }
        return null;
    }

    private native w nGetVersion(String var1);

    public final DisplayMode init() throws LWJGLException {
        this.current_gamma = this.saved_gamma = WindowsDisplay.getCurrentGammaRamp();
        this.current_mode = WindowsDisplay.getCurrentDisplayMode();
        return this.current_mode;
    }

    private static native DisplayMode getCurrentDisplayMode() throws LWJGLException;

    public final native void setTitle(String var1);

    public final boolean isCloseRequested() {
        boolean bl2 = this.close_requested;
        this.close_requested = false;
        return bl2;
    }

    public final boolean isVisible() {
        return !this.isMinimized;
    }

    public final boolean isActive() {
        return this.isFocused;
    }

    public final boolean isDirty() {
        boolean bl2 = this.is_dirty;
        this.is_dirty = false;
        return bl2;
    }

    public final v createPeerInfo(PixelFormat pixelFormat) throws LWJGLException {
        this.peer_info = new WindowsDisplayPeerInfo(pixelFormat);
        return this.peer_info;
    }

    public final void update() {
        WindowsDisplay.nUpdate();
        if (this.did_maximize) {
            this.did_maximize = false;
            try {
                if (Display.getContext().a()) {
                    Display.getContext().e();
                }
                return;
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Exception occurred while trying to make context current: " + lWJGLException);
            }
        }
    }

    private static native void nUpdate();

    public final void reshape(int n2, int n3, int n4, int n5) {
        if (!this.isFullscreen) {
            WindowsDisplay.nReshape(WindowsDisplay.getHwnd(), n2, n3, n4, n5);
        }
    }

    private static native void nReshape(long var0, int var2, int var3, int var4, int var5);

    public final native DisplayMode[] getAvailableDisplayModes() throws LWJGLException;

    public final boolean hasWheel() {
        return true;
    }

    public final int getButtonCount() {
        return 2;
    }

    public final void createMouse() throws LWJGLException {
    }

    public final void destroyMouse() {
    }

    public final void pollMouse(IntBuffer intBuffer, ByteBuffer byteBuffer) {
    }

    public final void readMouse(ByteBuffer byteBuffer) {
    }

    public final void grabMouse(boolean bl2) {
    }

    public final int getNativeCursorCapabilities() {
        return 0;
    }

    public final void setCursorPosition(int n2, int n3) {
        WindowsDisplay.nSetCursorPosition(n2, n3, this.isFullscreen);
    }

    private static native void nSetCursorPosition(int var0, int var1, boolean var2);

    public final native void setNativeCursor(Object var1) throws LWJGLException;

    public final int getMinCursorSize() {
        return this.getSystemMetrics(13);
    }

    public final int getMaxCursorSize() {
        return this.getSystemMetrics(13);
    }

    public final native int getSystemMetrics(int var1);

    private static native long getHwnd();

    public final void createKeyboard() throws LWJGLException {
    }

    public final void destroyKeyboard() {
    }

    public final void pollKeyboard(ByteBuffer byteBuffer) {
    }

    public final void readKeyboard(ByteBuffer byteBuffer) {
    }

    public final native ByteBuffer nCreateCursor(int var1, int var2, int var3, int var4, int var5, IntBuffer var6, int var7, IntBuffer var8, int var9) throws LWJGLException;

    public final Object createCursor(int n2, int n3, int n4, int n5, int n6, IntBuffer intBuffer, IntBuffer intBuffer2) throws LWJGLException {
        return this.nCreateCursor(n2, n3, n4, n5, n6, intBuffer, intBuffer.position(), intBuffer2, intBuffer2 != null ? intBuffer2.position() : -1);
    }

    public final native void destroyCursor(Object var1);

    public final int getPbufferCapabilities() {
        try {
            return this.nGetPbufferCapabilities(new PixelFormat(0, 0, 0, 0, 0, 0, 0, 0, false));
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("Exception occurred while determining pbuffer capabilities: " + lWJGLException);
            return 0;
        }
    }

    private native int nGetPbufferCapabilities(PixelFormat var1) throws LWJGLException;

    public final boolean isBufferLost(v v2) {
        return ((WindowsPbufferPeerInfo)v2).a();
    }

    public final v createPbuffer(int n2, int n3, PixelFormat pixelFormat, IntBuffer intBuffer, IntBuffer intBuffer2) throws LWJGLException {
        return new WindowsPbufferPeerInfo(n2, n3, pixelFormat, intBuffer, intBuffer2);
    }

    public final void setPbufferAttrib(v v2, int n2, int n3) {
        ((WindowsPbufferPeerInfo)v2).a(n2, n3);
    }

    public final void bindTexImageToPbuffer(v v2, int n2) {
        ((WindowsPbufferPeerInfo)v2).a(n2);
    }

    public final void releaseTexImageFromPbuffer(v v2, int n2) {
        ((WindowsPbufferPeerInfo)v2).b(n2);
    }

    public final int setIcon(ByteBuffer[] byteBufferArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        for (int i2 = 0; i2 < byteBufferArray.length; ++i2) {
            int n3 = byteBufferArray[i2].limit() / 4;
            if ((int)Math.sqrt(n3) == 16 && !bl2) {
                WindowsDisplay.nSetWindowIcon16(byteBufferArray[i2].asIntBuffer());
                ++n2;
                bl2 = true;
            }
            if ((int)Math.sqrt(n3) != 32 || bl3) continue;
            WindowsDisplay.nSetWindowIcon32(byteBufferArray[i2].asIntBuffer());
            ++n2;
            bl3 = true;
        }
        return n2;
    }

    private static native int nSetWindowIcon16(IntBuffer var0);

    private static native int nSetWindowIcon32(IntBuffer var0);

    private void handleMouseButton(int n2, int n3, long l2) {
    }

    private void handleMouseMoved(int n2, int n3, long l2) {
    }

    private void handleMouseScrolled(int n2, long l2) {
    }

    private static native int transformY(long var0, int var2);

    /*
     * Unable to fully structure code
     */
    final boolean doHandleMessage(long var1_2, int var3_3, long var4_4, long var6_5, long var8_1) {
        if (this.isFullscreen && !this.isMinimized && this.isFocused) {
            try {
                WindowsDisplay.setupCursorClipping(WindowsDisplay.getHwnd());
            }
            catch (LWJGLException var10_6) {
                LWJGLUtil.log("setupCursorClipping failed: " + var10_6.getMessage());
            }
        }
        switch (var3_3) {
            case 6: {
                switch ((int)var4_4) {
                    case 1: 
                    case 2: {
                        v0 = this;
                        v1 = true;
                        ** GOTO lbl17
                    }
                    case 0: {
                        v0 = this;
                        v1 = false;
lbl17:
                        // 2 sources

                        v0.appActivate(v1);
                    }
                }
                return true;
            }
            case 5: {
                switch ((int)var4_4) {
                    case 0: 
                    case 2: {
                        v2 = this;
                        v3 = false;
                        ** GOTO lbl28
                    }
                    case 1: {
                        v2 = this;
                        v3 = true;
lbl28:
                        // 2 sources

                        v2.isMinimized = v3;
                    }
                }
                return false;
            }
            case 512: {
                var10_7 = (short)(var6_5 & 65535L);
                var11_8 = WindowsDisplay.transformY(WindowsDisplay.getHwnd(), (short)(var6_5 >> 16 & 65535L));
                this.handleMouseMoved(var10_7, var11_8, var8_1);
                return true;
            }
            case 522: {
                var12_9 = (short)(var4_4 >> 16 & 65535L);
                this.handleMouseScrolled(var12_9, var8_1);
                return true;
            }
            case 513: {
                this.handleMouseButton(0, 1, var8_1);
                return true;
            }
            case 514: {
                this.handleMouseButton(0, 0, var8_1);
                return true;
            }
            case 516: {
                this.handleMouseButton(1, 1, var8_1);
                return true;
            }
            case 517: {
                this.handleMouseButton(1, 0, var8_1);
                return true;
            }
            case 519: {
                this.handleMouseButton(2, 1, var8_1);
                return true;
            }
            case 520: {
                this.handleMouseButton(2, 0, var8_1);
                return true;
            }
            case 18: {
                this.close_requested = true;
                return true;
            }
            case 274: {
                switch ((int)var4_4) {
                    case 61584: 
                    case 61696: 
                    case 61760: 
                    case 61808: {
                        return true;
                    }
                    case 61536: {
                        this.close_requested = true;
                        return true;
                    }
                }
                return false;
            }
            case 15: {
                this.is_dirty = true;
                return false;
            }
        }
        return false;
    }

    public final int getWidth() {
        return Display.getDisplayMode().getWidth();
    }

    public final int getHeight() {
        return Display.getDisplayMode().getHeight();
    }
}

