/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.util.HashMap;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.util.AbstractVisitor;
import org.objectweb.asm.util.TraceAbstractVisitor;
import org.objectweb.asm.util.TraceAnnotationVisitor;
import org.objectweb.asm.util.TraceSignatureVisitor;
import org.objectweb.asm.util.Traceable;

public class TraceMethodVisitor
extends TraceAbstractVisitor
implements MethodVisitor {
    protected MethodVisitor mv;
    protected String tab2 = "    ";
    protected String tab3 = "      ";
    protected String ltab = "   ";
    protected final HashMap labelNames = new HashMap();

    public TraceMethodVisitor() {
        this(null);
    }

    public TraceMethodVisitor(MethodVisitor methodVisitor) {
        this.mv = methodVisitor;
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl2) {
        AnnotationVisitor annotationVisitor = super.visitAnnotation(string, bl2);
        if (this.mv != null) {
            ((TraceAnnotationVisitor)annotationVisitor).av = this.mv.visitAnnotation(string, bl2);
        }
        return annotationVisitor;
    }

    public void visitAttribute(Attribute attribute) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append("ATTRIBUTE ");
        this.appendDescriptor(-1, attribute.type);
        if (attribute instanceof Traceable) {
            ((Traceable)((Object)attribute)).trace(this.buf, this.labelNames);
        } else {
            this.buf.append(" : unknown\n");
        }
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitAttribute(attribute);
        }
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.text.add(this.tab2 + "default=");
        TraceAnnotationVisitor traceAnnotationVisitor = this.createTraceAnnotationVisitor();
        this.text.add(traceAnnotationVisitor.getText());
        this.text.add("\n");
        if (this.mv != null) {
            traceAnnotationVisitor.av = this.mv.visitAnnotationDefault();
        }
        return traceAnnotationVisitor;
    }

    public AnnotationVisitor visitParameterAnnotation(int n2, String string, boolean bl2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append('@');
        this.appendDescriptor(1, string);
        this.buf.append('(');
        this.text.add(this.buf.toString());
        TraceAnnotationVisitor traceAnnotationVisitor = this.createTraceAnnotationVisitor();
        this.text.add(traceAnnotationVisitor.getText());
        this.text.add(bl2 ? ") // parameter " : ") // invisible, parameter ");
        this.text.add(new Integer(n2));
        this.text.add("\n");
        if (this.mv != null) {
            traceAnnotationVisitor.av = this.mv.visitParameterAnnotation(n2, string, bl2);
        }
        return traceAnnotationVisitor;
    }

    public void visitCode() {
        if (this.mv != null) {
            this.mv.visitCode();
        }
    }

    public void visitFrame(int n2, int n3, Object[] objectArray, int n4, Object[] objectArray2) {
        this.buf.setLength(0);
        this.buf.append(this.ltab);
        this.buf.append("FRAME ");
        switch (n2) {
            case -1: 
            case 0: {
                this.buf.append("FULL [");
                this.appendFrameTypes(n3, objectArray);
                this.buf.append("] [");
                this.appendFrameTypes(n4, objectArray2);
                this.buf.append("]");
                break;
            }
            case 1: {
                this.buf.append("APPEND [");
                this.appendFrameTypes(n3, objectArray);
                this.buf.append("]");
                break;
            }
            case 2: {
                this.buf.append("CHOP ").append(n3);
                break;
            }
            case 3: {
                this.buf.append("SAME");
                break;
            }
            case 4: {
                this.buf.append("SAME1 ");
                this.appendFrameTypes(1, objectArray2);
            }
        }
        this.buf.append("\n");
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitFrame(n2, n3, objectArray, n4, objectArray2);
        }
    }

    public void visitInsn(int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[n2]).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitInsn(n2);
        }
    }

    public void visitIntInsn(int n2, int n3) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[n2]).append(' ').append(n2 == 188 ? AbstractVisitor.TYPES[n3] : Integer.toString(n3)).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitIntInsn(n2, n3);
        }
    }

    public void visitVarInsn(int n2, int n3) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[n2]).append(' ').append(n3).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitVarInsn(n2, n3);
        }
    }

    public void visitTypeInsn(int n2, String string) {
        int n3;
        TraceMethodVisitor traceMethodVisitor;
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[n2]).append(' ');
        if (string.startsWith("[")) {
            traceMethodVisitor = this;
            n3 = 1;
        } else {
            traceMethodVisitor = this;
            n3 = 0;
        }
        traceMethodVisitor.appendDescriptor(n3, string);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitTypeInsn(n2, string);
        }
    }

    public void visitFieldInsn(int n2, String string, String string2, String string3) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[n2]).append(' ');
        this.appendDescriptor(0, string);
        this.buf.append('.').append(string2).append(" : ");
        this.appendDescriptor(1, string3);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitFieldInsn(n2, string, string2, string3);
        }
    }

    public void visitMethodInsn(int n2, String string, String string2, String string3) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[n2]).append(' ');
        this.appendDescriptor(0, string);
        this.buf.append('.').append(string2).append(' ');
        this.appendDescriptor(3, string3);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitMethodInsn(n2, string, string2, string3);
        }
    }

    public void visitJumpInsn(int n2, Label label) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(AbstractVisitor.OPCODES[n2]).append(' ');
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitJumpInsn(n2, label);
        }
    }

    public void visitLabel(Label label) {
        this.buf.setLength(0);
        this.buf.append(this.ltab);
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLabel(label);
        }
    }

    public void visitLdcInsn(Object object) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LDC ");
        if (object instanceof String) {
            AbstractVisitor.appendString(this.buf, (String)object);
        } else if (object instanceof Type) {
            this.buf.append(((Type)object).getDescriptor() + ".class");
        } else {
            this.buf.append(object);
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLdcInsn(object);
        }
    }

    public void visitIincInsn(int n2, int n3) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("IINC ").append(n2).append(' ').append(n3).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitIincInsn(n2, n3);
        }
    }

    public void visitTableSwitchInsn(int n2, int n3, Label label, Label[] labelArray) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("TABLESWITCH\n");
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            this.buf.append(this.tab3).append(n2 + i2).append(": ");
            this.appendLabel(labelArray[i2]);
            this.buf.append('\n');
        }
        this.buf.append(this.tab3).append("default: ");
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitTableSwitchInsn(n2, n3, label, labelArray);
        }
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LOOKUPSWITCH\n");
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            this.buf.append(this.tab3).append(nArray[i2]).append(": ");
            this.appendLabel(labelArray[i2]);
            this.buf.append('\n');
        }
        this.buf.append(this.tab3).append("default: ");
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLookupSwitchInsn(label, nArray, labelArray);
        }
    }

    public void visitMultiANewArrayInsn(String string, int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MULTIANEWARRAY ");
        this.appendDescriptor(1, string);
        this.buf.append(' ').append(n2).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitMultiANewArrayInsn(string, n2);
        }
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("TRYCATCHBLOCK ");
        this.appendLabel(label);
        this.buf.append(' ');
        this.appendLabel(label2);
        this.buf.append(' ');
        this.appendLabel(label3);
        this.buf.append(' ');
        this.appendDescriptor(0, string);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitTryCatchBlock(label, label2, label3, string);
        }
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LOCALVARIABLE ").append(string).append(' ');
        this.appendDescriptor(1, string2);
        this.buf.append(' ');
        this.appendLabel(label);
        this.buf.append(' ');
        this.appendLabel(label2);
        this.buf.append(' ').append(n2).append('\n');
        if (string3 != null) {
            this.buf.append(this.tab2);
            this.appendDescriptor(2, string3);
            TraceSignatureVisitor traceSignatureVisitor = new TraceSignatureVisitor(0);
            SignatureReader signatureReader = new SignatureReader(string3);
            signatureReader.acceptType(traceSignatureVisitor);
            this.buf.append(this.tab2).append("// declaration: ").append(traceSignatureVisitor.getDeclaration()).append('\n');
        }
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLocalVariable(string, string2, string3, label, label2, n2);
        }
    }

    public void visitLineNumber(int n2, Label label) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LINENUMBER ").append(n2).append(' ');
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLineNumber(n2, label);
        }
    }

    public void visitMaxs(int n2, int n3) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MAXSTACK = ").append(n2).append('\n');
        this.text.add(this.buf.toString());
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MAXLOCALS = ").append(n3).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitMaxs(n2, n3);
        }
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.mv != null) {
            this.mv.visitEnd();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void appendFrameTypes(int var1_1, Object[] var2_2) {
        for (var3_3 = 0; var3_3 < var1_1; ++var3_3) {
            block14: {
                if (var3_3 > 0) {
                    this.buf.append(' ');
                }
                if (var2_2[var3_3] instanceof String) {
                    var4_4 = (String)var2_2[var3_3];
                    if (var4_4.startsWith("[")) {
                        v0 = this;
                        v1 = 1;
                    } else {
                        v0 = this;
                        v1 = 0;
                    }
                    v0.appendDescriptor(v1, var4_4);
                    continue;
                }
                if (!(var2_2[var3_3] instanceof Integer)) break block14;
                switch ((Integer)var2_2[var3_3]) {
                    case 0: {
                        v2 = this;
                        v3 = 1;
                        v4 = "T";
                        ** GOTO lbl51
                    }
                    case 1: {
                        v2 = this;
                        v3 = 1;
                        v4 = "I";
                        ** GOTO lbl51
                    }
                    case 2: {
                        v2 = this;
                        v3 = 1;
                        v4 = "F";
                        ** GOTO lbl51
                    }
                    case 3: {
                        v2 = this;
                        v3 = 1;
                        v4 = "D";
                        ** GOTO lbl51
                    }
                    case 4: {
                        v2 = this;
                        v3 = 1;
                        v4 = "J";
                        ** GOTO lbl51
                    }
                    case 5: {
                        v2 = this;
                        v3 = 1;
                        v4 = "N";
                        ** GOTO lbl51
                    }
                    case 6: {
                        v2 = this;
                        v3 = 1;
                        v4 = "U";
lbl51:
                        // 7 sources

                        v2.appendDescriptor(v3, v4);
                    }
                }
                continue;
            }
            this.appendLabel((Label)var2_2[var3_3]);
        }
    }

    protected void appendLabel(Label label) {
        String string = (String)this.labelNames.get(label);
        if (string == null) {
            string = "L" + this.labelNames.size();
            this.labelNames.put(label, string);
        }
        this.buf.append(string);
    }
}

