/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.Hashtable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.GCP_RESULTS;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;

public class BidiUtil {
    public static final int KEYBOARD_NON_BIDI = 0;
    public static final int KEYBOARD_BIDI = 1;
    static int isBidiPlatform = -1;
    public static final int CLASSIN = 1;
    public static final int LINKBEFORE = 2;
    public static final int LINKAFTER = 4;
    static Hashtable languageMap = new Hashtable();
    static Hashtable keyMap = new Hashtable();
    static Hashtable oldProcMap = new Hashtable();
    static final String CLASS_NAME = "org.eclipse.swt.internal.BidiUtil";
    static Callback callback;
    static final int GCP_REORDER = 2;
    static final int GCP_GLYPHSHAPE = 16;
    static final int GCP_LIGATE = 32;
    static final int GCP_CLASSIN = 524288;
    static final byte GCPCLASS_ARABIC = 2;
    static final byte GCPCLASS_HEBREW = 2;
    static final byte GCPCLASS_LOCALNUMBER = 4;
    static final byte GCPCLASS_LATINNUMBER = 5;
    static final int GCPGLYPH_LINKBEFORE = 32768;
    static final int GCPGLYPH_LINKAFTER = 16384;
    static final int ETO_CLIPPED = 4;
    static final int ETO_GLYPH_INDEX = 16;
    static final int LANG_ARABIC = 1;
    static final int LANG_HEBREW = 13;
    static final String CD_PG_HEBREW = "1255";
    static final String CD_PG_ARABIC = "1256";
    static final int HKL_NEXT = 1;
    static final int HKL_PREV = 0;
    public static final int CLASS_HEBREW = 2;
    public static final int CLASS_ARABIC = 2;
    public static final int CLASS_LOCALNUMBER = 4;
    public static final int CLASS_LATINNUMBER = 5;
    public static final int REORDER = 2;
    public static final int LIGATE = 32;
    public static final int GLYPHSHAPE = 16;

    static {
        try {
            callback = new Callback(Class.forName(CLASS_NAME), "windowProc", 4);
            if (callback.getAddress() == 0) {
                SWT.error(3);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public static void addLanguageListener(int n2, Runnable runnable) {
        languageMap.put(new Integer(n2), runnable);
        BidiUtil.subclass(n2);
    }

    static int EnumSystemLanguageGroupsProc(int n2, int n3, int n4, int n5, int n6) {
        if (n2 == 12) {
            isBidiPlatform = 1;
            return 0;
        }
        if (n2 == 13) {
            isBidiPlatform = 1;
            return 0;
        }
        return 1;
    }

    public static void drawGlyphs(GC gC, char[] cArray, int[] nArray, int n2, int n3) {
        int n4 = nArray.length;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && OS.GetLayout(gC.handle) != 0) {
            BidiUtil.reverse(nArray);
            int n5 = n4 - 1;
            nArray[n5] = nArray[n5] - 1;
            BidiUtil.reverse(cArray);
        }
        int n6 = OS.SetBkMode(gC.handle, 1);
        OS.ExtTextOutW(gC.handle, n2, n3, 16, null, cArray, cArray.length, nArray);
        OS.SetBkMode(gC.handle, n6);
    }

    public static char[] getRenderInfo(GC gC, String string, int[] nArray, byte[] byArray, int[] nArray2, int n2, int[] nArray3) {
        int n3 = OS.GetFontLanguageInfo(gC.handle);
        int n4 = OS.GetProcessHeap();
        int[] nArray4 = new int[8];
        int n5 = OS.GetTextCharset(gC.handle);
        boolean bl2 = false;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            bl2 = OS.GetLayout(gC.handle) != 0;
        }
        OS.TranslateCharsetInfo(n5, nArray4, 1);
        TCHAR tCHAR = new TCHAR(nArray4[1], string, false);
        int n6 = tCHAR.length();
        boolean bl3 = (n2 & 2) == 2;
        boolean bl4 = (n2 & 4) == 4;
        GCP_RESULTS gCP_RESULTS = new GCP_RESULTS();
        gCP_RESULTS.lStructSize = GCP_RESULTS.sizeof;
        gCP_RESULTS.nGlyphs = n6;
        int n7 = gCP_RESULTS.lpOrder = OS.HeapAlloc(n4, 8, n6 * 4);
        int n8 = gCP_RESULTS.lpDx = OS.HeapAlloc(n4, 8, n6 * 4);
        int n9 = gCP_RESULTS.lpClass = OS.HeapAlloc(n4, 8, n6);
        int n10 = gCP_RESULTS.lpGlyphs = OS.HeapAlloc(n4, 8, n6 * 2);
        int n11 = 0;
        int n12 = 0;
        n11 |= 2;
        if ((n3 & 0x20) == 32) {
            n11 |= 0x20;
            n12 |= 0;
        }
        if ((n3 & 0x10) == 16) {
            n11 |= 0x10;
            if (bl3) {
                n12 |= 0x8000;
            }
            if (bl4) {
                n12 |= 0x4000;
            }
        }
        byte[] byArray2 = bl3 || bl4 ? new byte[]{(byte)n12, (byte)(n12 >> 8)} : new byte[]{(byte)n12};
        OS.MoveMemory(gCP_RESULTS.lpGlyphs, byArray2, byArray2.length);
        if ((n2 & 1) == 1) {
            n11 |= 0x80000;
            OS.MoveMemory(gCP_RESULTS.lpClass, byArray, byArray.length);
        }
        char[] cArray = new char[gCP_RESULTS.nGlyphs];
        int n13 = 0;
        int n14 = 0;
        while (n14 < nArray3.length - 1) {
            Object[] objectArray;
            int n15;
            int n16 = nArray3[n14];
            gCP_RESULTS.nGlyphs = n15 = nArray3[n14 + 1] - nArray3[n14];
            TCHAR tCHAR2 = new TCHAR(nArray4[1], string.substring(n16, n16 + n15), false);
            OS.GetCharacterPlacement(gC.handle, tCHAR2, tCHAR2.length(), 0, gCP_RESULTS, n11);
            if (nArray2 != null) {
                objectArray = new int[gCP_RESULTS.nGlyphs];
                OS.MoveMemory(objectArray, gCP_RESULTS.lpDx, objectArray.length * 4);
                if (bl2) {
                    BidiUtil.reverse(objectArray);
                }
                System.arraycopy(objectArray, 0, nArray2, n13, objectArray.length);
            }
            if (nArray != null) {
                objectArray = new int[n15];
                OS.MoveMemory(objectArray, gCP_RESULTS.lpOrder, objectArray.length * 4);
                BidiUtil.translateOrder(objectArray, n13, bl2);
                System.arraycopy(objectArray, 0, nArray, n16, n15);
            }
            if (byArray != null) {
                objectArray = new byte[n15];
                OS.MoveMemory((byte[])objectArray, gCP_RESULTS.lpClass, objectArray.length);
                System.arraycopy(objectArray, 0, byArray, n16, n15);
            }
            objectArray = new char[gCP_RESULTS.nGlyphs];
            OS.MoveMemory((char[])objectArray, gCP_RESULTS.lpGlyphs, objectArray.length * 2);
            if (bl2) {
                BidiUtil.reverse((char[])objectArray);
            }
            System.arraycopy(objectArray, 0, cArray, n13, objectArray.length);
            n13 += objectArray.length;
            gCP_RESULTS.lpOrder += n15 * 4;
            gCP_RESULTS.lpDx += n15 * 4;
            gCP_RESULTS.lpClass += n15;
            gCP_RESULTS.lpGlyphs += objectArray.length * 2;
            ++n14;
        }
        OS.HeapFree(n4, 0, n10);
        OS.HeapFree(n4, 0, n9);
        OS.HeapFree(n4, 0, n8);
        OS.HeapFree(n4, 0, n7);
        return cArray;
    }

    public static void getOrderInfo(GC gC, String string, int[] nArray, byte[] byArray, int n2, int[] nArray2) {
        int n3 = OS.GetFontLanguageInfo(gC.handle);
        int n4 = OS.GetProcessHeap();
        int[] nArray3 = new int[8];
        int n5 = OS.GetTextCharset(gC.handle);
        OS.TranslateCharsetInfo(n5, nArray3, 1);
        TCHAR tCHAR = new TCHAR(nArray3[1], string, false);
        int n6 = tCHAR.length();
        boolean bl2 = false;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            bl2 = OS.GetLayout(gC.handle) != 0;
        }
        GCP_RESULTS gCP_RESULTS = new GCP_RESULTS();
        gCP_RESULTS.lStructSize = GCP_RESULTS.sizeof;
        gCP_RESULTS.nGlyphs = n6;
        int n7 = gCP_RESULTS.lpOrder = OS.HeapAlloc(n4, 8, n6 * 4);
        int n8 = gCP_RESULTS.lpClass = OS.HeapAlloc(n4, 8, n6);
        int n9 = 0;
        n9 |= 2;
        if ((n3 & 0x20) == 32) {
            n9 |= 0x20;
        }
        if ((n3 & 0x10) == 16) {
            n9 |= 0x10;
        }
        if ((n2 & 1) == 1) {
            n9 |= 0x80000;
            OS.MoveMemory(gCP_RESULTS.lpClass, byArray, byArray.length);
        }
        int n10 = 0;
        int n11 = 0;
        while (n11 < nArray2.length - 1) {
            Object[] objectArray;
            int n12;
            int n13 = nArray2[n11];
            gCP_RESULTS.nGlyphs = n12 = nArray2[n11 + 1] - nArray2[n11];
            TCHAR tCHAR2 = new TCHAR(nArray3[1], string.substring(n13, n13 + n12), false);
            OS.GetCharacterPlacement(gC.handle, tCHAR2, tCHAR2.length(), 0, gCP_RESULTS, n9);
            if (nArray != null) {
                objectArray = new int[n12];
                OS.MoveMemory(objectArray, gCP_RESULTS.lpOrder, objectArray.length * 4);
                BidiUtil.translateOrder(objectArray, n10, bl2);
                System.arraycopy(objectArray, 0, nArray, n13, n12);
            }
            if (byArray != null) {
                objectArray = new byte[n12];
                OS.MoveMemory((byte[])objectArray, gCP_RESULTS.lpClass, objectArray.length);
                System.arraycopy(objectArray, 0, byArray, n13, n12);
            }
            n10 += gCP_RESULTS.nGlyphs;
            gCP_RESULTS.lpOrder += n12 * 4;
            gCP_RESULTS.lpClass += n12;
            ++n11;
        }
        OS.HeapFree(n4, 0, n8);
        OS.HeapFree(n4, 0, n7);
    }

    public static int getFontBidiAttributes(GC gC) {
        int n2 = 0;
        int n3 = OS.GetFontLanguageInfo(gC.handle);
        if ((n3 & 2) != 0) {
            n2 |= 2;
        }
        if ((n3 & 0x20) != 0) {
            n2 |= 0x20;
        }
        if ((n3 & 0x10) != 0) {
            n2 |= 0x10;
        }
        return n2;
    }

    public static int getKeyboardLanguage() {
        int n2 = OS.GetKeyboardLayout(0);
        if ((n2 &= 0xFF) == 13) {
            return 1;
        }
        if (n2 == 1) {
            return 1;
        }
        return 0;
    }

    static int[] getKeyboardLanguageList() {
        int n2 = 10;
        int[] nArray = new int[n2];
        int n3 = OS.GetKeyboardLayoutList(n2, nArray);
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    public static boolean isBidiPlatform() {
        block8: {
            if (OS.IsWinCE) {
                return false;
            }
            if (isBidiPlatform != -1) {
                return isBidiPlatform == 1;
            }
            isBidiPlatform = 0;
            if (!BidiUtil.isKeyboardBidi()) {
                return false;
            }
            Callback callback = null;
            try {
                callback = new Callback(Class.forName(CLASS_NAME), "EnumSystemLanguageGroupsProc", 5);
                int n2 = callback.getAddress();
                if (n2 == 0) {
                    SWT.error(3);
                }
                OS.EnumSystemLanguageGroups(n2, 1, 0);
                callback.dispose();
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (callback == null) break block8;
                callback.dispose();
            }
        }
        if (isBidiPlatform == 1) {
            return true;
        }
        String string = String.valueOf(OS.GetACP());
        if (CD_PG_ARABIC.equals(string) || CD_PG_HEBREW.equals(string)) {
            isBidiPlatform = 1;
        }
        return isBidiPlatform == 1;
    }

    public static boolean isKeyboardBidi() {
        int[] nArray = BidiUtil.getKeyboardLanguageList();
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2] & 0xFF;
            if (n3 == 1 || n3 == 13) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void removeLanguageListener(int n2) {
        languageMap.remove(new Integer(n2));
        BidiUtil.unsubclass(n2);
    }

    public static void setKeyboardLanguage(int n2) {
        if (n2 == BidiUtil.getKeyboardLanguage()) {
            return;
        }
        if (n2 == 1) {
            int[] nArray = BidiUtil.getKeyboardLanguageList();
            int n3 = 0;
            while (n3 < nArray.length) {
                int n4 = nArray[n3] & 0xFF;
                if (n4 == 1 || n4 == 13) {
                    OS.ActivateKeyboardLayout(nArray[n3], 0);
                    return;
                }
                ++n3;
            }
        } else {
            int[] nArray = BidiUtil.getKeyboardLanguageList();
            int n5 = 0;
            while (n5 < nArray.length) {
                int n6 = nArray[n5] & 0xFF;
                if (n6 != 13 && n6 != 1) {
                    OS.ActivateKeyboardLayout(nArray[n5], 0);
                    return;
                }
                ++n5;
            }
        }
    }

    public static boolean setOrientation(int n2, int n3) {
        if (OS.IsWinCE) {
            return false;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return false;
        }
        int n4 = OS.GetWindowLong(n2, -20);
        n4 = (n3 & 0x4000000) != 0 ? (n4 |= 0x400000) : (n4 &= 0xFFBFFFFF);
        OS.SetWindowLong(n2, -20, n4);
        return true;
    }

    static void subclass(int n2) {
        Integer n3 = new Integer(n2);
        if (oldProcMap.get(n3) == null) {
            int n4 = OS.GetWindowLong(n2, -4);
            oldProcMap.put(n3, new Integer(n4));
            OS.SetWindowLong(n2, -4, callback.getAddress());
        }
    }

    static void reverse(char[] cArray) {
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 <= (n2 - 1) / 2) {
            char c2 = cArray[n3];
            cArray[n3] = cArray[n2 - 1 - n3];
            cArray[n2 - 1 - n3] = c2;
            ++n3;
        }
    }

    static void reverse(int[] nArray) {
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 <= (n2 - 1) / 2) {
            int n4 = nArray[n3];
            nArray[n3] = nArray[n2 - 1 - n3];
            nArray[n2 - 1 - n3] = n4;
            ++n3;
        }
    }

    static void translateOrder(int[] nArray, int n2, boolean bl2) {
        int n3;
        int n4 = 0;
        int n5 = nArray.length;
        if (bl2) {
            n3 = 0;
            while (n3 < n5) {
                n4 = Math.max(n4, nArray[n3]);
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < n5) {
            if (bl2) {
                nArray[n3] = n4 - nArray[n3];
            }
            int n6 = n3++;
            nArray[n6] = nArray[n6] + n2;
        }
    }

    static void unsubclass(int n2) {
        Integer n3 = new Integer(n2);
        if (languageMap.get(n3) == null && keyMap.get(n3) == null) {
            Integer n4 = (Integer)oldProcMap.remove(n3);
            if (n4 == null) {
                return;
            }
            OS.SetWindowLong(n2, -4, n4);
        }
    }

    static int windowProc(int n2, int n3, int n4, int n5) {
        Object object;
        Integer n6 = new Integer(n2);
        switch (n3) {
            case 81: {
                object = (Runnable)languageMap.get(n6);
                if (object == null) break;
                object.run();
            }
        }
        object = (Integer)oldProcMap.get(n6);
        return OS.CallWindowProc((Integer)object, n2, n3, n4, n5);
    }
}

