/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.internal.image.PngDecodingDataStream;

public class PngHuffmanTable {
    CodeLengthInfo[] codeLengthInfo;
    int[] codeValues;
    static final int MAX_CODE_LENGTH = 15;
    static final int BAD_CODE = 0xFFFFFFF;
    static final int[] incs = new int[]{1391376, 463792, 198768, 86961, 33936, 13776, 4592, 1968, 861, 336, 112, 48, 21, 7, 3, 1};

    PngHuffmanTable(int[] nArray) {
        this.initialize(nArray);
        this.generateTable(nArray);
    }

    private void initialize(int[] nArray) {
        this.codeValues = new int[nArray.length];
        int n2 = 0;
        while (n2 < this.codeValues.length) {
            this.codeValues[n2] = n2;
            ++n2;
        }
        this.codeLengthInfo = new CodeLengthInfo[15];
        n2 = 0;
        while (n2 < 15) {
            this.codeLengthInfo[n2] = new CodeLengthInfo();
            this.codeLengthInfo[n2].length = n2;
            this.codeLengthInfo[n2].baseIndex = 0;
            this.codeLengthInfo[n2].min = 0xFFFFFFF;
            this.codeLengthInfo[n2].max = -1;
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void generateTable(int[] var1_1) {
        var3_2 = 0;
        while (var3_2 < 16) {
            var5_6 = var4_5 = PngHuffmanTable.incs[var3_2];
            while (var5_6 < var1_1.length) {
                var6_7 = var1_1[var5_6];
                var2_4 = this.codeValues[var5_6];
                var7_8 = var5_6;
                while (var7_8 >= var4_5 && (var1_1[var7_8 - var4_5] > var6_7 || var1_1[var7_8 - var4_5] == var6_7 && this.codeValues[var7_8 - var4_5] > var2_4)) {
                    var1_1[var7_8] = var1_1[var7_8 - var4_5];
                    this.codeValues[var7_8] = this.codeValues[var7_8 - var4_5];
                    var7_8 -= var4_5;
                }
                var1_1[var7_8] = var6_7;
                this.codeValues[var7_8] = var2_4;
                ++var5_6;
            }
            ++var3_2;
        }
        var3_3 = new int[var1_1.length];
        var4_5 = 0;
        var5_6 = 0;
        var6_7 = 0;
        ** GOTO lbl31
        {
            ++var4_5;
            var5_6 <<= 1;
            do {
                if (var4_5 != var1_1[var6_7]) continue block3;
                if (var4_5 != 0) {
                    var3_3[var6_7] = var5_6++;
                }
                ++var6_7;
lbl31:
                // 2 sources

            } while (var6_7 < var1_1.length);
        }
        var6_7 = 0;
        var7_8 = 0;
        while (var7_8 < var1_1.length) {
            if (var6_7 != var1_1[var7_8]) {
                var6_7 = var1_1[var7_8];
                this.codeLengthInfo[var6_7 - 1].baseIndex = var7_8;
                this.codeLengthInfo[var6_7 - 1].min = var3_3[var7_8];
            }
            if (var6_7 != 0) {
                this.codeLengthInfo[var6_7 - 1].max = var3_3[var7_8];
            }
            ++var7_8;
        }
    }

    int getNextValue(PngDecodingDataStream pngDecodingDataStream) throws IOException {
        int n2 = pngDecodingDataStream.getNextIdatBit();
        int n3 = 0;
        while (n3 < 15 && n2 > this.codeLengthInfo[n3].max) {
            n2 = n2 << 1 | pngDecodingDataStream.getNextIdatBit();
            ++n3;
        }
        if (n3 >= 15) {
            pngDecodingDataStream.error();
        }
        int n4 = n2 - this.codeLengthInfo[n3].min;
        int n5 = this.codeLengthInfo[n3].baseIndex + n4;
        return this.codeValues[n5];
    }

    class CodeLengthInfo {
        int length;
        int max;
        int min;
        int baseIndex;

        CodeLengthInfo() {
        }
    }
}

