/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.internal.image.PngDecodingDataStream;
import org.eclipse.swt.internal.image.PngHuffmanTable;

public class PngHuffmanTables {
    PngHuffmanTable literalTable;
    PngHuffmanTable distanceTable;
    static PngHuffmanTable FixedLiteralTable;
    static PngHuffmanTable FixedDistanceTable;
    static final int LiteralTableSize = 288;
    static final int[] FixedLiteralLengths;
    static final int DistanceTableSize = 32;
    static final int[] FixedDistanceLengths;
    static final int LengthCodeTableSize = 19;
    static final int[] LengthCodeOrder;

    static {
        FixedLiteralLengths = new int[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8};
        FixedDistanceLengths = new int[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5};
        int[] nArray = new int[19];
        nArray[0] = 16;
        nArray[1] = 17;
        nArray[2] = 18;
        nArray[4] = 8;
        nArray[5] = 7;
        nArray[6] = 9;
        nArray[7] = 6;
        nArray[8] = 10;
        nArray[9] = 5;
        nArray[10] = 11;
        nArray[11] = 4;
        nArray[12] = 12;
        nArray[13] = 3;
        nArray[14] = 13;
        nArray[15] = 2;
        nArray[16] = 14;
        nArray[17] = 1;
        nArray[18] = 15;
        LengthCodeOrder = nArray;
    }

    static PngHuffmanTables getDynamicTables(PngDecodingDataStream pngDecodingDataStream) throws IOException {
        return new PngHuffmanTables(pngDecodingDataStream);
    }

    static PngHuffmanTables getFixedTables() {
        return new PngHuffmanTables();
    }

    private PngHuffmanTable getFixedLiteralTable() {
        if (FixedLiteralTable == null) {
            FixedLiteralTable = new PngHuffmanTable(FixedLiteralLengths);
        }
        return FixedLiteralTable;
    }

    private PngHuffmanTable getFixedDistanceTable() {
        if (FixedDistanceTable == null) {
            FixedDistanceTable = new PngHuffmanTable(FixedDistanceLengths);
        }
        return FixedDistanceTable;
    }

    private PngHuffmanTables() {
        this.literalTable = this.getFixedLiteralTable();
        this.distanceTable = this.getFixedDistanceTable();
    }

    private PngHuffmanTables(PngDecodingDataStream pngDecodingDataStream) throws IOException {
        int n2 = 257 + pngDecodingDataStream.getNextIdatBits(5);
        int n3 = 1 + pngDecodingDataStream.getNextIdatBits(5);
        int n4 = 4 + pngDecodingDataStream.getNextIdatBits(4);
        if (n4 > 19) {
            pngDecodingDataStream.error();
        }
        int[] nArray = new int[19];
        int n5 = 0;
        while (n5 < n4) {
            nArray[PngHuffmanTables.LengthCodeOrder[n5]] = pngDecodingDataStream.getNextIdatBits(3);
            ++n5;
        }
        PngHuffmanTable pngHuffmanTable = new PngHuffmanTable(nArray);
        int[] nArray2 = this.readLengths(pngDecodingDataStream, n2, pngHuffmanTable, 288);
        int[] nArray3 = this.readLengths(pngDecodingDataStream, n3, pngHuffmanTable, 32);
        this.literalTable = new PngHuffmanTable(nArray2);
        this.distanceTable = new PngHuffmanTable(nArray3);
    }

    private int[] readLengths(PngDecodingDataStream pngDecodingDataStream, int n2, PngHuffmanTable pngHuffmanTable, int n3) throws IOException {
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            int n6;
            int n7 = pngHuffmanTable.getNextValue(pngDecodingDataStream);
            if (n7 < 16) {
                nArray[n4] = n7;
                ++n4;
                continue;
            }
            if (n7 == 16) {
                n6 = pngDecodingDataStream.getNextIdatBits(2) + 3;
                n5 = 0;
                while (n5 < n6) {
                    nArray[n4] = nArray[n4 - 1];
                    ++n4;
                    ++n5;
                }
                continue;
            }
            if (n7 == 17) {
                n6 = pngDecodingDataStream.getNextIdatBits(3) + 3;
                n5 = 0;
                while (n5 < n6) {
                    nArray[n4] = 0;
                    ++n4;
                    ++n5;
                }
                continue;
            }
            if (n7 == 18) {
                n6 = pngDecodingDataStream.getNextIdatBits(7) + 11;
                n5 = 0;
                while (n5 < n6) {
                    nArray[n4] = 0;
                    ++n4;
                    ++n5;
                }
                continue;
            }
            pngDecodingDataStream.error();
        }
        return nArray;
    }

    int getNextLiteralValue(PngDecodingDataStream pngDecodingDataStream) throws IOException {
        return this.literalTable.getNextValue(pngDecodingDataStream);
    }

    int getNextDistanceValue(PngDecodingDataStream pngDecodingDataStream) throws IOException {
        return this.distanceTable.getNextValue(pngDecodingDataStream);
    }
}

