/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.COMBOBOXINFO;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    boolean noSelection;
    boolean ignoreDefaultSelection;
    boolean ignoreCharacter;
    boolean ignoreModify;
    int cbtHook;
    int scrollWidth;
    int visibleCount = 5;
    public static final int LIMIT = OS.IsWinNT ? Integer.MAX_VALUE : Short.MAX_VALUE;
    static final int CBID_LIST = 1000;
    static final int CBID_EDIT = 1001;
    static int EditProc;
    static int ListProc;
    static final int ComboProc;
    static final TCHAR ComboClass;

    static {
        ComboClass = new TCHAR(0, "COMBOBOX", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, ComboClass, wNDCLASS);
        ComboProc = wNDCLASS.lpfnWndProc;
    }

    public Combo(Composite composite, int n2) {
        super(composite, Combo.checkStyle(n2));
        this.style |= 0x100;
    }

    public void add(String string) {
        TCHAR tCHAR;
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n2 = OS.SendMessage(this.handle, 323, 0, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -1) {
            this.error(14);
        }
        if (n2 == -2) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void add(String string, int n2) {
        TCHAR tCHAR;
        int n3;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n4 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n2 < 0 || n2 > n4) {
            this.error(6);
        }
        if ((n3 = OS.SendMessage(this.handle, 330, n2, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -2 || n3 == -1) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        if (n2 == this.handle) {
            return OS.CallWindowProc(ComboProc, n2, n3, n4, n5);
        }
        int n6 = OS.GetDlgItem(this.handle, 1001);
        if (n2 == n6) {
            return OS.CallWindowProc(EditProc, n2, n3, n4, n5);
        }
        int n7 = OS.GetDlgItem(this.handle, 1000);
        if (n2 == n7) {
            return OS.CallWindowProc(ListProc, n2, n3, n4, n5);
        }
        return OS.DefWindowProc(n2, n3, n4, n5);
    }

    int CBTProc(int n2, int n3, int n4) {
        if (n2 == 3) {
            TCHAR tCHAR = new TCHAR(0, 128);
            OS.GetClassName(n3, tCHAR, tCHAR.length());
            String string = tCHAR.toString(0, tCHAR.strlen());
            if (string.equals("Edit") || string.equals("EDIT")) {
                int n5 = OS.GetWindowLong(n3, -16);
                OS.SetWindowLong(n3, -16, n5 & 0xFFFFFEFF);
            }
        }
        return OS.CallNextHookEx(this.cbtHook, n2, n3, n4);
    }

    boolean checkHandle(int n2) {
        return n2 == this.handle || n2 == OS.GetDlgItem(this.handle, 1001) || n2 == OS.GetDlgItem(this.handle, 1000);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n2) {
        n2 &= 0xFFFFF7FF;
        n2 &= 0xFFFFFCFF;
        if (((n2 = Combo.checkBits(n2, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n2 & 0xFFFFFFF7;
        }
        return n2;
    }

    public void clearSelection() {
        this.checkWidget();
        OS.SendMessage(this.handle, 322, 0, -1);
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        int n4;
        int n5;
        int n6;
        this.checkWidget();
        int n7 = 0;
        int n8 = 0;
        if (n2 == -1) {
            n6 = 0;
            n5 = OS.GetDC(this.handle);
            n4 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n4 != 0) {
                n6 = OS.SelectObject(n5, n4);
            }
            int n9 = OS.SendMessage(this.handle, 326, 0, 0);
            RECT rECT = new RECT();
            int n10 = 3072;
            if ((this.style & 8) == 0) {
                n10 |= 0x2000;
            }
            int n11 = OS.GetWindowTextLength(this.handle);
            int n12 = this.getCodePage();
            TCHAR tCHAR = new TCHAR(n12, n11 + 1);
            OS.GetWindowText(this.handle, tCHAR, n11 + 1);
            OS.DrawText(n5, tCHAR, n11, rECT, n10);
            n7 = Math.max(n7, rECT.right - rECT.left);
            if ((this.style & 0x100) != 0) {
                n7 = Math.max(n7, this.scrollWidth);
            } else {
                int n13 = 0;
                while (n13 < n9) {
                    n11 = OS.SendMessage(this.handle, 329, n13, 0);
                    if (n11 != -1) {
                        int n14;
                        if (n11 + 1 > tCHAR.length()) {
                            tCHAR = new TCHAR(n12, n11 + 1);
                        }
                        if ((n14 = OS.SendMessage(this.handle, 328, n13, tCHAR)) != -1) {
                            OS.DrawText(n5, tCHAR, n11, rECT, n10);
                            n7 = Math.max(n7, rECT.right - rECT.left);
                        }
                    }
                    ++n13;
                }
            }
            if (n4 != 0) {
                OS.SelectObject(n5, n6);
            }
            OS.ReleaseDC(this.handle, n5);
        }
        if (n3 == -1 && (this.style & 0x40) != 0) {
            n4 = OS.SendMessage(this.handle, 326, 0, 0);
            n6 = OS.SendMessage(this.handle, 340, 0, 0);
            n8 = n4 * n6;
        }
        if (n7 == 0) {
            n7 = 64;
        }
        if (n8 == 0) {
            n8 = 64;
        }
        if (n2 != -1) {
            n7 = n2;
        }
        if (n3 != -1) {
            n8 = n3;
        }
        if ((this.style & 8) != 0) {
            n7 += 8;
        } else {
            n4 = OS.GetDlgItem(this.handle, 1001);
            if (n4 != 0) {
                n6 = OS.SendMessage(n4, 212, 0, 0);
                n5 = (n6 & 0xFFFF) + (n6 >> 16 & 0xFFFF);
                n7 += n5 + 3;
            }
        }
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if ((this.style & 0x40) == 0 && !OS.IsWinCE && OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            n7 += cOMBOBOXINFO.itemLeft + (cOMBOBOXINFO.buttonRight - cOMBOBOXINFO.buttonLeft);
            n8 = cOMBOBOXINFO.buttonBottom - cOMBOBOXINFO.buttonTop + cOMBOBOXINFO.buttonTop * 2;
        } else {
            n6 = OS.GetSystemMetrics(45);
            n7 += OS.GetSystemMetrics(2) + n6 * 2;
            n5 = OS.SendMessage(this.handle, 340, -1, 0);
            n8 = (this.style & 4) != 0 ? n5 + 6 : (n8 += n5 + 10);
        }
        if ((this.style & 0x40) != 0 && (this.style & 0x100) != 0) {
            n8 += OS.GetSystemMetrics(3);
        }
        return new Point(n7, n8);
    }

    public void copy() {
        this.checkWidget();
        OS.SendMessage(this.handle, 769, 0, 0);
    }

    void createHandle() {
        int n2;
        int n3;
        int n4;
        if (OS.IsWinCE || (this.style & 0x48) != 0) {
            super.createHandle();
        } else {
            n4 = OS.GetCurrentThreadId();
            Callback callback = new Callback(this, "CBTProc", 3);
            n3 = callback.getAddress();
            if (n3 == 0) {
                this.error(3);
            }
            this.cbtHook = OS.SetWindowsHookEx(5, n3, 0, n4);
            super.createHandle();
            if (this.cbtHook != 0) {
                OS.UnhookWindowsHookEx(this.cbtHook);
            }
            this.cbtHook = 0;
            callback.dispose();
        }
        this.state &= 0xFFFFFEFD;
        n4 = OS.GetDlgItem(this.handle, 1001);
        if (n4 != 0 && EditProc == 0) {
            EditProc = OS.GetWindowLong(n4, -4);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0 && ListProc == 0) {
            ListProc = OS.GetWindowLong(n2, -4);
        }
        if ((this.style & 0x40) != 0) {
            n3 = 52;
            this.SetWindowPos(this.handle, 0, 0, 0, 16383, 16383, n3);
            this.SetWindowPos(this.handle, 0, 0, 0, 0, 0, n3);
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 768, 0, 0);
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    void deregister() {
        int n2;
        super.deregister();
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0) {
            this.display.removeControl(n3);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            this.display.removeControl(n2);
        }
    }

    public void deselect(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 327, 0, 0);
        if (n2 != n3) {
            return;
        }
        OS.SendMessage(this.handle, 334, -1, 0);
        this.sendEvent(24);
    }

    public void deselectAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 334, -1, 0);
        this.sendEvent(24);
    }

    boolean dragDetect(int n2, int n3, int n4, boolean bl2, boolean[] blArray, boolean[] blArray2) {
        int n5;
        if (bl2 && (this.style & 8) == 0 && (n5 = OS.GetDlgItem(this.handle, 1001)) != 0) {
            int n6;
            int n7;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.SendMessage(this.handle, 320, nArray, nArray2);
            if (nArray[0] != nArray2[0] && nArray[0] <= (n7 = OS.SendMessage(n5, 215, 0, n6 = n3 & 0xFFFF | n4 << 16 & 0xFFFF0000) & 0xFFFF) && n7 < nArray2[0] && super.dragDetect(n2, n3, n4, bl2, blArray, blArray2)) {
                if (blArray2 != null) {
                    blArray2[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(n2, n3, n4, bl2, blArray, blArray2);
    }

    public String getItem(int n2) {
        TCHAR tCHAR;
        int n3;
        this.checkWidget();
        int n4 = OS.SendMessage(this.handle, 329, n2, 0);
        if (n4 != -1 && (n3 = OS.SendMessage(this.handle, 328, n2, tCHAR = new TCHAR(this.getCodePage(), n4 + 1))) != -1) {
            return tCHAR.toString(0, n4);
        }
        int n5 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n2 >= 0 && n2 < n5) {
            this.error(8);
        }
        this.error(6);
        return "";
    }

    public int getItemCount() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n2 == -1) {
            this.error(36);
        }
        return n2;
    }

    public int getItemHeight() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 340, 0, 0);
        if (n2 == -1) {
            this.error(11);
        }
        return n2;
    }

    public String[] getItems() {
        this.checkWidget();
        int n2 = this.getItemCount();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = this.getItem(n3);
            ++n3;
        }
        return stringArray;
    }

    boolean getListVisible() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.SendMessage(this.handle, 343, 0, 0) != 0;
        }
        return true;
    }

    String getNameText() {
        return this.getText();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0 && (this.style & 8) != 0) {
            return new Point(0, OS.GetWindowTextLength(this.handle));
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 320, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        return new Point(nArray[0], nArray2[0]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if (this.noSelection) {
            return -1;
        }
        return OS.SendMessage(this.handle, 327, 0, 0);
    }

    public String getText() {
        this.checkWidget();
        int n2 = OS.GetWindowTextLength(this.handle);
        if (n2 == 0) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n2 + 1);
        OS.GetWindowText(this.handle, tCHAR, n2 + 1);
        return tCHAR.toString(0, n2);
    }

    public int getTextHeight() {
        this.checkWidget();
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if ((this.style & 0x40) == 0 && !OS.IsWinCE && OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            return cOMBOBOXINFO.buttonBottom - cOMBOBOXINFO.buttonTop + cOMBOBOXINFO.buttonTop * 2;
        }
        int n2 = OS.SendMessage(this.handle, 340, -1, 0);
        if (n2 == -1) {
            this.error(11);
        }
        return (this.style & 4) != 0 ? n2 + 6 : n2 + 10;
    }

    public int getTextLimit() {
        this.checkWidget();
        int n2 = OS.GetDlgItem(this.handle, 1001);
        if (n2 == 0) {
            return LIMIT;
        }
        return OS.SendMessage(n2, 213, 0, 0) & Integer.MAX_VALUE;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    boolean hasFocus() {
        int n2 = OS.GetFocus();
        if (n2 == this.handle) {
            return true;
        }
        if (n2 == 0) {
            return false;
        }
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n2 == n3) {
            return true;
        }
        int n4 = OS.GetDlgItem(this.handle, 1000);
        return n2 == n4;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n2) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.length() == 0) {
            int n3 = this.getItemCount();
            int n4 = n2;
            while (n4 < n3) {
                if (string.equals(this.getItem(n4))) {
                    return n4;
                }
                ++n4;
            }
            return -1;
        }
        int n5 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n2 < 0 || n2 >= n5) {
            return -1;
        }
        int n6 = n2 - 1;
        int n7 = 0;
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        do {
            if ((n6 = OS.SendMessage(this.handle, 344, n7 = n6, tCHAR)) != -1 && n6 > n7) continue;
            return -1;
        } while (!string.equals(this.getItem(n6)));
        return n6;
    }

    int mbcsToWcsPos(int n2) {
        if (n2 <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n2;
        }
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 == 0) {
            return n2;
        }
        int n4 = OS.GetWindowTextLengthA(n3);
        if (n4 == 0) {
            return 0;
        }
        if (n2 >= n4) {
            return n4;
        }
        byte[] byArray = new byte[n4 + 1];
        OS.GetWindowTextA(n3, byArray, n4 + 1);
        return OS.MultiByteToWideChar(this.getCodePage(), 1, byArray, n2, null, 0);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 770, 0, 0);
    }

    void register() {
        int n2;
        super.register();
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0) {
            this.display.addControl(n3, this);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            this.display.addControl(n2, this);
        }
    }

    public void remove(int n2) {
        this.checkWidget();
        this.remove(n2, true);
    }

    void remove(int n2, boolean bl2) {
        int n3;
        int n4;
        int n5;
        TCHAR tCHAR = null;
        if ((this.style & 0x100) != 0) {
            n5 = OS.SendMessage(this.handle, 329, n2, 0);
            if (n5 == -1) {
                n4 = OS.SendMessage(this.handle, 326, 0, 0);
                if (n2 >= 0 && n2 < n4) {
                    this.error(15);
                }
                this.error(6);
            }
            if ((n4 = OS.SendMessage(this.handle, 328, n2, tCHAR = new TCHAR(this.getCodePage(), n5 + 1))) == -1) {
                n3 = OS.SendMessage(this.handle, 326, 0, 0);
                if (n2 >= 0 && n2 < n3) {
                    this.error(15);
                }
                this.error(6);
            }
        }
        n5 = OS.GetWindowTextLength(this.handle);
        n4 = OS.SendMessage(this.handle, 324, n2, 0);
        if (n4 == -1) {
            n3 = OS.SendMessage(this.handle, 326, 0, 0);
            if (n2 >= 0 && n2 < n3) {
                this.error(15);
            }
            this.error(6);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
        if (bl2 && n5 != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
        if ((this.style & 8) != 0 && (n3 = OS.SendMessage(this.handle, 326, 0, 0)) == 0) {
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    public void remove(int n2, int n3) {
        this.checkWidget();
        if (n2 > n3) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n2 < 0 || n2 > n3 || n3 >= n4) {
            this.error(6);
        }
        int n5 = OS.GetWindowTextLength(this.handle);
        RECT rECT = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            n6 = OS.GetDC(this.handle);
            n8 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n8 != 0) {
                n7 = OS.SelectObject(n6, n8);
            }
        }
        int n10 = this.getCodePage();
        int n11 = 3104;
        int n12 = n2;
        while (n12 <= n3) {
            int n13;
            int n14;
            TCHAR tCHAR = null;
            if ((this.style & 0x100) != 0 && ((n14 = OS.SendMessage(this.handle, 329, n2, 0)) == -1 || (n13 = OS.SendMessage(this.handle, 328, n2, tCHAR = new TCHAR(n10, n14 + 1))) == -1)) break;
            n14 = OS.SendMessage(this.handle, 324, n2, 0);
            if (n14 == -1) {
                this.error(15);
            }
            if ((this.style & 0x100) != 0) {
                OS.DrawText(n6, tCHAR, -1, rECT, n11);
                n9 = Math.max(n9, rECT.right - rECT.left);
            }
            ++n12;
        }
        if ((this.style & 0x100) != 0) {
            if (n8 != 0) {
                OS.SelectObject(n6, n7);
            }
            OS.ReleaseDC(this.handle, n6);
            this.setScrollWidth(n9, false);
        }
        if (n5 != OS.GetWindowTextLength(this.handle)) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return;
            }
        }
        if ((this.style & 8) != 0 && (n4 = OS.SendMessage(this.handle, 326, 0, 0)) == 0) {
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    public void remove(String string) {
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n2 = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n2);
    }

    public void removeAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 331, 0, 0);
        this.sendEvent(24);
        if (this.isDisposed()) {
            return;
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(0);
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    boolean sendKeyEvent(int n2, int n3, int n4, int n5, Event event) {
        Object object;
        Object object2;
        if (!super.sendKeyEvent(n2, n3, n4, n5, event)) {
            return false;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (n2 != 1) {
            return true;
        }
        if (n3 != 258 && n3 != 256 && n3 != 646) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return true;
        }
        char c2 = event.character;
        int n6 = event.stateMask;
        switch (n3) {
            case 258: {
                if (c2 != '\b' && c2 != '\u007f' && c2 != '\r' && c2 != '\t' && c2 != '\n') break;
            }
            case 256: {
                if ((n6 & 0x70000) == 0) break;
                return false;
            }
        }
        if (OS.GetKeyState(1) < 0) {
            return true;
        }
        String string = "";
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n7 = OS.GetDlgItem(this.handle, 1001);
        if (n7 == 0) {
            return true;
        }
        OS.SendMessage(n7, 176, nArray, nArray2);
        switch (c2) {
            case '\b': {
                if (nArray[0] != nArray2[0]) break;
                if (nArray[0] == 0) {
                    return true;
                }
                nArray[0] = nArray[0] - 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object2 = new int[1];
                    object = new int[1];
                    OS.SendMessage(n7, 177, nArray[0], nArray2[0]);
                    OS.SendMessage(n7, 176, (int[])object2, object);
                    if (nArray[0] != object2[0]) {
                        nArray[0] = nArray[0] - 1;
                    }
                }
                nArray[0] = Math.max(nArray[0], 0);
                break;
            }
            case '\u007f': {
                if (nArray[0] != nArray2[0]) break;
                int n8 = OS.GetWindowTextLength(n7);
                if (nArray[0] == n8) {
                    return true;
                }
                nArray2[0] = nArray2[0] + 1;
                if (!OS.IsUnicode && OS.IsDBLocale) {
                    object = new int[1];
                    int[] nArray3 = new int[1];
                    OS.SendMessage(n7, 177, nArray[0], nArray2[0]);
                    OS.SendMessage(n7, 176, object, nArray3);
                    if (nArray2[0] != nArray3[0]) {
                        nArray2[0] = nArray2[0] + 1;
                    }
                }
                nArray2[0] = Math.min(nArray2[0], n8);
                break;
            }
            case '\r': {
                return true;
            }
            default: {
                if (c2 != '\t' && c2 < ' ') {
                    return true;
                }
                string = new String(new char[]{c2});
            }
        }
        if ((object2 = this.verifyText(string, nArray[0], nArray2[0], event)) == null) {
            return false;
        }
        if (object2 == string) {
            return true;
        }
        object = new TCHAR(this.getCodePage(), (String)object2, true);
        OS.SendMessage(n7, 177, nArray[0], nArray2[0]);
        OS.SendMessage(n7, 194, 0, (TCHAR)object);
        return false;
    }

    public void select(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n2 >= 0 && n2 < n3) {
            int n4 = OS.SendMessage(this.handle, 327, 0, 0);
            int n5 = OS.SendMessage(this.handle, 334, n2, 0);
            if (n5 != -1 && n5 != n4) {
                this.sendEvent(24);
            }
        }
    }

    void setBackgroundImage(int n2) {
        int n3;
        super.setBackgroundImage(n2);
        int n4 = OS.GetDlgItem(this.handle, 1001);
        if (n4 != 0) {
            OS.InvalidateRect(n4, null, true);
        }
        if ((n3 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(n3, null, true);
        }
    }

    void setBackgroundPixel(int n2) {
        int n3;
        super.setBackgroundPixel(n2);
        int n4 = OS.GetDlgItem(this.handle, 1001);
        if (n4 != 0) {
            OS.InvalidateRect(n4, null, true);
        }
        if ((n3 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(n3, null, true);
        }
    }

    void setBounds(int n2, int n3, int n4, int n5, int n6) {
        if ((this.style & 4) != 0) {
            n5 = this.getTextHeight() + this.getItemHeight() * this.visibleCount + 2;
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            if (rECT.right - rECT.left != 0 && OS.SendMessage(this.handle, 338, 0, rECT) != 0) {
                int n7 = rECT.right - rECT.left;
                int n8 = rECT.bottom - rECT.top;
                if (n7 == n4 && n8 == n5) {
                    n6 |= 1;
                }
            }
            this.SetWindowPos(this.handle, 0, n2, n3, n4, n5, n6);
        } else {
            super.setBounds(n2, n3, n4, n5, n6);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth();
        }
    }

    void setForegroundPixel(int n2) {
        int n3;
        super.setForegroundPixel(n2);
        int n4 = OS.GetDlgItem(this.handle, 1001);
        if (n4 != 0) {
            OS.InvalidateRect(n4, null, true);
        }
        if ((n3 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.InvalidateRect(n3, null, true);
        }
    }

    public void setItem(int n2, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n3 = this.getSelectionIndex();
        this.remove(n2, false);
        if (this.isDisposed()) {
            return;
        }
        this.add(string, n2);
        if (n3 != -1) {
            this.select(n3);
        }
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] == null) {
                this.error(5);
            }
            ++n2;
        }
        RECT rECT = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            n3 = OS.GetDC(this.handle);
            n5 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n5 != 0) {
                n4 = OS.SelectObject(n3, n5);
            }
            this.setScrollWidth(0);
        }
        OS.SendMessage(this.handle, 331, 0, 0);
        int n7 = this.getCodePage();
        int n8 = 0;
        while (n8 < stringArray.length) {
            String string = stringArray[n8];
            TCHAR tCHAR = new TCHAR(n7, string, true);
            int n9 = OS.SendMessage(this.handle, 323, 0, tCHAR);
            if (n9 == -1) {
                this.error(14);
            }
            if (n9 == -2) {
                this.error(14);
            }
            if ((this.style & 0x100) != 0) {
                int n10 = 3104;
                OS.DrawText(n3, tCHAR, -1, rECT, n10);
                n6 = Math.max(n6, rECT.right - rECT.left);
            }
            ++n8;
        }
        if ((this.style & 0x100) != 0) {
            if (n5 != 0) {
                OS.SelectObject(n3, n4);
            }
            OS.ReleaseDC(this.handle, n3);
            this.setScrollWidth(n6 + 3);
        }
        this.sendEvent(24);
    }

    void setListVisible(boolean bl2) {
        this.checkWidget();
        OS.SendMessage(this.handle, 335, bl2 ? 1 : 0, 0);
    }

    public void setOrientation(int n2) {
        int n3;
        this.checkWidget();
        if (OS.IsWinCE) {
            return;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return;
        }
        int n4 = 0x6000000;
        if ((n2 & n4) == 0 || (n2 & n4) == n4) {
            return;
        }
        this.style &= ~n4;
        this.style |= n2 & n4;
        int n5 = OS.GetWindowLong(this.handle, -20);
        if ((this.style & 0x4000000) != 0) {
            this.style |= 0x8000000;
            n5 |= 0x400000;
        } else {
            this.style &= 0xF7FFFFFF;
            n5 &= 0xFFBFFFFF;
        }
        OS.SetWindowLong(this.handle, -20, n5);
        int n6 = 0;
        int n7 = 0;
        COMBOBOXINFO cOMBOBOXINFO = new COMBOBOXINFO();
        cOMBOBOXINFO.cbSize = COMBOBOXINFO.sizeof;
        if (OS.GetComboBoxInfo(this.handle, cOMBOBOXINFO)) {
            n6 = cOMBOBOXINFO.hwndItem;
            n7 = cOMBOBOXINFO.hwndList;
        }
        if (n6 != 0) {
            n3 = OS.GetWindowLong(n6, -20);
            int n8 = OS.GetWindowLong(n6, -16);
            if ((this.style & 0x4000000) != 0) {
                n3 |= 0x3000;
                n8 |= 2;
            } else {
                n3 &= 0xFFFFCFFF;
                n8 &= 0xFFFFFFFD;
            }
            OS.SetWindowLong(n6, -20, n3);
            OS.SetWindowLong(n6, -16, n8);
            RECT rECT = new RECT();
            OS.GetWindowRect(n6, rECT);
            int n9 = rECT.right - rECT.left;
            int n10 = rECT.bottom - rECT.top;
            OS.GetWindowRect(this.handle, rECT);
            int n11 = rECT.right - rECT.left;
            int n12 = rECT.bottom - rECT.top;
            int n13 = 22;
            this.SetWindowPos(n6, 0, 0, 0, n9 - 1, n10 - 1, n13);
            this.SetWindowPos(this.handle, 0, 0, 0, n11 - 1, n12 - 1, n13);
            this.SetWindowPos(n6, 0, 0, 0, n9, n10, n13);
            this.SetWindowPos(this.handle, 0, 0, 0, n11, n12, n13);
            OS.InvalidateRect(this.handle, null, true);
        }
        if (n7 != 0) {
            n3 = OS.GetWindowLong(n7, -20);
            n3 = (this.style & 0x4000000) != 0 ? (n3 |= 0x400000) : (n3 &= 0xFFBFFFFF);
            OS.SetWindowLong(n7, -20, n3);
        }
    }

    void setScrollWidth() {
        int n2 = 0;
        RECT rECT = new RECT();
        int n3 = 0;
        int n4 = OS.GetDC(this.handle);
        int n5 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n5 != 0) {
            n3 = OS.SelectObject(n4, n5);
        }
        int n6 = this.getCodePage();
        int n7 = OS.SendMessage(this.handle, 326, 0, 0);
        int n8 = 3104;
        int n9 = 0;
        while (n9 < n7) {
            TCHAR tCHAR;
            int n10;
            int n11 = OS.SendMessage(this.handle, 329, n9, 0);
            if (n11 != -1 && (n10 = OS.SendMessage(this.handle, 328, n9, tCHAR = new TCHAR(n6, n11 + 1))) != -1) {
                OS.DrawText(n4, tCHAR, -1, rECT, n8);
                n2 = Math.max(n2, rECT.right - rECT.left);
            }
            ++n9;
        }
        if (n5 != 0) {
            OS.SelectObject(n4, n3);
        }
        OS.ReleaseDC(this.handle, n4);
        this.setScrollWidth(n2 + 3);
    }

    void setScrollWidth(int n2) {
        this.scrollWidth = n2;
        if ((this.style & 0x40) != 0) {
            OS.SendMessage(this.handle, 350, n2, 0);
            return;
        }
        boolean bl2 = false;
        int n3 = OS.SendMessage(this.handle, 326, 0, 0);
        if (n3 > 3) {
            int n4 = 0;
            if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
                RECT rECT = new RECT();
                OS.SystemParametersInfo(48, 0, rECT, 0);
                n4 = (rECT.right - rECT.left) / 4;
            } else {
                int n5 = OS.MonitorFromWindow(this.handle, 2);
                MONITORINFO mONITORINFO = new MONITORINFO();
                mONITORINFO.cbSize = MONITORINFO.sizeof;
                OS.GetMonitorInfo(n5, mONITORINFO);
                n4 = (mONITORINFO.rcWork_right - mONITORINFO.rcWork_left) / 4;
            }
            boolean bl3 = bl2 = n2 > n4;
        }
        if (bl2) {
            OS.SendMessage(this.handle, 352, 0, 0);
            OS.SendMessage(this.handle, 350, n2, 0);
        } else {
            OS.SendMessage(this.handle, 352, n2 += OS.GetSystemMetrics(3), 0);
            OS.SendMessage(this.handle, 350, 0, 0);
        }
    }

    void setScrollWidth(TCHAR tCHAR, boolean bl2) {
        RECT rECT = new RECT();
        int n2 = 0;
        int n3 = OS.GetDC(this.handle);
        int n4 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n4 != 0) {
            n2 = OS.SelectObject(n3, n4);
        }
        int n5 = 3104;
        OS.DrawText(n3, tCHAR, -1, rECT, n5);
        if (n4 != 0) {
            OS.SelectObject(n3, n2);
        }
        OS.ReleaseDC(this.handle, n3);
        this.setScrollWidth(rECT.right - rECT.left, bl2);
    }

    void setScrollWidth(int n2, boolean bl2) {
        if (bl2) {
            if (n2 <= this.scrollWidth) {
                return;
            }
            this.setScrollWidth(n2 + 3);
        } else {
            if (n2 < this.scrollWidth) {
                return;
            }
            this.setScrollWidth();
        }
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n2 = point.x;
        int n3 = point.y;
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n2 = this.wcsToMbcsPos(n2);
            n3 = this.wcsToMbcsPos(n3);
        }
        int n4 = n2 & 0xFFFF | n3 << 16 & 0xFFFF0000;
        OS.SendMessage(this.handle, 322, 0, n4);
    }

    public void setText(String string) {
        TCHAR tCHAR;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int n2 = this.indexOf(string);
            if (n2 != -1) {
                this.select(n2);
            }
            return;
        }
        int n3 = LIMIT;
        int n4 = OS.GetDlgItem(this.handle, 1001);
        if (n4 != 0) {
            n3 = OS.SendMessage(n4, 213, 0, 0);
        }
        if (string.length() > n3) {
            string = string.substring(0, n3);
        }
        if (OS.SetWindowText(this.handle, tCHAR = new TCHAR(this.getCodePage(), string, true))) {
            this.sendEvent(24);
        }
    }

    public void setTextLimit(int n2) {
        this.checkWidget();
        if (n2 == 0) {
            this.error(7);
        }
        OS.SendMessage(this.handle, 321, n2, 0);
    }

    void setToolTipText(Shell shell, String string) {
        int n2 = OS.GetDlgItem(this.handle, 1001);
        int n3 = OS.GetDlgItem(this.handle, 1000);
        if (n2 != 0) {
            shell.setToolTipText(n2, string);
        }
        if (n3 != 0) {
            shell.setToolTipText(n3, string);
        }
        shell.setToolTipText(this.handle, string);
    }

    public void setVisibleItemCount(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        this.visibleCount = n2;
        if ((this.style & 4) != 0) {
            this.forceResize();
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            int n3 = 54;
            this.setBounds(0, 0, rECT.right - rECT.left, rECT.bottom - rECT.top, n3);
        }
    }

    void subclass() {
        int n2;
        super.subclass();
        int n3 = this.display.windowProc;
        int n4 = OS.GetDlgItem(this.handle, 1001);
        if (n4 != 0) {
            OS.SetWindowLong(n4, -4, n3);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0) {
            OS.SetWindowLong(n2, -4, n3);
        }
    }

    boolean translateTraversal(MSG mSG) {
        switch (mSG.wParam) {
            case 13: 
            case 27: {
                if ((this.style & 4) == 0 || OS.SendMessage(this.handle, 343, 0, 0) == 0) break;
                return false;
            }
        }
        return super.translateTraversal(mSG);
    }

    boolean traverseEscape() {
        if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0, 0) != 0) {
            OS.SendMessage(this.handle, 335, 0, 0);
            return true;
        }
        return super.traverseEscape();
    }

    boolean traverseReturn() {
        if ((this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0, 0) != 0) {
            OS.SendMessage(this.handle, 335, 0, 0);
            return true;
        }
        return super.traverseReturn();
    }

    void unsubclass() {
        int n2;
        super.unsubclass();
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 != 0 && EditProc != 0) {
            OS.SetWindowLong(n3, -4, EditProc);
        }
        if ((n2 = OS.GetDlgItem(this.handle, 1000)) != 0 && ListProc != 0) {
            OS.SetWindowLong(n2, -4, ListProc);
        }
    }

    String verifyText(String string, int n2, int n3, Event event) {
        Event event2 = new Event();
        event2.text = string;
        event2.start = n2;
        event2.end = n3;
        if (event != null) {
            event2.character = event.character;
            event2.keyCode = event.keyCode;
            event2.stateMask = event.stateMask;
        }
        if (!OS.IsUnicode && OS.IsDBLocale) {
            event2.start = this.mbcsToWcsPos(n2);
            event2.end = this.mbcsToWcsPos(n3);
        }
        this.sendEvent(25, event2);
        if (!event2.doit || this.isDisposed()) {
            return null;
        }
        return event2.text;
    }

    int wcsToMbcsPos(int n2) {
        if (n2 <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n2;
        }
        int n3 = OS.GetDlgItem(this.handle, 1001);
        if (n3 == 0) {
            return n2;
        }
        int n4 = OS.GetWindowTextLengthA(n3);
        if (n4 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n4 + 1];
        OS.GetWindowTextA(n3, byArray, n4 + 1);
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            if (n2 == n6) break;
            if (OS.IsDBCSLeadByte(byArray[n5++])) {
                ++n5;
            }
            ++n6;
        }
        return n5;
    }

    int widgetExtStyle() {
        return super.widgetExtStyle() & 0xFFEFFFFF;
    }

    int widgetStyle() {
        int n2 = super.widgetStyle() | 0x40 | 0x400 | 0x100000 | 0x200000;
        if ((this.style & 0x40) != 0) {
            return n2 | 1;
        }
        if ((this.style & 8) != 0) {
            return n2 | 3;
        }
        return n2 | 2;
    }

    TCHAR windowClass() {
        return ComboClass;
    }

    int windowProc() {
        return ComboProc;
    }

    int windowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        if (n2 != this.handle) {
            int n6 = OS.GetDlgItem(this.handle, 1001);
            int n7 = OS.GetDlgItem(this.handle, 1000);
            if (n6 != 0 && n2 == n6 || n7 != 0 && n2 == n7) {
                LRESULT lRESULT = null;
                switch (n3) {
                    case 258: {
                        lRESULT = this.wmChar(n2, n4, n5);
                        break;
                    }
                    case 646: {
                        lRESULT = this.wmIMEChar(n2, n4, n5);
                        break;
                    }
                    case 256: {
                        lRESULT = this.wmKeyDown(n2, n4, n5);
                        break;
                    }
                    case 257: {
                        lRESULT = this.wmKeyUp(n2, n4, n5);
                        break;
                    }
                    case 262: {
                        lRESULT = this.wmSysChar(n2, n4, n5);
                        break;
                    }
                    case 260: {
                        lRESULT = this.wmSysKeyDown(n2, n4, n5);
                        break;
                    }
                    case 261: {
                        lRESULT = this.wmSysKeyUp(n2, n4, n5);
                        break;
                    }
                    case 533: {
                        lRESULT = this.wmCaptureChanged(n2, n4, n5);
                        break;
                    }
                    case 515: {
                        lRESULT = this.wmLButtonDblClk(n2, n4, n5);
                        break;
                    }
                    case 513: {
                        lRESULT = this.wmLButtonDown(n2, n4, n5);
                        break;
                    }
                    case 514: {
                        lRESULT = this.wmLButtonUp(n2, n4, n5);
                        break;
                    }
                    case 521: {
                        lRESULT = this.wmMButtonDblClk(n2, n4, n5);
                        break;
                    }
                    case 519: {
                        lRESULT = this.wmMButtonDown(n2, n4, n5);
                        break;
                    }
                    case 520: {
                        lRESULT = this.wmMButtonUp(n2, n4, n5);
                        break;
                    }
                    case 673: {
                        lRESULT = this.wmMouseHover(n2, n4, n5);
                        break;
                    }
                    case 675: {
                        lRESULT = this.wmMouseLeave(n2, n4, n5);
                        break;
                    }
                    case 512: {
                        lRESULT = this.wmMouseMove(n2, n4, n5);
                        break;
                    }
                    case 518: {
                        lRESULT = this.wmRButtonDblClk(n2, n4, n5);
                        break;
                    }
                    case 516: {
                        lRESULT = this.wmRButtonDown(n2, n4, n5);
                        break;
                    }
                    case 517: {
                        lRESULT = this.wmRButtonUp(n2, n4, n5);
                        break;
                    }
                    case 525: {
                        lRESULT = this.wmXButtonDblClk(n2, n4, n5);
                        break;
                    }
                    case 523: {
                        lRESULT = this.wmXButtonDown(n2, n4, n5);
                        break;
                    }
                    case 524: {
                        lRESULT = this.wmXButtonUp(n2, n4, n5);
                        break;
                    }
                    case 15: {
                        lRESULT = this.wmPaint(n2, n4, n5);
                        break;
                    }
                    case 123: {
                        lRESULT = this.wmContextMenu(n2, n4, n5);
                        break;
                    }
                    case 12: 
                    case 199: 
                    case 768: 
                    case 770: 
                    case 771: 
                    case 772: {
                        if (n2 != n6) break;
                        lRESULT = this.wmClipboard(n2, n3, n4, n5);
                    }
                }
                if (lRESULT != null) {
                    return lRESULT.value;
                }
                return this.callWindowProc(n2, n3, n4, n5);
            }
        }
        if (n3 == 334 && (this.style & 8) != 0 && (this.hooks(25) || this.filters(25))) {
            String string = this.getText();
            String string2 = null;
            if (n4 == -1) {
                string2 = "";
            } else if (n4 >= 0 && n4 < this.getItemCount()) {
                string2 = this.getItem(n4);
            }
            if (string2 != null && !string2.equals(string)) {
                int n8;
                int n9 = OS.GetWindowTextLength(this.handle);
                string = string2;
                if ((string2 = this.verifyText(string2, 0, n9, null)) == null) {
                    return 0;
                }
                if (!string2.equals(string) && (n8 = this.indexOf(string2)) != -1 && n8 != n4) {
                    return this.callWindowProc(this.handle, 334, n8, n5);
                }
            }
        }
        return super.windowProc(n2, n3, n4, n5);
    }

    LRESULT WM_CTLCOLOR(int n2, int n3) {
        return this.wmColorChild(n2, n3);
    }

    LRESULT WM_GETDLGCODE(int n2, int n3) {
        int n4 = this.callWindowProc(this.handle, 135, n2, n3);
        return new LRESULT(n4 | 1);
    }

    LRESULT WM_KILLFOCUS(int n2, int n3) {
        if ((this.style & 8) != 0) {
            return super.WM_KILLFOCUS(n2, n3);
        }
        return null;
    }

    LRESULT WM_LBUTTONDOWN(int n2, int n3) {
        int n4;
        int n5 = OS.SendMessage(this.handle, 327, 0, 0);
        LRESULT lRESULT = super.WM_LBUTTONDOWN(n2, n3);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if ((this.style & 8) == 0 && n5 != (n4 = OS.SendMessage(this.handle, 327, 0, 0))) {
            this.sendEvent(24);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            this.sendEvent(13);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT WM_SETFOCUS(int n2, int n3) {
        return null;
    }

    LRESULT WM_SIZE(int n2, int n3) {
        if ((this.style & 0x40) != 0) {
            LRESULT lRESULT = super.WM_SIZE(n2, n3);
            if (OS.IsWindowVisible(this.handle)) {
                if (OS.IsWinCE) {
                    int n4;
                    int n5 = OS.GetDlgItem(this.handle, 1001);
                    if (n5 != 0) {
                        OS.InvalidateRect(n5, null, true);
                    }
                    if ((n4 = OS.GetDlgItem(this.handle, 1000)) != 0) {
                        OS.InvalidateRect(n4, null, true);
                    }
                } else {
                    int n6 = 133;
                    OS.RedrawWindow(this.handle, null, 0, n6);
                }
            }
            return lRESULT;
        }
        LRESULT lRESULT = null;
        if ((this.style & 8) != 0) {
            lRESULT = super.WM_SIZE(n2, n3);
        } else {
            int n7;
            int n8 = OS.SendMessage(this.handle, 327, 0, 0);
            boolean bl2 = false;
            TCHAR tCHAR = null;
            int[] nArray = null;
            int[] nArray2 = null;
            if (n8 == -1 && (n7 = OS.GetWindowTextLength(this.handle)) != 0) {
                tCHAR = new TCHAR(this.getCodePage(), n7 + 1);
                OS.GetWindowText(this.handle, tCHAR, n7 + 1);
                nArray = new int[1];
                nArray2 = new int[1];
                OS.SendMessage(this.handle, 320, nArray, nArray2);
                boolean bl3 = bl2 = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
                if (bl2) {
                    this.setRedraw(false);
                }
            }
            lRESULT = super.WM_SIZE(n2, n3);
            if (this.isDisposed()) {
                return lRESULT;
            }
            if (tCHAR != null) {
                OS.SetWindowText(this.handle, tCHAR);
                n7 = nArray[0] & 0xFFFF | nArray2[0] << 16 & 0xFFFF0000;
                OS.SendMessage(this.handle, 322, 0, n7);
                if (bl2) {
                    this.setRedraw(true);
                }
            }
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(this.scrollWidth);
        }
        return lRESULT;
    }

    LRESULT wmChar(int n2, int n3, int n4) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT lRESULT = super.wmChar(n2, n3, n4);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n3) {
            case 9: {
                return LRESULT.ZERO;
            }
            case 13: {
                if (!this.ignoreDefaultSelection) {
                    this.postEvent(14);
                }
                this.ignoreDefaultSelection = false;
            }
            case 27: {
                if ((this.style & 4) == 0 || OS.SendMessage(this.handle, 343, 0, 0) != 0) break;
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT wmClipboard(int n2, int n3, int n4, int n5) {
        Object object;
        if ((this.style & 8) != 0) {
            return null;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return null;
        }
        boolean bl2 = false;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        String string = null;
        switch (n3) {
            case 768: 
            case 771: {
                OS.SendMessage(n2, 176, nArray, nArray2);
                if (nArray[0] == nArray2[0]) break;
                string = "";
                bl2 = true;
                break;
            }
            case 770: {
                OS.SendMessage(n2, 176, nArray, nArray2);
                string = this.getClipboardText();
                break;
            }
            case 199: 
            case 772: {
                if (OS.SendMessage(n2, 198, 0, 0) == 0) break;
                this.ignoreModify = true;
                OS.SendMessage(n2, 176, nArray, nArray2);
                OS.CallWindowProc(EditProc, n2, n3, n4, n5);
                int n6 = OS.GetWindowTextLength(n2);
                object = new int[1];
                int[] nArray3 = new int[1];
                OS.SendMessage(n2, 176, (int[])object, nArray3);
                if (n6 != 0 && object[0] != nArray3[0]) {
                    TCHAR tCHAR = new TCHAR(this.getCodePage(), n6 + 1);
                    OS.GetWindowText(n2, tCHAR, n6 + 1);
                    string = tCHAR.toString((int)object[0], nArray3[0] - object[0]);
                } else {
                    string = "";
                }
                OS.CallWindowProc(EditProc, n2, n3, n4, n5);
                this.ignoreModify = false;
                break;
            }
            case 12: {
                nArray2[0] = OS.GetWindowTextLength(n2);
                int n6 = OS.IsUnicode ? OS.wcslen(n5) : OS.strlen(n5);
                object = new TCHAR(this.getCodePage(), n6);
                int n7 = ((TCHAR)object).length() * TCHAR.sizeof;
                OS.MoveMemory((TCHAR)object, n5, n7);
                string = ((TCHAR)object).toString(0, n6);
            }
        }
        if (string != null) {
            String string2 = string;
            if ((string = this.verifyText(string, nArray[0], nArray2[0], null)) == null) {
                return LRESULT.ZERO;
            }
            if (!string.equals(string2)) {
                if (bl2) {
                    OS.CallWindowProc(EditProc, n2, n3, n4, n5);
                }
                object = new TCHAR(this.getCodePage(), string, true);
                if (n3 == 12) {
                    int n8 = OS.GetProcessHeap();
                    int n9 = ((TCHAR)object).length() * TCHAR.sizeof;
                    int n10 = OS.HeapAlloc(n8, 8, n9);
                    OS.MoveMemory(n10, (TCHAR)object, n9);
                    int n11 = OS.CallWindowProc(EditProc, n2, n3, n4, n10);
                    OS.HeapFree(n8, 0, n10);
                    return new LRESULT(n11);
                }
                OS.SendMessage(n2, 194, 0, (TCHAR)object);
                return LRESULT.ZERO;
            }
        }
        return null;
    }

    LRESULT wmCommandChild(int n2, int n3) {
        int n4 = n2 >> 16;
        switch (n4) {
            case 5: {
                if (this.ignoreModify) break;
                this.noSelection = true;
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.noSelection = false;
                break;
            }
            case 1: {
                int n5 = OS.SendMessage(this.handle, 327, 0, 0);
                if (n5 != -1) {
                    OS.SendMessage(this.handle, 334, n5, 0);
                }
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.postEvent(13);
                break;
            }
            case 3: {
                this.sendFocusEvent(15);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
            case 4: {
                if ((this.style & 8) != 0) break;
                this.sendFocusEvent(16);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
        }
        return super.wmCommandChild(n2, n3);
    }

    LRESULT wmIMEChar(int n2, int n3, int n4) {
        Display display = this.display;
        display.lastKey = 0;
        display.lastAscii = n3;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!this.sendKeyEvent(1, 646, n3, n4)) {
            return LRESULT.ZERO;
        }
        this.ignoreCharacter = true;
        int n5 = this.callWindowProc(n2, 646, n3, n4);
        MSG mSG = new MSG();
        int n6 = 10420227;
        while (OS.PeekMessage(mSG, n2, 258, 258, n6)) {
            OS.TranslateMessage(mSG);
            OS.DispatchMessage(mSG);
        }
        this.ignoreCharacter = false;
        this.sendKeyEvent(2, 646, n3, n4);
        display.lastAscii = 0;
        display.lastKey = 0;
        return new LRESULT(n5);
    }

    LRESULT wmKeyDown(int n2, int n3, int n4) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT lRESULT = super.wmKeyDown(n2, n3, n4);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.ignoreDefaultSelection = false;
        if (n3 == 13 && (this.style & 4) != 0 && OS.SendMessage(this.handle, 343, 0, 0) != 0) {
            this.ignoreDefaultSelection = true;
        }
        return lRESULT;
    }

    LRESULT wmSysKeyDown(int n2, int n3, int n4) {
        int n5 = OS.SendMessage(this.handle, 327, 0, 0);
        LRESULT lRESULT = super.wmSysKeyDown(n2, n3, n4);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 8) == 0 && n3 == 40) {
            int n6 = this.callWindowProc(n2, 260, n3, n4);
            int n7 = OS.SendMessage(this.handle, 327, 0, 0);
            if (n5 != n7) {
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                this.sendEvent(13);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
            }
            return new LRESULT(n6);
        }
        return lRESULT;
    }
}

