/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.assembler;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.logging.Logger;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubelineAssembler;
import com.sun.xml.internal.ws.assembler.DefaultClientTubelineAssemblyContext;
import com.sun.xml.internal.ws.assembler.DefaultServerTubelineAssemblyContext;
import com.sun.xml.internal.ws.assembler.MetroConfigName;
import com.sun.xml.internal.ws.assembler.MetroConfigNameImpl;
import com.sun.xml.internal.ws.assembler.TubeCreator;
import com.sun.xml.internal.ws.assembler.TubelineAssemblyController;
import com.sun.xml.internal.ws.assembler.dev.TubelineAssemblyDecorator;
import com.sun.xml.internal.ws.dump.LoggingDumpTube;
import com.sun.xml.internal.ws.resources.TubelineassemblyMessages;
import com.sun.xml.internal.ws.util.ServiceFinder;
import java.util.Collection;
import java.util.logging.Level;

public class MetroTubelineAssembler
implements TubelineAssembler {
    private static final String COMMON_MESSAGE_DUMP_SYSTEM_PROPERTY_BASE = "com.sun.metro.soap.dump";
    public static final MetroConfigNameImpl JAXWS_TUBES_CONFIG_NAMES = new MetroConfigNameImpl("jaxws-tubes-default.xml", "jaxws-tubes.xml");
    private static final Logger LOGGER = Logger.getLogger(MetroTubelineAssembler.class);
    private final BindingID bindingId;
    private final TubelineAssemblyController tubelineAssemblyController;

    public MetroTubelineAssembler(BindingID bindingID, MetroConfigName metroConfigName) {
        this.bindingId = bindingID;
        this.tubelineAssemblyController = new TubelineAssemblyController(metroConfigName);
    }

    TubelineAssemblyController getTubelineAssemblyController() {
        return this.tubelineAssemblyController;
    }

    @Override
    @NotNull
    public Tube createClient(@NotNull ClientTubeAssemblerContext clientTubeAssemblerContext) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Assembling client-side tubeline for WS endpoint: " + clientTubeAssemblerContext.getAddress().getURI().toString());
        }
        DefaultClientTubelineAssemblyContext defaultClientTubelineAssemblyContext = this.createClientContext(clientTubeAssemblerContext);
        Collection<TubeCreator> collection = this.tubelineAssemblyController.getTubeCreators(defaultClientTubelineAssemblyContext);
        for (TubeCreator tubeCreator : collection) {
            tubeCreator.updateContext(defaultClientTubelineAssemblyContext);
        }
        TubelineAssemblyDecorator tubelineAssemblyDecorator = TubelineAssemblyDecorator.composite(ServiceFinder.find(TubelineAssemblyDecorator.class, defaultClientTubelineAssemblyContext.getContainer()));
        boolean bl = true;
        for (TubeCreator tubeCreator : collection) {
            MessageDumpingInfo messageDumpingInfo = this.setupMessageDumping(tubeCreator.getMessageDumpPropertyBase(), Side.Client);
            Tube tube = defaultClientTubelineAssemblyContext.getTubelineHead();
            LoggingDumpTube loggingDumpTube = null;
            if (messageDumpingInfo.dumpAfter) {
                loggingDumpTube = new LoggingDumpTube(messageDumpingInfo.logLevel, LoggingDumpTube.Position.After, defaultClientTubelineAssemblyContext.getTubelineHead());
                defaultClientTubelineAssemblyContext.setTubelineHead(loggingDumpTube);
            }
            if (!defaultClientTubelineAssemblyContext.setTubelineHead(tubelineAssemblyDecorator.decorateClient(tubeCreator.createTube(defaultClientTubelineAssemblyContext), defaultClientTubelineAssemblyContext))) {
                if (loggingDumpTube != null) {
                    defaultClientTubelineAssemblyContext.setTubelineHead(tube);
                }
            } else {
                String string = defaultClientTubelineAssemblyContext.getTubelineHead().getClass().getName();
                if (loggingDumpTube != null) {
                    loggingDumpTube.setLoggedTubeName(string);
                }
                if (messageDumpingInfo.dumpBefore) {
                    LoggingDumpTube loggingDumpTube2 = new LoggingDumpTube(messageDumpingInfo.logLevel, LoggingDumpTube.Position.Before, defaultClientTubelineAssemblyContext.getTubelineHead());
                    loggingDumpTube2.setLoggedTubeName(string);
                    defaultClientTubelineAssemblyContext.setTubelineHead(loggingDumpTube2);
                }
            }
            if (!bl) continue;
            defaultClientTubelineAssemblyContext.setTubelineHead(tubelineAssemblyDecorator.decorateClientTail(defaultClientTubelineAssemblyContext.getTubelineHead(), defaultClientTubelineAssemblyContext));
            bl = false;
        }
        return tubelineAssemblyDecorator.decorateClientHead(defaultClientTubelineAssemblyContext.getTubelineHead(), defaultClientTubelineAssemblyContext);
    }

    @Override
    @NotNull
    public Tube createServer(@NotNull ServerTubeAssemblerContext serverTubeAssemblerContext) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Assembling endpoint tubeline for WS endpoint: " + serverTubeAssemblerContext.getEndpoint().getServiceName() + "::" + serverTubeAssemblerContext.getEndpoint().getPortName());
        }
        DefaultServerTubelineAssemblyContext defaultServerTubelineAssemblyContext = this.createServerContext(serverTubeAssemblerContext);
        Collection<TubeCreator> collection = this.tubelineAssemblyController.getTubeCreators(defaultServerTubelineAssemblyContext);
        for (TubeCreator tubeCreator : collection) {
            tubeCreator.updateContext(defaultServerTubelineAssemblyContext);
        }
        TubelineAssemblyDecorator tubelineAssemblyDecorator = TubelineAssemblyDecorator.composite(ServiceFinder.find(TubelineAssemblyDecorator.class, defaultServerTubelineAssemblyContext.getEndpoint().getContainer()));
        boolean bl = true;
        for (TubeCreator tubeCreator : collection) {
            MessageDumpingInfo messageDumpingInfo = this.setupMessageDumping(tubeCreator.getMessageDumpPropertyBase(), Side.Endpoint);
            Tube tube = defaultServerTubelineAssemblyContext.getTubelineHead();
            LoggingDumpTube loggingDumpTube = null;
            if (messageDumpingInfo.dumpAfter) {
                loggingDumpTube = new LoggingDumpTube(messageDumpingInfo.logLevel, LoggingDumpTube.Position.After, defaultServerTubelineAssemblyContext.getTubelineHead());
                defaultServerTubelineAssemblyContext.setTubelineHead(loggingDumpTube);
            }
            if (!defaultServerTubelineAssemblyContext.setTubelineHead(tubelineAssemblyDecorator.decorateServer(tubeCreator.createTube(defaultServerTubelineAssemblyContext), defaultServerTubelineAssemblyContext))) {
                if (loggingDumpTube != null) {
                    defaultServerTubelineAssemblyContext.setTubelineHead(tube);
                }
            } else {
                String string = defaultServerTubelineAssemblyContext.getTubelineHead().getClass().getName();
                if (loggingDumpTube != null) {
                    loggingDumpTube.setLoggedTubeName(string);
                }
                if (messageDumpingInfo.dumpBefore) {
                    LoggingDumpTube loggingDumpTube2 = new LoggingDumpTube(messageDumpingInfo.logLevel, LoggingDumpTube.Position.Before, defaultServerTubelineAssemblyContext.getTubelineHead());
                    loggingDumpTube2.setLoggedTubeName(string);
                    defaultServerTubelineAssemblyContext.setTubelineHead(loggingDumpTube2);
                }
            }
            if (!bl) continue;
            defaultServerTubelineAssemblyContext.setTubelineHead(tubelineAssemblyDecorator.decorateServerTail(defaultServerTubelineAssemblyContext.getTubelineHead(), defaultServerTubelineAssemblyContext));
            bl = false;
        }
        return tubelineAssemblyDecorator.decorateServerHead(defaultServerTubelineAssemblyContext.getTubelineHead(), defaultServerTubelineAssemblyContext);
    }

    private MessageDumpingInfo setupMessageDumping(String string, Side side) {
        boolean bl = false;
        boolean bl2 = false;
        Level level = Level.INFO;
        Boolean bl3 = this.getBooleanValue(COMMON_MESSAGE_DUMP_SYSTEM_PROPERTY_BASE);
        if (bl3 != null) {
            bl = bl3;
            bl2 = bl3;
        }
        bl = (bl3 = this.getBooleanValue("com.sun.metro.soap.dump.before")) != null ? bl3 : bl;
        bl3 = this.getBooleanValue("com.sun.metro.soap.dump.after");
        bl2 = bl3 != null ? bl3 : bl2;
        Level level2 = this.getLevelValue("com.sun.metro.soap.dump.level");
        if (level2 != null) {
            level = level2;
        }
        if ((bl3 = this.getBooleanValue("com.sun.metro.soap.dump." + side.toString())) != null) {
            bl = bl3;
            bl2 = bl3;
        }
        bl = (bl3 = this.getBooleanValue("com.sun.metro.soap.dump." + side.toString() + ".before")) != null ? bl3 : bl;
        bl3 = this.getBooleanValue("com.sun.metro.soap.dump." + side.toString() + ".after");
        bl2 = bl3 != null ? bl3 : bl2;
        level2 = this.getLevelValue("com.sun.metro.soap.dump." + side.toString() + ".level");
        if (level2 != null) {
            level = level2;
        }
        if ((bl3 = this.getBooleanValue(string)) != null) {
            bl = bl3;
            bl2 = bl3;
        }
        bl = (bl3 = this.getBooleanValue(string + ".before")) != null ? bl3 : bl;
        bl3 = this.getBooleanValue(string + ".after");
        bl2 = bl3 != null ? bl3 : bl2;
        level2 = this.getLevelValue(string + ".level");
        if (level2 != null) {
            level = level2;
        }
        if ((bl3 = this.getBooleanValue(string = string + "." + side.toString())) != null) {
            bl = bl3;
            bl2 = bl3;
        }
        bl = (bl3 = this.getBooleanValue(string + ".before")) != null ? bl3 : bl;
        bl3 = this.getBooleanValue(string + ".after");
        bl2 = bl3 != null ? bl3 : bl2;
        level2 = this.getLevelValue(string + ".level");
        if (level2 != null) {
            level = level2;
        }
        return new MessageDumpingInfo(bl, bl2, level);
    }

    private Boolean getBooleanValue(String string) {
        Boolean bl = null;
        String string2 = System.getProperty(string);
        if (string2 != null) {
            bl = Boolean.valueOf(string2);
            LOGGER.fine(TubelineassemblyMessages.MASM_0018_MSG_LOGGING_SYSTEM_PROPERTY_SET_TO_VALUE(string, bl));
        }
        return bl;
    }

    private Level getLevelValue(String string) {
        Level level = null;
        String string2 = System.getProperty(string);
        if (string2 != null) {
            LOGGER.fine(TubelineassemblyMessages.MASM_0018_MSG_LOGGING_SYSTEM_PROPERTY_SET_TO_VALUE(string, string2));
            try {
                level = Level.parse(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.warning(TubelineassemblyMessages.MASM_0019_MSG_LOGGING_SYSTEM_PROPERTY_ILLEGAL_VALUE(string, string2), illegalArgumentException);
            }
        }
        return level;
    }

    protected DefaultServerTubelineAssemblyContext createServerContext(ServerTubeAssemblerContext serverTubeAssemblerContext) {
        return new DefaultServerTubelineAssemblyContext(serverTubeAssemblerContext);
    }

    protected DefaultClientTubelineAssemblyContext createClientContext(ClientTubeAssemblerContext clientTubeAssemblerContext) {
        return new DefaultClientTubelineAssemblyContext(clientTubeAssemblerContext);
    }

    private static class MessageDumpingInfo {
        final boolean dumpBefore;
        final boolean dumpAfter;
        final Level logLevel;

        MessageDumpingInfo(boolean bl, boolean bl2, Level level) {
            this.dumpBefore = bl;
            this.dumpAfter = bl2;
            this.logLevel = level;
        }
    }

    private static enum Side {
        Client("client"),
        Endpoint("endpoint");

        private final String name;

        private Side(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

