/*
 * Decompiled with CFR 0.152.
 */
package emulator.custom.subclass;

import emulator.custom.subclass.SubTimerTask;

class TaskQueue {
    private SubTimerTask[] queue = new SubTimerTask[4];
    private int size = 0;
    boolean newTasksMayBeScheduled = true;

    TaskQueue() {
    }

    void add(SubTimerTask subTimerTask) {
        if (++this.size == this.queue.length) {
            SubTimerTask[] subTimerTaskArray = new SubTimerTask[2 * this.queue.length];
            System.arraycopy(this.queue, 0, subTimerTaskArray, 0, this.size);
            this.queue = subTimerTaskArray;
        }
        this.queue[this.size] = subTimerTask;
        this.fixUp(this.size);
    }

    SubTimerTask getMin() {
        return this.queue[1];
    }

    void removeMin() {
        this.queue[1] = this.queue[this.size];
        this.queue[this.size--] = null;
        this.fixDown(1);
    }

    void rescheduleMin(long l2) {
        this.queue[1].nextExecutionTime = l2;
        this.fixDown(1);
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    void clear() {
        for (int i2 = 1; i2 <= this.size; ++i2) {
            this.queue[i2] = null;
        }
        this.size = 0;
    }

    private void fixUp(int n2) {
        while (n2 > 1) {
            int n3 = n2 >> 1;
            if (this.queue[n3].nextExecutionTime <= this.queue[n2].nextExecutionTime) {
                return;
            }
            SubTimerTask subTimerTask = this.queue[n3];
            this.queue[n3] = this.queue[n2];
            this.queue[n2] = subTimerTask;
            n2 = n3;
        }
    }

    private void fixDown(int n2) {
        int n3;
        while ((n3 = n2 << 1) <= this.size) {
            if (n3 < this.size && this.queue[n3].nextExecutionTime > this.queue[n3 + 1].nextExecutionTime) {
                ++n3;
            }
            if (this.queue[n2].nextExecutionTime <= this.queue[n3].nextExecutionTime) {
                return;
            }
            SubTimerTask subTimerTask = this.queue[n3];
            this.queue[n3] = this.queue[n2];
            this.queue[n2] = subTimerTask;
            n2 = n3;
        }
    }
}

