/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IAccessible;
import org.eclipse.swt.internal.ole.win32.IEnumVARIANT;
import org.eclipse.swt.internal.ole.win32.VARIANT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class Accessible {
    int refCount = 0;
    int enumIndex = 0;
    COMObject objIAccessible;
    COMObject objIEnumVARIANT;
    IAccessible iaccessible;
    Vector accessibleListeners = new Vector();
    Vector accessibleControlListeners = new Vector();
    Vector textListeners = new Vector();
    Object[] variants;
    Control control;

    Accessible(Control control) {
        this.control = control;
        int[] nArray = new int[1];
        int n2 = COM.CreateStdAccessibleObject(control.handle, -4, COM.IIDIAccessible, nArray);
        if (nArray[0] == 0) {
            return;
        }
        if (n2 != 0) {
            OLE.error(1001, n2);
        }
        this.iaccessible = new IAccessible(nArray[0]);
        int[] nArray2 = new int[28];
        nArray2[0] = 2;
        nArray2[3] = 1;
        nArray2[4] = 3;
        nArray2[5] = 5;
        nArray2[6] = 8;
        nArray2[7] = 1;
        nArray2[8] = 1;
        nArray2[9] = 2;
        nArray2[10] = 2;
        nArray2[11] = 2;
        nArray2[12] = 2;
        nArray2[13] = 2;
        nArray2[14] = 2;
        nArray2[15] = 2;
        nArray2[16] = 3;
        nArray2[17] = 2;
        nArray2[18] = 1;
        nArray2[19] = 1;
        nArray2[20] = 2;
        nArray2[21] = 2;
        nArray2[22] = 5;
        nArray2[23] = 3;
        nArray2[24] = 3;
        nArray2[25] = 1;
        nArray2[26] = 2;
        nArray2[27] = 2;
        this.objIAccessible = new COMObject(nArray2){

            public int method0(int[] nArray) {
                return Accessible.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return Accessible.this.AddRef();
            }

            public int method2(int[] nArray) {
                return Accessible.this.Release();
            }

            public int method7(int[] nArray) {
                return Accessible.this.get_accParent(nArray[0]);
            }

            public int method8(int[] nArray) {
                return Accessible.this.get_accChildCount(nArray[0]);
            }

            public int method9(int[] nArray) {
                return Accessible.this.get_accChild(nArray[0], nArray[1]);
            }

            public int method10(int[] nArray) {
                return Accessible.this.get_accName(nArray[0], nArray[1]);
            }

            public int method11(int[] nArray) {
                return Accessible.this.get_accValue(nArray[0], nArray[1]);
            }

            public int method12(int[] nArray) {
                return Accessible.this.get_accDescription(nArray[0], nArray[1]);
            }

            public int method13(int[] nArray) {
                return Accessible.this.get_accRole(nArray[0], nArray[1]);
            }

            public int method14(int[] nArray) {
                return Accessible.this.get_accState(nArray[0], nArray[1]);
            }

            public int method15(int[] nArray) {
                return Accessible.this.get_accHelp(nArray[0], nArray[1]);
            }

            public int method16(int[] nArray) {
                return Accessible.this.get_accHelpTopic(nArray[0], nArray[1], nArray[2]);
            }

            public int method17(int[] nArray) {
                return Accessible.this.get_accKeyboardShortcut(nArray[0], nArray[1]);
            }

            public int method18(int[] nArray) {
                return Accessible.this.get_accFocus(nArray[0]);
            }

            public int method19(int[] nArray) {
                return Accessible.this.get_accSelection(nArray[0]);
            }

            public int method20(int[] nArray) {
                return Accessible.this.get_accDefaultAction(nArray[0], nArray[1]);
            }

            public int method21(int[] nArray) {
                return Accessible.this.accSelect(nArray[0], nArray[1]);
            }

            public int method22(int[] nArray) {
                return Accessible.this.accLocation(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }

            public int method23(int[] nArray) {
                return Accessible.this.accNavigate(nArray[0], nArray[1], nArray[2]);
            }

            public int method24(int[] nArray) {
                return Accessible.this.accHitTest(nArray[0], nArray[1], nArray[2]);
            }

            public int method25(int[] nArray) {
                return Accessible.this.accDoDefaultAction(nArray[0]);
            }

            public int method26(int[] nArray) {
                return Accessible.this.put_accName(nArray[0], nArray[1]);
            }

            public int method27(int[] nArray) {
                return Accessible.this.put_accValue(nArray[0], nArray[1]);
            }
        };
        int n3 = this.objIAccessible.ppVtable;
        int[] nArray3 = new int[1];
        COM.MoveMemory(nArray3, n3, OS.PTR_SIZEOF);
        int[] nArray4 = new int[28];
        COM.MoveMemory(nArray4, nArray3[0], OS.PTR_SIZEOF * nArray4.length);
        nArray4[9] = COM.get_accChild_CALLBACK(nArray4[9]);
        nArray4[10] = COM.get_accName_CALLBACK(nArray4[10]);
        nArray4[11] = COM.get_accValue_CALLBACK(nArray4[11]);
        nArray4[12] = COM.get_accDescription_CALLBACK(nArray4[12]);
        nArray4[13] = COM.get_accRole_CALLBACK(nArray4[13]);
        nArray4[14] = COM.get_accState_CALLBACK(nArray4[14]);
        nArray4[15] = COM.get_accHelp_CALLBACK(nArray4[15]);
        nArray4[16] = COM.get_accHelpTopic_CALLBACK(nArray4[16]);
        nArray4[17] = COM.get_accKeyboardShortcut_CALLBACK(nArray4[17]);
        nArray4[20] = COM.get_accDefaultAction_CALLBACK(nArray4[20]);
        nArray4[21] = COM.accSelect_CALLBACK(nArray4[21]);
        nArray4[22] = COM.accLocation_CALLBACK(nArray4[22]);
        nArray4[23] = COM.accNavigate_CALLBACK(nArray4[23]);
        nArray4[25] = COM.accDoDefaultAction_CALLBACK(nArray4[25]);
        nArray4[26] = COM.put_accName_CALLBACK(nArray4[26]);
        nArray4[27] = COM.put_accValue_CALLBACK(nArray4[27]);
        COM.MoveMemory(nArray3[0], nArray4, OS.PTR_SIZEOF * nArray4.length);
        int[] nArray5 = new int[7];
        nArray5[0] = 2;
        nArray5[3] = 3;
        nArray5[4] = 1;
        nArray5[6] = 1;
        this.objIEnumVARIANT = new COMObject(nArray5){

            public int method0(int[] nArray) {
                return Accessible.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return Accessible.this.AddRef();
            }

            public int method2(int[] nArray) {
                return Accessible.this.Release();
            }

            public int method3(int[] nArray) {
                return Accessible.this.Next(nArray[0], nArray[1], nArray[2]);
            }

            public int method4(int[] nArray) {
                return Accessible.this.Skip(nArray[0]);
            }

            public int method5(int[] nArray) {
                return Accessible.this.Reset();
            }

            public int method6(int[] nArray) {
                return Accessible.this.Clone(nArray[0]);
            }
        };
        this.AddRef();
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    public void addAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.addElement(accessibleListener);
    }

    public void addAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.addElement(accessibleControlListener);
    }

    public void addAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        this.textListeners.addElement(accessibleTextListener);
    }

    public Control getControl() {
        return this.control;
    }

    public void internal_dispose_Accessible() {
        if (this.iaccessible != null) {
            this.iaccessible.Release();
        }
        this.iaccessible = null;
        this.Release();
    }

    public int internal_WM_GETOBJECT(int n2, int n3) {
        if (this.objIAccessible == null) {
            return 0;
        }
        if (n3 == -4) {
            return COM.LresultFromObject(COM.IIDIAccessible, n2, this.objIAccessible.getAddress());
        }
        return 0;
    }

    public void removeAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.removeElement(accessibleListener);
    }

    public void removeAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.removeElement(accessibleControlListener);
    }

    public void removeAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        this.textListeners.removeElement(accessibleTextListener);
    }

    public void selectionChanged() {
        this.checkWidget();
        COM.NotifyWinEvent(32777, this.control.handle, -4, 0);
    }

    public void setFocus(int n2) {
        this.checkWidget();
        COM.NotifyWinEvent(32773, this.control.handle, -4, this.childIDToOs(n2));
    }

    public void textCaretMoved(int n2) {
        this.checkWidget();
        COM.NotifyWinEvent(32779, this.control.handle, -8, 0);
    }

    public void textChanged(int n2, int n3, int n4) {
        this.checkWidget();
        COM.NotifyWinEvent(32782, this.control.handle, -4, 0);
    }

    public void textSelectionChanged() {
        this.checkWidget();
    }

    int QueryInterface(int n2, int n3) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n2, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(n3, new int[]{this.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIDispatch)) {
            COM.MoveMemory(n3, new int[]{this.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessible)) {
            COM.MoveMemory(n3, new int[]{this.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIEnumVARIANT)) {
            COM.MoveMemory(n3, new int[]{this.objIEnumVARIANT.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            this.enumIndex = 0;
            return 0;
        }
        int[] nArray = new int[1];
        int n4 = this.iaccessible.QueryInterface(gUID, nArray);
        COM.MoveMemory(n3, nArray, OS.PTR_SIZEOF);
        return n4;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            if (this.objIAccessible != null) {
                this.objIAccessible.dispose();
            }
            this.objIAccessible = null;
            if (this.objIEnumVARIANT != null) {
                this.objIEnumVARIANT.dispose();
            }
            this.objIEnumVARIANT = null;
        }
        return this.refCount;
    }

    int accDoDefaultAction(int n2) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n3 = this.iaccessible.accDoDefaultAction(n2);
        if (n3 == -2147024809) {
            n3 = 1;
        }
        return n3;
    }

    int accHitTest(int n2, int n3, int n4) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        if (this.accessibleControlListeners.size() == 0) {
            return this.iaccessible.accHitTest(n2, n3, n4);
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = -2;
        accessibleControlEvent.x = n2;
        accessibleControlEvent.y = n3;
        int n5 = 0;
        while (n5 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
            accessibleControlListener.getChildAtPoint(accessibleControlEvent);
            ++n5;
        }
        n5 = accessibleControlEvent.childID;
        if (n5 == -2) {
            return this.iaccessible.accHitTest(n2, n3, n4);
        }
        COM.MoveMemory(n4, new short[]{3}, 2);
        COM.MoveMemory(n4 + 8, new int[]{this.childIDToOs(n5)}, 4);
        return 0;
    }

    int accLocation(int n2, int n3, int n4, int n5, int n6) {
        Object object;
        Object object2;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, n6, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = this.iaccessible.accLocation(n2, n3, n4, n5, n6);
        if (n11 == -2147024809) {
            n11 = 1;
        }
        if (this.accessibleControlListeners.size() == 0) {
            return n11;
        }
        if (n11 == 0) {
            object2 = new int[1];
            int[] nArray = new int[1];
            object = new int[1];
            int[] nArray2 = new int[1];
            COM.MoveMemory(object2, n2, 4);
            COM.MoveMemory(nArray, n3, 4);
            COM.MoveMemory((int[])object, n4, 4);
            COM.MoveMemory(nArray2, n5, 4);
            n7 = object2[0];
            n8 = nArray[0];
            n9 = object[0];
            n10 = nArray2[0];
        }
        object2 = new AccessibleControlEvent(this);
        object2.childID = this.osToChildID(vARIANT.lVal);
        object2.x = n7;
        object2.y = n8;
        object2.width = n9;
        object2.height = n10;
        int n12 = 0;
        while (n12 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n12);
            object.getLocation((AccessibleControlEvent)object2);
            ++n12;
        }
        OS.MoveMemory(n2, new int[]{object2.x}, 4);
        OS.MoveMemory(n3, new int[]{object2.y}, 4);
        OS.MoveMemory(n4, new int[]{object2.width}, 4);
        OS.MoveMemory(n5, new int[]{object2.height}, 4);
        return 0;
    }

    int accNavigate(int n2, int n3, int n4) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n5 = this.iaccessible.accNavigate(n2, n3, n4);
        if (n5 == -2147024809) {
            n5 = 1;
        }
        return n5;
    }

    int accSelect(int n2, int n3) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n4 = this.iaccessible.accSelect(n2, n3);
        if (n4 == -2147024809) {
            n4 = 1;
        }
        return n4;
    }

    int get_accChild(int n2, int n3) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, n2, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        if (this.accessibleControlListeners.size() == 0) {
            int n4 = this.iaccessible.get_accChild(n2, n3);
            if (n4 == -2147024809) {
                n4 = 1;
            }
            return n4;
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = this.osToChildID(vARIANT.lVal);
        int n5 = 0;
        while (n5 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
            accessibleControlListener.getChild(accessibleControlEvent);
            ++n5;
        }
        Accessible accessible = accessibleControlEvent.accessible;
        if (accessible != null) {
            accessible.AddRef();
            COM.MoveMemory(n3, new int[]{accessible.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            return 0;
        }
        return 1;
    }

    int get_accChildCount(int n2) {
        Object object;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n3 = 0;
        int n4 = this.iaccessible.get_accChildCount(n2);
        if (this.accessibleControlListeners.size() == 0) {
            return n4;
        }
        if (n4 == 0) {
            object = new int[1];
            COM.MoveMemory(object, n2, 4);
            n3 = object[0];
        }
        object = new AccessibleControlEvent(this);
        object.childID = -1;
        object.detail = n3;
        int n5 = 0;
        while (n5 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
            accessibleControlListener.getChildCount((AccessibleControlEvent)object);
            ++n5;
        }
        COM.MoveMemory(n2, new int[]{object.detail}, 4);
        return 0;
    }

    int get_accDefaultAction(int n2, int n3) {
        Object object;
        int n4;
        Object object2;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, n2, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String string = null;
        int n5 = this.iaccessible.get_accDefaultAction(n2, n3);
        if (n5 == -2147024809) {
            n5 = 1;
        }
        if (this.accessibleControlListeners.size() == 0) {
            return n5;
        }
        if (n5 == 0) {
            object2 = new int[1];
            COM.MoveMemory(object2, n3, OS.PTR_SIZEOF);
            n4 = COM.SysStringByteLen(object2[0]);
            if (n4 > 0) {
                object = new char[(n4 + 1) / 2];
                COM.MoveMemory((char[])object, object2[0], n4);
                string = new String((char[])object);
            }
        }
        object2 = new AccessibleControlEvent(this);
        object2.childID = this.osToChildID(vARIANT.lVal);
        object2.result = string;
        n4 = 0;
        while (n4 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n4);
            object.getDefaultAction((AccessibleControlEvent)object2);
            ++n4;
        }
        if (object2.result == null) {
            return n5;
        }
        char[] cArray = (String.valueOf(object2.result) + "\u0000").toCharArray();
        int n6 = COM.SysAllocString(cArray);
        COM.MoveMemory(n3, new int[]{n6}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_accDescription(int n2, int n3) {
        Tree tree;
        int n4;
        Object object;
        int n5;
        Object object2;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, n2, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String string = null;
        int n6 = this.iaccessible.get_accDescription(n2, n3);
        if (n6 == -2147024809) {
            n6 = 1;
        }
        if (this.accessibleListeners.size() == 0 && !(this.control instanceof Tree)) {
            return n6;
        }
        if (n6 == 0) {
            object2 = new int[1];
            COM.MoveMemory(object2, n3, OS.PTR_SIZEOF);
            n5 = COM.SysStringByteLen(object2[0]);
            if (n5 > 0) {
                object = new char[(n5 + 1) / 2];
                COM.MoveMemory((char[])object, object2[0], n5);
                string = new String((char[])object);
            }
        }
        object2 = new AccessibleEvent(this);
        object2.childID = this.osToChildID(vARIANT.lVal);
        object2.result = string;
        if (vARIANT.lVal != 0 && this.control instanceof Tree && (n4 = (tree = (Tree)this.control).getColumnCount()) > 1) {
            int n7 = this.control.handle;
            int n8 = 0;
            n8 = OS.COMCTL32_MAJOR >= 6 ? OS.SendMessage(n7, 4394, vARIANT.lVal, 0) : vARIANT.lVal;
            Widget widget = tree.getDisplay().findWidget(n7, n8);
            object2.result = "";
            if (widget != null && widget instanceof TreeItem) {
                TreeItem treeItem = (TreeItem)widget;
                int n9 = 1;
                while (n9 < n4) {
                    object2.result = String.valueOf(object2.result) + tree.getColumn(n9).getText() + ": " + treeItem.getText(n9);
                    if (n9 + 1 < n4) {
                        object2.result = String.valueOf(object2.result) + ", ";
                    }
                    ++n9;
                }
            }
        }
        n5 = 0;
        while (n5 < this.accessibleListeners.size()) {
            object = (AccessibleListener)this.accessibleListeners.elementAt(n5);
            object.getDescription((AccessibleEvent)object2);
            ++n5;
        }
        if (object2.result == null) {
            return n6;
        }
        char[] cArray = (String.valueOf(object2.result) + "\u0000").toCharArray();
        int n10 = COM.SysAllocString(cArray);
        COM.MoveMemory(n3, new int[]{n10}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_accFocus(int n2) {
        Object object;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n3 = -2;
        int n4 = this.iaccessible.get_accFocus(n2);
        if (this.accessibleControlListeners.size() == 0) {
            return n4;
        }
        if (n4 == 0) {
            object = new short[1];
            COM.MoveMemory(object, n2, 2);
            if (object[0] == 3) {
                int[] nArray = new int[1];
                COM.MoveMemory(nArray, n2 + 8, 4);
                n3 = this.osToChildID(nArray[0]);
            }
        }
        object = new AccessibleControlEvent(this);
        object.childID = n3;
        int n5 = 0;
        while (n5 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
            accessibleControlListener.getFocus((AccessibleControlEvent)object);
            ++n5;
        }
        Accessible accessible = object.accessible;
        if (accessible != null) {
            accessible.AddRef();
            COM.MoveMemory(n2, new short[]{9}, 2);
            COM.MoveMemory(n2 + 8, new int[]{accessible.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            return 0;
        }
        int n6 = object.childID;
        if (n6 == -2) {
            COM.MoveMemory(n2, new short[1], 2);
            return 1;
        }
        if (n6 == -1) {
            this.AddRef();
            COM.MoveMemory(n2, new short[]{9}, 2);
            COM.MoveMemory(n2 + 8, new int[]{this.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            return 0;
        }
        COM.MoveMemory(n2, new short[]{3}, 2);
        COM.MoveMemory(n2 + 8, new int[]{this.childIDToOs(n6)}, 4);
        return 0;
    }

    int get_accHelp(int n2, int n3) {
        Object object;
        int n4;
        Object object2;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, n2, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String string = null;
        int n5 = this.iaccessible.get_accHelp(n2, n3);
        if (n5 == -2147024809) {
            n5 = 1;
        }
        if (this.accessibleListeners.size() == 0) {
            return n5;
        }
        if (n5 == 0) {
            object2 = new int[1];
            COM.MoveMemory(object2, n3, OS.PTR_SIZEOF);
            n4 = COM.SysStringByteLen(object2[0]);
            if (n4 > 0) {
                object = new char[(n4 + 1) / 2];
                COM.MoveMemory((char[])object, object2[0], n4);
                string = new String((char[])object);
            }
        }
        object2 = new AccessibleEvent(this);
        object2.childID = this.osToChildID(vARIANT.lVal);
        object2.result = string;
        n4 = 0;
        while (n4 < this.accessibleListeners.size()) {
            object = (AccessibleListener)this.accessibleListeners.elementAt(n4);
            object.getHelp((AccessibleEvent)object2);
            ++n4;
        }
        if (object2.result == null) {
            return n5;
        }
        char[] cArray = (String.valueOf(object2.result) + "\u0000").toCharArray();
        int n6 = COM.SysAllocString(cArray);
        COM.MoveMemory(n3, new int[]{n6}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_accHelpTopic(int n2, int n3, int n4) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n5 = this.iaccessible.get_accHelpTopic(n2, n3, n4);
        if (n5 == -2147024809) {
            n5 = 1;
        }
        return n5;
    }

    int get_accKeyboardShortcut(int n2, int n3) {
        Object object;
        int n4;
        Object object2;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, n2, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String string = null;
        int n5 = this.iaccessible.get_accKeyboardShortcut(n2, n3);
        if (n5 == -2147024809) {
            n5 = 1;
        }
        if (this.accessibleListeners.size() == 0) {
            return n5;
        }
        if (n5 == 0) {
            object2 = new int[1];
            COM.MoveMemory(object2, n3, OS.PTR_SIZEOF);
            n4 = COM.SysStringByteLen(object2[0]);
            if (n4 > 0) {
                object = new char[(n4 + 1) / 2];
                COM.MoveMemory((char[])object, object2[0], n4);
                string = new String((char[])object);
            }
        }
        object2 = new AccessibleEvent(this);
        object2.childID = this.osToChildID(vARIANT.lVal);
        object2.result = string;
        n4 = 0;
        while (n4 < this.accessibleListeners.size()) {
            object = (AccessibleListener)this.accessibleListeners.elementAt(n4);
            object.getKeyboardShortcut((AccessibleEvent)object2);
            ++n4;
        }
        if (object2.result == null) {
            return n5;
        }
        char[] cArray = (String.valueOf(object2.result) + "\u0000").toCharArray();
        int n6 = COM.SysAllocString(cArray);
        COM.MoveMemory(n3, new int[]{n6}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_accName(int n2, int n3) {
        Object object;
        int n4;
        Object object2;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, n2, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String string = null;
        int n5 = this.iaccessible.get_accName(n2, n3);
        if (n5 == -2147024809) {
            n5 = 1;
        }
        if (this.accessibleListeners.size() == 0) {
            return n5;
        }
        if (n5 == 0) {
            object2 = new int[1];
            COM.MoveMemory(object2, n3, OS.PTR_SIZEOF);
            n4 = COM.SysStringByteLen(object2[0]);
            if (n4 > 0) {
                object = new char[(n4 + 1) / 2];
                COM.MoveMemory((char[])object, object2[0], n4);
                string = new String((char[])object);
            }
        }
        object2 = new AccessibleEvent(this);
        object2.childID = this.osToChildID(vARIANT.lVal);
        object2.result = string;
        n4 = 0;
        while (n4 < this.accessibleListeners.size()) {
            object = (AccessibleListener)this.accessibleListeners.elementAt(n4);
            object.getName((AccessibleEvent)object2);
            ++n4;
        }
        if (object2.result == null) {
            return n5;
        }
        char[] cArray = (String.valueOf(object2.result) + "\u0000").toCharArray();
        int n6 = COM.SysAllocString(cArray);
        COM.MoveMemory(n3, new int[]{n6}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_accParent(int n2) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        return this.iaccessible.get_accParent(n2);
    }

    int get_accRole(int n2, int n3) {
        Object object;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, n2, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        int n4 = 10;
        int n5 = this.iaccessible.get_accRole(n2, n3);
        if (n5 == -2147024809) {
            n5 = 1;
        }
        if (this.accessibleControlListeners.size() == 0 && !(this.control instanceof Tree) && !(this.control instanceof Table)) {
            return n5;
        }
        if (n5 == 0) {
            object = new short[1];
            COM.MoveMemory(object, n3, 2);
            if (object[0] == 3) {
                int[] nArray = new int[1];
                COM.MoveMemory(nArray, n3 + 8, 4);
                n4 = nArray[0];
            }
        }
        object = new AccessibleControlEvent(this);
        object.childID = this.osToChildID(vARIANT.lVal);
        object.detail = this.osToRole(n4);
        if (vARIANT.lVal != 0 && (this.control instanceof Tree || this.control instanceof Table) && (this.control.getStyle() & 0x20) != 0) {
            object.detail = 44;
        }
        int n6 = 0;
        while (n6 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n6);
            accessibleControlListener.getRole((AccessibleControlEvent)object);
            ++n6;
        }
        n6 = this.roleToOs(object.detail);
        COM.MoveMemory(n3, new short[]{3}, 2);
        COM.MoveMemory(n3 + 8, new int[]{n6}, 4);
        return 0;
    }

    int get_accSelection(int n2) {
        Object object;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n3 = -2;
        int n4 = this.iaccessible.get_accSelection(n2);
        if (this.accessibleControlListeners.size() == 0) {
            return n4;
        }
        if (n4 == 0) {
            object = new short[1];
            COM.MoveMemory(object, n2, 2);
            if (object[0] == 3) {
                int[] nArray = new int[1];
                COM.MoveMemory(nArray, n2 + 8, 4);
                n3 = this.osToChildID(nArray[0]);
            } else if (object[0] == 13) {
                n3 = -3;
            }
        }
        object = new AccessibleControlEvent(this);
        object.childID = n3;
        int n5 = 0;
        while (n5 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
            accessibleControlListener.getSelection((AccessibleControlEvent)object);
            ++n5;
        }
        Accessible accessible = object.accessible;
        if (accessible != null) {
            accessible.AddRef();
            COM.MoveMemory(n2, new short[]{9}, 2);
            COM.MoveMemory(n2 + 8, new int[]{accessible.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            return 0;
        }
        int n6 = object.childID;
        if (n6 == -2) {
            COM.MoveMemory(n2, new short[1], 2);
            return 1;
        }
        if (n6 == -3) {
            this.AddRef();
            COM.MoveMemory(n2, new short[]{13}, 2);
            COM.MoveMemory(n2 + 8, new int[]{this.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            return 0;
        }
        if (n6 == -1) {
            this.AddRef();
            COM.MoveMemory(n2, new short[]{9}, 2);
            COM.MoveMemory(n2 + 8, new int[]{this.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            return 0;
        }
        COM.MoveMemory(n2, new short[]{3}, 2);
        COM.MoveMemory(n2 + 8, new int[]{this.childIDToOs(n6)}, 4);
        return 0;
    }

    int get_accState(int n2, int n3) {
        Object object;
        Object object2;
        Object object3;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, n2, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        int n4 = 0;
        int n5 = this.iaccessible.get_accState(n2, n3);
        if (n5 == -2147024809) {
            n5 = 1;
        }
        if (this.accessibleControlListeners.size() == 0 && !(this.control instanceof Tree) && !(this.control instanceof Table)) {
            return n5;
        }
        if (n5 == 0) {
            object3 = new short[1];
            COM.MoveMemory(object3, n3, 2);
            if (object3[0] == 3) {
                object2 = new int[1];
                COM.MoveMemory((int[])object2, n3 + 8, 4);
                n4 = object2[0];
            }
        }
        object3 = new AccessibleControlEvent(this);
        object3.childID = this.osToChildID(vARIANT.lVal);
        object3.detail = this.osToState(n4);
        if (vARIANT.lVal != 0) {
            if (this.control instanceof Tree && (this.control.getStyle() & 0x20) != 0) {
                boolean bl2;
                int n6 = this.control.handle;
                object = new TVITEM();
                ((TVITEM)object).mask = 24;
                ((TVITEM)object).stateMask = 61440;
                ((TVITEM)object).hItem = OS.COMCTL32_MAJOR >= 6 ? OS.SendMessage(n6, 4394, vARIANT.lVal, 0) : vARIANT.lVal;
                int n7 = OS.SendMessage(n6, OS.TVM_GETITEM, 0, (TVITEM)object);
                boolean bl3 = bl2 = n7 != 0 && (((TVITEM)object).state >> 12 & 1) == 0;
                if (bl2) {
                    object3.detail |= 0x10;
                }
            } else if (this.control instanceof Table && (this.control.getStyle() & 0x20) != 0 && (object = ((Table)(object2 = (Object)((Table)this.control))).getItem(object3.childID)) != null && ((TableItem)object).getChecked()) {
                object3.detail |= 0x10;
            }
        }
        int n8 = 0;
        while (n8 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n8);
            object.getState((AccessibleControlEvent)object3);
            ++n8;
        }
        n8 = this.stateToOs(object3.detail);
        COM.MoveMemory(n3, new short[]{3}, 2);
        COM.MoveMemory(n3 + 8, new int[]{n8}, 4);
        return 0;
    }

    int get_accValue(int n2, int n3) {
        Object object;
        int n4;
        Object object2;
        if (this.iaccessible == null) {
            return -2147220995;
        }
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, n2, VARIANT.sizeof);
        if ((vARIANT.vt & 0xFFFF) != 3) {
            return -2147024809;
        }
        String string = null;
        int n5 = this.iaccessible.get_accValue(n2, n3);
        if (n5 == -2147024809) {
            n5 = 1;
        }
        if (this.accessibleControlListeners.size() == 0) {
            return n5;
        }
        if (n5 == 0) {
            object2 = new int[1];
            COM.MoveMemory(object2, n3, OS.PTR_SIZEOF);
            n4 = COM.SysStringByteLen(object2[0]);
            if (n4 > 0) {
                object = new char[(n4 + 1) / 2];
                COM.MoveMemory((char[])object, object2[0], n4);
                string = new String((char[])object);
            }
        }
        object2 = new AccessibleControlEvent(this);
        object2.childID = this.osToChildID(vARIANT.lVal);
        object2.result = string;
        n4 = 0;
        while (n4 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n4);
            object.getValue((AccessibleControlEvent)object2);
            ++n4;
        }
        if (object2.result == null) {
            return n5;
        }
        char[] cArray = (String.valueOf(object2.result) + "\u0000").toCharArray();
        int n6 = COM.SysAllocString(cArray);
        COM.MoveMemory(n3, new int[]{n6}, OS.PTR_SIZEOF);
        return 0;
    }

    int put_accName(int n2, int n3) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n4 = this.iaccessible.put_accName(n2, n3);
        if (n4 == -2147024809) {
            n4 = 1;
        }
        return n4;
    }

    int put_accValue(int n2, int n3) {
        if (this.iaccessible == null) {
            return -2147220995;
        }
        int n4 = this.iaccessible.put_accValue(n2, n3);
        if (n4 == -2147024809) {
            n4 = 1;
        }
        return n4;
    }

    int Next(int n2, int n3, int n4) {
        int n5;
        Object object;
        if (this.accessibleControlListeners.size() == 0) {
            int[] nArray = new int[1];
            int n6 = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, nArray);
            if (n6 != 0) {
                return n6;
            }
            IEnumVARIANT iEnumVARIANT = new IEnumVARIANT(nArray[0]);
            int[] nArray2 = new int[1];
            n6 = iEnumVARIANT.Next(n2, n3, nArray2);
            iEnumVARIANT.Release();
            COM.MoveMemory(n4, nArray2, 4);
            return n6;
        }
        if (n3 == 0) {
            return -2147024809;
        }
        if (n4 == 0 && n2 != 1) {
            return -2147024809;
        }
        if (this.enumIndex == 0) {
            object = new AccessibleControlEvent(this);
            object.childID = -1;
            n5 = 0;
            while (n5 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
                accessibleControlListener.getChildren((AccessibleControlEvent)object);
                ++n5;
            }
            this.variants = object.children;
        }
        object = null;
        if (this.variants != null && n2 >= 1) {
            n5 = this.enumIndex + n2 - 1;
            if (n5 > this.variants.length - 1) {
                n5 = this.variants.length - 1;
            }
            if (this.enumIndex <= n5) {
                object = new Object[n5 - this.enumIndex + 1];
                int n7 = 0;
                while (n7 < ((Object[])object).length) {
                    Object object2 = this.variants[this.enumIndex];
                    object[n7] = object2 instanceof Integer ? new Integer(this.childIDToOs((Integer)object2)) : object2;
                    ++this.enumIndex;
                    ++n7;
                }
            }
        }
        if (object != null) {
            n5 = 0;
            while (n5 < ((Object[])object).length) {
                Object object3 = object[n5];
                if (object3 instanceof Integer) {
                    int n8 = (Integer)object3;
                    COM.MoveMemory(n3 + n5 * 16, new short[]{3}, 2);
                    COM.MoveMemory(n3 + n5 * 16 + 8, new int[]{n8}, 4);
                } else {
                    Accessible accessible = (Accessible)object3;
                    accessible.AddRef();
                    COM.MoveMemory(n3 + n5 * 16, new short[]{9}, 2);
                    COM.MoveMemory(n3 + n5 * 16 + 8, new int[]{accessible.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
                }
                ++n5;
            }
            if (n4 != 0) {
                COM.MoveMemory(n4, new int[]{((Object[])object).length}, 4);
            }
            if (((Object[])object).length == n2) {
                return 0;
            }
        } else if (n4 != 0) {
            COM.MoveMemory(n4, new int[1], 4);
        }
        return 1;
    }

    int Skip(int n2) {
        if (this.accessibleControlListeners.size() == 0) {
            int[] nArray = new int[1];
            int n3 = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, nArray);
            if (n3 != 0) {
                return n3;
            }
            IEnumVARIANT iEnumVARIANT = new IEnumVARIANT(nArray[0]);
            n3 = iEnumVARIANT.Skip(n2);
            iEnumVARIANT.Release();
            return n3;
        }
        if (n2 < 1) {
            return -2147024809;
        }
        this.enumIndex += n2;
        if (this.enumIndex > this.variants.length - 1) {
            this.enumIndex = this.variants.length - 1;
            return 1;
        }
        return 0;
    }

    int Reset() {
        if (this.accessibleControlListeners.size() == 0) {
            int[] nArray = new int[1];
            int n2 = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, nArray);
            if (n2 != 0) {
                return n2;
            }
            IEnumVARIANT iEnumVARIANT = new IEnumVARIANT(nArray[0]);
            n2 = iEnumVARIANT.Reset();
            iEnumVARIANT.Release();
            return n2;
        }
        this.enumIndex = 0;
        return 0;
    }

    int Clone(int n2) {
        if (this.accessibleControlListeners.size() == 0) {
            int[] nArray = new int[1];
            int n3 = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, nArray);
            if (n3 != 0) {
                return n3;
            }
            IEnumVARIANT iEnumVARIANT = new IEnumVARIANT(nArray[0]);
            int[] nArray2 = new int[1];
            n3 = iEnumVARIANT.Clone(nArray2);
            iEnumVARIANT.Release();
            COM.MoveMemory(n2, nArray2, 4);
            return n3;
        }
        if (n2 == 0) {
            return -2147024809;
        }
        COM.MoveMemory(n2, new int[]{this.objIEnumVARIANT.getAddress()}, OS.PTR_SIZEOF);
        this.AddRef();
        return 0;
    }

    int childIDToOs(int n2) {
        if (n2 == -1) {
            return 0;
        }
        if (!(this.control instanceof Tree)) {
            return n2 + 1;
        }
        if (OS.COMCTL32_MAJOR < 6) {
            return n2;
        }
        return OS.SendMessage(this.control.handle, 4395, n2, 0);
    }

    int osToChildID(int n2) {
        if (n2 == 0) {
            return -1;
        }
        if (!(this.control instanceof Tree)) {
            return n2 - 1;
        }
        if (OS.COMCTL32_MAJOR < 6) {
            return n2;
        }
        return OS.SendMessage(this.control.handle, 4394, n2, 0);
    }

    int stateToOs(int n2) {
        int n3 = 0;
        if ((n2 & 2) != 0) {
            n3 |= 2;
        }
        if ((n2 & 0x200000) != 0) {
            n3 |= 0x200000;
        }
        if ((n2 & 0x1000000) != 0) {
            n3 |= 0x1000000;
        }
        if ((n2 & 4) != 0) {
            n3 |= 4;
        }
        if ((n2 & 0x100000) != 0) {
            n3 |= 0x100000;
        }
        if ((n2 & 8) != 0) {
            n3 |= 8;
        }
        if ((n2 & 0x10) != 0) {
            n3 |= 0x10;
        }
        if ((n2 & 0x200) != 0) {
            n3 |= 0x200;
        }
        if ((n2 & 0x400) != 0) {
            n3 |= 0x400;
        }
        if ((n2 & 0x80) != 0) {
            n3 |= 0x80;
        }
        if ((n2 & 0x800) != 0) {
            n3 |= 0x800;
        }
        if ((n2 & 0x40) != 0) {
            n3 |= 0x40;
        }
        if ((n2 & 0x8000) != 0) {
            n3 |= 0x8000;
        }
        if ((n2 & 0x10000) != 0) {
            n3 |= 0x10000;
        }
        if ((n2 & 0x20000) != 0) {
            n3 |= 0x20000;
        }
        if ((n2 & 0x400000) != 0) {
            n3 |= 0x400000;
        }
        return n3;
    }

    int osToState(int n2) {
        int n3 = 0;
        if ((n2 & 2) != 0) {
            n3 |= 2;
        }
        if ((n2 & 0x200000) != 0) {
            n3 |= 0x200000;
        }
        if ((n2 & 0x1000000) != 0) {
            n3 |= 0x1000000;
        }
        if ((n2 & 4) != 0) {
            n3 |= 4;
        }
        if ((n2 & 0x100000) != 0) {
            n3 |= 0x100000;
        }
        if ((n2 & 8) != 0) {
            n3 |= 8;
        }
        if ((n2 & 0x10) != 0) {
            n3 |= 0x10;
        }
        if ((n2 & 0x200) != 0) {
            n3 |= 0x200;
        }
        if ((n2 & 0x400) != 0) {
            n3 |= 0x400;
        }
        if ((n2 & 0x80) != 0) {
            n3 |= 0x80;
        }
        if ((n2 & 0x800) != 0) {
            n3 |= 0x800;
        }
        if ((n2 & 0x40) != 0) {
            n3 |= 0x40;
        }
        if ((n2 & 0x8000) != 0) {
            n3 |= 0x8000;
        }
        if ((n2 & 0x10000) != 0) {
            n3 |= 0x10000;
        }
        if ((n2 & 0x20000) != 0) {
            n3 |= 0x20000;
        }
        if ((n2 & 0x400000) != 0) {
            n3 |= 0x400000;
        }
        return n3;
    }

    int roleToOs(int n2) {
        switch (n2) {
            case 10: {
                return 10;
            }
            case 9: {
                return 9;
            }
            case 2: {
                return 2;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 21: {
                return 21;
            }
            case 13: {
                return 13;
            }
            case 3: {
                return 3;
            }
            case 18: {
                return 18;
            }
            case 41: {
                return 41;
            }
            case 43: {
                return 43;
            }
            case 44: {
                return 44;
            }
            case 45: {
                return 45;
            }
            case 46: {
                return 46;
            }
            case 42: {
                return 42;
            }
            case 22: {
                return 22;
            }
            case 33: {
                return 33;
            }
            case 34: {
                return 34;
            }
            case 24: {
                return 24;
            }
            case 29: {
                return 29;
            }
            case 25: {
                return 25;
            }
            case 26: {
                return 26;
            }
            case 35: {
                return 35;
            }
            case 36: {
                return 36;
            }
            case 60: {
                return 60;
            }
            case 37: {
                return 37;
            }
            case 48: {
                return 48;
            }
            case 51: {
                return 51;
            }
            case 30: {
                return 30;
            }
        }
        return 10;
    }

    int osToRole(int n2) {
        switch (n2) {
            case 10: {
                return 10;
            }
            case 9: {
                return 9;
            }
            case 2: {
                return 2;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 21: {
                return 21;
            }
            case 13: {
                return 13;
            }
            case 3: {
                return 3;
            }
            case 18: {
                return 18;
            }
            case 41: {
                return 41;
            }
            case 43: {
                return 43;
            }
            case 44: {
                return 44;
            }
            case 45: {
                return 45;
            }
            case 46: {
                return 46;
            }
            case 42: {
                return 42;
            }
            case 22: {
                return 22;
            }
            case 33: {
                return 33;
            }
            case 34: {
                return 34;
            }
            case 24: {
                return 24;
            }
            case 29: {
                return 29;
            }
            case 25: {
                return 25;
            }
            case 26: {
                return 26;
            }
            case 35: {
                return 35;
            }
            case 36: {
                return 36;
            }
            case 60: {
                return 60;
            }
            case 37: {
                return 37;
            }
            case 48: {
                return 48;
            }
            case 51: {
                return 51;
            }
            case 30: {
                return 30;
            }
        }
        return 10;
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }
}

