/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.LZWCodec;

final class GIFFileFormat
extends FileFormat {
    String signature;
    int screenWidth;
    int screenHeight;
    int backgroundPixel;
    int bitsPerPixel;
    int defaultDepth;
    int disposalMethod = 0;
    int delayTime = 0;
    int transparentPixel = -1;
    int repeatCount = 1;
    static final int GIF_APPLICATION_EXTENSION_BLOCK_ID = 255;
    static final int GIF_GRAPHICS_CONTROL_BLOCK_ID = 249;
    static final int GIF_PLAIN_TEXT_BLOCK_ID = 1;
    static final int GIF_COMMENT_BLOCK_ID = 254;
    static final int GIF_EXTENSION_BLOCK_ID = 33;
    static final int GIF_IMAGE_BLOCK_ID = 44;
    static final int GIF_TRAILER_ID = 59;
    static final byte[] GIF89a = new byte[]{71, 73, 70, 56, 57, 97};
    static final byte[] NETSCAPE2_0 = new byte[]{78, 69, 84, 83, 67, 65, 80, 69, 50, 46, 48};

    GIFFileFormat() {
    }

    static PaletteData grayRamp(int n2) {
        int n3 = n2 - 1;
        RGB[] rGBArray = new RGB[n2];
        int n4 = 0;
        while (n4 < n2) {
            byte by2 = (byte)(n4 * 3 * 256 / n3);
            rGBArray[n4] = new RGB(by2, by2, by2);
            ++n4;
        }
        return new PaletteData(rGBArray);
    }

    boolean isFileFormat(LEDataInputStream lEDataInputStream) {
        try {
            byte[] byArray = new byte[3];
            lEDataInputStream.read(byArray);
            lEDataInputStream.unread(byArray);
            return new String(byArray).equals("GIF");
        }
        catch (Exception exception) {
            return false;
        }
    }

    ImageData[] loadFromByteStream() {
        byte[] byArray = new byte[3];
        byte[] byArray2 = new byte[3];
        byte[] byArray3 = new byte[7];
        try {
            this.inputStream.read(byArray);
            this.signature = new String(byArray);
            if (!this.signature.equals("GIF")) {
                SWT.error(40);
            }
            this.inputStream.read(byArray2);
            this.inputStream.read(byArray3);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        this.loader.logicalScreenWidth = this.screenWidth = byArray3[0] & 0xFF | (byArray3[1] & 0xFF) << 8;
        this.loader.logicalScreenHeight = this.screenHeight = byArray3[2] & 0xFF | (byArray3[3] & 0xFF) << 8;
        byte by2 = byArray3[4];
        this.backgroundPixel = byArray3[5] & 0xFF;
        this.bitsPerPixel = (by2 >> 4 & 7) + 1;
        this.defaultDepth = (by2 & 7) + 1;
        PaletteData paletteData = null;
        if ((by2 & 0x80) != 0) {
            paletteData = this.readPalette(1 << this.defaultDepth);
        } else {
            this.backgroundPixel = -1;
            this.defaultDepth = this.bitsPerPixel;
        }
        this.loader.backgroundPixel = this.backgroundPixel;
        this.getExtensions();
        int n2 = this.readID();
        ImageData[] imageDataArray = new ImageData[]{};
        while (n2 == 44) {
            ImageData imageData = this.readImageBlock(paletteData);
            if (this.loader.hasListeners()) {
                this.loader.notifyListeners(new ImageLoaderEvent(this.loader, imageData, 3, true));
            }
            ImageData[] imageDataArray2 = imageDataArray;
            imageDataArray = new ImageData[imageDataArray2.length + 1];
            System.arraycopy(imageDataArray2, 0, imageDataArray, 0, imageDataArray2.length);
            imageDataArray[imageDataArray.length - 1] = imageData;
            try {
                n2 = this.inputStream.read();
                if (n2 > 0) {
                    this.inputStream.unread(new byte[]{(byte)n2});
                }
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
            this.getExtensions();
            n2 = this.readID();
        }
        return imageDataArray;
    }

    int readID() {
        try {
            return this.inputStream.read();
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
            return -1;
        }
    }

    void getExtensions() {
        int n2 = this.readID();
        while (n2 != 44 && n2 != 59 && n2 > 0) {
            if (n2 == 33) {
                this.readExtension();
            } else {
                SWT.error(40);
            }
            n2 = this.readID();
        }
        if (n2 == 44 || n2 == 59) {
            try {
                this.inputStream.unread(new byte[]{(byte)n2});
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        }
    }

    byte[] readExtension() {
        int n2 = this.readID();
        if (n2 == 254) {
            return this.readCommentExtension();
        }
        if (n2 == 1) {
            return this.readPlainTextExtension();
        }
        if (n2 == 249) {
            return this.readGraphicsControlExtension();
        }
        if (n2 == 255) {
            return this.readApplicationExtension();
        }
        try {
            int n3 = this.inputStream.read();
            if (n3 < 0) {
                SWT.error(40);
            }
            byte[] byArray = new byte[n3];
            this.inputStream.read(byArray, 0, n3);
            return byArray;
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
            return null;
        }
    }

    byte[] readCommentExtension() {
        try {
            byte[] byArray = new byte[]{};
            byte[] byArray2 = new byte[255];
            int n2 = this.inputStream.read();
            while (n2 > 0 && this.inputStream.read(byArray2, 0, n2) != -1) {
                byte[] byArray3 = byArray;
                byArray = new byte[byArray3.length + n2];
                System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
                System.arraycopy(byArray2, 0, byArray, byArray3.length, n2);
                n2 = this.inputStream.read();
            }
            return byArray;
        }
        catch (Exception exception) {
            SWT.error(39, exception);
            return null;
        }
    }

    byte[] readPlainTextExtension() {
        try {
            this.inputStream.read();
            byte[] byArray = new byte[12];
            this.inputStream.read(byArray);
            byte[] byArray2 = new byte[]{};
            byte[] byArray3 = new byte[255];
            int n2 = this.inputStream.read();
            while (n2 > 0 && this.inputStream.read(byArray3, 0, n2) != -1) {
                byte[] byArray4 = byArray2;
                byArray2 = new byte[byArray4.length + n2];
                System.arraycopy(byArray4, 0, byArray2, 0, byArray4.length);
                System.arraycopy(byArray3, 0, byArray2, byArray4.length, n2);
                n2 = this.inputStream.read();
            }
            return byArray2;
        }
        catch (Exception exception) {
            SWT.error(39, exception);
            return null;
        }
    }

    byte[] readGraphicsControlExtension() {
        try {
            this.inputStream.read();
            byte[] byArray = new byte[4];
            this.inputStream.read(byArray);
            byte by2 = byArray[0];
            this.disposalMethod = by2 >> 2 & 7;
            this.delayTime = byArray[1] & 0xFF | (byArray[2] & 0xFF) << 8;
            this.transparentPixel = (by2 & 1) != 0 ? byArray[3] & 0xFF : -1;
            this.inputStream.read();
            return byArray;
        }
        catch (Exception exception) {
            SWT.error(39, exception);
            return null;
        }
    }

    byte[] readApplicationExtension() {
        try {
            this.inputStream.read();
            byte[] byArray = new byte[8];
            this.inputStream.read(byArray);
            String string = new String(byArray);
            byte[] byArray2 = new byte[3];
            this.inputStream.read(byArray2);
            String string2 = new String(byArray2);
            byte[] byArray3 = new byte[]{};
            byte[] byArray4 = new byte[255];
            int n2 = this.inputStream.read();
            while (n2 > 0 && this.inputStream.read(byArray4, 0, n2) != -1) {
                byte[] byArray5 = byArray3;
                byArray3 = new byte[byArray5.length + n2];
                System.arraycopy(byArray5, 0, byArray3, 0, byArray5.length);
                System.arraycopy(byArray4, 0, byArray3, byArray5.length, n2);
                n2 = this.inputStream.read();
            }
            if (string.equals("NETSCAPE") && string2.equals("2.0") && byArray3[0] == 1) {
                this.loader.repeatCount = this.repeatCount = byArray3[1] & 0xFF | (byArray3[2] & 0xFF) << 8;
            }
            return byArray3;
        }
        catch (Exception exception) {
            SWT.error(39, exception);
            return null;
        }
    }

    ImageData readImageBlock(PaletteData paletteData) {
        PaletteData paletteData2;
        int n2;
        boolean bl2;
        byte[] byArray = new byte[9];
        try {
            this.inputStream.read(byArray);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        int n3 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
        int n4 = byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8;
        int n5 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8;
        int n6 = byArray[6] & 0xFF | (byArray[7] & 0xFF) << 8;
        byte by2 = byArray[8];
        boolean bl3 = bl2 = (by2 & 0x40) != 0;
        if ((by2 & 0x80) != 0) {
            n2 = (by2 & 7) + 1;
            paletteData2 = this.readPalette(1 << n2);
        } else {
            n2 = this.defaultDepth;
            paletteData2 = paletteData;
        }
        if (this.transparentPixel > 1 << n2) {
            this.transparentPixel = -1;
        }
        if (n2 != 1 && n2 != 4 && n2 != 8) {
            n2 = n2 < 4 ? 4 : 8;
        }
        if (paletteData2 == null) {
            paletteData2 = GIFFileFormat.grayRamp(1 << n2);
        }
        int n7 = -1;
        try {
            n7 = this.inputStream.read();
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        if (n7 < 0) {
            SWT.error(40);
        }
        ImageData imageData = ImageData.internal_new(n5, n6, n2, paletteData2, 4, null, 0, null, null, -1, this.transparentPixel, 2, n3, n4, this.disposalMethod, this.delayTime);
        LZWCodec lZWCodec = new LZWCodec();
        lZWCodec.decode(this.inputStream, this.loader, imageData, bl2, n7);
        return imageData;
    }

    PaletteData readPalette(int n2) {
        byte[] byArray = new byte[n2 * 3];
        try {
            if (this.inputStream.read(byArray) != byArray.length) {
                SWT.error(40);
            }
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        RGB[] rGBArray = new RGB[n2];
        int n3 = 0;
        while (n3 < n2) {
            rGBArray[n3] = new RGB(byArray[n3 * 3] & 0xFF, byArray[n3 * 3 + 1] & 0xFF, byArray[n3 * 3 + 2] & 0xFF);
            ++n3;
        }
        return new PaletteData(rGBArray);
    }

    void unloadIntoByteStream(ImageLoader imageLoader) {
        int n2;
        ImageData[] imageDataArray = imageLoader.data;
        int n3 = imageDataArray.length;
        boolean bl2 = n3 > 1;
        ImageData imageData = imageDataArray[0];
        int n4 = bl2 ? imageLoader.logicalScreenWidth : imageData.width;
        int n5 = bl2 ? imageLoader.logicalScreenHeight : imageData.height;
        int n6 = imageLoader.backgroundPixel;
        int n7 = imageData.depth;
        PaletteData paletteData = imageData.palette;
        RGB[] rGBArray = paletteData.getRGBs();
        int n8 = 1;
        if (n7 != 1 && n7 != 4 && n7 != 8) {
            SWT.error(38);
        }
        int n9 = 0;
        while (n9 < n3) {
            if (imageDataArray[n9].palette.isDirect) {
                SWT.error(40);
            }
            if (bl2) {
                if (imageDataArray[n9].height > n5 || imageDataArray[n9].width > n4 || imageDataArray[n9].depth != n7) {
                    SWT.error(40);
                }
                if (n8 == 1) {
                    RGB[] rGBArray2 = imageDataArray[n9].palette.getRGBs();
                    if (rGBArray2.length != rGBArray.length) {
                        n8 = 0;
                    } else {
                        n2 = 0;
                        while (n2 < rGBArray.length) {
                            if (rGBArray2[n2].red != rGBArray[n2].red || rGBArray2[n2].green != rGBArray[n2].green || rGBArray2[n2].blue != rGBArray[n2].blue) {
                                n8 = 0;
                            }
                            ++n2;
                        }
                    }
                }
            }
            ++n9;
        }
        try {
            this.outputStream.write(GIF89a);
            n9 = n8 * 128 + (n7 - 1) * 16 + n7 - 1;
            this.outputStream.writeShort((short)n4);
            this.outputStream.writeShort((short)n5);
            this.outputStream.write(n9);
            this.outputStream.write(n6);
            this.outputStream.write(0);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        if (n8 == 1) {
            this.writePalette(paletteData, n7);
        }
        if (bl2) {
            int n10 = imageLoader.repeatCount;
            try {
                this.outputStream.write(33);
                this.outputStream.write(255);
                this.outputStream.write(NETSCAPE2_0.length);
                this.outputStream.write(NETSCAPE2_0);
                this.outputStream.write(3);
                this.outputStream.write(1);
                this.outputStream.writeShort((short)n10);
                this.outputStream.write(0);
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        }
        int n11 = 0;
        while (n11 < n3) {
            if (bl2 || imageDataArray[n11].transparentPixel != -1) {
                this.writeGraphicsControlBlock(imageDataArray[n11]);
            }
            int n12 = imageDataArray[n11].x;
            n2 = imageDataArray[n11].y;
            int n13 = imageDataArray[n11].width;
            int n14 = imageDataArray[n11].height;
            try {
                this.outputStream.write(44);
                byte[] byArray = new byte[]{(byte)(n12 & 0xFF), (byte)(n12 >> 8 & 0xFF), (byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n13 & 0xFF), (byte)(n13 >> 8 & 0xFF), (byte)(n14 & 0xFF), (byte)(n14 >> 8 & 0xFF), (byte)(n8 == 0 ? n7 - 1 | 0x80 : 0)};
                this.outputStream.write(byArray);
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
            if (n8 == 0) {
                this.writePalette(imageDataArray[n11].palette, n7);
            }
            try {
                this.outputStream.write(n7);
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
            new LZWCodec().encode(this.outputStream, imageDataArray[n11]);
            ++n11;
        }
        try {
            this.outputStream.write(59);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }

    void writeGraphicsControlBlock(ImageData imageData) {
        try {
            this.outputStream.write(33);
            this.outputStream.write(249);
            byte[] byArray = new byte[]{0, 0, 0, 0};
            if (imageData.transparentPixel != -1) {
                byArray[0] = 1;
                byArray[3] = (byte)imageData.transparentPixel;
            }
            if (imageData.disposalMethod != 0) {
                byArray[0] = (byte)(byArray[0] | (byte)((imageData.disposalMethod & 7) << 2));
            }
            if (imageData.delayTime != 0) {
                byArray[1] = (byte)(imageData.delayTime & 0xFF);
                byArray[2] = (byte)(imageData.delayTime >> 8 & 0xFF);
            }
            this.outputStream.write((byte)byArray.length);
            this.outputStream.write(byArray);
            this.outputStream.write(0);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }

    void writePalette(PaletteData paletteData, int n2) {
        byte[] byArray = new byte[(1 << n2) * 3];
        int n3 = 0;
        int n4 = 0;
        while (n4 < paletteData.colors.length) {
            RGB rGB = paletteData.colors[n4];
            byArray[n3] = (byte)rGB.red;
            byArray[n3 + 1] = (byte)rGB.green;
            byArray[n3 + 2] = (byte)rGB.blue;
            n3 += 3;
            ++n4;
        }
        try {
            this.outputStream.write(byArray);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }
}

