/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public final class FormLayout
extends Layout {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int marginLeft = 0;
    public int marginTop = 0;
    public int marginRight = 0;
    public int marginBottom = 0;
    public int spacing = 0;

    int computeHeight(Control control, FormData formData, boolean bl2) {
        FormAttachment formAttachment = formData.getTopAttachment(control, this.spacing, bl2);
        FormAttachment formAttachment2 = formData.getBottomAttachment(control, this.spacing, bl2);
        FormAttachment formAttachment3 = formAttachment2.minus(formAttachment);
        if (formAttachment3.numerator == 0) {
            if (formAttachment2.numerator == 0) {
                return formAttachment2.offset;
            }
            if (formAttachment2.numerator == formAttachment2.denominator) {
                return -formAttachment.offset;
            }
            if (formAttachment2.offset <= 0) {
                return -formAttachment.offset * formAttachment.denominator / formAttachment2.numerator;
            }
            int n2 = formAttachment2.denominator - formAttachment2.numerator;
            return formAttachment2.denominator * formAttachment2.offset / n2;
        }
        return formAttachment3.solveY(formData.getHeight(control, bl2));
    }

    protected Point computeSize(Composite composite, int n2, int n3, boolean bl2) {
        Point point = this.layout(composite, false, 0, 0, n2, n3, bl2);
        if (n2 != -1) {
            point.x = n2;
        }
        if (n3 != -1) {
            point.y = n3;
        }
        return point;
    }

    protected boolean flushCache(Control control) {
        Object object = control.getLayoutData();
        if (object != null) {
            ((FormData)object).flushCache();
        }
        return true;
    }

    String getName() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1, string.length());
    }

    int computeWidth(Control control, FormData formData, boolean bl2) {
        FormAttachment formAttachment = formData.getLeftAttachment(control, this.spacing, bl2);
        FormAttachment formAttachment2 = formData.getRightAttachment(control, this.spacing, bl2);
        FormAttachment formAttachment3 = formAttachment2.minus(formAttachment);
        if (formAttachment3.numerator == 0) {
            if (formAttachment2.numerator == 0) {
                return formAttachment2.offset;
            }
            if (formAttachment2.numerator == formAttachment2.denominator) {
                return -formAttachment.offset;
            }
            if (formAttachment2.offset <= 0) {
                return -formAttachment.offset * formAttachment.denominator / formAttachment.numerator;
            }
            int n2 = formAttachment2.denominator - formAttachment2.numerator;
            return formAttachment2.denominator * formAttachment2.offset / n2;
        }
        return formAttachment3.solveY(formData.getWidth(control, bl2));
    }

    protected void layout(Composite composite, boolean bl2) {
        Rectangle rectangle = composite.getClientArea();
        int n2 = rectangle.x + this.marginLeft + this.marginWidth;
        int n3 = rectangle.y + this.marginTop + this.marginHeight;
        int n4 = Math.max(0, rectangle.width - this.marginLeft - 2 * this.marginWidth - this.marginRight);
        int n5 = Math.max(0, rectangle.height - this.marginTop - 2 * this.marginHeight - this.marginBottom);
        this.layout(composite, true, n2, n3, n4, n5, bl2);
    }

    Point layout(Composite composite, boolean bl2, int n2, int n3, int n4, int n5, boolean bl3) {
        FormData formData;
        Control control;
        Rectangle[] rectangleArray;
        Control[] controlArray = composite.getChildren();
        int n6 = 0;
        while (n6 < controlArray.length) {
            rectangleArray = controlArray[n6];
            FormData formData2 = (FormData)rectangleArray.getLayoutData();
            if (formData2 == null) {
                formData2 = new FormData();
                rectangleArray.setLayoutData(formData2);
            }
            if (bl3) {
                formData2.flushCache();
            }
            formData2.cacheBottom = null;
            formData2.cacheTop = null;
            formData2.cacheRight = null;
            formData2.cacheLeft = null;
            ++n6;
        }
        boolean[] blArray = null;
        rectangleArray = null;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < controlArray.length) {
            control = controlArray[n9];
            formData = (FormData)control.getLayoutData();
            if (n4 != -1) {
                formData.needed = false;
                FormAttachment formAttachment = formData.getLeftAttachment(control, this.spacing, bl3);
                FormAttachment formAttachment2 = formData.getRightAttachment(control, this.spacing, bl3);
                int n10 = formAttachment.solveX(n4);
                int n11 = formAttachment2.solveX(n4);
                if (formData.height == -1 && !formData.needed) {
                    int n12 = 0;
                    if (control instanceof Scrollable) {
                        Rectangle rectangle = ((Scrollable)control).computeTrim(0, 0, 0, 0);
                        n12 = rectangle.width;
                    } else {
                        n12 = control.getBorderWidth() * 2;
                    }
                    formData.cacheHeight = -1;
                    formData.cacheWidth = -1;
                    int n13 = Math.max(0, n11 - n10 - n12);
                    formData.computeSize(control, n13, formData.height, bl3);
                    if (blArray == null) {
                        blArray = new boolean[controlArray.length];
                    }
                    blArray[n9] = true;
                }
                n7 = Math.max(n11, n7);
                if (bl2) {
                    if (rectangleArray == null) {
                        rectangleArray = new Rectangle[controlArray.length];
                    }
                    rectangleArray[n9] = new Rectangle(0, 0, 0, 0);
                    rectangleArray[n9].x = n2 + n10;
                    rectangleArray[n9].width = n11 - n10;
                }
            } else {
                n7 = Math.max(this.computeWidth(control, formData, bl3), n7);
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < controlArray.length) {
            control = controlArray[n9];
            formData = (FormData)control.getLayoutData();
            if (n5 != -1) {
                int n14 = formData.getTopAttachment(control, this.spacing, bl3).solveX(n5);
                int n15 = formData.getBottomAttachment(control, this.spacing, bl3).solveX(n5);
                n8 = Math.max(n15, n8);
                if (bl2) {
                    rectangleArray[n9].y = n3 + n14;
                    rectangleArray[n9].height = n15 - n14;
                }
            } else {
                n8 = Math.max(this.computeHeight(control, formData, bl3), n8);
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < controlArray.length) {
            control = controlArray[n9];
            formData = (FormData)control.getLayoutData();
            if (blArray != null && blArray[n9]) {
                formData.cacheHeight = -1;
                formData.cacheWidth = -1;
            }
            formData.cacheBottom = null;
            formData.cacheTop = null;
            formData.cacheRight = null;
            formData.cacheLeft = null;
            ++n9;
        }
        if (bl2) {
            n9 = 0;
            while (n9 < controlArray.length) {
                controlArray[n9].setBounds(rectangleArray[n9]);
                ++n9;
            }
        }
        return new Point(n7 += this.marginLeft + this.marginWidth * 2 + this.marginRight, n8 += this.marginTop + this.marginHeight * 2 + this.marginBottom);
    }

    public String toString() {
        String string = String.valueOf(this.getName()) + " {";
        if (this.marginWidth != 0) {
            string = String.valueOf(string) + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = String.valueOf(string) + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.marginLeft != 0) {
            string = String.valueOf(string) + "marginLeft=" + this.marginLeft + " ";
        }
        if (this.marginRight != 0) {
            string = String.valueOf(string) + "marginRight=" + this.marginRight + " ";
        }
        if (this.marginTop != 0) {
            string = String.valueOf(string) + "marginTop=" + this.marginTop + " ";
        }
        if (this.marginBottom != 0) {
            string = String.valueOf(string) + "marginBottom=" + this.marginBottom + " ";
        }
        if (this.spacing != 0) {
            string = String.valueOf(string) + "spacing=" + this.spacing + " ";
        }
        string = string.trim();
        string = String.valueOf(string) + "}";
        return string;
    }
}

