/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleListener;

class OleEventTable {
    int[] types;
    OleListener[] handlers;

    OleEventTable() {
    }

    void hook(int n2, OleListener oleListener) {
        if (this.types == null) {
            this.types = new int[4];
        }
        if (this.handlers == null) {
            this.handlers = new OleListener[4];
        }
        int n3 = 0;
        while (n3 < this.types.length) {
            if (this.types[n3] == 0) {
                this.types[n3] = n2;
                this.handlers[n3] = oleListener;
                return;
            }
            ++n3;
        }
        n3 = this.types.length;
        int[] nArray = new int[n3 + 4];
        OleListener[] oleListenerArray = new OleListener[n3 + 4];
        System.arraycopy(this.types, 0, nArray, 0, n3);
        System.arraycopy(this.handlers, 0, oleListenerArray, 0, n3);
        this.types = nArray;
        this.handlers = oleListenerArray;
        this.types[n3] = n2;
        this.handlers[n3] = oleListener;
    }

    boolean hooks(int n2) {
        if (this.handlers == null) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.types.length) {
            if (this.types[n3] == n2) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    void sendEvent(OleEvent oleEvent) {
        if (this.handlers == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.types.length) {
            OleListener oleListener;
            if (this.types[n2] == oleEvent.type && (oleListener = this.handlers[n2]) != null) {
                oleListener.handleEvent(oleEvent);
            }
            ++n2;
        }
    }

    void unhook(int n2, OleListener oleListener) {
        if (this.handlers == null) {
            return;
        }
        int n3 = 0;
        while (n3 < this.types.length) {
            if (this.types[n3] == n2 && this.handlers[n3] == oleListener) {
                this.types[n3] = 0;
                this.handlers[n3] = null;
                return;
            }
            ++n3;
        }
    }

    boolean hasEntries() {
        int n2 = 0;
        while (n2 < this.types.length) {
            if (this.types[n2] != 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

