/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.AdobeMarkerSegment;
import com.sun.imageio.plugins.jpeg.COMMarkerSegment;
import com.sun.imageio.plugins.jpeg.DHTMarkerSegment;
import com.sun.imageio.plugins.jpeg.DQTMarkerSegment;
import com.sun.imageio.plugins.jpeg.DRIMarkerSegment;
import com.sun.imageio.plugins.jpeg.JFIFMarkerSegment;
import com.sun.imageio.plugins.jpeg.JPEG;
import com.sun.imageio.plugins.jpeg.JPEGBuffer;
import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import com.sun.imageio.plugins.jpeg.JPEGImageWriter;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import com.sun.imageio.plugins.jpeg.SOFMarkerSegment;
import com.sun.imageio.plugins.jpeg.SOSMarkerSegment;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JPEGMetadata
extends IIOMetadata
implements Cloneable {
    private static final boolean debug = false;
    private List resetSequence;
    private boolean inThumb;
    private boolean hasAlpha;
    List markerSequence;
    final boolean isStream;
    private boolean transparencyDone;

    private int countScanBands() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.markerSequence.iterator();
        while (iterator.hasNext()) {
            MarkerSegment markerSegment = (MarkerSegment)iterator.next();
            if (!(markerSegment instanceof SOSMarkerSegment)) continue;
            SOSMarkerSegment sOSMarkerSegment = (SOSMarkerSegment)markerSegment;
            SOSMarkerSegment.ScanComponentSpec[] scanComponentSpecArray = sOSMarkerSegment.componentSpecs;
            for (int i2 = 0; i2 < scanComponentSpecArray.length; ++i2) {
                Integer n2 = new Integer(scanComponentSpecArray[i2].componentSelector);
                if (arrayList.contains(n2)) continue;
                arrayList.add(n2);
            }
        }
        return arrayList.size();
    }

    private int findLastUnknownMarkerSegmentPosition() {
        ListIterator listIterator = this.markerSequence.listIterator(this.markerSequence.size());
        int n2 = this.markerSequence.size() - 1;
        while (listIterator.hasPrevious()) {
            MarkerSegment markerSegment = (MarkerSegment)listIterator.previous();
            if (markerSegment.unknown) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public void print() {
        for (int i2 = 0; i2 < this.markerSequence.size(); ++i2) {
            MarkerSegment markerSegment = (MarkerSegment)this.markerSequence.get(i2);
            markerSegment.print();
        }
    }

    public void reset() {
        if (this.resetSequence != null) {
            this.markerSequence = this.resetSequence;
            this.resetSequence = null;
            System.gc();
        }
    }

    private boolean isConsistent() {
        SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
        JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
        AdobeMarkerSegment adobeMarkerSegment = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
        boolean bl2 = true;
        if (!this.isStream) {
            if (sOFMarkerSegment != null) {
                int n2 = sOFMarkerSegment.componentSpecs.length;
                int n3 = this.countScanBands();
                if (n3 != 0 && n3 != n2) {
                    bl2 = false;
                }
                if (jFIFMarkerSegment != null) {
                    if (n2 != 1 && n2 != 3) {
                        bl2 = false;
                    }
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (sOFMarkerSegment.componentSpecs[i2].componentId == i2 + 1) continue;
                        bl2 = false;
                    }
                    if (adobeMarkerSegment != null && (n2 == 1 && adobeMarkerSegment.transform != 0 || n2 == 3 && adobeMarkerSegment.transform != 1)) {
                        bl2 = false;
                    }
                }
            } else {
                SOSMarkerSegment sOSMarkerSegment = (SOSMarkerSegment)this.findMarkerSegment(SOSMarkerSegment.class, true);
                if (jFIFMarkerSegment != null || adobeMarkerSegment != null || sOFMarkerSegment != null || sOSMarkerSegment != null) {
                    bl2 = false;
                }
            }
        }
        return bl2;
    }

    public boolean isReadOnly() {
        return false;
    }

    JPEGMetadata(boolean bl2, boolean bl3) {
        super(true, "javax_imageio_jpeg_image_1.0", "com.sun.imageio.plugins.jpeg.JPEGImageMetadataFormat", null, null);
        this.resetSequence = null;
        this.inThumb = false;
        this.markerSequence = new ArrayList();
        this.inThumb = bl3;
        this.isStream = bl2;
        if (bl2) {
            this.nativeMetadataFormatName = "javax_imageio_jpeg_stream_1.0";
            this.nativeMetadataFormatClassName = "com.sun.imageio.plugins.jpeg.JPEGStreamMetadataFormat";
        }
    }

    private void insertAdobeMarkerSegment(AdobeMarkerSegment adobeMarkerSegment) {
        boolean bl2 = this.findMarkerSegment(JFIFMarkerSegment.class, true) != null;
        int n2 = this.findLastUnknownMarkerSegmentPosition();
        if (bl2) {
            this.markerSequence.add(1, adobeMarkerSegment);
        } else if (n2 != -1) {
            this.markerSequence.add(n2 + 1, adobeMarkerSegment);
        } else {
            this.markerSequence.add(0, adobeMarkerSegment);
        }
    }

    private void insertCOMMarkerSegment(COMMarkerSegment cOMMarkerSegment) {
        int n2 = this.findMarkerSegmentPosition(COMMarkerSegment.class, false);
        boolean bl2 = this.findMarkerSegment(JFIFMarkerSegment.class, true) != null;
        int n3 = this.findMarkerSegmentPosition(AdobeMarkerSegment.class, true);
        if (n2 != -1) {
            this.markerSequence.add(n2 + 1, cOMMarkerSegment);
        } else if (bl2) {
            this.markerSequence.add(1, cOMMarkerSegment);
        } else if (n3 != -1) {
            this.markerSequence.add(n3 + 1, cOMMarkerSegment);
        } else {
            this.markerSequence.add(0, cOMMarkerSegment);
        }
    }

    MarkerSegment findMarkerSegment(int n2) {
        Iterator iterator = this.markerSequence.iterator();
        while (iterator.hasNext()) {
            MarkerSegment markerSegment = (MarkerSegment)iterator.next();
            if (markerSegment.tag != n2) continue;
            return markerSegment;
        }
        return null;
    }

    private static Point findIntegerRatio(float f2) {
        float f3 = 0.005f;
        if ((f2 = Math.abs(f2)) <= f3) {
            return new Point(1, 255);
        }
        if (f2 >= 255.0f) {
            return new Point(255, 1);
        }
        boolean bl2 = false;
        if ((double)f2 < 1.0) {
            f2 = 1.0f / f2;
            bl2 = true;
        }
        int n2 = 1;
        int n3 = Math.round(f2);
        float f4 = n3;
        float f5 = Math.abs(f2 - f4);
        while (f5 > f3) {
            n3 = Math.round((float)(++n2) * f2);
            f4 = (float)n3 / (float)n2;
            f5 = Math.abs(f2 - f4);
        }
        return bl2 ? new Point(n2, n3) : new Point(n3, n2);
    }

    private int findMarkerSegmentPosition(Class clazz, boolean bl2) {
        if (bl2) {
            ListIterator listIterator = this.markerSequence.listIterator();
            int n2 = 0;
            while (listIterator.hasNext()) {
                MarkerSegment markerSegment = (MarkerSegment)listIterator.next();
                if (clazz.isInstance(markerSegment)) {
                    return n2;
                }
                ++n2;
            }
        } else {
            ListIterator listIterator = this.markerSequence.listIterator(this.markerSequence.size());
            int n3 = this.markerSequence.size() - 1;
            while (listIterator.hasPrevious()) {
                MarkerSegment markerSegment = (MarkerSegment)listIterator.previous();
                if (clazz.isInstance(markerSegment)) {
                    return n3;
                }
                --n3;
            }
        }
        return -1;
    }

    protected Object clone() {
        JPEGMetadata jPEGMetadata = null;
        try {
            jPEGMetadata = (JPEGMetadata)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.markerSequence != null) {
            jPEGMetadata.markerSequence = this.cloneSequence();
        }
        jPEGMetadata.resetSequence = null;
        return jPEGMetadata;
    }

    private List cloneSequence() {
        if (this.markerSequence == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(this.markerSequence.size());
        Iterator iterator = this.markerSequence.iterator();
        while (iterator.hasNext()) {
            MarkerSegment markerSegment = (MarkerSegment)iterator.next();
            arrayList.add(markerSegment.clone());
        }
        return arrayList;
    }

    IIOMetadataNode getNativeTree() {
        Object object;
        IIOMetadataNode iIOMetadataNode;
        IIOMetadataNode iIOMetadataNode2;
        Iterator iterator = this.markerSequence.iterator();
        if (this.isStream) {
            iIOMetadataNode = iIOMetadataNode2 = new IIOMetadataNode("javax_imageio_jpeg_stream_1.0");
        } else {
            object = new IIOMetadataNode("markerSequence");
            if (!this.inThumb) {
                iIOMetadataNode2 = new IIOMetadataNode("javax_imageio_jpeg_image_1.0");
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("JPEGvariety");
                iIOMetadataNode2.appendChild(iIOMetadataNode3);
                JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
                if (jFIFMarkerSegment != null) {
                    iterator.next();
                    iIOMetadataNode3.appendChild(jFIFMarkerSegment.getNativeNode());
                }
                iIOMetadataNode2.appendChild((Node)object);
            } else {
                iIOMetadataNode2 = object;
            }
            iIOMetadataNode = object;
        }
        while (iterator.hasNext()) {
            object = (MarkerSegment)iterator.next();
            iIOMetadataNode.appendChild(((MarkerSegment)object).getNativeNode());
        }
        return iIOMetadataNode2;
    }

    protected IIOMetadataNode getStandardChromaNode() {
        int n2;
        int n3;
        this.hasAlpha = false;
        SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
        if (sOFMarkerSegment == null) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        int n4 = sOFMarkerSegment.componentSpecs.length;
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("NumChannels");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        iIOMetadataNode3.setAttribute("value", Integer.toString(n4));
        if (this.findMarkerSegment(JFIFMarkerSegment.class, true) != null) {
            if (n4 == 1) {
                iIOMetadataNode2.setAttribute("name", "GRAY");
            } else {
                iIOMetadataNode2.setAttribute("name", "YCbCr");
            }
            return iIOMetadataNode;
        }
        AdobeMarkerSegment adobeMarkerSegment = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
        if (adobeMarkerSegment != null) {
            switch (adobeMarkerSegment.transform) {
                case 2: {
                    iIOMetadataNode2.setAttribute("name", "YCCK");
                    break;
                }
                case 1: {
                    iIOMetadataNode2.setAttribute("name", "YCbCr");
                    break;
                }
                case 0: {
                    if (n4 == 3) {
                        iIOMetadataNode2.setAttribute("name", "RGB");
                        break;
                    }
                    if (n4 != 4) break;
                    iIOMetadataNode2.setAttribute("name", "CMYK");
                }
            }
            return iIOMetadataNode;
        }
        if (n4 < 3) {
            iIOMetadataNode2.setAttribute("name", "GRAY");
            if (n4 == 2) {
                this.hasAlpha = true;
            }
            return iIOMetadataNode;
        }
        boolean bl2 = true;
        for (n3 = 0; n3 < sOFMarkerSegment.componentSpecs.length; ++n3) {
            n2 = sOFMarkerSegment.componentSpecs[n3].componentId;
            if (n2 >= 1 && n2 < sOFMarkerSegment.componentSpecs.length) continue;
            bl2 = false;
        }
        if (bl2) {
            iIOMetadataNode2.setAttribute("name", "YCbCr");
            if (n4 == 4) {
                this.hasAlpha = true;
            }
            return iIOMetadataNode;
        }
        if (sOFMarkerSegment.componentSpecs[0].componentId == 82 && sOFMarkerSegment.componentSpecs[1].componentId == 71 && sOFMarkerSegment.componentSpecs[2].componentId == 66) {
            iIOMetadataNode2.setAttribute("name", "RGB");
            if (n4 == 4 && sOFMarkerSegment.componentSpecs[3].componentId == 65) {
                this.hasAlpha = true;
            }
            return iIOMetadataNode;
        }
        if (sOFMarkerSegment.componentSpecs[0].componentId == 89 && sOFMarkerSegment.componentSpecs[1].componentId == 67 && sOFMarkerSegment.componentSpecs[2].componentId == 99) {
            iIOMetadataNode2.setAttribute("name", "PhotoYCC");
            if (n4 == 4 && sOFMarkerSegment.componentSpecs[3].componentId == 65) {
                this.hasAlpha = true;
            }
            return iIOMetadataNode;
        }
        n3 = 0;
        n2 = sOFMarkerSegment.componentSpecs[0].HsamplingFactor;
        int n5 = sOFMarkerSegment.componentSpecs[0].VsamplingFactor;
        for (int i2 = 1; i2 < sOFMarkerSegment.componentSpecs.length; ++i2) {
            if (sOFMarkerSegment.componentSpecs[i2].HsamplingFactor == n2 && sOFMarkerSegment.componentSpecs[i2].VsamplingFactor == n5) continue;
            n3 = 1;
            break;
        }
        if (n3 != 0) {
            iIOMetadataNode2.setAttribute("name", "YCbCr");
            if (n4 == 4) {
                this.hasAlpha = true;
            }
            return iIOMetadataNode;
        }
        if (n4 == 3) {
            iIOMetadataNode2.setAttribute("name", "RGB");
        } else {
            iIOMetadataNode2.setAttribute("name", "CMYK");
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardCompressionNode() {
        Object object;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
        iIOMetadataNode2.setAttribute("value", "JPEG");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("Lossless");
        iIOMetadataNode3.setAttribute("value", "false");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        int n2 = 0;
        Iterator iterator = this.markerSequence.iterator();
        while (iterator.hasNext()) {
            object = (MarkerSegment)iterator.next();
            if (((MarkerSegment)object).tag != 218) continue;
            ++n2;
        }
        if (n2 != 0) {
            object = new IIOMetadataNode("NumProgressiveScans");
            ((IIOMetadataNode)object).setAttribute("value", Integer.toString(n2));
            iIOMetadataNode.appendChild((Node)object);
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
        if (jFIFMarkerSegment != null) {
            float f2 = jFIFMarkerSegment.resUnits == 0 ? (float)jFIFMarkerSegment.Xdensity / (float)jFIFMarkerSegment.Ydensity : (float)jFIFMarkerSegment.Ydensity / (float)jFIFMarkerSegment.Xdensity;
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("PixelAspectRatio");
            iIOMetadataNode3.setAttribute("value", Float.toString(f2));
            iIOMetadataNode.insertBefore(iIOMetadataNode3, iIOMetadataNode2);
            if (jFIFMarkerSegment.resUnits != 0) {
                float f3 = jFIFMarkerSegment.resUnits == 1 ? 25.4f : 10.0f;
                IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("HorizontalPixelSize");
                iIOMetadataNode4.setAttribute("value", Float.toString(f3 / (float)jFIFMarkerSegment.Xdensity));
                iIOMetadataNode.appendChild(iIOMetadataNode4);
                IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("VerticalPixelSize");
                iIOMetadataNode5.setAttribute("value", Float.toString(f3 / (float)jFIFMarkerSegment.Ydensity));
                iIOMetadataNode.appendChild(iIOMetadataNode5);
            }
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardTextNode() {
        IIOMetadataNode iIOMetadataNode = null;
        if (this.findMarkerSegment(254) != null) {
            iIOMetadataNode = new IIOMetadataNode("Text");
            Iterator iterator = this.markerSequence.iterator();
            while (iterator.hasNext()) {
                MarkerSegment markerSegment = (MarkerSegment)iterator.next();
                if (markerSegment.tag != 254) continue;
                COMMarkerSegment cOMMarkerSegment = (COMMarkerSegment)markerSegment;
                IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
                iIOMetadataNode2.setAttribute("keyword", "comment");
                iIOMetadataNode2.setAttribute("value", cOMMarkerSegment.getComment());
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode = null;
        if (this.hasAlpha) {
            iIOMetadataNode = new IIOMetadataNode("Transparency");
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Alpha");
            iIOMetadataNode2.setAttribute("value", "nonpremultiplied");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    private void mergeAdobeNode(Node node) throws IIOInvalidTreeException {
        AdobeMarkerSegment adobeMarkerSegment = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
        if (adobeMarkerSegment != null) {
            adobeMarkerSegment.updateFromNativeNode(node, false);
        } else {
            AdobeMarkerSegment adobeMarkerSegment2 = new AdobeMarkerSegment(node);
            this.insertAdobeMarkerSegment(adobeMarkerSegment2);
        }
    }

    private void mergeCOMNode(Node node) throws IIOInvalidTreeException {
        COMMarkerSegment cOMMarkerSegment = new COMMarkerSegment(node);
        this.insertCOMMarkerSegment(cOMMarkerSegment);
    }

    private void mergeDHTNode(Node node) throws IIOInvalidTreeException {
        Object object;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.markerSequence.iterator();
        while (iterator.hasNext()) {
            object = (MarkerSegment)iterator.next();
            if (!(object instanceof DHTMarkerSegment)) continue;
            arrayList.add(object);
        }
        if (!arrayList.isEmpty()) {
            object = node.getChildNodes();
            for (int i2 = 0; i2 < object.getLength(); ++i2) {
                Node node2 = object.item(i2);
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n2 = MarkerSegment.getAttributeValue(node2, namedNodeMap, "htableId", 0, 3, true);
                int n3 = MarkerSegment.getAttributeValue(node2, namedNodeMap, "class", 0, 1, true);
                DHTMarkerSegment dHTMarkerSegment = null;
                int n4 = -1;
                for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                    DHTMarkerSegment dHTMarkerSegment2 = (DHTMarkerSegment)arrayList.get(i3);
                    for (int i4 = 0; i4 < dHTMarkerSegment2.tables.size(); ++i4) {
                        DHTMarkerSegment.Htable htable = (DHTMarkerSegment.Htable)dHTMarkerSegment2.tables.get(i4);
                        if (n2 != htable.tableID || n3 != htable.tableClass) continue;
                        dHTMarkerSegment = dHTMarkerSegment2;
                        n4 = i4;
                        break;
                    }
                    if (dHTMarkerSegment != null) break;
                }
                if (dHTMarkerSegment != null) {
                    dHTMarkerSegment.tables.set(n4, dHTMarkerSegment.getHtableFromNode(node2));
                    continue;
                }
                dHTMarkerSegment = (DHTMarkerSegment)arrayList.get(arrayList.size() - 1);
                dHTMarkerSegment.tables.add(dHTMarkerSegment.getHtableFromNode(node2));
            }
        } else {
            object = new DHTMarkerSegment(node);
            int n5 = this.findMarkerSegmentPosition(DQTMarkerSegment.class, false);
            int n6 = this.findMarkerSegmentPosition(SOFMarkerSegment.class, true);
            int n7 = this.findMarkerSegmentPosition(SOSMarkerSegment.class, true);
            if (n5 != -1) {
                this.markerSequence.add(n5 + 1, object);
            } else if (n6 != -1) {
                this.markerSequence.add(n6, object);
            } else if (n7 != -1) {
                this.markerSequence.add(n7, object);
            } else {
                this.markerSequence.add(object);
            }
        }
    }

    private void mergeDQTNode(Node node) throws IIOInvalidTreeException {
        Object object;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.markerSequence.iterator();
        while (iterator.hasNext()) {
            object = (MarkerSegment)iterator.next();
            if (!(object instanceof DQTMarkerSegment)) continue;
            arrayList.add(object);
        }
        if (!arrayList.isEmpty()) {
            object = node.getChildNodes();
            for (int i2 = 0; i2 < object.getLength(); ++i2) {
                Node node2 = object.item(i2);
                int n2 = MarkerSegment.getAttributeValue(node2, null, "qtableId", 0, 3, true);
                DQTMarkerSegment dQTMarkerSegment = null;
                int n3 = -1;
                for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                    DQTMarkerSegment dQTMarkerSegment2 = (DQTMarkerSegment)arrayList.get(i3);
                    for (int i4 = 0; i4 < dQTMarkerSegment2.tables.size(); ++i4) {
                        DQTMarkerSegment.Qtable qtable = (DQTMarkerSegment.Qtable)dQTMarkerSegment2.tables.get(i4);
                        if (n2 != qtable.tableID) continue;
                        dQTMarkerSegment = dQTMarkerSegment2;
                        n3 = i4;
                        break;
                    }
                    if (dQTMarkerSegment != null) break;
                }
                if (dQTMarkerSegment != null) {
                    dQTMarkerSegment.tables.set(n3, dQTMarkerSegment.getQtableFromNode(node2));
                    continue;
                }
                dQTMarkerSegment = (DQTMarkerSegment)arrayList.get(arrayList.size() - 1);
                dQTMarkerSegment.tables.add(dQTMarkerSegment.getQtableFromNode(node2));
            }
        } else {
            object = new DQTMarkerSegment(node);
            int n4 = this.findMarkerSegmentPosition(DHTMarkerSegment.class, true);
            int n5 = this.findMarkerSegmentPosition(SOFMarkerSegment.class, true);
            int n6 = this.findMarkerSegmentPosition(SOSMarkerSegment.class, true);
            if (n4 != -1) {
                this.markerSequence.add(n4, object);
            } else if (n5 != -1) {
                this.markerSequence.add(n5, object);
            } else if (n6 != -1) {
                this.markerSequence.add(n6, object);
            } else {
                this.markerSequence.add(object);
            }
        }
    }

    private void mergeDRINode(Node node) throws IIOInvalidTreeException {
        DRIMarkerSegment dRIMarkerSegment = (DRIMarkerSegment)this.findMarkerSegment(DRIMarkerSegment.class, true);
        if (dRIMarkerSegment != null) {
            dRIMarkerSegment.updateFromNativeNode(node, false);
        } else {
            DRIMarkerSegment dRIMarkerSegment2 = new DRIMarkerSegment(node);
            int n2 = this.findMarkerSegmentPosition(SOFMarkerSegment.class, true);
            int n3 = this.findMarkerSegmentPosition(SOSMarkerSegment.class, true);
            if (n2 != -1) {
                this.markerSequence.add(n2, dRIMarkerSegment2);
            } else if (n3 != -1) {
                this.markerSequence.add(n3, dRIMarkerSegment2);
            } else {
                this.markerSequence.add(dRIMarkerSegment2);
            }
        }
    }

    private void mergeJFIFsubtree(Node node) throws IIOInvalidTreeException {
        if (node.getChildNodes().getLength() != 0) {
            Node node2 = node.getFirstChild();
            JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
            if (jFIFMarkerSegment != null) {
                jFIFMarkerSegment.updateFromNativeNode(node2, false);
            } else {
                this.markerSequence.add(0, new JFIFMarkerSegment(node2));
            }
        }
    }

    private void mergeNativeTree(Node node) throws IIOInvalidTreeException {
        String string = node.getNodeName();
        if (string != (this.isStream ? "javax_imageio_jpeg_stream_1.0" : "javax_imageio_jpeg_image_1.0")) {
            throw new IIOInvalidTreeException("Invalid root node name: " + string, node);
        }
        if (node.getChildNodes().getLength() != 2) {
            throw new IIOInvalidTreeException("JPEGvariety and markerSequence nodes must be present", node);
        }
        this.mergeJFIFsubtree(node.getFirstChild());
        this.mergeSequenceSubtree(node.getLastChild());
    }

    private void mergeSOFNode(Node node) throws IIOInvalidTreeException {
        SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
        if (sOFMarkerSegment != null) {
            sOFMarkerSegment.updateFromNativeNode(node, false);
        } else {
            SOFMarkerSegment sOFMarkerSegment2 = new SOFMarkerSegment(node);
            int n2 = this.findMarkerSegmentPosition(SOSMarkerSegment.class, true);
            if (n2 != -1) {
                this.markerSequence.add(n2, sOFMarkerSegment2);
            } else {
                this.markerSequence.add(sOFMarkerSegment2);
            }
        }
    }

    private void mergeSOSNode(Node node) throws IIOInvalidTreeException {
        SOSMarkerSegment sOSMarkerSegment = (SOSMarkerSegment)this.findMarkerSegment(SOSMarkerSegment.class, true);
        SOSMarkerSegment sOSMarkerSegment2 = (SOSMarkerSegment)this.findMarkerSegment(SOSMarkerSegment.class, false);
        if (sOSMarkerSegment != null) {
            if (sOSMarkerSegment != sOSMarkerSegment2) {
                throw new IIOInvalidTreeException("Can't merge SOS node into a tree with > 1 SOS node", node);
            }
            sOSMarkerSegment.updateFromNativeNode(node, false);
        } else {
            this.markerSequence.add(new SOSMarkerSegment(node));
        }
    }

    private void mergeSequenceSubtree(Node node) throws IIOInvalidTreeException {
        NodeList nodeList = node.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node2 = nodeList.item(i2);
            String string = node2.getNodeName();
            if (string.equals("dqt")) {
                this.mergeDQTNode(node2);
                continue;
            }
            if (string.equals("dht")) {
                this.mergeDHTNode(node2);
                continue;
            }
            if (string.equals("dri")) {
                this.mergeDRINode(node2);
                continue;
            }
            if (string.equals("com")) {
                this.mergeCOMNode(node2);
                continue;
            }
            if (string.equals("app14Adobe")) {
                this.mergeAdobeNode(node2);
                continue;
            }
            if (string.equals("unknown")) {
                this.mergeUnknownNode(node2);
                continue;
            }
            if (string.equals("sof")) {
                this.mergeSOFNode(node2);
                continue;
            }
            if (string.equals("sos")) {
                this.mergeSOSNode(node2);
                continue;
            }
            throw new IIOInvalidTreeException("Invalid node: " + string, node2);
        }
    }

    private void mergeStandardCompressionNode(Node node) throws IIOInvalidTreeException {
    }

    private void mergeStandardDataNode(Node node) throws IIOInvalidTreeException {
    }

    private void mergeStandardDimensionNode(Node node) throws IIOInvalidTreeException {
        Object object;
        JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
        if (jFIFMarkerSegment == null) {
            int n2;
            boolean bl2 = false;
            SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
            if (sOFMarkerSegment != null && ((n2 = sOFMarkerSegment.componentSpecs.length) == 1 || n2 == 3)) {
                bl2 = true;
                for (int i2 = 0; i2 < sOFMarkerSegment.componentSpecs.length; ++i2) {
                    if (sOFMarkerSegment.componentSpecs[i2].componentId == i2 + 1) continue;
                    bl2 = false;
                }
                object = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
                if (object != null && ((AdobeMarkerSegment)object).transform != (n2 == 1 ? 0 : 1)) {
                    bl2 = false;
                }
            }
            if (bl2) {
                jFIFMarkerSegment = new JFIFMarkerSegment();
                this.markerSequence.add(0, jFIFMarkerSegment);
            }
        }
        if (jFIFMarkerSegment != null) {
            NodeList nodeList = node.getChildNodes();
            for (int i3 = 0; i3 < nodeList.getLength(); ++i3) {
                float f2;
                String string;
                Node node2 = nodeList.item(i3);
                object = node2.getAttributes();
                String string2 = node2.getNodeName();
                if (string2.equals("PixelAspectRatio")) {
                    string = object.getNamedItem("value").getNodeValue();
                    f2 = Float.parseFloat(string);
                    Point point = JPEGMetadata.findIntegerRatio(f2);
                    jFIFMarkerSegment.resUnits = 0;
                    jFIFMarkerSegment.Xdensity = point.x;
                    jFIFMarkerSegment.Xdensity = point.y;
                    continue;
                }
                if (string2.equals("HorizontalPixelSize")) {
                    string = object.getNamedItem("value").getNodeValue();
                    f2 = Float.parseFloat(string);
                    int n3 = (int)Math.round(1.0 / ((double)f2 * 10.0));
                    jFIFMarkerSegment.resUnits = 2;
                    jFIFMarkerSegment.Xdensity = n3;
                    continue;
                }
                if (!string2.equals("VerticalPixelSize")) continue;
                string = object.getNamedItem("value").getNodeValue();
                f2 = Float.parseFloat(string);
                int n4 = (int)Math.round(1.0 / ((double)f2 * 10.0));
                jFIFMarkerSegment.resUnits = 2;
                jFIFMarkerSegment.Ydensity = n4;
            }
        }
    }

    private void mergeStandardDocumentNode(Node node) throws IIOInvalidTreeException {
    }

    private void mergeStandardTextNode(Node node) throws IIOInvalidTreeException {
        NodeList nodeList = node.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string;
            Node node2 = nodeList.item(i2);
            NamedNodeMap namedNodeMap = node2.getAttributes();
            Node node3 = namedNodeMap.getNamedItem("compression");
            boolean bl2 = true;
            if (node3 != null && !(string = node3.getNodeValue()).equals("none")) {
                bl2 = false;
            }
            if (!bl2) continue;
            string = namedNodeMap.getNamedItem("value").getNodeValue();
            COMMarkerSegment cOMMarkerSegment = new COMMarkerSegment(string);
            this.insertCOMMarkerSegment(cOMMarkerSegment);
        }
    }

    private void mergeStandardTransparencyNode(Node node) throws IIOInvalidTreeException {
        if (!this.transparencyDone && !this.isStream) {
            boolean bl2 = this.wantAlpha(node);
            JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
            AdobeMarkerSegment adobeMarkerSegment = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
            SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
            SOSMarkerSegment sOSMarkerSegment = (SOSMarkerSegment)this.findMarkerSegment(SOSMarkerSegment.class, true);
            if (sOFMarkerSegment != null && sOFMarkerSegment.tag == 194) {
                return;
            }
            if (sOFMarkerSegment != null) {
                boolean bl3;
                int n2 = sOFMarkerSegment.componentSpecs.length;
                boolean bl4 = bl3 = n2 == 2 || n2 == 4;
                if (bl3 != bl2) {
                    if (bl2) {
                        int n3;
                        ++n2;
                        if (jFIFMarkerSegment != null) {
                            this.markerSequence.remove(jFIFMarkerSegment);
                        }
                        if (adobeMarkerSegment != null) {
                            adobeMarkerSegment.transform = 0;
                        }
                        SOFMarkerSegment.ComponentSpec[] componentSpecArray = new SOFMarkerSegment.ComponentSpec[n2];
                        for (n3 = 0; n3 < sOFMarkerSegment.componentSpecs.length; ++n3) {
                            componentSpecArray[n3] = sOFMarkerSegment.componentSpecs[n3];
                        }
                        n3 = (byte)sOFMarkerSegment.componentSpecs[0].componentId;
                        byte by = (byte)(n3 > 1 ? 65 : 4);
                        componentSpecArray[n2 - 1] = sOFMarkerSegment.getComponentSpec(by, sOFMarkerSegment.componentSpecs[0].HsamplingFactor, sOFMarkerSegment.componentSpecs[0].QtableSelector);
                        sOFMarkerSegment.componentSpecs = componentSpecArray;
                        SOSMarkerSegment.ScanComponentSpec[] scanComponentSpecArray = new SOSMarkerSegment.ScanComponentSpec[n2];
                        for (int i2 = 0; i2 < sOSMarkerSegment.componentSpecs.length; ++i2) {
                            scanComponentSpecArray[i2] = sOSMarkerSegment.componentSpecs[i2];
                        }
                        scanComponentSpecArray[n2 - 1] = sOSMarkerSegment.getScanComponentSpec(by, 0);
                        sOSMarkerSegment.componentSpecs = scanComponentSpecArray;
                    } else {
                        SOFMarkerSegment.ComponentSpec[] componentSpecArray = new SOFMarkerSegment.ComponentSpec[--n2];
                        for (int i3 = 0; i3 < n2; ++i3) {
                            componentSpecArray[i3] = sOFMarkerSegment.componentSpecs[i3];
                        }
                        sOFMarkerSegment.componentSpecs = componentSpecArray;
                        SOSMarkerSegment.ScanComponentSpec[] scanComponentSpecArray = new SOSMarkerSegment.ScanComponentSpec[n2];
                        for (int i4 = 0; i4 < n2; ++i4) {
                            scanComponentSpecArray[i4] = sOSMarkerSegment.componentSpecs[i4];
                        }
                        sOSMarkerSegment.componentSpecs = scanComponentSpecArray;
                    }
                }
            }
        }
    }

    private void mergeStandardTree(Node node) throws IIOInvalidTreeException {
        this.transparencyDone = false;
        NodeList nodeList = node.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node2 = nodeList.item(i2);
            String string = node2.getNodeName();
            if (string.equals("Chroma")) {
                this.mergeStandardChromaNode(node2, nodeList);
                continue;
            }
            if (string.equals("Compression")) {
                this.mergeStandardCompressionNode(node2);
                continue;
            }
            if (string.equals("Data")) {
                this.mergeStandardDataNode(node2);
                continue;
            }
            if (string.equals("Dimension")) {
                this.mergeStandardDimensionNode(node2);
                continue;
            }
            if (string.equals("Document")) {
                this.mergeStandardDocumentNode(node2);
                continue;
            }
            if (string.equals("Text")) {
                this.mergeStandardTextNode(node2);
                continue;
            }
            if (string.equals("Transparency")) {
                this.mergeStandardTransparencyNode(node2);
                continue;
            }
            throw new IIOInvalidTreeException("Invalid node: " + string, node2);
        }
    }

    private void mergeUnknownNode(Node node) throws IIOInvalidTreeException {
        MarkerSegment markerSegment = new MarkerSegment(node);
        int n2 = this.findLastUnknownMarkerSegmentPosition();
        boolean bl2 = this.findMarkerSegment(JFIFMarkerSegment.class, true) != null;
        int n3 = this.findMarkerSegmentPosition(AdobeMarkerSegment.class, true);
        if (n2 != -1) {
            this.markerSequence.add(n2 + 1, markerSegment);
        } else if (bl2) {
            this.markerSequence.add(1, markerSegment);
        }
        if (n3 != -1) {
            this.markerSequence.add(n3, markerSegment);
        } else {
            this.markerSequence.add(0, markerSegment);
        }
    }

    void setFromMarkerSequenceNode(Node node) throws IIOInvalidTreeException {
        NodeList nodeList = node.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node2 = nodeList.item(i2);
            String string = node2.getNodeName();
            if (string.equals("dqt")) {
                this.markerSequence.add(new DQTMarkerSegment(node2));
                continue;
            }
            if (string.equals("dht")) {
                this.markerSequence.add(new DHTMarkerSegment(node2));
                continue;
            }
            if (string.equals("dri")) {
                this.markerSequence.add(new DRIMarkerSegment(node2));
                continue;
            }
            if (string.equals("com")) {
                this.markerSequence.add(new COMMarkerSegment(node2));
                continue;
            }
            if (string.equals("app14Adobe")) {
                this.markerSequence.add(new AdobeMarkerSegment(node2));
                continue;
            }
            if (string.equals("unknown")) {
                this.markerSequence.add(new MarkerSegment(node2));
                continue;
            }
            if (string.equals("sof")) {
                this.markerSequence.add(new SOFMarkerSegment(node2));
                continue;
            }
            if (string.equals("sos")) {
                this.markerSequence.add(new SOSMarkerSegment(node2));
                continue;
            }
            throw new IIOInvalidTreeException("Invalid " + (this.isStream ? "stream " : "image ") + "child: " + string, node2);
        }
    }

    private void setFromNativeTree(Node node) throws IIOInvalidTreeException {
        Node node2;
        if (this.resetSequence == null) {
            this.resetSequence = this.markerSequence;
        }
        this.markerSequence = new ArrayList();
        String string = node.getNodeName();
        if (string != (this.isStream ? "javax_imageio_jpeg_stream_1.0" : "javax_imageio_jpeg_image_1.0")) {
            throw new IIOInvalidTreeException("Invalid root node name: " + string, node);
        }
        if (!this.isStream) {
            if (node.getChildNodes().getLength() != 2) {
                throw new IIOInvalidTreeException("JPEGvariety and markerSequence nodes must be present", node);
            }
            node2 = node.getFirstChild();
            if (node2.getChildNodes().getLength() != 0) {
                this.markerSequence.add(new JFIFMarkerSegment(node2.getFirstChild()));
            }
        }
        node2 = this.isStream ? node : node.getLastChild();
        this.setFromMarkerSequenceNode(node2);
    }

    private boolean wantAlpha(Node node) {
        String string;
        boolean bl2 = false;
        Node node2 = node.getFirstChild();
        if (node2.getNodeName().equals("Alpha") && node2.hasAttributes() && !(string = node2.getAttributes().getNamedItem("value").getNodeValue()).equals("none")) {
            bl2 = true;
        }
        this.transparencyDone = true;
        return bl2;
    }

    JPEGMetadata(boolean bl2, boolean bl3, ImageInputStream imageInputStream, JPEGImageReader jPEGImageReader) throws IOException {
        this(bl2, bl3);
        JPEGBuffer jPEGBuffer = new JPEGBuffer(imageInputStream);
        jPEGBuffer.loadBuf(0);
        if ((jPEGBuffer.buf[0] & 0xFF) != 255 || (jPEGBuffer.buf[1] & 0xFF) != 216 || (jPEGBuffer.buf[2] & 0xFF) != 255) {
            throw new IIOException("Image format error");
        }
        boolean bl4 = false;
        jPEGBuffer.bufAvail -= 2;
        jPEGBuffer.bufPtr = 2;
        MarkerSegment markerSegment = null;
        while (!bl4) {
            jPEGBuffer.loadBuf(1);
            jPEGBuffer.scanForFF(jPEGImageReader);
            switch (jPEGBuffer.buf[jPEGBuffer.bufPtr] & 0xFF) {
                case 0: {
                    --jPEGBuffer.bufAvail;
                    ++jPEGBuffer.bufPtr;
                    break;
                }
                case 192: 
                case 193: 
                case 194: {
                    if (bl2) {
                        throw new IIOException("SOF not permitted in stream metadata");
                    }
                    markerSegment = new SOFMarkerSegment(jPEGBuffer);
                    break;
                }
                case 219: {
                    markerSegment = new DQTMarkerSegment(jPEGBuffer);
                    break;
                }
                case 196: {
                    markerSegment = new DHTMarkerSegment(jPEGBuffer);
                    break;
                }
                case 221: {
                    markerSegment = new DRIMarkerSegment(jPEGBuffer);
                    break;
                }
                case 224: {
                    JFIFMarkerSegment jFIFMarkerSegment;
                    jPEGBuffer.loadBuf(8);
                    byte[] byArray = jPEGBuffer.buf;
                    int n2 = jPEGBuffer.bufPtr;
                    if (byArray[n2 + 3] == 74 && byArray[n2 + 4] == 70 && byArray[n2 + 5] == 73 && byArray[n2 + 6] == 70 && byArray[n2 + 7] == 0) {
                        if (this.inThumb) {
                            jPEGImageReader.warningOccurred(1);
                            jFIFMarkerSegment = new JFIFMarkerSegment(jPEGBuffer);
                            break;
                        }
                        if (bl2) {
                            throw new IIOException("JFIF not permitted in stream metadata");
                        }
                        if (!this.markerSequence.isEmpty()) {
                            throw new IIOException("JFIF APP0 must be first marker after SOI");
                        }
                        markerSegment = new JFIFMarkerSegment(jPEGBuffer);
                        break;
                    }
                    if (byArray[n2 + 3] == 74 && byArray[n2 + 4] == 70 && byArray[n2 + 5] == 88 && byArray[n2 + 6] == 88 && byArray[n2 + 7] == 0) {
                        if (bl2) {
                            throw new IIOException("JFXX not permitted in stream metadata");
                        }
                        if (this.inThumb) {
                            throw new IIOException("JFXX markers not allowed in JFIF JPEG thumbnail");
                        }
                        jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment == null ? JPEGMetadata.class$("com.sun.imageio.plugins.jpeg.JFIFMarkerSegment") : class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment, true);
                        if (jFIFMarkerSegment == null) {
                            throw new IIOException("JFXX encountered without prior JFIF!");
                        }
                        jFIFMarkerSegment.addJFXX(jPEGBuffer, jPEGImageReader);
                        break;
                    }
                    markerSegment = new MarkerSegment(jPEGBuffer);
                    markerSegment.loadData(jPEGBuffer);
                    break;
                }
                case 226: {
                    JFIFMarkerSegment jFIFMarkerSegment;
                    jPEGBuffer.loadBuf(15);
                    if (jPEGBuffer.buf[jPEGBuffer.bufPtr + 3] == 73 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 4] == 67 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 5] == 67 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 6] == 95 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 7] == 80 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 8] == 82 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 9] == 79 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 10] == 70 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 11] == 73 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 12] == 76 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 13] == 69 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 14] == 0) {
                        if (bl2) {
                            throw new IIOException("ICC profiles not permitted in stream metadata");
                        }
                        jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment == null ? JPEGMetadata.class$("com.sun.imageio.plugins.jpeg.JFIFMarkerSegment") : class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment, true);
                        if (jFIFMarkerSegment == null) {
                            throw new IIOException("ICC APP2 encountered without prior JFIF!");
                        }
                        jFIFMarkerSegment.addICC(jPEGBuffer);
                        break;
                    }
                    markerSegment = new MarkerSegment(jPEGBuffer);
                    markerSegment.loadData(jPEGBuffer);
                    break;
                }
                case 238: {
                    jPEGBuffer.loadBuf(8);
                    if (jPEGBuffer.buf[jPEGBuffer.bufPtr + 3] == 65 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 4] == 100 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 5] == 111 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 6] == 98 && jPEGBuffer.buf[jPEGBuffer.bufPtr + 7] == 101) {
                        if (bl2) {
                            throw new IIOException("Adobe APP14 markers not permitted in stream metadata");
                        }
                        markerSegment = new AdobeMarkerSegment(jPEGBuffer);
                        break;
                    }
                    markerSegment = new MarkerSegment(jPEGBuffer);
                    markerSegment.loadData(jPEGBuffer);
                    break;
                }
                case 254: {
                    markerSegment = new COMMarkerSegment(jPEGBuffer);
                    break;
                }
                case 218: {
                    if (bl2) {
                        throw new IIOException("SOS not permitted in stream metadata");
                    }
                    markerSegment = new SOSMarkerSegment(jPEGBuffer);
                    break;
                }
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: {
                    ++jPEGBuffer.bufPtr;
                    --jPEGBuffer.bufAvail;
                    break;
                }
                case 217: {
                    bl4 = true;
                    ++jPEGBuffer.bufPtr;
                    --jPEGBuffer.bufAvail;
                    break;
                }
                default: {
                    markerSegment = new MarkerSegment(jPEGBuffer);
                    markerSegment.loadData(jPEGBuffer);
                    markerSegment.unknown = true;
                }
            }
            if (markerSegment == null) continue;
            this.markerSequence.add(markerSegment);
            markerSegment = null;
        }
        jPEGBuffer.pushBack();
        if (!this.isConsistent()) {
            throw new IIOException("Inconsistent metadata read from stream");
        }
    }

    JPEGMetadata(ImageWriteParam imageWriteParam, JPEGImageWriter jPEGImageWriter) {
        this(true, false);
        JPEGImageWriteParam jPEGImageWriteParam = null;
        if (imageWriteParam != null && imageWriteParam instanceof JPEGImageWriteParam && !(jPEGImageWriteParam = (JPEGImageWriteParam)imageWriteParam).areTablesSet()) {
            jPEGImageWriteParam = null;
        }
        if (jPEGImageWriteParam != null) {
            this.markerSequence.add(new DQTMarkerSegment(jPEGImageWriteParam.getQTables()));
            this.markerSequence.add(new DHTMarkerSegment(jPEGImageWriteParam.getDCHuffmanTables(), jPEGImageWriteParam.getACHuffmanTables()));
        } else {
            this.markerSequence.add(new DQTMarkerSegment(JPEG.getDefaultQTables()));
            this.markerSequence.add(new DHTMarkerSegment(JPEG.getDefaultHuffmanTables(true), JPEG.getDefaultHuffmanTables(false)));
        }
        if (!this.isConsistent()) {
            throw new InternalError("Default stream metadata is inconsistent");
        }
    }

    MarkerSegment findMarkerSegment(Class clazz, boolean bl2) {
        if (bl2) {
            Iterator iterator = this.markerSequence.iterator();
            while (iterator.hasNext()) {
                MarkerSegment markerSegment = (MarkerSegment)iterator.next();
                if (!clazz.isInstance(markerSegment)) continue;
                return markerSegment;
            }
        } else {
            ListIterator listIterator = this.markerSequence.listIterator(this.markerSequence.size());
            while (listIterator.hasPrevious()) {
                MarkerSegment markerSegment = (MarkerSegment)listIterator.previous();
                if (!clazz.isInstance(markerSegment)) continue;
                return markerSegment;
            }
        }
        return null;
    }

    public Node getAsTree(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null formatName!");
        }
        if (this.isStream) {
            if (string.equals("javax_imageio_jpeg_stream_1.0")) {
                return this.getNativeTree();
            }
        } else {
            if (string.equals("javax_imageio_jpeg_image_1.0")) {
                return this.getNativeTree();
            }
            if (string.equals("javax_imageio_1.0")) {
                return this.getStandardTree();
            }
        }
        throw new IllegalArgumentException("Unsupported format name: " + string);
    }

    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string == null) {
            throw new IllegalArgumentException("null formatName!");
        }
        if (node == null) {
            throw new IllegalArgumentException("null root!");
        }
        List list = null;
        list = this.resetSequence == null ? (this.resetSequence = this.cloneSequence()) : this.cloneSequence();
        if (this.isStream && string.equals("javax_imageio_jpeg_stream_1.0")) {
            this.mergeNativeTree(node);
        } else if (!this.isStream && string.equals("javax_imageio_jpeg_image_1.0")) {
            this.mergeNativeTree(node);
        } else if (!this.isStream && string.equals("javax_imageio_1.0")) {
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException("Unsupported format name: " + string);
        }
        if (!this.isConsistent()) {
            this.markerSequence = list;
            throw new IIOInvalidTreeException("Merged tree is invalid; original restored", node);
        }
    }

    public void setFromTree(String string, Node node) throws IIOInvalidTreeException {
        if (string == null) {
            throw new IllegalArgumentException("null formatName!");
        }
        if (node == null) {
            throw new IllegalArgumentException("null root!");
        }
        if (this.isStream && string.equals("javax_imageio_jpeg_stream_1.0")) {
            this.setFromNativeTree(node);
        } else if (!this.isStream && string.equals("javax_imageio_jpeg_image_1.0")) {
            this.setFromNativeTree(node);
        } else if (!this.isStream && string.equals("javax_imageio_1.0")) {
            super.setFromTree(string, node);
        } else {
            throw new IllegalArgumentException("Unsupported format name: " + string);
        }
    }

    private void mergeStandardChromaNode(Node node, NodeList nodeList) throws IIOInvalidTreeException {
        Object object;
        Object object2;
        Object object3;
        if (this.transparencyDone) {
            throw new IIOInvalidTreeException("Transparency node must follow Chroma node", node);
        }
        Node node2 = node.getFirstChild();
        if (node2 == null || !node2.getNodeName().equals("ColorSpaceType")) {
            return;
        }
        String string = node2.getAttributes().getNamedItem("name").getNodeValue();
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        boolean bl4 = false;
        byte[] byArray = new byte[]{1, 2, 3, 4};
        if (string.equals("GRAY")) {
            n2 = 1;
            bl2 = true;
        } else if (string.equals("YCbCr")) {
            n2 = 3;
            bl2 = true;
            bl4 = true;
        } else if (string.equals("PhotoYCC")) {
            n2 = 3;
            bl3 = true;
            n3 = 1;
            byArray[0] = 89;
            byArray[1] = 67;
            byArray[2] = 99;
        } else if (string.equals("RGB")) {
            n2 = 3;
            bl3 = true;
            n3 = 0;
            byArray[0] = 82;
            byArray[1] = 71;
            byArray[2] = 66;
        } else if (string.equals("XYZ") || string.equals("Lab") || string.equals("Luv") || string.equals("YxY") || string.equals("HSV") || string.equals("HLS") || string.equals("CMY") || string.equals("3CLR")) {
            n2 = 3;
        } else if (string.equals("YCCK")) {
            n2 = 4;
            bl3 = true;
            n3 = 2;
            bl4 = true;
        } else if (string.equals("CMYK")) {
            n2 = 4;
            bl3 = true;
            n3 = 0;
        } else if (string.equals("4CLR")) {
            n2 = 4;
        } else {
            return;
        }
        boolean bl5 = false;
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            object3 = nodeList.item(i2);
            if (!object3.getNodeName().equals("Transparency")) continue;
            bl5 = this.wantAlpha((Node)object3);
            break;
        }
        if (bl5) {
            ++n2;
            bl2 = false;
            if (byArray[0] == 82) {
                byArray[3] = 65;
                bl3 = false;
            }
        }
        JFIFMarkerSegment jFIFMarkerSegment = (JFIFMarkerSegment)this.findMarkerSegment(JFIFMarkerSegment.class, true);
        object3 = (AdobeMarkerSegment)this.findMarkerSegment(AdobeMarkerSegment.class, true);
        SOFMarkerSegment sOFMarkerSegment = (SOFMarkerSegment)this.findMarkerSegment(SOFMarkerSegment.class, true);
        SOSMarkerSegment sOSMarkerSegment = (SOSMarkerSegment)this.findMarkerSegment(SOSMarkerSegment.class, true);
        if (sOFMarkerSegment != null && sOFMarkerSegment.tag == 194 && sOFMarkerSegment.componentSpecs.length != n2 && sOSMarkerSegment != null) {
            return;
        }
        if (!bl2 && jFIFMarkerSegment != null) {
            this.markerSequence.remove(jFIFMarkerSegment);
        }
        if (bl2 && !this.isStream) {
            this.markerSequence.add(0, new JFIFMarkerSegment());
        }
        if (bl3) {
            if (object3 == null && !this.isStream) {
                object3 = new AdobeMarkerSegment(n3);
                this.insertAdobeMarkerSegment((AdobeMarkerSegment)object3);
            } else {
                ((AdobeMarkerSegment)object3).transform = n3;
            }
        } else if (object3 != null) {
            this.markerSequence.remove(object3);
        }
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        int[] nArray = new int[]{0, 1, 1, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        int[] nArray3 = bl4 ? nArray : nArray2;
        SOFMarkerSegment.ComponentSpec[] componentSpecArray = null;
        if (sOFMarkerSegment != null) {
            int n4;
            componentSpecArray = sOFMarkerSegment.componentSpecs;
            bl8 = sOFMarkerSegment.tag == 194;
            this.markerSequence.set(this.markerSequence.indexOf(sOFMarkerSegment), new SOFMarkerSegment(bl8, false, bl4, byArray, n2));
            for (n4 = 0; n4 < componentSpecArray.length; ++n4) {
                if (componentSpecArray[n4].QtableSelector == nArray3[n4]) continue;
                bl6 = true;
            }
            if (bl8) {
                n4 = 0;
                for (int i3 = 0; i3 < componentSpecArray.length; ++i3) {
                    if (byArray[i3] == componentSpecArray[i3].componentId) continue;
                    n4 = 1;
                }
                if (n4 != 0) {
                    Iterator iterator = this.markerSequence.iterator();
                    while (iterator.hasNext()) {
                        object2 = (MarkerSegment)iterator.next();
                        if (!(object2 instanceof SOSMarkerSegment)) continue;
                        object = (SOSMarkerSegment)object2;
                        for (int i4 = 0; i4 < ((SOSMarkerSegment)object).componentSpecs.length; ++i4) {
                            int n5 = ((SOSMarkerSegment)object).componentSpecs[i4].componentSelector;
                            for (int i5 = 0; i5 < componentSpecArray.length; ++i5) {
                                if (componentSpecArray[i5].componentId != n5) continue;
                                ((SOSMarkerSegment)object).componentSpecs[i4].componentSelector = byArray[i5];
                            }
                        }
                    }
                }
            } else if (sOSMarkerSegment != null) {
                for (n4 = 0; n4 < sOSMarkerSegment.componentSpecs.length; ++n4) {
                    if (sOSMarkerSegment.componentSpecs[n4].dcHuffTable == nArray3[n4] && sOSMarkerSegment.componentSpecs[n4].acHuffTable == nArray3[n4]) continue;
                    bl7 = true;
                }
                this.markerSequence.set(this.markerSequence.indexOf(sOSMarkerSegment), new SOSMarkerSegment(bl4, byArray, n2));
            }
        } else if (this.isStream) {
            bl6 = true;
            bl7 = true;
        }
        if (bl6) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.markerSequence.iterator();
            while (iterator.hasNext()) {
                object2 = (MarkerSegment)iterator.next();
                if (!(object2 instanceof DQTMarkerSegment)) continue;
                arrayList.add(object2);
            }
            if (!arrayList.isEmpty() && bl4) {
                boolean bl9 = false;
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    object = (DQTMarkerSegment)object2.next();
                    Iterator iterator2 = ((DQTMarkerSegment)object).tables.iterator();
                    while (iterator2.hasNext()) {
                        DQTMarkerSegment.Qtable qtable = (DQTMarkerSegment.Qtable)iterator2.next();
                        if (qtable.tableID != 1) continue;
                        bl9 = true;
                    }
                }
                if (!bl9) {
                    object2 = null;
                    object = arrayList.iterator();
                    while (object.hasNext()) {
                        DQTMarkerSegment dQTMarkerSegment = (DQTMarkerSegment)object.next();
                        Iterator iterator3 = dQTMarkerSegment.tables.iterator();
                        while (iterator3.hasNext()) {
                            DQTMarkerSegment.Qtable qtable = (DQTMarkerSegment.Qtable)iterator3.next();
                            if (qtable.tableID != 0) continue;
                            object2 = qtable;
                        }
                    }
                    object = (DQTMarkerSegment)arrayList.get(arrayList.size() - 1);
                    ((DQTMarkerSegment)object).tables.add(((DQTMarkerSegment)object).getChromaForLuma((DQTMarkerSegment.Qtable)object2));
                }
            }
        }
        if (bl7) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.markerSequence.iterator();
            while (iterator.hasNext()) {
                object2 = (MarkerSegment)iterator.next();
                if (!(object2 instanceof DHTMarkerSegment)) continue;
                arrayList.add(object2);
            }
            if (!arrayList.isEmpty() && bl4) {
                boolean bl10 = false;
                object2 = arrayList.iterator();
                while (object2.hasNext()) {
                    object = (DHTMarkerSegment)object2.next();
                    Iterator iterator4 = ((DHTMarkerSegment)object).tables.iterator();
                    while (iterator4.hasNext()) {
                        DHTMarkerSegment.Htable htable = (DHTMarkerSegment.Htable)iterator4.next();
                        if (htable.tableID != 1) continue;
                        bl10 = true;
                    }
                }
                if (!bl10) {
                    object2 = (DHTMarkerSegment)arrayList.get(arrayList.size() - 1);
                    ((DHTMarkerSegment)object2).addHtable(JPEGHuffmanTable.StdDCLuminance, true, 1);
                    ((DHTMarkerSegment)object2).addHtable(JPEGHuffmanTable.StdACLuminance, true, 1);
                }
            }
        }
    }

    JPEGMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, JPEGImageWriter jPEGImageWriter) {
        Object object;
        Object object2;
        int n2;
        byte[] byArray;
        float f2;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        int n3;
        boolean bl8;
        boolean bl9;
        block39: {
            block38: {
                this(false, false);
                bl9 = true;
                bl8 = false;
                n3 = 0;
                bl7 = true;
                bl6 = false;
                bl5 = false;
                boolean bl10 = false;
                bl4 = false;
                bl3 = true;
                bl2 = true;
                f2 = 0.75f;
                byArray = new byte[]{1, 2, 3, 4};
                n2 = 0;
                ImageTypeSpecifier imageTypeSpecifier2 = null;
                if (imageWriteParam != null) {
                    imageTypeSpecifier2 = imageWriteParam.getDestinationType();
                    if (imageTypeSpecifier2 != null && imageTypeSpecifier != null) {
                        jPEGImageWriter.warningOccurred(0);
                        imageTypeSpecifier2 = null;
                    }
                    if (imageWriteParam.canWriteProgressive() && imageWriteParam.getProgressiveMode() == 1) {
                        bl5 = true;
                        bl10 = true;
                        bl2 = false;
                    }
                    if (imageWriteParam instanceof JPEGImageWriteParam) {
                        object2 = (JPEGImageWriteParam)imageWriteParam;
                        if (((JPEGImageWriteParam)object2).areTablesSet()) {
                            bl3 = false;
                            bl2 = false;
                            if (((JPEGImageWriteParam)object2).getDCHuffmanTables().length > 2 || ((JPEGImageWriteParam)object2).getACHuffmanTables().length > 2) {
                                bl4 = true;
                            }
                        }
                        if (!bl5 && (bl10 = ((JPEGImageWriteParam)object2).getOptimizeHuffmanTables())) {
                            bl2 = false;
                        }
                    }
                    if (imageWriteParam.canWriteCompressed() && imageWriteParam.getCompressionMode() == 2) {
                        f2 = imageWriteParam.getCompressionQuality();
                    }
                }
                object2 = null;
                if (imageTypeSpecifier2 == null) break block38;
                object = imageTypeSpecifier2.getColorModel();
                n2 = ((ColorModel)object).getNumComponents();
                boolean bl11 = ((ColorModel)object).getNumColorComponents() != n2;
                boolean bl12 = ((ColorModel)object).hasAlpha();
                object2 = ((ColorModel)object).getColorSpace();
                int n4 = ((ColorSpace)object2).getType();
                switch (n4) {
                    case 6: {
                        bl7 = false;
                        if (bl11) {
                            bl9 = false;
                            break;
                        }
                        break block39;
                    }
                    case 13: {
                        if (object2 == JPEG.YCC) {
                            bl9 = false;
                            byArray[0] = 89;
                            byArray[1] = 67;
                            byArray[2] = 99;
                            if (bl12) {
                                byArray[3] = 65;
                                break;
                            }
                        }
                        break block39;
                    }
                    case 3: {
                        if (bl11) {
                            bl9 = false;
                            if (!bl12) {
                                bl8 = true;
                                n3 = 2;
                                break;
                            }
                        }
                        break block39;
                    }
                    case 5: {
                        bl9 = false;
                        bl8 = true;
                        bl7 = false;
                        byArray[0] = 82;
                        byArray[1] = 71;
                        byArray[2] = 66;
                        if (bl12) {
                            byArray[3] = 65;
                            break;
                        }
                        break block39;
                    }
                    default: {
                        bl9 = false;
                        bl7 = false;
                        break;
                    }
                }
                break block39;
            }
            if (imageTypeSpecifier != null) {
                object = imageTypeSpecifier.getColorModel();
                n2 = ((ColorModel)object).getNumComponents();
                boolean bl13 = ((ColorModel)object).getNumColorComponents() != n2;
                boolean bl14 = ((ColorModel)object).hasAlpha();
                object2 = ((ColorModel)object).getColorSpace();
                int n5 = ((ColorSpace)object2).getType();
                switch (n5) {
                    case 6: {
                        bl7 = false;
                        if (!bl13) break;
                        bl9 = false;
                        break;
                    }
                    case 5: {
                        if (!bl14) break;
                        bl9 = false;
                        break;
                    }
                    case 13: {
                        bl9 = false;
                        bl7 = false;
                        if (!object2.equals(ColorSpace.getInstance(1002))) break;
                        bl7 = true;
                        bl8 = true;
                        byArray[0] = 89;
                        byArray[1] = 67;
                        byArray[2] = 99;
                        if (!bl14) break;
                        byArray[3] = 65;
                        break;
                    }
                    case 3: {
                        if (!bl13) break;
                        bl9 = false;
                        if (bl14) break;
                        bl8 = true;
                        n3 = 2;
                        break;
                    }
                    case 9: {
                        bl9 = false;
                        bl8 = true;
                        n3 = 2;
                        break;
                    }
                    default: {
                        bl9 = false;
                        bl7 = false;
                    }
                }
            }
        }
        if (bl9 && JPEG.isNonStandardICC(object2)) {
            bl6 = true;
        }
        if (bl9) {
            object = new JFIFMarkerSegment();
            this.markerSequence.add(object);
            if (bl6) {
                try {
                    ((JFIFMarkerSegment)object).addICC((ICC_ColorSpace)object2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (bl8) {
            this.markerSequence.add(new AdobeMarkerSegment(n3));
        }
        if (bl3) {
            this.markerSequence.add(new DQTMarkerSegment(f2, bl7));
        }
        if (bl2) {
            this.markerSequence.add(new DHTMarkerSegment(bl7));
        }
        this.markerSequence.add(new SOFMarkerSegment(bl5, bl4, bl7, byArray, n2));
        if (!bl5) {
            this.markerSequence.add(new SOSMarkerSegment(bl7, byArray, n2));
        }
        if (!this.isConsistent()) {
            throw new InternalError("Default image metadata is inconsistent");
        }
    }

    void writeToStream(ImageOutputStream imageOutputStream, boolean bl2, boolean bl3, List list, ICC_Profile iCC_Profile, boolean bl4, int n2, JPEGImageWriter jPEGImageWriter) throws IOException {
        if (bl3) {
            JFIFMarkerSegment.writeDefaultJFIF(imageOutputStream, list, iCC_Profile, jPEGImageWriter);
            if (!bl4 && n2 != -1 && n2 != 0 && n2 != 1) {
                bl4 = true;
                jPEGImageWriter.warningOccurred(13);
            }
        }
        Iterator iterator = this.markerSequence.iterator();
        while (iterator.hasNext()) {
            MarkerSegment markerSegment;
            MarkerSegment markerSegment2 = (MarkerSegment)iterator.next();
            if (markerSegment2 instanceof JFIFMarkerSegment) {
                if (bl2) continue;
                markerSegment = (JFIFMarkerSegment)markerSegment2;
                ((JFIFMarkerSegment)markerSegment).writeWithThumbs(imageOutputStream, list, jPEGImageWriter);
                if (iCC_Profile == null) continue;
                JFIFMarkerSegment.writeICC(iCC_Profile, imageOutputStream);
                continue;
            }
            if (markerSegment2 instanceof AdobeMarkerSegment) {
                if (bl4) continue;
                if (n2 != -1) {
                    markerSegment = (AdobeMarkerSegment)markerSegment2.clone();
                    ((AdobeMarkerSegment)markerSegment).transform = n2;
                    ((AdobeMarkerSegment)markerSegment).write(imageOutputStream);
                    continue;
                }
                if (bl3) {
                    markerSegment = (AdobeMarkerSegment)markerSegment2;
                    if (((AdobeMarkerSegment)markerSegment).transform == 0 || ((AdobeMarkerSegment)markerSegment).transform == 1) {
                        ((AdobeMarkerSegment)markerSegment).write(imageOutputStream);
                        continue;
                    }
                    jPEGImageWriter.warningOccurred(13);
                    continue;
                }
                markerSegment2.write(imageOutputStream);
                continue;
            }
            markerSegment2.write(imageOutputStream);
        }
    }
}

