/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.ASCII;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import sun.text.Normalizer;

public final class Pattern
implements Serializable {
    public static final int UNIX_LINES = 1;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int MULTILINE = 8;
    public static final int DOTALL = 32;
    public static final int UNICODE_CASE = 64;
    public static final int CANON_EQ = 128;
    private static final long serialVersionUID = 5073258162644648461L;
    private String pattern;
    private int flags;
    private volatile transient boolean compiled = false;
    private transient String normalizedPattern;
    transient Node root;
    transient Node matchRoot;
    transient char[] buffer;
    transient GroupHead[] groupNodes;
    private transient char[] temp;
    transient int groupCount;
    transient int localCount;
    private transient int cursor;
    private transient int patternLength;
    static final int MAX_REPS = Integer.MAX_VALUE;
    static final int GREEDY = 0;
    static final int LAZY = 1;
    static final int POSSESSIVE = 2;
    static final int INDEPENDENT = 3;
    static Node accept = new Node();
    static Node lastAccept = new LastNode();
    static HashMap families = null;
    static HashMap categories = null;
    private static final String[] familyNames = new String[]{"BasicLatin", "Latin-1Supplement", "LatinExtended-A", "LatinExtended-Bound", "IPAExtensions", "SpacingModifierLetters", "CombiningDiacriticalMarks", "Greek", "Cyrillic", "Armenian", "Hebrew", "Arabic", "Syriac", "Thaana", "Devanagari", "Bengali", "Gurmukhi", "Gujarati", "Oriya", "Tamil", "Telugu", "Kannada", "Malayalam", "Sinhala", "Thai", "Lao", "Tibetan", "Myanmar", "Georgian", "HangulJamo", "Ethiopic", "Cherokee", "UnifiedCanadianAboriginalSyllabics", "Ogham", "Runic", "Khmer", "Mongolian", "LatinExtendedAdditional", "GreekExtended", "GeneralPunctuation", "SuperscriptsandSubscripts", "CurrencySymbols", "CombiningMarksforSymbols", "LetterlikeSymbols", "NumberForms", "Arrows", "MathematicalOperators", "MiscellaneousTechnical", "ControlPictures", "OpticalCharacterRecognition", "EnclosedAlphanumerics", "BoxDrawing", "BlockElements", "GeometricShapes", "MiscellaneousSymbols", "Dingbats", "BraillePatterns", "CJKRadicalsSupplement", "KangxiRadicals", "IdeographicDescriptionCharacters", "CJKSymbolsandPunctuation", "Hiragana", "Katakana", "Bopomofo", "HangulCompatibilityJamo", "Kanbun", "BopomofoExtended", "EnclosedCJKLettersandMonths", "CJKCompatibility", "CJKUnifiedIdeographsExtensionA", "CJKUnifiedIdeographs", "YiSyllables", "YiRadicals", "HangulSyllables", "HighSurrogates", "HighPrivateUseSurrogates", "LowSurrogates", "PrivateUse", "CJKCompatibilityIdeographs", "AlphabeticPresentationForms", "ArabicPresentationForms-A", "CombiningHalfMarks", "CJKCompatibilityForms", "SmallFormVariants", "ArabicPresentationForms-Bound", "Specials", "HalfwidthandFullwidthForms"};
    private static final String[] categoryNames = new String[]{"Cn", "Lu", "Ll", "Lt", "Lm", "Lo", "Mn", "Me", "Mc", "Nd", "Nl", "No", "Zs", "Zl", "Zp", "Cc", "Cf", "Co", "Cs", "Pd", "Ps", "Pe", "Pc", "Po", "Sm", "Sc", "Sk", "So", "L", "M", "N", "Z", "C", "P", "S", "LD", "L1", "all", "ASCII", "Alnum", "Alpha", "Blank", "Cntrl", "Digit", "Graph", "Lower", "Print", "Punct", "Space", "Upper", "XDigit"};
    private static final Node[] familyNodes = new Node[]{new Range(127), new Range(0x8000FF), new Range(16777599), new Range(25166415), new Range(38797999), new Range(45089535), new Range(50332527), new Range(57672703), new Range(0x40004FF), new Range(87033231), new Range(93324799), new Range(0x60006FF), new Range(117442383), new Range(125831103), new Range(150997375), new Range(159386111), new Range(167774847), new Range(176163583), new Range(184552319), new Range(192941055), new Range(201329791), new Range(209718527), new Range(218107263), new Range(226495999), new Range(234884735), new Range(243273471), new Range(0xF000FFF), new Range(268439711), new Range(278925567), new Range(0x110011FF), new Range(301994879), new Range(329257983), new Range(335550079), new Range(377493151), new Range(379590399), new Range(394270719), new Range(402659503), new Range(503324415), new Range(0x1F001FFF), new Range(536879215), new Range(544219295), new Range(547365071), new Range(550510847), new Range(553656655), new Range(558899599), new Range(563094015), new Range(0x220022FF), new Range(587211775), new Range(603989055), new Range(608183391), new Range(610280703), new Range(620766591), new Range(629155231), new Range(631252479), new Range(637544191), new Range(654321599), new Range(671099135), new Range(780152575), new Range(788541407), new Range(0x2FF02FFF), new Range(0x3000303F), new Range(809513119), new Range(815804671), new Range(822096175), new Range(825241999), new Range(831533471), new Range(832582079), new Range(838873855), new Range(0x330033FF), new Range(872435125), new Range(1308663807), new Range(-1610570609), new Range(-1534024497), new Range(-1409230941), new Range(-671032449), new Range(-612312065), new Range(-603922433), new Range(-536807169), new Range(-117376257), new Range(-83821745), new Range(-78578177), new Range(-31392209), new Range(-30343601), new Range(-28246417), new Range(-26149122), new Specials(), new Range(-16711697)};
    private static final Node[] categoryNodes = new Node[]{new Category(1), new Category(2), new Category(4), new Category(8), new Category(16), new Category(32), new Category(64), new Category(128), new Category(256), new Category(512), new Category(1024), new Category(2048), new Category(4096), new Category(8192), new Category(16384), new Category(32768), new Category(65536), new Category(262144), new Category(524288), new Category(0x100000), new Category(0x200000), new Category(0x400000), new Category(0x800000), new Category(0x1000000), new Category(0x2000000), new Category(0x4000000), new Category(0x8000000), new Category(0x10000000), new Category(62), new Category(448), new Category(3584), new Category(28672), new Category(884736), new Category(0x1F00000), new Category(0x1E000000), new Category(574), new Range(255), new All(), new Range(127), new Ctype(1792), new Ctype(768), new Ctype(16384), new Ctype(8192), new Range(0x300039), new Ctype(5888), new Range(6357114), new Range(2097278), new Ctype(4096), new Ctype(2048), new Range(4259930), new Ctype(32768)};

    private int c() {
        if (this.cursor < this.patternLength) {
            return this.read() ^ 0x40;
        }
        this.error("Illegal control escape sequence");
        return -1;
    }

    public int flags() {
        return this.flags;
    }

    private int next() {
        int n2 = this.temp[++this.cursor];
        if (this.has(4)) {
            n2 = this.peekPastWhitespace(n2);
        }
        return n2;
    }

    private int nextEscaped() {
        char c2 = this.temp[++this.cursor];
        return c2;
    }

    private int o() {
        int n2 = this.read();
        if ((n2 - 48 | 55 - n2) >= 0) {
            int n3 = this.read();
            if ((n3 - 48 | 55 - n3) >= 0) {
                int n4 = this.read();
                if ((n4 - 48 | 55 - n4) >= 0 && (n2 - 48 | 51 - n2) >= 0) {
                    return (n2 - 48) * 64 + (n3 - 48) * 8 + (n4 - 48);
                }
                this.unread();
                return (n2 - 48) * 8 + (n3 - 48);
            }
            this.unread();
            return n2 - 48;
        }
        this.error("Illegal octal escape sequence");
        return -1;
    }

    private int parsePastLine() {
        char c2 = this.temp[this.cursor++];
        while (c2 != '\u0000' && !this.isLineSeparator(c2)) {
            c2 = this.temp[this.cursor++];
        }
        return c2;
    }

    private int peek() {
        int n2 = this.temp[this.cursor];
        if (this.has(4)) {
            n2 = this.peekPastWhitespace(n2);
        }
        return n2;
    }

    private int peekPastLine() {
        char c2 = this.temp[++this.cursor];
        while (c2 != '\u0000' && !this.isLineSeparator(c2)) {
            c2 = this.temp[++this.cursor];
        }
        return c2;
    }

    private int read() {
        int n2 = this.temp[this.cursor++];
        if (this.has(4)) {
            n2 = this.parsePastWhitespace(n2);
        }
        return n2;
    }

    private int readEscaped() {
        char c2 = this.temp[this.cursor++];
        return c2;
    }

    private int single() {
        int n2 = this.peek();
        switch (n2) {
            case 92: {
                return this.escape(true, false);
            }
        }
        this.next();
        return n2;
    }

    private int skip() {
        int n2 = this.cursor;
        char c2 = this.temp[n2 + 1];
        this.cursor = n2 + 2;
        return c2;
    }

    private int u() {
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            int n3 = this.read();
            if (!ASCII.isHexDigit(n3)) {
                this.error("Illegal Unicode escape sequence");
            }
            n2 = n2 * 16 + ASCII.toDigit(n3);
        }
        return n2;
    }

    private int x() {
        int n2;
        int n3 = this.read();
        if (ASCII.isHexDigit(n3) && ASCII.isHexDigit(n2 = this.read())) {
            return ASCII.toDigit(n3) * 16 + ASCII.toDigit(n2);
        }
        this.error("Illegal hexadecimal escape sequence");
        return -1;
    }

    private void addFlag() {
        int n2 = this.peek();
        while (true) {
            switch (n2) {
                case 105: {
                    this.flags |= 2;
                    break;
                }
                case 109: {
                    this.flags |= 8;
                    break;
                }
                case 115: {
                    this.flags |= 0x20;
                    break;
                }
                case 100: {
                    this.flags |= 1;
                    break;
                }
                case 117: {
                    this.flags |= 0x40;
                    break;
                }
                case 99: {
                    this.flags |= 0x80;
                    break;
                }
                case 120: {
                    this.flags |= 4;
                    break;
                }
                case 45: {
                    n2 = this.next();
                    this.subFlag();
                }
                default: {
                    return;
                }
            }
            n2 = this.next();
        }
    }

    private void compile() {
        if (this.has(128)) {
            this.normalize();
        } else {
            this.normalizedPattern = this.pattern;
        }
        this.patternLength = this.normalizedPattern.length();
        this.temp = new char[this.patternLength + 2];
        this.normalizedPattern.getChars(0, this.patternLength, this.temp, 0);
        this.temp[this.patternLength] = '\u0000';
        this.temp[this.patternLength + 1] = '\u0000';
        this.buffer = new char[32];
        this.groupNodes = new GroupHead[10];
        this.matchRoot = this.expr(lastAccept);
        if (this.patternLength != this.cursor) {
            if (this.peek() == 41) {
                this.error("Unmatched closing ')'");
            } else {
                this.error("Unexpected internal error");
            }
        }
        if (this.matchRoot instanceof Slice) {
            this.root = BnM.optimize(this.matchRoot);
            if (this.root == this.matchRoot) {
                this.root = new Start(this.matchRoot);
            }
        } else {
            this.root = this.matchRoot instanceof Begin || this.matchRoot instanceof First ? this.matchRoot : new Start(this.matchRoot);
        }
        this.temp = null;
        this.buffer = null;
        this.groupNodes = null;
        this.patternLength = 0;
        this.compiled = true;
    }

    private void normalize() {
        boolean bl2 = false;
        char c2 = '\uffff';
        this.normalizedPattern = Normalizer.decompose(this.pattern, false, 0);
        this.patternLength = this.normalizedPattern.length();
        StringBuffer stringBuffer = new StringBuffer(this.patternLength);
        for (int i2 = 0; i2 < this.patternLength; ++i2) {
            char c3 = this.normalizedPattern.charAt(i2);
            if (Character.getType(c3) == 6 && c2 != '\uffff') {
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(c2);
                stringBuffer2.append(c3);
                while (Character.getType(c3) == 6 && ++i2 < this.patternLength) {
                    c3 = this.normalizedPattern.charAt(i2);
                    stringBuffer2.append(c3);
                }
                String string = this.produceEquivalentAlternation(stringBuffer2.toString());
                stringBuffer.setLength(stringBuffer.length() - 1);
                stringBuffer.append("(?:").append(string).append(")");
            } else if (c3 == '[' && c2 != '\\') {
                i2 = this.normalizeCharClass(stringBuffer, i2);
            } else {
                stringBuffer.append(c3);
            }
            c2 = c3;
        }
        this.normalizedPattern = stringBuffer.toString();
    }

    private void subFlag() {
        int n2 = this.peek();
        while (true) {
            switch (n2) {
                case 105: {
                    this.flags &= 0xFFFFFFFD;
                    break;
                }
                case 109: {
                    this.flags &= 0xFFFFFFF7;
                    break;
                }
                case 115: {
                    this.flags &= 0xFFFFFFDF;
                    break;
                }
                case 100: {
                    this.flags &= 0xFFFFFFFE;
                    break;
                }
                case 117: {
                    this.flags &= 0xFFFFFFBF;
                    break;
                }
                case 99: {
                    this.flags &= 0xFFFFFF7F;
                    break;
                }
                case 120: {
                    this.flags &= 0xFFFFFFFB;
                    break;
                }
                default: {
                    return;
                }
            }
            n2 = this.next();
        }
    }

    private void unread() {
        --this.cursor;
    }

    private int getClass(char c2) {
        return Normalizer.getClass(c2);
    }

    private void mark(char c2) {
        this.temp[this.patternLength] = c2;
    }

    private int parsePastWhitespace(int n2) {
        while (ASCII.isSpace(n2) || n2 == 35) {
            while (ASCII.isSpace(n2)) {
                n2 = this.temp[this.cursor++];
            }
            if (n2 != 35) continue;
            n2 = this.parsePastLine();
        }
        return n2;
    }

    private int peekPastWhitespace(int n2) {
        while (ASCII.isSpace(n2) || n2 == 35) {
            while (ASCII.isSpace(n2)) {
                n2 = this.temp[++this.cursor];
            }
            if (n2 != 35) continue;
            n2 = this.peekPastLine();
        }
        return n2;
    }

    private boolean has(int n2) {
        return (this.flags & n2) > 0;
    }

    private boolean isLineSeparator(int n2) {
        if (this.has(1)) {
            return n2 == 10;
        }
        return n2 == 10 || n2 == 13 || (n2 | 1) == 8233 || n2 == 133;
    }

    private void append(int n2, int n3) {
        if (n3 >= this.buffer.length) {
            char[] cArray = new char[n3 + n3];
            System.arraycopy(this.buffer, 0, cArray, 0, n3);
            this.buffer = cArray;
        }
        this.buffer[n3] = (char)n2;
    }

    private int escape(boolean bl2, boolean bl3) {
        int n2 = this.skip();
        switch (n2) {
            case 48: {
                return this.o();
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                if (bl2) break;
                if (this.groupCount < n2 - 48) {
                    this.error("No such group yet exists at this point in the pattern");
                }
                if (bl3) {
                    this.root = this.ref(n2 - 48);
                }
                return -1;
            }
            case 65: {
                if (bl2) break;
                if (bl3) {
                    this.root = new Begin();
                }
                return -1;
            }
            case 66: {
                if (bl2) break;
                if (bl3) {
                    this.root = new Bound(Bound.NONE);
                }
                return -1;
            }
            case 67: {
                break;
            }
            case 68: {
                if (bl3) {
                    this.root = new NotCtype(1024);
                }
                return -1;
            }
            case 69: 
            case 70: {
                break;
            }
            case 71: {
                if (bl2) break;
                if (bl3) {
                    this.root = new LastMatch();
                }
                return -1;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                break;
            }
            case 81: {
                if (bl3) {
                    int n3;
                    int n4 = this.cursor;
                    while ((n3 = this.readEscaped()) != 0 && (n3 != 92 || (n3 = this.readEscaped()) != 69 && n3 != 0)) {
                    }
                    int n5 = this.cursor - 1;
                    if (n3 == 69) {
                        --n5;
                    } else {
                        this.unread();
                    }
                    for (int i2 = n4; i2 < n5; ++i2) {
                        this.append(this.temp[i2], i2 - n4);
                    }
                    this.root = this.newSlice(this.buffer, n5 - n4);
                }
                return -1;
            }
            case 82: {
                break;
            }
            case 83: {
                if (bl3) {
                    this.root = new NotCtype(2048);
                }
                return -1;
            }
            case 84: 
            case 85: 
            case 86: {
                break;
            }
            case 87: {
                if (bl3) {
                    this.root = new NotCtype(67328);
                }
                return -1;
            }
            case 88: 
            case 89: {
                break;
            }
            case 90: {
                if (bl2) break;
                if (bl3) {
                    this.root = this.has(1) ? new UnixDollar(false) : new Dollar(false);
                }
                return -1;
            }
            case 97: {
                return 7;
            }
            case 98: {
                if (bl2) break;
                if (bl3) {
                    this.root = new Bound(Bound.BOTH);
                }
                return -1;
            }
            case 99: {
                return this.c();
            }
            case 100: {
                if (bl3) {
                    this.root = new Ctype(1024);
                }
                return -1;
            }
            case 101: {
                return 27;
            }
            case 102: {
                return 12;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                break;
            }
            case 110: {
                return 10;
            }
            case 111: 
            case 112: 
            case 113: {
                break;
            }
            case 114: {
                return 13;
            }
            case 115: {
                if (bl3) {
                    this.root = new Ctype(2048);
                }
                return -1;
            }
            case 116: {
                return 9;
            }
            case 117: {
                return this.u();
            }
            case 118: {
                return 11;
            }
            case 119: {
                if (bl3) {
                    this.root = new Ctype(67328);
                }
                return -1;
            }
            case 120: {
                return this.x();
            }
            case 121: {
                break;
            }
            case 122: {
                if (bl2) break;
                if (bl3) {
                    this.root = new End();
                }
                return -1;
            }
            default: {
                return n2;
            }
        }
        this.error("Illegal/unsupported escape squence");
        return -2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.groupCount = 1;
        this.localCount = 0;
        this.compiled = false;
        if (this.pattern.length() == 0) {
            this.root = new Start(lastAccept);
            this.matchRoot = lastAccept;
            this.compiled = true;
        }
    }

    public String pattern() {
        return this.pattern;
    }

    private void accept(int n2, String string) {
        int n3 = this.temp[this.cursor++];
        if (this.has(4)) {
            n3 = this.parsePastWhitespace(n3);
        }
        if (n2 != n3) {
            this.error(string);
        }
    }

    private Pattern(String string, int n2) {
        this.pattern = string;
        this.flags = n2;
        this.groupCount = 1;
        this.localCount = 0;
        if (this.pattern.length() > 0) {
            this.compile();
        } else {
            this.root = new Start(lastAccept);
            this.matchRoot = lastAccept;
        }
    }

    private int normalizeCharClass(StringBuffer stringBuffer, int n2) {
        char c2;
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = null;
        char c3 = '\uffff';
        ++n2;
        stringBuffer2.append("[");
        while (true) {
            if ((c2 = this.normalizedPattern.charAt(n2)) == ']' && c3 != '\\') break;
            if (Character.getType(c2) == 6) {
                StringBuffer stringBuffer4 = new StringBuffer();
                stringBuffer4.append(c3);
                while (Character.getType(c2) == 6) {
                    stringBuffer4.append(c2);
                    if (++n2 >= this.normalizedPattern.length()) break;
                    c2 = this.normalizedPattern.charAt(n2);
                }
                String string = this.produceEquivalentAlternation(stringBuffer4.toString());
                stringBuffer2.setLength(stringBuffer2.length() - 1);
                if (stringBuffer3 == null) {
                    stringBuffer3 = new StringBuffer();
                }
                stringBuffer3.append('|');
                stringBuffer3.append(string);
            } else {
                stringBuffer2.append(c2);
                ++n2;
            }
            if (n2 == this.normalizedPattern.length()) {
                this.error("Unclosed character class");
            }
            c3 = c2;
        }
        stringBuffer2.append(c2);
        String string = stringBuffer3 != null ? new String("(?:" + stringBuffer2.toString() + stringBuffer3.toString() + ")") : stringBuffer2.toString();
        stringBuffer.append(string);
        return n2;
    }

    private Node atom() {
        int n2 = 0;
        int n3 = -1;
        int n4 = this.peek();
        block6: while (true) {
            switch (n4) {
                case 42: 
                case 43: 
                case 63: 
                case 123: {
                    if (n2 <= true) break block6;
                    this.cursor = n3;
                    --n2;
                    break block6;
                }
                case 36: 
                case 40: 
                case 41: 
                case 46: 
                case 91: 
                case 94: 
                case 124: {
                    break block6;
                }
                case 92: {
                    n4 = this.nextEscaped();
                    if (n4 == 112 || n4 == 80) {
                        if (n2 > 0) {
                            this.unread();
                            break block6;
                        }
                        if (n4 != 112 && n4 != 80) break block6;
                        boolean bl2 = n4 == 80;
                        boolean bl3 = true;
                        n4 = this.next();
                        if (n4 != 123) {
                            this.unread();
                        } else {
                            bl3 = false;
                        }
                        return this.family(bl2, bl3);
                    }
                    this.unread();
                    n3 = this.cursor;
                    n4 = this.escape(false, n2 == 0);
                    if (n4 >= 0) {
                        this.append(n4, n2);
                        ++n2;
                        n4 = this.peek();
                        continue block6;
                    }
                    if (n2 == 0) {
                        return this.root;
                    }
                    this.cursor = n3;
                    break block6;
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block6;
                }
                default: {
                    n3 = this.cursor;
                    this.append(n4, n2);
                    ++n2;
                    n4 = this.next();
                    continue block6;
                }
            }
            break;
        }
        if (n2 == 1) {
            return this.newSingle(this.buffer[0]);
        }
        return this.newSlice(this.buffer, n2);
    }

    private Node group0() {
        Object object;
        Node node = null;
        Node node2 = null;
        int n2 = this.flags;
        this.root = null;
        int n3 = this.next();
        if (n3 == 63) {
            n3 = this.skip();
            switch (n3) {
                case 58: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    break;
                }
                case 33: 
                case 61: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    if (n3 == 61) {
                        node = node2 = new Pos(node);
                        break;
                    }
                    node = node2 = new Neg(node);
                    break;
                }
                case 62: {
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    node = node2 = new Ques(node, 3);
                    break;
                }
                case 60: {
                    n3 = this.read();
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    object = new TreeInfo();
                    node.study((TreeInfo)object);
                    if (!((TreeInfo)object).maxValid) {
                        return this.error("Look-behind group does not have an obvious maximum length");
                    }
                    if (n3 == 61) {
                        node = node2 = new Behind(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength);
                        break;
                    }
                    if (n3 == 33) {
                        node = node2 = new NotBehind(node, ((TreeInfo)object).maxLength, ((TreeInfo)object).minLength);
                        break;
                    }
                    this.error("Unknown look-behind group");
                    break;
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (this.groupNodes[n3 - 48] != null) {
                        node = node2 = new GroupRef(this.groupNodes[n3 - 48]);
                        break;
                    }
                    return this.error("Unknown group reference");
                }
                case 36: 
                case 64: {
                    return this.error("Unknown group type");
                }
                default: {
                    this.unread();
                    this.addFlag();
                    n3 = this.read();
                    if (n3 == 41) {
                        return null;
                    }
                    if (n3 != 58) {
                        return this.error("Unknown inline modifier");
                    }
                    node = this.createGroup(true);
                    node2 = this.root;
                    node.next = this.expr(node2);
                    break;
                }
            }
        } else {
            node = this.createGroup(false);
            node2 = this.root;
            node.next = this.expr(node2);
        }
        this.accept(41, "Unclosed group");
        this.flags = n2;
        object = this.closure(node);
        if (object == node) {
            this.root = node2;
            return object;
        }
        if (node == node2) {
            this.root = object;
            return object;
        }
        if (object instanceof Ques) {
            Ques ques = (Ques)object;
            if (ques.type == 2) {
                this.root = object;
                return object;
            }
            node2 = node2.next = new Dummy();
            node = ques.type == 0 ? new Branch(node, node2) : new Branch(node2, node);
            this.root = node2;
            return node;
        }
        if (object instanceof Curly) {
            Curly curly = (Curly)object;
            if (curly.type == 2) {
                this.root = object;
                return object;
            }
            TreeInfo treeInfo = new TreeInfo();
            if (node.study(treeInfo)) {
                GroupTail groupTail = (GroupTail)node2;
                node = this.root = new GroupCurly(node.next, curly.cmin, curly.cmax, curly.type, ((GroupTail)node2).localIndex, ((GroupTail)node2).groupIndex);
                return node;
            }
            int n4 = ((GroupHead)node).localIndex;
            Loop loop = curly.type == 0 ? new Loop(this.localCount, n4) : new LazyLoop(this.localCount, n4);
            Prolog prolog = new Prolog(loop);
            ++this.localCount;
            loop.cmin = curly.cmin;
            loop.cmax = curly.cmax;
            loop.body = node;
            node2.next = loop;
            this.root = loop;
            return prolog;
        }
        if (object instanceof First) {
            this.root = object;
            return object;
        }
        return this.error("Internal logic error");
    }

    private Node newSingle(int n2) {
        int n3 = this.flags;
        if ((n3 & 2) == 0) {
            return new Single(n2);
        }
        if ((n3 & 0x40) == 0) {
            return new SingleA(n2);
        }
        return new SingleU(n2);
    }

    private Node ref(int n2) {
        boolean bl2 = false;
        block3: while (!bl2) {
            int n3 = this.peek();
            switch (n3) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int n4 = n2 * 10 + (n3 - 48);
                    if (this.groupCount - 1 < n4) {
                        bl2 = true;
                        continue block3;
                    }
                    n2 = n4;
                    this.read();
                    continue block3;
                }
            }
            bl2 = true;
        }
        if (this.has(2)) {
            return new CIBackRef(n2);
        }
        return new BackRef(n2);
    }

    private static void printObjectTree(Node node) {
        while (node != null) {
            if (node instanceof Prolog) {
                System.out.println(node);
                Pattern.printObjectTree(((Prolog)node).loop);
                System.out.println("**** end contents prolog loop");
            } else if (node instanceof Loop) {
                System.out.println(node);
                Pattern.printObjectTree(((Loop)node).body);
                System.out.println("**** end contents Loop body");
            } else if (node instanceof Curly) {
                System.out.println(node);
                Pattern.printObjectTree(((Curly)node).atom);
                System.out.println("**** end contents Curly body");
            } else {
                if (node instanceof GroupTail) {
                    System.out.println(node);
                    System.out.println("Tail next is " + node.next);
                    return;
                }
                System.out.println(node);
            }
            node = node.next;
            if (node != null) {
                System.out.println("->next:");
            }
            if (node != accept) continue;
            System.out.println("Accept Node");
            node = null;
        }
    }

    private Node clazz(boolean bl2) {
        Node node = null;
        Node node2 = null;
        BitClass bitClass = new BitClass(false);
        boolean bl3 = true;
        boolean bl4 = true;
        int n2 = this.next();
        block7: while (true) {
            switch (n2) {
                case 94: {
                    if (!bl4 || this.temp[this.cursor - 1] != '[') break;
                    n2 = this.next();
                    bl3 = !bl3;
                    continue block7;
                }
                case 91: {
                    bl4 = false;
                    node2 = this.clazz(true);
                    node = node == null ? node2 : new Add(node, node2);
                    n2 = this.peek();
                    continue block7;
                }
                case 38: {
                    bl4 = false;
                    n2 = this.next();
                    if (n2 == 38) {
                        n2 = this.next();
                        Node node3 = null;
                        while (n2 != 93 && n2 != 38) {
                            if (n2 == 91) {
                                node3 = node3 == null ? this.clazz(true) : new Add(node3, this.clazz(true));
                            } else {
                                this.unread();
                                node3 = this.clazz(false);
                            }
                            n2 = this.peek();
                        }
                        if (node3 != null) {
                            node2 = node3;
                        }
                        if (node == null) {
                            if (node3 == null) {
                                return this.error("Bad class syntax");
                            }
                            node = node3;
                            continue block7;
                        }
                        node = new Both(node, node2);
                        continue block7;
                    }
                    this.unread();
                    break;
                }
                case 0: {
                    bl4 = false;
                    if (this.cursor < this.patternLength) break;
                    return this.error("Unclosed character class");
                }
                case 93: {
                    bl4 = false;
                    if (node == null) break;
                    if (bl2) {
                        this.next();
                    }
                    return node;
                }
                default: {
                    bl4 = false;
                }
            }
            node2 = this.range(bitClass);
            if (bl3) {
                if (node == null) {
                    node = node2;
                } else if (node != node2) {
                    node = new Add(node, node2);
                }
            } else if (node == null) {
                node = node2.dup(true);
            } else if (node != node2) {
                node = new Sub(node, node2);
            }
            n2 = this.peek();
        }
    }

    private Node createGroup(boolean bl2) {
        int n2 = this.localCount++;
        int n3 = 0;
        if (!bl2) {
            n3 = this.groupCount++;
        }
        GroupHead groupHead = new GroupHead(n2);
        this.root = new GroupTail(n2, n3);
        if (!bl2 && n3 < 10) {
            this.groupNodes[n3] = groupHead;
        }
        return groupHead;
    }

    private Node family(boolean bl2, boolean bl3) {
        String string;
        this.next();
        if (bl3) {
            string = new String(this.temp, this.cursor, 1).intern();
            this.read();
        } else {
            int n2 = this.cursor;
            this.mark('}');
            while (this.read() != 125) {
            }
            this.mark('\u0000');
            int n3 = this.cursor;
            if (n3 > this.patternLength) {
                return this.error("Unclosed character family");
            }
            if (n2 + 1 >= n3) {
                return this.error("Empty character family");
            }
            string = new String(this.temp, n2, n3 - n2 - 1).intern();
        }
        if (string.startsWith("In")) {
            string = string.substring(2, string.length()).intern();
            return this.retrieveFamilyNode(string).dup(bl2);
        }
        if (string.startsWith("Is")) {
            string = string.substring(2, string.length()).intern();
        }
        return this.retrieveCategoryNode(string).dup(bl2);
    }

    private Node newSlice(char[] cArray, int n2) {
        char[] cArray2 = new char[n2];
        int n3 = this.flags;
        if ((n3 & 2) == 0) {
            for (n3 = 0; n3 < n2; ++n3) {
                cArray2[n3] = cArray[n3];
            }
            return new Slice(cArray2);
        }
        if ((n3 & 0x40) == 0) {
            for (n3 = 0; n3 < n2; ++n3) {
                cArray2[n3] = (char)ASCII.toLower(cArray[n3]);
            }
            return new SliceA(cArray2);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            char c2 = cArray[n3];
            c2 = Character.toUpperCase(c2);
            cArray2[n3] = c2 = Character.toLowerCase(c2);
        }
        return new SliceU(cArray2);
    }

    public static boolean matches(String string, CharSequence charSequence) {
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(charSequence);
        return matcher.matches();
    }

    public String[] split(CharSequence charSequence) {
        return this.split(charSequence, 0);
    }

    public String[] split(CharSequence charSequence, int n2) {
        int n3;
        int n4 = 0;
        boolean bl2 = n2 > 0;
        ArrayList arrayList = new ArrayList();
        Matcher matcher = this.matcher(charSequence);
        while (matcher.find()) {
            String string;
            if (!bl2 || arrayList.size() < n2 - 1) {
                string = ((Object)charSequence.subSequence(n4, matcher.start())).toString();
                arrayList.add(string);
                n4 = matcher.end();
                continue;
            }
            if (arrayList.size() != n2 - 1) continue;
            string = ((Object)charSequence.subSequence(n4, charSequence.length())).toString();
            arrayList.add(string);
            n4 = matcher.end();
        }
        if (n4 == 0) {
            return new String[]{((Object)charSequence).toString()};
        }
        if (!bl2 || arrayList.size() < n2) {
            arrayList.add(((Object)charSequence.subSequence(n4, charSequence.length())).toString());
        }
        if (n2 == 0) {
            for (n3 = arrayList.size(); n3 > 0 && arrayList.get(n3 - 1).equals(""); --n3) {
            }
        }
        Object[] objectArray = new String[n3];
        return (String[])arrayList.subList(0, n3).toArray(objectArray);
    }

    private String composeOneStep(String string) {
        String string2 = string.substring(0, 2);
        String string3 = Normalizer.compose(string2, false, 0);
        if (string3.equals(string2)) {
            return null;
        }
        String string4 = string.substring(2);
        return string3 + string4;
    }

    private String produceEquivalentAlternation(String string) {
        if (string.length() == 1) {
            return new String(string);
        }
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1);
        String[] stringArray = this.producePermutations(string3);
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string4 = string2 + stringArray[i2];
            if (i2 > 0) {
                stringBuffer.append("|" + string4);
            }
            if ((string4 = this.composeOneStep(string4)) == null) continue;
            stringBuffer.append("|" + this.produceEquivalentAlternation(string4));
        }
        return stringBuffer.toString();
    }

    private String[] producePermutations(String string) {
        int n2;
        int n3;
        if (string.length() == 1) {
            return new String[]{string};
        }
        if (string.length() == 2) {
            if (this.getClass(string.charAt(1)) == this.getClass(string.charAt(0))) {
                return new String[]{string};
            }
            String[] stringArray = new String[2];
            stringArray[0] = string;
            StringBuffer stringBuffer = new StringBuffer(2);
            stringBuffer.append(string.charAt(1));
            stringBuffer.append(string.charAt(0));
            stringArray[1] = stringBuffer.toString();
            return stringArray;
        }
        int n4 = 1;
        for (int i2 = 1; i2 < string.length(); ++i2) {
            n4 *= i2 + 1;
        }
        String[] stringArray = new String[n4];
        int[] nArray = new int[string.length()];
        for (n3 = 0; n3 < string.length(); ++n3) {
            nArray[n3] = this.getClass(string.charAt(n3));
        }
        n3 = 0;
        block2: for (int i3 = 0; i3 < string.length(); ++i3) {
            n2 = 0;
            for (int i4 = i3 - 1; i4 >= 0; --i4) {
                if (nArray[i4] == nArray[i3]) continue block2;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            String string2 = stringBuffer.delete(i3, i3 + 1).toString();
            String[] stringArray2 = this.producePermutations(string2);
            String string3 = string.substring(i3, i3 + 1);
            for (int i5 = 0; i5 < stringArray2.length; ++i5) {
                stringArray[n3++] = string3 + stringArray2[i5];
            }
        }
        String[] stringArray3 = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray3[n2] = stringArray[n2];
        }
        return stringArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matcher matcher(CharSequence charSequence) {
        Object object = this;
        synchronized (object) {
            if (!this.compiled) {
                this.compile();
            }
        }
        object = new Matcher(this, charSequence);
        return object;
    }

    public static Pattern compile(String string) {
        return new Pattern(string, 0);
    }

    public static Pattern compile(String string, int n2) {
        return new Pattern(string, n2);
    }

    private Node error(String string) {
        throw new PatternSyntaxException(string, this.normalizedPattern, this.cursor - 1);
    }

    private Node retrieveCategoryNode(String string) {
        Node node;
        if (categories == null) {
            int n2 = categoryNodes.length;
            categories = new HashMap((int)((double)n2 / 0.75) + 1);
            for (int i2 = 0; i2 < n2; ++i2) {
                categories.put(categoryNames[i2], categoryNodes[i2]);
            }
        }
        if ((node = (Node)categories.get(string)) != null) {
            return node;
        }
        return this.familyError(string, "Unknown character category {");
    }

    private Node retrieveFamilyNode(String string) {
        Node node;
        if (families == null) {
            int n2 = familyNodes.length;
            families = new HashMap((int)((double)n2 / 0.75) + 1);
            for (int i2 = 0; i2 < n2; ++i2) {
                families.put(familyNames[i2], familyNodes[i2]);
            }
        }
        if ((node = (Node)families.get(string)) != null) {
            return node;
        }
        return this.familyError(string, "Unknown character family {");
    }

    private Node range(BitClass bitClass) {
        int n2 = this.peek();
        if (n2 == 92) {
            n2 = this.nextEscaped();
            if (n2 == 112 || n2 == 80) {
                boolean bl2 = n2 == 80;
                boolean bl3 = true;
                n2 = this.next();
                if (n2 != 123) {
                    this.unread();
                } else {
                    bl3 = false;
                }
                return this.family(bl2, bl3);
            }
            this.unread();
            n2 = this.escape(true, true);
            if (n2 == -1) {
                return this.root;
            }
        } else {
            n2 = this.single();
        }
        if (n2 >= 0) {
            if (this.peek() == 45) {
                char c2 = this.temp[this.cursor + 1];
                if (c2 == '[') {
                    if (n2 < 256) {
                        return bitClass.add(n2, this.flags());
                    }
                    return this.newSingle(n2);
                }
                if (c2 != ']') {
                    this.next();
                    int n3 = this.single();
                    if (n3 < n2) {
                        return this.error("Illegal character range");
                    }
                    if (this.has(2)) {
                        return new CIRange((n2 << 16) + n3);
                    }
                    return new Range((n2 << 16) + n3);
                }
            }
            if (n2 < 256) {
                return bitClass.add(n2, this.flags());
            }
            return this.newSingle(n2);
        }
        return this.error("Unexpected character '" + (char)n2 + "'");
    }

    private Node closure(Node node) {
        int n2 = this.peek();
        switch (n2) {
            case 63: {
                n2 = this.next();
                if (n2 == 63) {
                    this.next();
                    return new Ques(node, 1);
                }
                if (n2 == 43) {
                    this.next();
                    return new Ques(node, 2);
                }
                return new Ques(node, 0);
            }
            case 42: {
                n2 = this.next();
                if (n2 == 63) {
                    this.next();
                    return new Curly(node, 0, Integer.MAX_VALUE, 1);
                }
                if (n2 == 43) {
                    this.next();
                    return new Curly(node, 0, Integer.MAX_VALUE, 2);
                }
                return new Curly(node, 0, Integer.MAX_VALUE, 0);
            }
            case 43: {
                n2 = this.next();
                if (n2 == 63) {
                    this.next();
                    return new Curly(node, 1, Integer.MAX_VALUE, 1);
                }
                if (n2 == 43) {
                    this.next();
                    return new Curly(node, 1, Integer.MAX_VALUE, 2);
                }
                return new Curly(node, 1, Integer.MAX_VALUE, 0);
            }
            case 123: {
                n2 = this.temp[this.cursor + 1];
                if (ASCII.isDigit(n2)) {
                    Curly curly;
                    this.skip();
                    int n3 = 0;
                    do {
                        n3 = n3 * 10 + (n2 - 48);
                    } while (ASCII.isDigit(n2 = this.read()));
                    int n4 = n3;
                    if (n2 == 44) {
                        n2 = this.read();
                        n4 = Integer.MAX_VALUE;
                        if (n2 != 125) {
                            n4 = 0;
                            while (ASCII.isDigit(n2)) {
                                n4 = n4 * 10 + (n2 - 48);
                                n2 = this.read();
                            }
                        }
                    }
                    if (n2 != 125) {
                        return this.error("Unclosed counted closure");
                    }
                    if ((n3 | n4 | n4 - n3) < 0) {
                        return this.error("Illegal repetition range");
                    }
                    n2 = this.peek();
                    if (n2 == 63) {
                        this.next();
                        curly = new Curly(node, n3, n4, 1);
                    } else if (n2 == 43) {
                        this.next();
                        curly = new Curly(node, n3, n4, 2);
                    } else {
                        curly = new Curly(node, n3, n4, 0);
                    }
                    return curly;
                }
                this.error("Illegal repetition");
                return node;
            }
        }
        return node;
    }

    private Node expr(Node node) {
        Node node2 = null;
        while (true) {
            Node node3 = this.sequence(node);
            node2 = node2 == null ? node3 : new Branch(node2, node3);
            if (this.peek() != 124) {
                return node2;
            }
            this.next();
        }
    }

    private Node sequence(Node node) {
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        block12: while (true) {
            int n2 = this.peek();
            switch (n2) {
                case 40: {
                    node4 = this.group0();
                    if (node4 == null) continue block12;
                    if (node2 == null) {
                        node2 = node4;
                    } else {
                        node3.next = node4;
                    }
                    node3 = this.root;
                    continue block12;
                }
                case 91: {
                    node4 = this.clazz(true);
                    break;
                }
                case 92: {
                    n2 = this.nextEscaped();
                    if (n2 == 112 || n2 == 80) {
                        boolean bl2 = n2 == 80;
                        boolean bl3 = true;
                        n2 = this.next();
                        if (n2 != 123) {
                            this.unread();
                        } else {
                            bl3 = false;
                        }
                        node4 = this.family(bl2, bl3);
                        break;
                    }
                    this.unread();
                    node4 = this.atom();
                    break;
                }
                case 94: {
                    this.next();
                    if (this.has(8)) {
                        if (this.has(1)) {
                            node4 = new UnixCaret();
                            break;
                        }
                        node4 = new Caret();
                        break;
                    }
                    node4 = new Begin();
                    break;
                }
                case 36: {
                    this.next();
                    if (this.has(1)) {
                        node4 = new UnixDollar(this.has(8));
                        break;
                    }
                    node4 = new Dollar(this.has(8));
                    break;
                }
                case 46: {
                    this.next();
                    if (this.has(32)) {
                        node4 = new All();
                        break;
                    }
                    if (this.has(1)) {
                        node4 = new UnixDot();
                        break;
                    }
                    node4 = new Dot();
                    break;
                }
                case 41: 
                case 124: {
                    break block12;
                }
                case 93: 
                case 125: {
                    node4 = this.atom();
                    break;
                }
                case 42: 
                case 43: 
                case 63: {
                    this.next();
                    return this.error("Dangling meta character '" + (char)n2 + "'");
                }
                case 0: {
                    if (this.cursor >= this.patternLength) break block12;
                }
                default: {
                    node4 = this.atom();
                }
            }
            node4 = this.closure(node4);
            if (node2 == null) {
                node2 = node3 = node4;
                continue;
            }
            node3.next = node4;
            node3 = node4;
        }
        if (node2 == null) {
            return node;
        }
        node3.next = node;
        return node2;
    }

    private Node familyError(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(string);
        stringBuffer.append("}");
        string = stringBuffer.toString();
        return this.error(string);
    }

    static class Add
    extends Node {
        Node lhs;
        Node rhs;

        boolean study(TreeInfo treeInfo) {
            boolean bl2 = treeInfo.maxValid;
            boolean bl3 = treeInfo.deterministic;
            int n2 = treeInfo.minLength;
            int n3 = treeInfo.maxLength;
            this.lhs.study(treeInfo);
            int n4 = treeInfo.minLength;
            int n5 = treeInfo.maxLength;
            treeInfo.minLength = n2;
            treeInfo.maxLength = n3;
            this.rhs.study(treeInfo);
            treeInfo.minLength = Math.min(n4, treeInfo.minLength);
            treeInfo.maxLength = Math.max(n5, treeInfo.maxLength);
            treeInfo.maxValid = bl2;
            treeInfo.deterministic = bl3;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                return (this.lhs.match(matcher, n2, charSequence) || this.rhs.match(matcher, n2, charSequence)) && this.next.match(matcher, matcher.last, charSequence);
            }
            return false;
        }

        Add(Node node, Node node2) {
            this.lhs = node;
            this.rhs = node2;
        }
    }

    static final class All
    extends Node {
        All() {
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new Single(-1);
            }
            return new All();
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return n2 < matcher.to && this.next.match(matcher, n2 + 1, charSequence);
        }
    }

    static class BackRef
    extends Node {
        int groupIndex;

        BackRef(int n2) {
            this.groupIndex = n2 + n2;
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.groups[this.groupIndex];
            int n4 = matcher.groups[this.groupIndex + 1];
            int n5 = n4 - n3;
            if (n3 < 0) {
                return false;
            }
            if (n2 + n5 > matcher.to) {
                return false;
            }
            for (int i2 = 0; i2 < n5; ++i2) {
                if (charSequence.charAt(n2 + i2) == charSequence.charAt(n3 + i2)) continue;
                return false;
            }
            return this.next.match(matcher, n2 + n5, charSequence);
        }
    }

    static final class Begin
    extends Node {
        Begin() {
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 == matcher.from && this.next.match(matcher, n2, charSequence)) {
                matcher.first = n2;
                matcher.groups[0] = n2;
                matcher.groups[1] = matcher.last;
                return true;
            }
            return false;
        }
    }

    static final class Behind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        Behind(Node node, int n2, int n3) {
            this.cond = node;
            this.rmax = n2;
            this.rmin = n3;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = Math.max(n2 - this.rmax, matcher.from);
            for (int i2 = n2 - this.rmin; i2 >= n3; --i2) {
                if (!this.cond.match(matcher, i2, charSequence) || matcher.last != n2) continue;
                return this.next.match(matcher, n2, charSequence);
            }
            return false;
        }
    }

    static final class BitClass
    extends Node {
        boolean[] bits = new boolean[256];
        boolean complementMe = false;

        BitClass(boolean bl2) {
            this.complementMe = bl2;
        }

        BitClass(boolean[] blArray, boolean bl2) {
            this.complementMe = bl2;
            this.bits = blArray;
        }

        Node add(int n2, int n3) {
            if ((n3 & 2) == 0) {
                this.bits[n2] = true;
                return this;
            }
            if (n2 < 128) {
                this.bits[n2] = true;
                if (ASCII.isUpper(n2)) {
                    this.bits[n2 += 32] = true;
                } else if (ASCII.isLower(n2)) {
                    this.bits[n2 -= 32] = true;
                }
                return this;
            }
            n2 = Character.toLowerCase((char)n2);
            this.bits[n2] = true;
            n2 = Character.toUpperCase((char)n2);
            this.bits[n2] = true;
            return this;
        }

        Node dup(boolean bl2) {
            return new BitClass(this.bits, bl2);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 >= matcher.to) {
                return false;
            }
            char c2 = charSequence.charAt(n2);
            boolean bl2 = c2 > '\u00ff' ? this.complementMe : this.bits[c2] ^ this.complementMe;
            return bl2 && this.next.match(matcher, n2 + 1, charSequence);
        }
    }

    static final class BnM
    extends Node {
        char[] buffer;
        int[] lastOcc;
        int[] optoSft;

        BnM(char[] cArray, int[] nArray, int[] nArray2, Node node) {
            this.buffer = cArray;
            this.lastOcc = nArray;
            this.optoSft = nArray2;
            this.next = node;
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            char[] cArray = this.buffer;
            int n3 = cArray.length;
            int n4 = matcher.to - n3;
            block0: while (n2 <= n4) {
                int n5;
                for (n5 = n3 - 1; n5 >= 0; --n5) {
                    char c2 = charSequence.charAt(n2 + n5);
                    if (c2 == cArray[n5]) continue;
                    n2 += Math.max(n5 + 1 - this.lastOcc[c2 & 0x7F], this.optoSft[n5]);
                    continue block0;
                }
                matcher.first = n2;
                n5 = this.next.match(matcher, n2 + n3, charSequence) ? 1 : 0;
                if (n5 != 0) {
                    matcher.groups[0] = matcher.first = n2;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                ++n2;
            }
            return false;
        }

        static Node optimize(Node node) {
            int n2;
            if (!(node instanceof Slice)) {
                return node;
            }
            char[] cArray = ((Slice)node).buffer;
            int n3 = cArray.length;
            if (n3 < 4) {
                return node;
            }
            int[] nArray = new int[128];
            int[] nArray2 = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[cArray[n2] & 0x7F] = n2 + 1;
            }
            block1: for (n2 = n3; n2 > 0; --n2) {
                int n4;
                for (n4 = n3 - 1; n4 >= n2; --n4) {
                    if (cArray[n4] != cArray[n4 - n2]) continue block1;
                    nArray2[n4 - 1] = n2;
                }
                while (n4 > 0) {
                    nArray2[--n4] = n2;
                }
            }
            nArray2[n3 - 1] = 1;
            return new BnM(cArray, nArray, nArray2, node.next);
        }
    }

    static class Both
    extends Node {
        Node lhs;
        Node rhs;

        boolean study(TreeInfo treeInfo) {
            boolean bl2 = treeInfo.maxValid;
            boolean bl3 = treeInfo.deterministic;
            int n2 = treeInfo.minLength;
            int n3 = treeInfo.maxLength;
            this.lhs.study(treeInfo);
            int n4 = treeInfo.minLength;
            int n5 = treeInfo.maxLength;
            treeInfo.minLength = n2;
            treeInfo.maxLength = n3;
            this.rhs.study(treeInfo);
            treeInfo.minLength = Math.min(n4, treeInfo.minLength);
            treeInfo.maxLength = Math.max(n5, treeInfo.maxLength);
            treeInfo.maxValid = bl2;
            treeInfo.deterministic = bl3;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                return this.lhs.match(matcher, n2, charSequence) && this.rhs.match(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence);
            }
            return false;
        }

        Both(Node node, Node node2) {
            this.lhs = node;
            this.rhs = node2;
        }
    }

    static final class Bound
    extends Node {
        static int LEFT = 1;
        static int RIGHT = 2;
        static int BOTH = 3;
        static int NONE = 4;
        int type;

        Bound(int n2) {
            this.type = n2;
        }

        int check(Matcher matcher, int n2, CharSequence charSequence) {
            char c2;
            boolean bl2 = false;
            if (n2 > matcher.from) {
                c2 = charSequence.charAt(n2 - 1);
                bl2 = c2 == '_' || Character.isLetterOrDigit(c2);
            }
            boolean bl3 = false;
            if (n2 < matcher.to) {
                c2 = charSequence.charAt(n2);
                boolean bl4 = bl3 = c2 == '_' || Character.isLetterOrDigit(c2);
            }
            return bl2 ^ bl3 ? (bl3 ? LEFT : RIGHT) : NONE;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return (this.check(matcher, n2, charSequence) & this.type) > 0 && this.next.match(matcher, n2, charSequence);
        }
    }

    static final class Branch
    extends Node {
        Node prev;

        boolean study(TreeInfo treeInfo) {
            int n2 = treeInfo.minLength;
            int n3 = treeInfo.maxLength;
            boolean bl2 = treeInfo.maxValid;
            treeInfo.reset();
            this.prev.study(treeInfo);
            int n4 = treeInfo.minLength;
            int n5 = treeInfo.maxLength;
            boolean bl3 = treeInfo.maxValid;
            treeInfo.reset();
            this.next.study(treeInfo);
            treeInfo.minLength = n2 + Math.min(n4, treeInfo.minLength);
            treeInfo.maxLength = n3 + Math.max(n5, treeInfo.maxLength);
            treeInfo.maxValid = bl2 & bl3 & treeInfo.maxValid;
            treeInfo.deterministic = false;
            return false;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return this.prev.match(matcher, n2, charSequence) || this.next.match(matcher, n2, charSequence);
        }

        Branch(Node node, Node node2) {
            this.prev = node;
            this.next = node2;
        }
    }

    static class CIBackRef
    extends Node {
        int groupIndex;

        CIBackRef(int n2) {
            this.groupIndex = n2 + n2;
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.groups[this.groupIndex];
            int n4 = matcher.groups[this.groupIndex + 1];
            int n5 = n4 - n3;
            if (n3 < 0) {
                return false;
            }
            if (n2 + n5 > matcher.to) {
                return false;
            }
            for (int i2 = 0; i2 < n5; ++i2) {
                char c2;
                char c3 = charSequence.charAt(n2 + i2);
                if (c3 == (c2 = charSequence.charAt(n3 + i2)) || (c3 = Character.toUpperCase(c3)) == (c2 = Character.toUpperCase(c2)) || (c3 = Character.toLowerCase(c3)) == (c2 = Character.toLowerCase(c2))) continue;
                return false;
            }
            return this.next.match(matcher, n2 + n5, charSequence);
        }
    }

    static class CINotRange
    extends NotRange {
        int lower;
        int upper;

        CINotRange(int n2) {
            this.lower = n2 >>> 16;
            this.upper = n2 & 0xFFFF;
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new CIRange((this.lower << 16) + this.upper);
            }
            return new CINotRange((this.lower << 16) + this.upper);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                boolean bl2;
                char c2 = charSequence.charAt(n2);
                boolean bl3 = bl2 = (c2 - this.lower | this.upper - c2) < 0;
                if (bl2) {
                    boolean bl4 = bl2 = ((c2 = Character.toUpperCase(c2)) - this.lower | this.upper - c2) < 0;
                    if (bl2) {
                        bl2 = ((c2 = Character.toLowerCase(c2)) - this.lower | this.upper - c2) < 0;
                    }
                }
                return bl2 && this.next.match(matcher, n2 + 1, charSequence);
            }
            return false;
        }
    }

    static final class CIRange
    extends Range {
        CIRange(int n2) {
            this.lower = n2 >>> 16;
            this.upper = n2 & 0xFFFF;
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new CINotRange((this.lower << 16) + this.upper);
            }
            return new CIRange((this.lower << 16) + this.upper);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                boolean bl2;
                char c2 = charSequence.charAt(n2);
                boolean bl3 = bl2 = (c2 - this.lower | this.upper - c2) >= 0;
                if (!bl2) {
                    boolean bl4 = bl2 = ((c2 = Character.toUpperCase(c2)) - this.lower | this.upper - c2) >= 0;
                    if (!bl2) {
                        bl2 = ((c2 = Character.toLowerCase(c2)) - this.lower | this.upper - c2) >= 0;
                    }
                }
                return bl2 && this.next.match(matcher, n2 + 1, charSequence);
            }
            return false;
        }
    }

    static final class Caret
    extends Node {
        Caret() {
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 > matcher.from) {
                char c2 = charSequence.charAt(n2 - 1);
                if (c2 != '\n' && c2 != '\r' && (c2 | '\u0001') != 8233 && c2 != '\u0085') {
                    return false;
                }
                if (c2 == '\r' && charSequence.charAt(n2) == '\n') {
                    return false;
                }
            }
            if (n2 == matcher.to) {
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static final class Category
    extends Node {
        int atype;

        Category(int n2) {
            this.atype = n2;
        }

        Node dup(boolean bl2) {
            return new Category(bl2 ? ~this.atype : this.atype);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return n2 < matcher.to && (this.atype & 1 << Character.getType(charSequence.charAt(n2))) != 0 && this.next.match(matcher, n2 + 1, charSequence);
        }
    }

    static final class Conditional
    extends Node {
        Node cond;
        Node yes;
        Node not;

        boolean study(TreeInfo treeInfo) {
            int n2 = treeInfo.minLength;
            int n3 = treeInfo.maxLength;
            boolean bl2 = treeInfo.maxValid;
            treeInfo.reset();
            this.yes.study(treeInfo);
            int n4 = treeInfo.minLength;
            int n5 = treeInfo.maxLength;
            boolean bl3 = treeInfo.maxValid;
            treeInfo.reset();
            this.not.study(treeInfo);
            treeInfo.minLength = n2 + Math.min(n4, treeInfo.minLength);
            treeInfo.maxLength = n3 + Math.max(n5, treeInfo.maxLength);
            treeInfo.maxValid = bl2 & bl3 & treeInfo.maxValid;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (this.cond.match(matcher, n2, charSequence)) {
                return this.yes.match(matcher, n2, charSequence);
            }
            return this.not.match(matcher, n2, charSequence);
        }

        Conditional(Node node, Node node2, Node node3) {
            this.cond = node;
            this.yes = node2;
            this.not = node3;
        }
    }

    static final class Ctype
    extends Node {
        int ctype;

        Ctype(int n2) {
            this.ctype = n2;
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new NotCtype(this.ctype);
            }
            return new Ctype(this.ctype);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return n2 < matcher.to && ASCII.isType(charSequence.charAt(n2), this.ctype) && this.next.match(matcher, n2 + 1, charSequence);
        }
    }

    static final class Curly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;

        Curly(Node node, int n2, int n3, int n4) {
            this.atom = node;
            this.type = n4;
            this.cmin = n2;
            this.cmax = n3;
        }

        boolean study(TreeInfo treeInfo) {
            int n2 = treeInfo.minLength;
            int n3 = treeInfo.maxLength;
            boolean bl2 = treeInfo.maxValid;
            boolean bl3 = treeInfo.deterministic;
            treeInfo.reset();
            this.atom.study(treeInfo);
            int n4 = treeInfo.minLength * this.cmin + n2;
            if (n4 < n2) {
                n4 = 0xFFFFFFF;
            }
            treeInfo.minLength = n4;
            if (bl2 & treeInfo.maxValid) {
                treeInfo.maxLength = n4 = treeInfo.maxLength * this.cmax + n3;
                if (n4 < n3) {
                    treeInfo.maxValid = false;
                }
            } else {
                treeInfo.maxValid = false;
            }
            treeInfo.deterministic = treeInfo.deterministic && this.cmin == this.cmax ? bl3 : false;
            return this.next.study(treeInfo);
        }

        boolean match0(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            int n4;
            if (n3 >= this.cmax) {
                return this.next.match(matcher, n2, charSequence);
            }
            int n5 = n3++;
            if (this.atom.match(matcher, n2, charSequence) && (n4 = matcher.last - n2) != 0) {
                n2 = matcher.last;
                while (n3 < this.cmax && this.atom.match(matcher, n2, charSequence)) {
                    if (n2 + n4 != matcher.last) {
                        if (!this.match0(matcher, matcher.last, n3 + 1, charSequence)) break;
                        return true;
                    }
                    n2 += n4;
                    ++n3;
                }
                while (n3 >= n5) {
                    if (this.next.match(matcher, n2, charSequence)) {
                        return true;
                    }
                    n2 -= n4;
                    --n3;
                }
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }

        boolean match1(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            while (!this.next.match(matcher, n2, charSequence)) {
                if (n3 >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, n2, charSequence)) {
                    return false;
                }
                if (n2 == matcher.last) {
                    return false;
                }
                n2 = matcher.last;
                ++n3;
            }
            return true;
        }

        boolean match2(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            while (n3 < this.cmax && this.atom.match(matcher, n2, charSequence) && n2 != matcher.last) {
                n2 = matcher.last;
                ++n3;
            }
            return this.next.match(matcher, n2, charSequence);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3;
            for (n3 = 0; n3 < this.cmin; ++n3) {
                if (!this.atom.match(matcher, n2, charSequence)) {
                    return false;
                }
                n2 = matcher.last;
            }
            if (this.type == 0) {
                return this.match0(matcher, n2, n3, charSequence);
            }
            if (this.type == 1) {
                return this.match1(matcher, n2, n3, charSequence);
            }
            return this.match2(matcher, n2, n3, charSequence);
        }
    }

    static final class Dollar
    extends Node {
        boolean multiline;

        Dollar(boolean bl2) {
            this.multiline = bl2;
        }

        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            return treeInfo.deterministic;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            char c2;
            if (!this.multiline) {
                if (n2 < matcher.to - 2) {
                    return false;
                }
                if (n2 == matcher.to - 2) {
                    c2 = charSequence.charAt(n2);
                    if (c2 != '\r') {
                        return false;
                    }
                    c2 = charSequence.charAt(n2 + 1);
                    if (c2 != '\n') {
                        return false;
                    }
                }
            }
            if (n2 < matcher.to) {
                c2 = charSequence.charAt(n2);
                if (c2 == '\n') {
                    if (n2 > 0 && charSequence.charAt(n2 - 1) == '\r') {
                        return false;
                    }
                } else if (c2 != '\r' && c2 != '\u0085' && (c2 | '\u0001') != 8233) {
                    return false;
                }
            }
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static final class Dot
    extends Node {
        Dot() {
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                char c2 = charSequence.charAt(n2);
                return c2 != '\n' && c2 != '\r' && (c2 | '\u0001') != 8233 && c2 != '\u0085' && this.next.match(matcher, n2 + 1, charSequence);
            }
            return false;
        }
    }

    static class Dummy
    extends Node {
        Dummy() {
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static final class End
    extends Node {
        End() {
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return n2 == matcher.to && this.next.match(matcher, n2, charSequence);
        }
    }

    static final class First
    extends Node {
        Node atom;

        First(Node node) {
            this.atom = BnM.optimize(node);
        }

        boolean study(TreeInfo treeInfo) {
            this.atom.study(treeInfo);
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (this.atom instanceof BnM) {
                return this.atom.match(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence);
            }
            while (n2 <= matcher.to) {
                if (this.atom.match(matcher, n2, charSequence)) {
                    return this.next.match(matcher, matcher.last, charSequence);
                }
                ++n2;
                ++matcher.first;
            }
            return false;
        }
    }

    static final class GroupCurly
    extends Node {
        Node atom;
        int type;
        int cmin;
        int cmax;
        int localIndex;
        int groupIndex;

        GroupCurly(Node node, int n2, int n3, int n4, int n5, int n6) {
            this.atom = node;
            this.type = n4;
            this.cmin = n2;
            this.cmax = n3;
            this.localIndex = n5;
            this.groupIndex = n6;
        }

        boolean study(TreeInfo treeInfo) {
            int n2 = treeInfo.minLength;
            int n3 = treeInfo.maxLength;
            boolean bl2 = treeInfo.maxValid;
            boolean bl3 = treeInfo.deterministic;
            treeInfo.reset();
            this.atom.study(treeInfo);
            int n4 = treeInfo.minLength * this.cmin + n2;
            if (n4 < n2) {
                n4 = 0xFFFFFFF;
            }
            treeInfo.minLength = n4;
            if (bl2 & treeInfo.maxValid) {
                treeInfo.maxLength = n4 = treeInfo.maxLength * this.cmax + n3;
                if (n4 < n3) {
                    treeInfo.maxValid = false;
                }
            } else {
                treeInfo.maxValid = false;
            }
            treeInfo.deterministic = treeInfo.deterministic && this.cmin == this.cmax ? bl3 : false;
            return this.next.study(treeInfo);
        }

        boolean match0(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            int[] nArray = matcher.groups;
            int n4 = nArray[this.groupIndex];
            int n5 = nArray[this.groupIndex + 1];
            if (n3 < this.cmax && this.atom.match(matcher, n2, charSequence)) {
                int n6 = matcher.last - n2;
                if (n6 <= 0) {
                    nArray[this.groupIndex] = n2;
                    nArray[this.groupIndex + 1] = n2 += n6;
                } else {
                    block7: {
                        do {
                            nArray[this.groupIndex] = n2;
                            nArray[this.groupIndex + 1] = n2 += n6;
                            if (++n3 >= this.cmax || !this.atom.match(matcher, n2, charSequence)) break block7;
                        } while (n2 + n6 == matcher.last);
                        if (this.match0(matcher, n2, n3, charSequence)) {
                            return true;
                        }
                    }
                    while (n3 > this.cmin) {
                        if (this.next.match(matcher, n2, charSequence)) {
                            nArray[this.groupIndex + 1] = n2;
                            nArray[this.groupIndex] = n2 -= n6;
                            return true;
                        }
                        nArray[this.groupIndex + 1] = n2;
                        nArray[this.groupIndex] = n2 -= n6;
                        --n3;
                    }
                }
            }
            nArray[this.groupIndex] = n4;
            nArray[this.groupIndex + 1] = n5;
            return this.next.match(matcher, n2, charSequence);
        }

        boolean match1(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            while (!this.next.match(matcher, n2, charSequence)) {
                if (n3 >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, n2, charSequence)) {
                    return false;
                }
                if (n2 == matcher.last) {
                    return false;
                }
                matcher.groups[this.groupIndex] = n2;
                matcher.groups[this.groupIndex + 1] = n2 = matcher.last;
                ++n3;
            }
            return true;
        }

        boolean match2(Matcher matcher, int n2, int n3, CharSequence charSequence) {
            while (n3 < this.cmax && this.atom.match(matcher, n2, charSequence)) {
                matcher.groups[this.groupIndex] = n2;
                matcher.groups[this.groupIndex + 1] = matcher.last;
                if (n2 == matcher.last) break;
                n2 = matcher.last;
                ++n3;
            }
            return this.next.match(matcher, n2, charSequence);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int[] nArray = matcher.groups;
            int[] nArray2 = matcher.locals;
            int n3 = nArray2[this.localIndex];
            int n4 = nArray[this.groupIndex];
            int n5 = nArray[this.groupIndex + 1];
            nArray2[this.localIndex] = -1;
            boolean bl2 = true;
            for (int i2 = 0; i2 < this.cmin; ++i2) {
                if (!this.atom.match(matcher, n2, charSequence)) {
                    bl2 = false;
                    break;
                }
                nArray[this.groupIndex] = n2;
                nArray[this.groupIndex + 1] = n2 = matcher.last;
            }
            if (bl2) {
                bl2 = this.type == 0 ? this.match0(matcher, n2, this.cmin, charSequence) : (this.type == 1 ? this.match1(matcher, n2, this.cmin, charSequence) : this.match2(matcher, n2, this.cmin, charSequence));
            }
            if (!bl2) {
                nArray2[this.localIndex] = n3;
                nArray[this.groupIndex] = n4;
                nArray[this.groupIndex + 1] = n5;
            }
            return bl2;
        }
    }

    static final class GroupHead
    extends Node {
        int localIndex;

        GroupHead(int n2) {
            this.localIndex = n2;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.locals[this.localIndex];
            matcher.locals[this.localIndex] = n2;
            boolean bl2 = this.next.match(matcher, n2, charSequence);
            matcher.locals[this.localIndex] = n3;
            return bl2;
        }

        boolean matchRef(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.locals[this.localIndex];
            matcher.locals[this.localIndex] = ~n2;
            boolean bl2 = this.next.match(matcher, n2, charSequence);
            matcher.locals[this.localIndex] = n3;
            return bl2;
        }
    }

    static final class GroupRef
    extends Node {
        GroupHead head;

        GroupRef(GroupHead groupHead) {
            this.head = groupHead;
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return this.head.matchRef(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence);
        }
    }

    static final class GroupTail
    extends Node {
        int localIndex;
        int groupIndex;

        GroupTail(int n2, int n3) {
            this.localIndex = n2;
            this.groupIndex = n3 + n3;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.locals[this.localIndex];
            if (n3 >= 0) {
                int n4 = matcher.groups[this.groupIndex];
                int n5 = matcher.groups[this.groupIndex + 1];
                matcher.groups[this.groupIndex] = n3;
                matcher.groups[this.groupIndex + 1] = n2;
                if (this.next.match(matcher, n2, charSequence)) {
                    return true;
                }
                matcher.groups[this.groupIndex] = n4;
                matcher.groups[this.groupIndex + 1] = n5;
                return false;
            }
            matcher.last = n2;
            return true;
        }
    }

    static final class LastMatch
    extends Node {
        LastMatch() {
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 != matcher.oldLast) {
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static class LastNode
    extends Node {
        LastNode() {
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (matcher.acceptMode == 1 && n2 != matcher.to) {
                return false;
            }
            matcher.last = n2;
            matcher.groups[0] = matcher.first;
            matcher.groups[1] = matcher.last;
            return true;
        }
    }

    static final class LazyLoop
    extends Loop {
        LazyLoop(int n2, int n3) {
            super(n2, n3);
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 > matcher.locals[this.beginIndex]) {
                int n3 = matcher.locals[this.countIndex];
                if (n3 < this.cmin) {
                    matcher.locals[this.countIndex] = n3 + 1;
                    boolean bl2 = this.body.match(matcher, n2, charSequence);
                    if (!bl2) {
                        matcher.locals[this.countIndex] = n3;
                    }
                    return bl2;
                }
                if (this.next.match(matcher, n2, charSequence)) {
                    return true;
                }
                if (n3 < this.cmax) {
                    matcher.locals[this.countIndex] = n3 + 1;
                    boolean bl3 = this.body.match(matcher, n2, charSequence);
                    if (!bl3) {
                        matcher.locals[this.countIndex] = n3;
                    }
                    return bl3;
                }
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }

        boolean matchInit(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.locals[this.countIndex];
            boolean bl2 = false;
            if (0 < this.cmin) {
                matcher.locals[this.countIndex] = 1;
                bl2 = this.body.match(matcher, n2, charSequence);
            } else if (this.next.match(matcher, n2, charSequence)) {
                bl2 = true;
            } else if (0 < this.cmax) {
                matcher.locals[this.countIndex] = 1;
                bl2 = this.body.match(matcher, n2, charSequence);
            }
            matcher.locals[this.countIndex] = n3;
            return bl2;
        }
    }

    static class Loop
    extends Node {
        Node body;
        int countIndex;
        int beginIndex;
        int cmin;
        int cmax;

        Loop(int n2, int n3) {
            this.countIndex = n2;
            this.beginIndex = n3;
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 > matcher.locals[this.beginIndex]) {
                int n3 = matcher.locals[this.countIndex];
                if (n3 < this.cmin) {
                    matcher.locals[this.countIndex] = n3 + 1;
                    boolean bl2 = this.body.match(matcher, n2, charSequence);
                    if (!bl2) {
                        matcher.locals[this.countIndex] = n3;
                    }
                    return bl2;
                }
                if (n3 < this.cmax) {
                    matcher.locals[this.countIndex] = n3 + 1;
                    boolean bl3 = this.body.match(matcher, n2, charSequence);
                    if (!bl3) {
                        matcher.locals[this.countIndex] = n3;
                    } else {
                        return true;
                    }
                }
            }
            return this.next.match(matcher, n2, charSequence);
        }

        boolean matchInit(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = matcher.locals[this.countIndex];
            boolean bl2 = false;
            if (0 < this.cmin) {
                matcher.locals[this.countIndex] = 1;
                bl2 = this.body.match(matcher, n2, charSequence);
            } else if (0 < this.cmax) {
                matcher.locals[this.countIndex] = 1;
                bl2 = this.body.match(matcher, n2, charSequence);
                if (!bl2) {
                    bl2 = this.next.match(matcher, n2, charSequence);
                }
            } else {
                bl2 = this.next.match(matcher, n2, charSequence);
            }
            matcher.locals[this.countIndex] = n3;
            return bl2;
        }
    }

    static final class Neg
    extends Node {
        Node cond;

        Neg(Node node) {
            this.cond = node;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return !this.cond.match(matcher, n2, charSequence) && this.next.match(matcher, n2, charSequence);
        }
    }

    static class Node {
        Node next = accept;

        Node() {
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new Not(this);
            }
            throw new RuntimeException("internal error in Node dup()");
        }

        boolean study(TreeInfo treeInfo) {
            if (this.next != null) {
                return this.next.study(treeInfo);
            }
            return treeInfo.deterministic;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            matcher.last = n2;
            matcher.groups[0] = matcher.first;
            matcher.groups[1] = matcher.last;
            return true;
        }
    }

    static final class Not
    extends Node {
        Node atom;

        Not(Node node) {
            this.atom = node;
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return !this.atom.match(matcher, n2, charSequence) && this.next.match(matcher, n2 + 1, charSequence);
        }
    }

    static final class NotBehind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        NotBehind(Node node, int n2, int n3) {
            this.cond = node;
            this.rmax = n2;
            this.rmin = n3;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            int n3 = Math.max(n2 - this.rmax, matcher.from);
            for (int i2 = n2 - this.rmin; i2 >= n3; --i2) {
                if (!this.cond.match(matcher, i2, charSequence) || matcher.last != n2) continue;
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static final class NotCtype
    extends Node {
        int ctype;

        NotCtype(int n2) {
            this.ctype = n2;
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new Ctype(this.ctype);
            }
            return new NotCtype(this.ctype);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return n2 < matcher.to && !ASCII.isType(charSequence.charAt(n2), this.ctype) && this.next.match(matcher, n2 + 1, charSequence);
        }
    }

    static class NotRange
    extends Node {
        int lower;
        int upper;

        NotRange() {
        }

        NotRange(int n2) {
            this.lower = n2 >>> 16;
            this.upper = n2 & 0xFFFF;
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new Range((this.lower << 16) + this.upper);
            }
            return new NotRange((this.lower << 16) + this.upper);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                char c2 = charSequence.charAt(n2);
                return (c2 - this.lower | this.upper - c2) < 0 && this.next.match(matcher, n2 + 1, charSequence);
            }
            return false;
        }
    }

    static final class NotSingle
    extends Node {
        int ch;

        NotSingle(int n2) {
            this.ch = n2;
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new Single(this.ch);
            }
            return new NotSingle(this.ch);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return n2 < matcher.to && charSequence.charAt(n2) != this.ch && this.next.match(matcher, n2 + 1, charSequence);
        }
    }

    static final class NotSingleA
    extends Node {
        int ch;

        NotSingleA(int n2) {
            this.ch = ASCII.toLower(n2);
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new SingleA(this.ch);
            }
            return new NotSingleA(this.ch);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            char c2;
            if (n2 < matcher.to && (c2 = charSequence.charAt(n2)) != this.ch && ASCII.toLower(c2) != this.ch) {
                return this.next.match(matcher, n2 + 1, charSequence);
            }
            return false;
        }
    }

    static final class NotSingleU
    extends Node {
        int ch;

        NotSingleU(int n2) {
            this.ch = Character.toLowerCase(Character.toUpperCase((char)n2));
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new SingleU(this.ch);
            }
            return new NotSingleU(this.ch);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                char c2 = charSequence.charAt(n2);
                if (c2 == this.ch) {
                    return false;
                }
                c2 = Character.toUpperCase(c2);
                if ((c2 = Character.toLowerCase(c2)) != this.ch) {
                    return this.next.match(matcher, n2 + 1, charSequence);
                }
            }
            return false;
        }
    }

    static final class Pos
    extends Node {
        Node cond;

        Pos(Node node) {
            this.cond = node;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return this.cond.match(matcher, n2, charSequence) && this.next.match(matcher, n2, charSequence);
        }
    }

    static final class Prolog
    extends Node {
        Loop loop;

        Prolog(Loop loop) {
            this.loop = loop;
        }

        boolean study(TreeInfo treeInfo) {
            return this.loop.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return this.loop.matchInit(matcher, n2, charSequence);
        }
    }

    static final class Ques
    extends Node {
        Node atom;
        int type;

        Ques(Node node, int n2) {
            this.atom = node;
            this.type = n2;
        }

        boolean study(TreeInfo treeInfo) {
            if (this.type != 3) {
                int n2 = treeInfo.minLength;
                this.atom.study(treeInfo);
                treeInfo.minLength = n2;
                treeInfo.deterministic = false;
                return this.next.study(treeInfo);
            }
            this.atom.study(treeInfo);
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            switch (this.type) {
                case 0: {
                    return this.atom.match(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence) || this.next.match(matcher, n2, charSequence);
                }
                case 1: {
                    return this.next.match(matcher, n2, charSequence) || this.atom.match(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence);
                }
                case 2: {
                    if (this.atom.match(matcher, n2, charSequence)) {
                        n2 = matcher.last;
                    }
                    return this.next.match(matcher, n2, charSequence);
                }
            }
            return this.atom.match(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence);
        }
    }

    static class Range
    extends Node {
        int lower;
        int upper;

        Range() {
        }

        Range(int n2) {
            this.lower = n2 >>> 16;
            this.upper = n2 & 0xFFFF;
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new NotRange((this.lower << 16) + this.upper);
            }
            return new Range((this.lower << 16) + this.upper);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                char c2 = charSequence.charAt(n2);
                return (c2 - this.lower | this.upper - c2) >= 0 && this.next.match(matcher, n2 + 1, charSequence);
            }
            return false;
        }
    }

    static final class Single
    extends Node {
        int ch;

        Single(int n2) {
            this.ch = n2;
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new NotSingle(this.ch);
            }
            return new Single(this.ch);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            return n2 < matcher.to && charSequence.charAt(n2) == this.ch && this.next.match(matcher, n2 + 1, charSequence);
        }
    }

    static final class SingleA
    extends Node {
        int ch;

        SingleA(int n2) {
            this.ch = ASCII.toLower(n2);
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new NotSingleA(this.ch);
            }
            return new SingleA(this.ch);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            char c2;
            if (n2 < matcher.to && ((c2 = charSequence.charAt(n2)) == this.ch || ASCII.toLower(c2) == this.ch)) {
                return this.next.match(matcher, n2 + 1, charSequence);
            }
            return false;
        }
    }

    static final class SingleU
    extends Node {
        int ch;

        SingleU(int n2) {
            this.ch = Character.toLowerCase(Character.toUpperCase((char)n2));
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new NotSingleU(this.ch);
            }
            return new SingleU(this.ch);
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                char c2 = charSequence.charAt(n2);
                if (c2 == this.ch) {
                    return this.next.match(matcher, n2 + 1, charSequence);
                }
                c2 = Character.toUpperCase(c2);
                if ((c2 = Character.toLowerCase(c2)) == this.ch) {
                    return this.next.match(matcher, n2 + 1, charSequence);
                }
            }
            return false;
        }
    }

    static final class Slice
    extends Node {
        char[] buffer;

        Slice(char[] cArray) {
            this.buffer = cArray;
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxLength += this.buffer.length;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            char[] cArray = this.buffer;
            int n3 = cArray.length;
            if (n2 + n3 > matcher.to) {
                return false;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                if (cArray[i2] == charSequence.charAt(n2 + i2)) continue;
                return false;
            }
            return this.next.match(matcher, n2 + n3, charSequence);
        }
    }

    static final class SliceA
    extends Node {
        char[] buffer;

        SliceA(char[] cArray) {
            this.buffer = cArray;
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxLength += this.buffer.length;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            char[] cArray = this.buffer;
            int n3 = cArray.length;
            if (n2 + n3 > matcher.to) {
                return false;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = ASCII.toLower(charSequence.charAt(n2 + i2));
                if (cArray[i2] == n4) continue;
                return false;
            }
            return this.next.match(matcher, n2 + n3, charSequence);
        }
    }

    static final class SliceU
    extends Node {
        char[] buffer;

        SliceU(char[] cArray) {
            this.buffer = cArray;
        }

        boolean study(TreeInfo treeInfo) {
            treeInfo.minLength += this.buffer.length;
            treeInfo.maxLength += this.buffer.length;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            char[] cArray = this.buffer;
            int n3 = cArray.length;
            if (n2 + n3 > matcher.to) {
                return false;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                char c2 = charSequence.charAt(n2 + i2);
                c2 = Character.toUpperCase(c2);
                if (cArray[i2] == (c2 = Character.toLowerCase(c2))) continue;
                return false;
            }
            return this.next.match(matcher, n2 + n3, charSequence);
        }
    }

    static final class Specials
    extends Node {
        Specials() {
        }

        Node dup(boolean bl2) {
            if (bl2) {
                return new Not(this);
            }
            return new Specials();
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                char c2 = charSequence.charAt(n2);
                return ((c2 - 65520 | 65533 - c2) >= 0 || c2 == '\ufeff') && this.next.match(matcher, n2 + 1, charSequence);
            }
            return false;
        }
    }

    static final class Start
    extends Node {
        int minLength;

        Start(Node node) {
            this.next = node;
            TreeInfo treeInfo = new TreeInfo();
            this.next.study(treeInfo);
            this.minLength = treeInfo.minLength;
        }

        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            treeInfo.maxValid = false;
            treeInfo.deterministic = false;
            return false;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 > matcher.to - this.minLength) {
                return false;
            }
            boolean bl2 = false;
            int n3 = matcher.to - this.minLength;
            while (n2 <= n3 && !(bl2 = this.next.match(matcher, n2, charSequence))) {
                ++n2;
            }
            if (bl2) {
                matcher.groups[0] = matcher.first = n2;
                matcher.groups[1] = matcher.last;
            }
            return bl2;
        }
    }

    static final class Sub
    extends Add {
        boolean study(TreeInfo treeInfo) {
            this.lhs.study(treeInfo);
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                return !this.rhs.match(matcher, n2, charSequence) && this.lhs.match(matcher, n2, charSequence) && this.next.match(matcher, matcher.last, charSequence);
            }
            return false;
        }

        Sub(Node node, Node node2) {
            super(node, node2);
        }
    }

    static final class TreeInfo {
        int minLength;
        int maxLength;
        boolean maxValid;
        boolean deterministic;

        TreeInfo() {
            this.reset();
        }

        void reset() {
            this.minLength = 0;
            this.maxLength = 0;
            this.maxValid = true;
            this.deterministic = true;
        }
    }

    static final class UnixCaret
    extends Node {
        UnixCaret() {
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            char c2;
            if (n2 > matcher.from && (c2 = charSequence.charAt(n2 - 1)) != '\n') {
                return false;
            }
            if (n2 == matcher.to) {
                return false;
            }
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static final class UnixDollar
    extends Node {
        boolean multiline;

        UnixDollar(boolean bl2) {
            this.multiline = bl2;
        }

        boolean study(TreeInfo treeInfo) {
            this.next.study(treeInfo);
            return treeInfo.deterministic;
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                char c2 = charSequence.charAt(n2);
                if (c2 == '\n') {
                    if (!this.multiline && n2 != matcher.to - 1) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            return this.next.match(matcher, n2, charSequence);
        }
    }

    static final class UnixDot
    extends Node {
        UnixDot() {
        }

        boolean study(TreeInfo treeInfo) {
            ++treeInfo.minLength;
            ++treeInfo.maxLength;
            return this.next.study(treeInfo);
        }

        boolean match(Matcher matcher, int n2, CharSequence charSequence) {
            if (n2 < matcher.to) {
                char c2 = charSequence.charAt(n2);
                return c2 != '\n' && this.next.match(matcher, n2 + 1, charSequence);
            }
            return false;
        }
    }
}

