/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.extensions.ExtensionHandler;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.ref.DTMNodeList;
import org.apache.xml.utils.StringVector;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xpath.XPathProcessorException;
import org.apache.xpath.objects.XObject;

public class ExtensionHandlerGeneral
extends ExtensionHandler {
    private String m_scriptSrc;
    private String m_scriptSrcURL;
    private Hashtable m_functions = new Hashtable();
    private Hashtable m_elements = new Hashtable();
    private Object m_mgr;
    private Object m_engine;
    private static final String BSF_MANAGER = "com.ibm.bsf.BSFManager";
    private static Class managerClass;
    private static Method mgrLoadScriptingEngine;
    private static final String BSF_ENGINE = "com.ibm.bsf.BSFEngine";
    private static Method engineExec;
    private static Method engineCall;
    private static final Integer NEG1INT;

    static {
        NEG1INT = new Integer(-1);
        try {
            managerClass = ExtensionHandler.getClassForName(BSF_MANAGER);
            mgrLoadScriptingEngine = managerClass.getMethod("loadScriptingEngine", new Class[]{String.class});
            Class clazz = ExtensionHandler.getClassForName(BSF_ENGINE);
            engineExec = clazz.getMethod("exec", new Class[]{String.class, Integer.TYPE, Integer.TYPE, Object.class});
            engineCall = clazz.getMethod("call", new Class[]{Object.class, String.class, Class.forName("[Ljava.lang.Object;")});
        }
        catch (Exception exception) {
            managerClass = null;
            mgrLoadScriptingEngine = null;
            engineExec = null;
            engineCall = null;
            exception.printStackTrace();
        }
    }

    public boolean isElementAvailable(String string) {
        return this.m_elements.get(string) != null;
    }

    public boolean isFunctionAvailable(String string) {
        return this.m_functions.get(string) != null;
    }

    public Object callFunction(String string, Vector vector, Object object, ExpressionContext expressionContext) throws TransformerException {
        try {
            Object[] objectArray = new Object[vector.size()];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object2 = vector.elementAt(i2);
                objectArray[i2] = object2 instanceof XObject ? ((XObject)object2).object() : object2;
                object2 = objectArray[i2];
                if (null == object2 || !(object2 instanceof DTMIterator)) continue;
                objectArray[i2] = new DTMNodeList((DTMIterator)object2);
            }
            return engineCall.invoke(this.m_engine, new Object[]{null, string, objectArray});
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string2 = exception.getMessage();
            if (null != string2) {
                if (string2.startsWith("Stopping after fatal error:")) {
                    string2 = string2.substring("Stopping after fatal error:".length());
                }
                throw new TransformerException(exception);
            }
            throw new TransformerException(XSLMessages.createMessage("ER_CANNOT_CREATE_EXTENSN", new Object[]{string, exception}));
        }
    }

    public void processElement(String string, ElemTemplateElement elemTemplateElement, TransformerImpl transformerImpl, Stylesheet stylesheet, Object object) throws TransformerException, IOException {
        Object object2 = null;
        XSLProcessorContext xSLProcessorContext = new XSLProcessorContext(transformerImpl, stylesheet);
        try {
            Vector vector = new Vector(2);
            vector.addElement(xSLProcessorContext);
            vector.addElement(elemTemplateElement);
            object2 = this.callFunction(string, vector, object, transformerImpl.getXPathContext().getExpressionContext());
        }
        catch (XPathProcessorException xPathProcessorException) {
            throw new TransformerException(xPathProcessorException.getMessage(), xPathProcessorException);
        }
        if (object2 != null) {
            xSLProcessorContext.outputToResultTree(stylesheet, object2);
        }
    }

    public ExtensionHandlerGeneral(String string, StringVector stringVector, StringVector stringVector2, String string2, String string3, String string4, String string5) throws TransformerException {
        super(string, string2);
        String string6;
        int n2;
        int n3;
        Object object;
        if (stringVector != null) {
            object = new Object();
            n3 = stringVector.size();
            for (n2 = 0; n2 < n3; ++n2) {
                string6 = stringVector.elementAt(n2);
                this.m_elements.put(string6, object);
            }
        }
        if (stringVector2 != null) {
            object = new Object();
            n3 = stringVector2.size();
            for (n2 = 0; n2 < n3; ++n2) {
                string6 = stringVector2.elementAt(n2);
                this.m_functions.put(string6, object);
            }
        }
        this.m_scriptSrcURL = string3;
        this.m_scriptSrc = string4;
        if (this.m_scriptSrcURL != null) {
            object = null;
            try {
                object = new URL(this.m_scriptSrcURL);
            }
            catch (MalformedURLException malformedURLException) {
                n2 = this.m_scriptSrcURL.indexOf(58);
                int n4 = this.m_scriptSrcURL.indexOf(47);
                if (n2 != -1 && n4 != -1 && n2 < n4) {
                    object = null;
                    throw new TransformerException(XSLMessages.createMessage("ER_COULD_NOT_FIND_EXTERN_SCRIPT", new Object[]{this.m_scriptSrcURL}), malformedURLException);
                }
                try {
                    object = new URL(new URL(SystemIDResolver.getAbsoluteURI(string5)), this.m_scriptSrcURL);
                }
                catch (MalformedURLException malformedURLException2) {
                    throw new TransformerException(XSLMessages.createMessage("ER_COULD_NOT_FIND_EXTERN_SCRIPT", new Object[]{this.m_scriptSrcURL}), malformedURLException2);
                }
            }
            if (object != null) {
                try {
                    URLConnection uRLConnection = ((URL)object).openConnection();
                    InputStream inputStream = uRLConnection.getInputStream();
                    byte[] byArray = new byte[uRLConnection.getContentLength()];
                    inputStream.read(byArray);
                    this.m_scriptSrc = new String(byArray);
                }
                catch (IOException iOException) {
                    throw new TransformerException(XSLMessages.createMessage("ER_COULD_NOT_FIND_EXTERN_SCRIPT", new Object[]{this.m_scriptSrcURL}), iOException);
                }
            }
        }
        if (null == managerClass) {
            throw new TransformerException(XSLMessages.createMessage("ER_CANNOT_INIT_BSFMGR", null));
        }
        try {
            this.m_mgr = managerClass.newInstance();
            this.m_engine = mgrLoadScriptingEngine.invoke(this.m_mgr, new Object[]{string2});
            engineExec.invoke(this.m_engine, new Object[]{"XalanScript", NEG1INT, NEG1INT, this.m_scriptSrc});
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new TransformerException(XSLMessages.createMessage("ER_CANNOT_CMPL_EXTENSN", null), exception);
        }
    }
}

