/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.geom;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import sun.awt.geom.ChainEnd;
import sun.awt.geom.Curve;
import sun.awt.geom.CurveLink;
import sun.awt.geom.Edge;

public abstract class AreaOp {
    public static final int CTAG_LEFT = 0;
    public static final int CTAG_RIGHT = 1;
    public static final int ETAG_IGNORE = 0;
    public static final int ETAG_ENTER = 1;
    public static final int ETAG_EXIT = -1;
    public static final int RSTAG_INSIDE = 1;
    public static final int RSTAG_OUTSIDE = -1;
    private static Comparator YXTopComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            double d2;
            Curve curve = ((Edge)object).getCurve();
            Curve curve2 = ((Edge)object2).getCurve();
            double d3 = curve.getYTop();
            if (d3 == (d2 = curve2.getYTop()) && (d3 = curve.getXTop()) == (d2 = curve2.getXTop())) {
                return 0;
            }
            if (d3 < d2) {
                return -1;
            }
            return 1;
        }
    };
    private static CurveLink[] EmptyLinkList = new CurveLink[2];
    private static ChainEnd[] EmptyChainList = new ChainEnd[2];

    public abstract int getState();

    private AreaOp() {
    }

    public abstract void newRow();

    public static boolean obstructs(double d2, double d3, int n2) {
        return (n2 & 1) == 0 ? d2 <= d3 : d2 < d3;
    }

    public abstract int classify(Edge var1);

    private Vector pruneEdges(Vector vector) {
        int n2 = vector.size();
        if (n2 < 2) {
            return vector;
        }
        Object[] objectArray = (Edge[])vector.toArray(new Edge[n2]);
        Arrays.sort(objectArray, YXTopComparator);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double[] dArray = new double[2];
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        while (n3 < n2) {
            int n7;
            Object object;
            double d2 = dArray[0];
            for (n5 = n6 = n4 - 1; n5 >= n3; --n5) {
                object = objectArray[n5];
                if (!(((Edge)object).getCurve().getYBot() > d2)) continue;
                if (n6 > n5) {
                    objectArray[n6] = object;
                }
                --n6;
            }
            n3 = n6 + 1;
            if (n3 >= n4) {
                if (n4 >= n2) break;
                d2 = ((Edge)objectArray[n4]).getCurve().getYTop();
                if (d2 > dArray[0]) {
                    AreaOp.finalizeSubCurves(vector2, vector3);
                }
                dArray[0] = d2;
            }
            while (n4 < n2 && !(((Edge)(object = objectArray[n4])).getCurve().getYTop() > d2)) {
                ++n4;
            }
            dArray[1] = ((Edge)objectArray[n3]).getCurve().getYBot();
            if (n4 < n2 && dArray[1] > (d2 = ((Edge)objectArray[n4]).getCurve().getYTop())) {
                dArray[1] = d2;
            }
            int n8 = 1;
            for (n5 = n3; n5 < n4; ++n5) {
                object = objectArray[n5];
                ((Edge)object).setEquivalence(0);
                for (n6 = n5; n6 > n3; --n6) {
                    Object object2 = objectArray[n6 - 1];
                    int n9 = ((Edge)object).compareTo((Edge)object2, dArray);
                    if (dArray[1] <= dArray[0]) {
                        throw new InternalError("backstepping to " + dArray[1] + " from " + dArray[0]);
                    }
                    if (n9 >= 0) {
                        if (n9 != 0) break;
                        int n10 = ((Edge)object2).getEquivalence();
                        if (n10 == 0) {
                            n10 = n8++;
                            ((Edge)object2).setEquivalence(n10);
                        }
                        ((Edge)object).setEquivalence(n10);
                        break;
                    }
                    objectArray[n6] = object2;
                }
                objectArray[n6] = object;
            }
            this.newRow();
            double d3 = dArray[0];
            double d4 = dArray[1];
            for (n5 = n3; n5 < n4; ++n5) {
                object = objectArray[n5];
                int n11 = ((Edge)object).getEquivalence();
                if (n11 != 0) {
                    int n12 = this.getState();
                    n7 = n12 == 1 ? -1 : 1;
                    Object object3 = null;
                    Object object4 = object;
                    double d5 = d4;
                    do {
                        this.classify((Edge)object);
                        if (object3 == null && ((Edge)object).isActiveFor(d3, n7)) {
                            object3 = object;
                        }
                        if (!((d2 = ((Edge)object).getCurve().getYBot()) > d5)) continue;
                        object4 = object;
                        d5 = d2;
                    } while (++n5 < n4 && ((Edge)(object = objectArray[n5])).getEquivalence() == n11);
                    --n5;
                    if (this.getState() == n12) {
                        n7 = 0;
                    } else {
                        object = object3 != null ? object3 : object4;
                    }
                } else {
                    n7 = this.classify((Edge)object);
                }
                if (n7 == 0) continue;
                ((Edge)object).record(d4, n7);
                vector4.add(new CurveLink(((Edge)object).getCurve(), d3, d4, n7));
            }
            if (this.getState() != -1) {
                System.out.println("Still inside at end of active edge list!");
                System.out.println("num curves = " + (n4 - n3));
                System.out.println("num links = " + vector4.size());
                System.out.println("y top = " + dArray[0]);
                if (n4 < n2) {
                    System.out.println("y top of next curve = " + ((Edge)objectArray[n4]).getCurve().getYTop());
                } else {
                    System.out.println("no more curves");
                }
                for (n5 = n3; n5 < n4; ++n5) {
                    object = objectArray[n5];
                    System.out.println(object);
                    n7 = ((Edge)object).getEquivalence();
                    if (n7 == 0) continue;
                    System.out.println("  was equal to " + n7 + "...");
                }
            }
            AreaOp.resolveLinks(vector2, vector3, vector4);
            vector4.clear();
            dArray[0] = d4;
        }
        AreaOp.finalizeSubCurves(vector2, vector3);
        Vector vector5 = new Vector();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            CurveLink curveLink = (CurveLink)enumeration.nextElement();
            vector5.add(curveLink.getMoveto());
            CurveLink curveLink2 = curveLink;
            while ((curveLink2 = curveLink2.getNext()) != null) {
                if (curveLink.absorb(curveLink2)) continue;
                vector5.add(curveLink.getSubCurve());
                curveLink = curveLink2;
            }
            vector5.add(curveLink.getSubCurve());
        }
        return vector5;
    }

    public static void finalizeSubCurves(Vector vector, Vector vector2) {
        int n2 = vector2.size();
        if (n2 == 0) {
            return;
        }
        if ((n2 & 1) != 0) {
            throw new InternalError("Odd number of chains!");
        }
        Object[] objectArray = new ChainEnd[n2];
        vector2.toArray(objectArray);
        for (int i2 = 1; i2 < n2; i2 += 2) {
            Object object = objectArray[i2 - 1];
            Object object2 = objectArray[i2];
            CurveLink curveLink = ((ChainEnd)object).linkTo((ChainEnd)object2);
            if (curveLink == null) continue;
            vector.add(curveLink);
        }
        vector2.clear();
    }

    private static void addEdges(Vector vector, Vector vector2, int n2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Curve curve = (Curve)enumeration.nextElement();
            if (curve.getOrder() <= 0) continue;
            vector.add(new Edge(curve, n2));
        }
    }

    public Vector calculate(Vector vector, Vector vector2) {
        Vector vector3 = new Vector();
        AreaOp.addEdges(vector3, vector, 0);
        AreaOp.addEdges(vector3, vector2, 1);
        vector3 = this.pruneEdges(vector3);
        return vector3;
    }

    public static void resolveLinks(Vector vector, Vector vector2, Vector vector3) {
        Object[] objectArray;
        Object[] objectArray2;
        int n2 = vector3.size();
        if (n2 == 0) {
            objectArray2 = EmptyLinkList;
        } else {
            if ((n2 & 1) != 0) {
                throw new InternalError("Odd number of new curves!");
            }
            objectArray2 = new CurveLink[n2 + 2];
            vector3.toArray(objectArray2);
        }
        int n3 = vector2.size();
        if (n3 == 0) {
            objectArray = EmptyChainList;
        } else {
            if ((n3 & 1) != 0) {
                throw new InternalError("Odd number of chains!");
            }
            objectArray = new ChainEnd[n3 + 2];
            vector2.toArray(objectArray);
        }
        int n4 = 0;
        int n5 = 0;
        vector2.clear();
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        Object object3 = objectArray2[0];
        Object object4 = objectArray2[1];
        while (object != null || object3 != null) {
            boolean bl2;
            boolean bl3 = object3 == null;
            boolean bl4 = bl2 = object == null;
            if (!bl3 && !bl2) {
                bl3 = !(n4 & true) && ((ChainEnd)object).getX() == ((ChainEnd)object2).getX();
                boolean bl5 = bl2 = !(n5 & true) && ((CurveLink)object3).getX() == ((CurveLink)object4).getX();
                if (!bl3 && !bl2) {
                    double d2 = ((ChainEnd)object).getX();
                    double d3 = ((CurveLink)object3).getX();
                    bl3 = object2 != null && d2 < d3 && AreaOp.obstructs(((ChainEnd)object2).getX(), d3, n4);
                    boolean bl6 = bl2 = object4 != null && d3 < d2 && AreaOp.obstructs(((CurveLink)object4).getX(), d2, n5);
                }
            }
            if (bl3) {
                CurveLink curveLink = ((ChainEnd)object).linkTo((ChainEnd)object2);
                if (curveLink != null) {
                    vector.add(curveLink);
                }
                object = objectArray[n4 += 2];
                object2 = objectArray[n4 + 1];
            }
            if (bl2) {
                ChainEnd chainEnd = new ChainEnd((CurveLink)object3, null);
                ChainEnd chainEnd2 = new ChainEnd((CurveLink)object4, chainEnd);
                chainEnd.setOtherEnd(chainEnd2);
                vector2.add(chainEnd);
                vector2.add(chainEnd2);
                object3 = objectArray2[n5 += 2];
                object4 = objectArray2[n5 + 1];
            }
            if (bl3 || bl2) continue;
            ((ChainEnd)object).addLink((CurveLink)object3);
            vector2.add(object);
            object = object2;
            object2 = objectArray[++n4 + 1];
            object3 = object4;
            object4 = objectArray2[++n5 + 1];
        }
        if ((vector2.size() & 1) != 0) {
            System.out.println("Odd number of chains!");
        }
    }

    public static class AddOp
    extends CAGOp {
        public boolean newClassification(boolean bl2, boolean bl3) {
            return bl2 || bl3;
        }
    }

    public static abstract class CAGOp
    extends AreaOp {
        boolean inLeft;
        boolean inRight;
        boolean inResult;

        public int getState() {
            return this.inResult ? 1 : -1;
        }

        public void newRow() {
            this.inLeft = false;
            this.inRight = false;
            this.inResult = false;
        }

        public abstract boolean newClassification(boolean var1, boolean var2);

        public int classify(Edge edge) {
            if (edge.getCurveTag() == 0) {
                this.inLeft = !this.inLeft;
            } else {
                this.inRight = !this.inRight;
            }
            boolean bl2 = this.newClassification(this.inLeft, this.inRight);
            if (this.inResult == bl2) {
                return 0;
            }
            this.inResult = bl2;
            return bl2 ? 1 : -1;
        }
    }

    public static class EOWindOp
    extends AreaOp {
        private boolean inside;

        public int getState() {
            return this.inside ? 1 : -1;
        }

        public void newRow() {
            this.inside = false;
        }

        public int classify(Edge edge) {
            boolean bl2;
            this.inside = bl2 = !this.inside;
            return bl2 ? 1 : -1;
        }
    }

    public static class IntOp
    extends CAGOp {
        public boolean newClassification(boolean bl2, boolean bl3) {
            return bl2 && bl3;
        }
    }

    public static class NZWindOp
    extends AreaOp {
        private int count;

        public int getState() {
            return this.count == 0 ? -1 : 1;
        }

        public void newRow() {
            this.count = 0;
        }

        public int classify(Edge edge) {
            int n2 = this.count;
            int n3 = n2 == 0 ? 1 : 0;
            this.count = n2 += edge.getCurve().getDirection();
            return n2 == 0 ? -1 : n3;
        }
    }

    public static class SubOp
    extends CAGOp {
        public boolean newClassification(boolean bl2, boolean bl3) {
            return bl2 && !bl3;
        }
    }

    public static class XorOp
    extends CAGOp {
        public boolean newClassification(boolean bl2, boolean bl3) {
            return bl2 != bl3;
        }
    }
}

