/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import sun.security.jgss.GSSHeader;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.Krb5Token;

abstract class MessageToken
extends Krb5Token {
    public static final byte[] ZERO_IV = new byte[8];
    public static final int TOKEN_SIZE = 24;
    public static final int FILLER = 65535;
    public static final int SIGN_DES_MAC_MD5 = 0;
    public static final int SIGN_DES_MAC = 512;
    public static final int SEAL_DES_CBC = 0;
    public static final int SEAL_NONE = 65535;
    private static final int TOKEN_ID_POS = 0;
    private static final int SIGN_ALG_POS = 2;
    private static final int SEAL_ALG_POS = 4;
    private byte[] contextKey = null;
    private int seqNumber;
    private boolean confState = true;
    private boolean initiator = true;
    private int tokenId = 0;
    private GSSHeader gssHeader = null;
    private MessageTokenHeader tokenHeader = null;
    private byte[] checksum = null;
    private byte[] encSeqNumber = null;
    private byte[] seqNumberData = null;
    private Cipher desCipher = null;

    protected int getKrb5TokenSize() {
        return 24;
    }

    public final int getSequenceNumber() {
        return MessageToken.readLittleEndian(this.seqNumberData, 0, 4);
    }

    public final int getTokenId() {
        return this.tokenId;
    }

    public final boolean getConfState() {
        return this.confState;
    }

    public final byte[] getContextKey() {
        return this.contextKey;
    }

    protected abstract int getSealAlg(boolean var1);

    public final boolean verifySignAndSeqNumber(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3) throws GSSException {
        byte[] byArray4 = this.getChecksum(byArray, byArray2, n2, n3, byArray3);
        if (MessageDigest.isEqual(this.checksum, byArray4)) {
            this.seqNumberData = new byte[8];
            try {
                Cipher cipher = this.getInitializedDes(false, this.contextKey, this.checksum);
                cipher.update(this.encSeqNumber, 0, 8, this.seqNumberData, 0);
                cipher.doFinal();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new GSSException(11, -1, "Could not use DES Cipher while obtaining sequence number - " + generalSecurityException.getMessage());
            }
            byte by = 0;
            if (this.initiator) {
                by = -1;
            }
            if (this.seqNumberData[4] == by && this.seqNumberData[5] == by && this.seqNumberData[6] == by && this.seqNumberData[7] == by) {
                return true;
            }
        }
        return false;
    }

    private byte[] getChecksum(byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3) throws GSSException {
        Object object;
        byte[] byArray4 = this.tokenHeader.getBytes();
        byte[] byArray5 = byArray;
        byte[] byArray6 = byArray4;
        if (byArray5 != null) {
            byArray6 = new byte[byArray4.length + byArray5.length];
            System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length);
            System.arraycopy(byArray5, 0, byArray6, byArray4.length, byArray5.length);
        }
        if (this.tokenHeader.getSignAlg() == 0) {
            try {
                object = MessageDigest.getInstance("MD5");
                ((MessageDigest)object).update(byArray6);
                ((MessageDigest)object).update(byArray2, n2, n3);
                if (byArray3 != null) {
                    ((MessageDigest)object).update(byArray3);
                }
                byArray2 = ((MessageDigest)object).digest();
                n2 = 0;
                n3 = byArray2.length;
                byArray6 = null;
                byArray3 = null;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new GSSException(11, -1, "Could not get MD5 Message Digest - " + noSuchAlgorithmException.getMessage());
            }
        }
        object = this.getDesCbcChecksum(this.contextKey, byArray6, byArray2, n2, n3);
        byte[] byArray7 = new byte[8];
        System.arraycopy(object, ((Object)object).length - 8, byArray7, 0, 8);
        return byArray7;
    }

    private byte[] getDesCbcChecksum(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) throws GSSException {
        Cipher cipher = this.getInitializedDes(true, byArray, ZERO_IV);
        int n4 = cipher.getBlockSize();
        byte[] byArray4 = new byte[n4];
        int n5 = n3 / n4;
        int n6 = n3 % n4;
        if (n6 == 0) {
            System.arraycopy(byArray3, n2 + --n5 * n4, byArray4, 0, n4);
        } else {
            System.arraycopy(byArray3, n2 + n5 * n4, byArray4, 0, n6);
        }
        try {
            byte[] byArray5 = new byte[n4];
            if (byArray2 != null) {
                cipher.update(byArray2, 0, byArray2.length, byArray5, 0);
            }
            for (int i2 = 0; i2 < n5; ++i2) {
                cipher.update(byArray3, n2, n4, byArray5, 0);
                n2 += n4;
            }
            byte[] byArray6 = new byte[n4];
            cipher.update(byArray4, 0, n4, byArray6, 0);
            cipher.doFinal();
            return byArray6;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new GSSException(11, -1, "Could not use DES Cipher - " + generalSecurityException.getMessage());
        }
    }

    public void encode(OutputStream outputStream) throws IOException, GSSException {
        this.gssHeader = new GSSHeader(OID, this.getKrb5TokenSize());
        this.gssHeader.encode(outputStream);
        this.tokenHeader.encode(outputStream);
        outputStream.write(this.encSeqNumber);
        outputStream.write(this.checksum);
    }

    public final Cipher getInitializedDes(boolean bl2, byte[] byArray, byte[] byArray2) throws GSSException {
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "DES");
            if (this.desCipher == null) {
                throw new GSSException(11, -1, "Internal Error:Uninitialized desCipher");
            }
            this.desCipher.init(bl2 ? 1 : 2, (Key)secretKeySpec, ivParameterSpec);
            return this.desCipher;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new GSSException(11, -1, generalSecurityException.getMessage());
        }
    }

    public void genSignAndSeqNumber(MessageProp messageProp, byte[] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3) throws GSSException {
        int n4 = messageProp.getQOP();
        if (n4 != 0 && n4 != 2 && n4 != 3) {
            n4 = 0;
            messageProp.setQOP(n4);
        }
        if (!this.confState) {
            messageProp.setPrivacy(false);
        }
        this.tokenHeader = new MessageTokenHeader(this.tokenId, messageProp.getPrivacy(), n4);
        this.checksum = this.getChecksum(byArray, byArray2, n2, n3, byArray3);
        this.seqNumberData = new byte[8];
        MessageToken.writeLittleEndian(this.seqNumber, this.seqNumberData);
        if (!this.initiator) {
            this.seqNumberData[4] = -1;
            this.seqNumberData[5] = -1;
            this.seqNumberData[6] = -1;
            this.seqNumberData[7] = -1;
        }
        try {
            Cipher cipher = this.getInitializedDes(true, this.contextKey, this.checksum);
            this.encSeqNumber = new byte[8];
            cipher.update(this.seqNumberData, 0, 8, this.encSeqNumber, 0);
            cipher.doFinal();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new GSSException(11, -1, "Could not use DES Cipher while creating sequence number- " + generalSecurityException.getMessage());
        }
    }

    public final GSSHeader getGSSHeader() {
        return this.gssHeader;
    }

    MessageToken(int n2, Krb5Context krb5Context) throws GSSException {
        this.init(n2, krb5Context);
        this.seqNumber = krb5Context.incrementMySequenceNumber();
    }

    private void init(int n2, Krb5Context krb5Context) throws GSSException {
        this.tokenId = n2;
        this.contextKey = krb5Context.getKey().getBytes();
        this.confState = krb5Context.getConfState();
        this.initiator = krb5Context.isInitiator();
        try {
            this.desCipher = krb5Context.getDesCipher();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new GSSException(11, -1, generalSecurityException.getMessage());
        }
    }

    MessageToken(int n2, Krb5Context krb5Context, byte[] byArray, int n3, int n4, MessageProp messageProp) throws GSSException {
        this(n2, krb5Context, new ByteArrayInputStream(byArray, n3, n4), messageProp);
    }

    MessageToken(int n2, Krb5Context krb5Context, InputStream inputStream, MessageProp messageProp) throws GSSException {
        this.init(n2, krb5Context);
        try {
            this.gssHeader = new GSSHeader(inputStream);
            if (!this.gssHeader.getOid().equals(OID)) {
                throw new GSSException(10, -1, MessageToken.getTokenName(n2));
            }
            if (!this.confState) {
                messageProp.setPrivacy(false);
            }
            this.tokenHeader = new MessageTokenHeader(inputStream, messageProp);
            this.encSeqNumber = new byte[8];
            MessageToken.readFully(inputStream, this.encSeqNumber);
            this.checksum = new byte[8];
            MessageToken.readFully(inputStream, this.checksum);
        }
        catch (IOException iOException) {
            throw new GSSException(10, -1, MessageToken.getTokenName(n2));
        }
    }

    class MessageTokenHeader {
        private int tokenId = 0;
        private int signAlg = 512;
        private int sealAlg = 0;
        private byte[] bytes = new byte[8];

        public final int getSealAlg() {
            return this.sealAlg;
        }

        public final int getSignAlg() {
            return this.signAlg;
        }

        public final int getTokenId() {
            return this.tokenId;
        }

        public final byte[] getBytes() {
            return this.bytes;
        }

        public final void encode(OutputStream outputStream) throws IOException {
            outputStream.write(this.bytes);
        }

        public MessageTokenHeader(int n2, boolean bl2, int n3) {
            this.tokenId = n2;
            switch (n3) {
                default: {
                    this.signAlg = 0;
                    break;
                }
                case 3: {
                    this.signAlg = 512;
                }
            }
            this.sealAlg = MessageToken.this.getSealAlg(bl2);
            this.bytes[0] = (byte)(n2 >>> 8);
            this.bytes[1] = (byte)n2;
            this.bytes[2] = (byte)(this.signAlg >>> 8);
            this.bytes[3] = (byte)this.signAlg;
            this.bytes[4] = (byte)(this.sealAlg >>> 8);
            this.bytes[5] = (byte)this.sealAlg;
            this.bytes[6] = -1;
            this.bytes[7] = -1;
        }

        public MessageTokenHeader(InputStream inputStream, MessageProp messageProp) throws IOException {
            Krb5Token.readFully(inputStream, this.bytes);
            this.tokenId = Krb5Token.readInt(this.bytes, 0);
            this.signAlg = Krb5Token.readInt(this.bytes, 2);
            this.sealAlg = Krb5Token.readInt(this.bytes, 4);
            int n2 = Krb5Token.readInt(this.bytes, 6);
            if (this.signAlg == 512) {
                messageProp.setQOP(3);
            } else {
                this.signAlg = 0;
                messageProp.setQOP(2);
            }
            if (this.sealAlg == 0) {
                messageProp.setPrivacy(true);
            } else {
                messageProp.setPrivacy(false);
            }
        }
    }
}

