/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import sun.net.util.IPAddressUtil;
import sun.security.ssl.Debug;

final class Utilities {
    Utilities() {
    }

    static List<SNIServerName> addToSNIServerNameList(List<SNIServerName> list, String string) {
        SNIHostName sNIHostName = Utilities.rawToSNIHostName(string);
        if (sNIHostName == null) {
            return list;
        }
        int n = list.size();
        ArrayList<SNIServerName> arrayList = n != 0 ? new ArrayList<SNIServerName>(list) : new ArrayList(1);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            SNIServerName sNIServerName = (SNIServerName)arrayList.get(i);
            if (sNIServerName.getType() != 0) continue;
            arrayList.set(i, sNIHostName);
            if (Debug.isOn("ssl")) {
                System.out.println(Thread.currentThread().getName() + ", the previous server name in SNI (" + sNIServerName + ") was replaced with (" + sNIHostName + ")");
            }
            bl = true;
            break;
        }
        if (!bl) {
            arrayList.add(sNIHostName);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static SNIHostName rawToSNIHostName(String string) {
        SNIHostName sNIHostName;
        block3: {
            sNIHostName = null;
            if (!(string == null || string.indexOf(46) <= 0 || string.endsWith(".") || IPAddressUtil.isIPv4LiteralAddress(string) || IPAddressUtil.isIPv6LiteralAddress(string))) {
                try {
                    sNIHostName = new SNIHostName(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!Debug.isOn("ssl")) break block3;
                    System.out.println(Thread.currentThread().getName() + ", \"" + string + "\" " + "is not a legal HostName for  server name indication");
                }
            }
        }
        return sNIHostName;
    }
}

