/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;

    public TableDragSourceEffect(Table table) {
        super(table);
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.image = this.getDragSourceImage(dragSourceEvent);
    }

    Image getDragSourceImage(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        Table table = (Table)this.control;
        TableItem[] tableItemArray = table.getSelection();
        if (tableItemArray.length == 0) {
            return null;
        }
        int n2 = OS.SendMessage(table.handle, 4098, 1, 0);
        if (n2 != 0) {
            int n3 = Math.min(tableItemArray.length, 10);
            Rectangle rectangle = tableItemArray[0].getBounds(0);
            int n4 = 1;
            while (n4 < n3) {
                rectangle = rectangle.union(tableItemArray[n4].getBounds(0));
                ++n4;
            }
            n4 = OS.GetDC(0);
            int n5 = OS.CreateCompatibleDC(n4);
            int n6 = OS.CreateCompatibleBitmap(n4, rectangle.width, rectangle.height);
            int n7 = OS.SelectObject(n5, n6);
            RECT rECT = new RECT();
            rECT.right = rectangle.width;
            rECT.bottom = rectangle.height;
            int n8 = OS.GetStockObject(0);
            OS.FillRect(n5, rECT, n8);
            int n9 = 0;
            while (n9 < n3) {
                TableItem tableItem = tableItemArray[n9];
                Rectangle rectangle2 = tableItem.getBounds(0);
                POINT pOINT = new POINT();
                int n10 = OS.SendMessage(table.handle, 4129, table.indexOf(tableItem), pOINT);
                OS.ImageList_Draw(n10, 0, n5, rectangle2.x - rectangle.x, rectangle2.y - rectangle.y, 4);
                OS.ImageList_Destroy(n10);
                ++n9;
            }
            OS.SelectObject(n5, n7);
            OS.DeleteDC(n5);
            OS.ReleaseDC(0, n4);
            Display display = table.getDisplay();
            this.dragSourceImage = Image.win32_new(display, 0, n6);
            return this.dragSourceImage;
        }
        return null;
    }
}

