/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.a;
import org.lwjgl.i;

public final class NondirectBufferWrapper {
    private static final int INITIAL_BUFFER_SIZE = 1;
    private static final ThreadLocal thread_buffer = new i();

    private static a getCachedBuffers(int n2) {
        a a2 = (a)thread_buffer.get();
        int n3 = a.a(a2).capacity();
        if (n2 > n3) {
            a2 = new a(n2, null);
            thread_buffer.set(a2);
        }
        return a2;
    }

    public static ByteBuffer wrapNoCopyBuffer(ByteBuffer byteBuffer, int n2) {
        BufferChecks.checkBufferSize(byteBuffer, n2);
        return NondirectBufferWrapper.wrapNoCopyDirect(byteBuffer);
    }

    public static ShortBuffer wrapNoCopyBuffer(ShortBuffer shortBuffer, int n2) {
        BufferChecks.checkBufferSize(shortBuffer, n2);
        return NondirectBufferWrapper.wrapNoCopyDirect(shortBuffer);
    }

    public static IntBuffer wrapNoCopyBuffer(IntBuffer intBuffer, int n2) {
        BufferChecks.checkBufferSize(intBuffer, n2);
        return NondirectBufferWrapper.wrapNoCopyDirect(intBuffer);
    }

    public static LongBuffer wrapNoCopyBuffer(LongBuffer longBuffer, int n2) {
        BufferChecks.checkBufferSize(longBuffer, n2);
        return NondirectBufferWrapper.wrapNoCopyDirect(longBuffer);
    }

    public static FloatBuffer wrapNoCopyBuffer(FloatBuffer floatBuffer, int n2) {
        BufferChecks.checkBufferSize(floatBuffer, n2);
        return NondirectBufferWrapper.wrapNoCopyDirect(floatBuffer);
    }

    public static DoubleBuffer wrapNoCopyBuffer(DoubleBuffer doubleBuffer, int n2) {
        BufferChecks.checkBufferSize(doubleBuffer, n2);
        return NondirectBufferWrapper.wrapNoCopyDirect(doubleBuffer);
    }

    public static ByteBuffer wrapBuffer(ByteBuffer byteBuffer, int n2) {
        BufferChecks.checkBufferSize(byteBuffer, n2);
        return NondirectBufferWrapper.wrapDirect(byteBuffer);
    }

    public static ShortBuffer wrapBuffer(ShortBuffer shortBuffer, int n2) {
        BufferChecks.checkBufferSize(shortBuffer, n2);
        return NondirectBufferWrapper.wrapDirect(shortBuffer);
    }

    public static IntBuffer wrapBuffer(IntBuffer intBuffer, int n2) {
        BufferChecks.checkBufferSize(intBuffer, n2);
        return NondirectBufferWrapper.wrapDirect(intBuffer);
    }

    public static LongBuffer wrapBuffer(LongBuffer longBuffer, int n2) {
        BufferChecks.checkBufferSize(longBuffer, n2);
        return NondirectBufferWrapper.wrapDirect(longBuffer);
    }

    public static FloatBuffer wrapBuffer(FloatBuffer floatBuffer, int n2) {
        BufferChecks.checkBufferSize(floatBuffer, n2);
        return NondirectBufferWrapper.wrapDirect(floatBuffer);
    }

    public static DoubleBuffer wrapBuffer(DoubleBuffer doubleBuffer, int n2) {
        BufferChecks.checkBufferSize(doubleBuffer, n2);
        return NondirectBufferWrapper.wrapDirect(doubleBuffer);
    }

    public static ByteBuffer wrapDirect(ByteBuffer byteBuffer) {
        if (!byteBuffer.isDirect()) {
            return NondirectBufferWrapper.doWrap(byteBuffer);
        }
        return byteBuffer;
    }

    public static ShortBuffer wrapDirect(ShortBuffer shortBuffer) {
        if (!shortBuffer.isDirect()) {
            return NondirectBufferWrapper.doWrap(shortBuffer);
        }
        return shortBuffer;
    }

    public static FloatBuffer wrapDirect(FloatBuffer floatBuffer) {
        if (!floatBuffer.isDirect()) {
            return NondirectBufferWrapper.doWrap(floatBuffer);
        }
        return floatBuffer;
    }

    public static IntBuffer wrapDirect(IntBuffer intBuffer) {
        if (!intBuffer.isDirect()) {
            return NondirectBufferWrapper.doWrap(intBuffer);
        }
        return intBuffer;
    }

    public static LongBuffer wrapDirect(LongBuffer longBuffer) {
        if (!longBuffer.isDirect()) {
            return NondirectBufferWrapper.doWrap(longBuffer);
        }
        return longBuffer;
    }

    public static DoubleBuffer wrapDirect(DoubleBuffer doubleBuffer) {
        if (!doubleBuffer.isDirect()) {
            return NondirectBufferWrapper.doWrap(doubleBuffer);
        }
        return doubleBuffer;
    }

    public static ByteBuffer wrapNoCopyDirect(ByteBuffer byteBuffer) {
        if (!byteBuffer.isDirect()) {
            return NondirectBufferWrapper.doNoCopyWrap(byteBuffer);
        }
        return byteBuffer;
    }

    public static ShortBuffer wrapNoCopyDirect(ShortBuffer shortBuffer) {
        if (!shortBuffer.isDirect()) {
            return NondirectBufferWrapper.doNoCopyWrap(shortBuffer);
        }
        return shortBuffer;
    }

    public static FloatBuffer wrapNoCopyDirect(FloatBuffer floatBuffer) {
        if (!floatBuffer.isDirect()) {
            return NondirectBufferWrapper.doNoCopyWrap(floatBuffer);
        }
        return floatBuffer;
    }

    public static IntBuffer wrapNoCopyDirect(IntBuffer intBuffer) {
        if (!intBuffer.isDirect()) {
            return NondirectBufferWrapper.doNoCopyWrap(intBuffer);
        }
        return intBuffer;
    }

    public static LongBuffer wrapNoCopyDirect(LongBuffer longBuffer) {
        if (!longBuffer.isDirect()) {
            return NondirectBufferWrapper.doNoCopyWrap(longBuffer);
        }
        return longBuffer;
    }

    public static DoubleBuffer wrapNoCopyDirect(DoubleBuffer doubleBuffer) {
        if (!doubleBuffer.isDirect()) {
            return NondirectBufferWrapper.doNoCopyWrap(doubleBuffer);
        }
        return doubleBuffer;
    }

    public static void copy(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (byteBuffer2 != null && !byteBuffer2.isDirect()) {
            int n2 = byteBuffer2.position();
            byteBuffer2.put(byteBuffer);
            ((Buffer)byteBuffer2).position(n2);
        }
    }

    public static void copy(ShortBuffer shortBuffer, ShortBuffer shortBuffer2) {
        if (shortBuffer2 != null && !shortBuffer2.isDirect()) {
            int n2 = shortBuffer2.position();
            shortBuffer2.put(shortBuffer);
            ((Buffer)shortBuffer2).position(n2);
        }
    }

    public static void copy(IntBuffer intBuffer, IntBuffer intBuffer2) {
        if (intBuffer2 != null && !intBuffer2.isDirect()) {
            int n2 = intBuffer2.position();
            intBuffer2.put(intBuffer);
            ((Buffer)intBuffer2).position(n2);
        }
    }

    public static void copy(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        if (floatBuffer2 != null && !floatBuffer2.isDirect()) {
            int n2 = floatBuffer2.position();
            floatBuffer2.put(floatBuffer);
            ((Buffer)floatBuffer2).position(n2);
        }
    }

    public static void copy(LongBuffer longBuffer, LongBuffer longBuffer2) {
        if (longBuffer2 != null && !longBuffer2.isDirect()) {
            int n2 = longBuffer2.position();
            longBuffer2.put(longBuffer);
            ((Buffer)longBuffer2).position(n2);
        }
    }

    public static void copy(DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2) {
        if (doubleBuffer2 != null && !doubleBuffer2.isDirect()) {
            int n2 = doubleBuffer2.position();
            doubleBuffer2.put(doubleBuffer);
            ((Buffer)doubleBuffer2).position(n2);
        }
    }

    private static ByteBuffer doNoCopyWrap(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = NondirectBufferWrapper.lookupBuffer(byteBuffer);
        ((Buffer)byteBuffer2).limit(byteBuffer.limit());
        ((Buffer)byteBuffer2).position(byteBuffer.position());
        return byteBuffer2;
    }

    private static ShortBuffer doNoCopyWrap(ShortBuffer shortBuffer) {
        ShortBuffer shortBuffer2 = NondirectBufferWrapper.lookupBuffer(shortBuffer);
        ((Buffer)shortBuffer2).limit(shortBuffer.limit());
        ((Buffer)shortBuffer2).position(shortBuffer.position());
        return shortBuffer2;
    }

    private static IntBuffer doNoCopyWrap(IntBuffer intBuffer) {
        IntBuffer intBuffer2 = NondirectBufferWrapper.lookupBuffer(intBuffer);
        ((Buffer)intBuffer2).limit(intBuffer.limit());
        ((Buffer)intBuffer2).position(intBuffer.position());
        return intBuffer2;
    }

    private static FloatBuffer doNoCopyWrap(FloatBuffer floatBuffer) {
        FloatBuffer floatBuffer2 = NondirectBufferWrapper.lookupBuffer(floatBuffer);
        ((Buffer)floatBuffer2).limit(floatBuffer.limit());
        ((Buffer)floatBuffer2).position(floatBuffer.position());
        return floatBuffer2;
    }

    private static LongBuffer doNoCopyWrap(LongBuffer longBuffer) {
        LongBuffer longBuffer2 = NondirectBufferWrapper.lookupBuffer(longBuffer);
        ((Buffer)longBuffer2).limit(longBuffer.limit());
        ((Buffer)longBuffer2).position(longBuffer.position());
        return longBuffer2;
    }

    private static DoubleBuffer doNoCopyWrap(DoubleBuffer doubleBuffer) {
        DoubleBuffer doubleBuffer2 = NondirectBufferWrapper.lookupBuffer(doubleBuffer);
        ((Buffer)doubleBuffer2).limit(doubleBuffer.limit());
        ((Buffer)doubleBuffer2).position(doubleBuffer.position());
        return doubleBuffer2;
    }

    private static ByteBuffer lookupBuffer(ByteBuffer byteBuffer) {
        return a.a(NondirectBufferWrapper.getCachedBuffers(byteBuffer.remaining()));
    }

    private static ByteBuffer doWrap(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = NondirectBufferWrapper.lookupBuffer(byteBuffer);
        ((Buffer)byteBuffer2).clear();
        int n2 = byteBuffer.position();
        byteBuffer2.put(byteBuffer);
        ((Buffer)byteBuffer).position(n2);
        ((Buffer)byteBuffer2).flip();
        return byteBuffer2;
    }

    private static ShortBuffer lookupBuffer(ShortBuffer shortBuffer) {
        a a2 = NondirectBufferWrapper.getCachedBuffers(shortBuffer.remaining() * 2);
        if (shortBuffer.order() == ByteOrder.LITTLE_ENDIAN) {
            return a.a(a2);
        }
        return a.b(a2);
    }

    private static ShortBuffer doWrap(ShortBuffer shortBuffer) {
        ShortBuffer shortBuffer2 = NondirectBufferWrapper.lookupBuffer(shortBuffer);
        ((Buffer)shortBuffer2).clear();
        int n2 = shortBuffer.position();
        shortBuffer2.put(shortBuffer);
        ((Buffer)shortBuffer).position(n2);
        ((Buffer)shortBuffer2).flip();
        return shortBuffer2;
    }

    private static FloatBuffer lookupBuffer(FloatBuffer floatBuffer) {
        a a2 = NondirectBufferWrapper.getCachedBuffers(floatBuffer.remaining() * 4);
        if (floatBuffer.order() == ByteOrder.LITTLE_ENDIAN) {
            return a.a(a2);
        }
        return a.b(a2);
    }

    private static FloatBuffer doWrap(FloatBuffer floatBuffer) {
        FloatBuffer floatBuffer2 = NondirectBufferWrapper.lookupBuffer(floatBuffer);
        ((Buffer)floatBuffer2).clear();
        int n2 = floatBuffer.position();
        floatBuffer2.put(floatBuffer);
        ((Buffer)floatBuffer).position(n2);
        ((Buffer)floatBuffer2).flip();
        return floatBuffer2;
    }

    private static IntBuffer lookupBuffer(IntBuffer intBuffer) {
        a a2 = NondirectBufferWrapper.getCachedBuffers(intBuffer.remaining() * 4);
        if (intBuffer.order() == ByteOrder.LITTLE_ENDIAN) {
            return a.a(a2);
        }
        return a.b(a2);
    }

    private static IntBuffer doWrap(IntBuffer intBuffer) {
        IntBuffer intBuffer2 = NondirectBufferWrapper.lookupBuffer(intBuffer);
        ((Buffer)intBuffer2).clear();
        int n2 = intBuffer.position();
        intBuffer2.put(intBuffer);
        ((Buffer)intBuffer).position(n2);
        ((Buffer)intBuffer2).flip();
        return intBuffer2;
    }

    private static LongBuffer lookupBuffer(LongBuffer longBuffer) {
        a a2 = NondirectBufferWrapper.getCachedBuffers(longBuffer.remaining() * 8);
        if (longBuffer.order() == ByteOrder.LITTLE_ENDIAN) {
            return a.a(a2);
        }
        return a.b(a2);
    }

    private static LongBuffer doWrap(LongBuffer longBuffer) {
        LongBuffer longBuffer2 = NondirectBufferWrapper.lookupBuffer(longBuffer);
        ((Buffer)longBuffer2).clear();
        int n2 = longBuffer.position();
        longBuffer2.put(longBuffer);
        ((Buffer)longBuffer).position(n2);
        ((Buffer)longBuffer2).flip();
        return longBuffer2;
    }

    private static DoubleBuffer lookupBuffer(DoubleBuffer doubleBuffer) {
        a a2 = NondirectBufferWrapper.getCachedBuffers(doubleBuffer.remaining() * 8);
        if (doubleBuffer.order() == ByteOrder.LITTLE_ENDIAN) {
            return a.a(a2);
        }
        return a.b(a2);
    }

    private static DoubleBuffer doWrap(DoubleBuffer doubleBuffer) {
        DoubleBuffer doubleBuffer2 = NondirectBufferWrapper.lookupBuffer(doubleBuffer);
        ((Buffer)doubleBuffer2).clear();
        int n2 = doubleBuffer.position();
        doubleBuffer2.put(doubleBuffer);
        ((Buffer)doubleBuffer).position(n2);
        ((Buffer)doubleBuffer2).flip();
        return doubleBuffer2;
    }
}

