/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.NondirectBufferWrapper;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public class NVProgram {
    public static final int GL_PROGRAM_TARGET_NV = 34374;
    public static final int GL_PROGRAM_LENGTH_NV = 34343;
    public static final int GL_PROGRAM_RESIDENT_NV = 34375;
    public static final int GL_PROGRAM_STRING_NV = 34344;
    public static final int GL_PROGRAM_ERROR_POSITION_NV = 34379;
    public static final int GL_PROGRAM_ERROR_STRING_NV = 34932;

    public static void glLoadProgramNV(int n2, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.NV_program_glLoadProgramNV_pointer;
        BufferChecks.checkFunctionAddress(l2);
        byteBuffer = NondirectBufferWrapper.wrapDirect(byteBuffer);
        NVProgram.nglLoadProgramNV(n2, n3, byteBuffer.remaining(), byteBuffer, byteBuffer.position(), l2);
    }

    private static native void nglLoadProgramNV(int var0, int var1, int var2, Buffer var3, int var4, long var5);

    public static void glBindProgramNV(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.NV_program_glBindProgramNV_pointer;
        BufferChecks.checkFunctionAddress(l2);
        NVProgram.nglBindProgramNV(n2, n3, l2);
    }

    private static native void nglBindProgramNV(int var0, int var1, long var2);

    public static void glDeleteProgramsNV(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.NV_program_glDeleteProgramsNV_pointer;
        BufferChecks.checkFunctionAddress(l2);
        intBuffer = NondirectBufferWrapper.wrapDirect(intBuffer);
        NVProgram.nglDeleteProgramsNV(intBuffer.remaining(), intBuffer, intBuffer.position(), l2);
    }

    private static native void nglDeleteProgramsNV(int var0, IntBuffer var1, int var2, long var3);

    public static void glGenProgramsNV(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.NV_program_glGenProgramsNV_pointer;
        BufferChecks.checkFunctionAddress(l2);
        intBuffer = NondirectBufferWrapper.wrapDirect(intBuffer);
        NVProgram.nglGenProgramsNV(intBuffer.remaining(), intBuffer, intBuffer.position(), l2);
    }

    private static native void nglGenProgramsNV(int var0, IntBuffer var1, int var2, long var3);

    public static void glGetProgramNV(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.NV_program_glGetProgramivNV_pointer;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer2 = intBuffer;
        intBuffer = NondirectBufferWrapper.wrapNoCopyDirect(intBuffer);
        NVProgram.nglGetProgramivNV(n2, n3, intBuffer, intBuffer.position(), l2);
        NondirectBufferWrapper.copy(intBuffer, intBuffer2);
    }

    private static native void nglGetProgramivNV(int var0, int var1, IntBuffer var2, int var3, long var4);

    public static void glGetProgramStringNV(int n2, int n3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.NV_program_glGetProgramStringNV_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ByteBuffer byteBuffer2 = byteBuffer;
        byteBuffer = NondirectBufferWrapper.wrapNoCopyDirect(byteBuffer);
        NVProgram.nglGetProgramStringNV(n2, n3, byteBuffer, byteBuffer.position(), l2);
        NondirectBufferWrapper.copy(byteBuffer, byteBuffer2);
    }

    private static native void nglGetProgramStringNV(int var0, int var1, Buffer var2, int var3, long var4);

    public static boolean glIsProgramNV(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.NV_program_glIsProgramNV_pointer;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = NVProgram.nglIsProgramNV(n2, l2);
        return bl2;
    }

    private static native boolean nglIsProgramNV(int var0, long var1);

    public static boolean glAreProgramsResidentNV(IntBuffer intBuffer, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.NV_program_glAreProgramsResidentNV_pointer;
        BufferChecks.checkFunctionAddress(l2);
        if (intBuffer.remaining() != byteBuffer.remaining()) {
            throw new IllegalArgumentException("programIDs.remaining() != programResidences.remaining()");
        }
        intBuffer = NondirectBufferWrapper.wrapDirect(intBuffer);
        byteBuffer = NondirectBufferWrapper.wrapDirect(byteBuffer);
        boolean bl2 = NVProgram.nglAreProgramsResidentNV(intBuffer.remaining(), intBuffer, intBuffer.position(), byteBuffer, byteBuffer.position(), l2);
        return bl2;
    }

    private static native boolean nglAreProgramsResidentNV(int var0, IntBuffer var1, int var2, ByteBuffer var3, int var4, long var5);

    public static void glRequestResidentProgramsNV(IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.NV_program_glRequestResidentProgramsNV_pointer;
        BufferChecks.checkFunctionAddress(l2);
        intBuffer = NondirectBufferWrapper.wrapDirect(intBuffer);
        NVProgram.nglRequestResidentProgramsNV(intBuffer.remaining(), intBuffer, intBuffer.position(), l2);
    }

    private static native void nglRequestResidentProgramsNV(int var0, IntBuffer var1, int var2, long var3);
}

