/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEvent;
import net.java.games.input.ControllerListener;
import net.java.games.input.DefaultControllerEnvironment;

public abstract class ControllerEnvironment {
    private static ControllerEnvironment defaultEnvironment = new DefaultControllerEnvironment();
    protected final ArrayList controllerListeners = new ArrayList();

    static void logln(String string) {
    }

    protected ControllerEnvironment() {
    }

    public abstract Controller[] getControllers();

    public void addControllerListener(ControllerListener controllerListener) {
        if (controllerListener != null) {
            this.controllerListeners.add(controllerListener);
        }
    }

    public void removeControllerListener(ControllerListener controllerListener) {
        if (controllerListener != null) {
            ((AbstractCollection)this.controllerListeners).remove(controllerListener);
        }
    }

    protected void fireControllerAdded(Controller controller) {
        ControllerEvent controllerEvent = new ControllerEvent(controller);
        Iterator iterator = ((AbstractList)this.controllerListeners).iterator();
        while (iterator.hasNext()) {
            ((ControllerListener)iterator.next()).controllerAdded(controllerEvent);
        }
    }

    protected void fireControllerRemoved(Controller controller) {
        ControllerEvent controllerEvent = new ControllerEvent(controller);
        Iterator iterator = ((AbstractList)this.controllerListeners).iterator();
        while (iterator.hasNext()) {
            ((ControllerListener)iterator.next()).controllerRemoved(controllerEvent);
        }
    }

    public static ControllerEnvironment getDefaultEnvironment() {
        return defaultEnvironment;
    }
}

