/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class StyledTextDropTargetEffect
extends DropTargetEffect {
    static final int CARET_WIDTH = 2;
    static final int SCROLL_HYSTERESIS = 100;
    static final int SCROLL_TOLERANCE = 20;
    int currentOffset = -1;
    long scrollBeginTime;
    int scrollX = -1;
    int scrollY = -1;
    Listener paintListener = new Listener(){

        public void handleEvent(Event event) {
            if (StyledTextDropTargetEffect.this.currentOffset != -1) {
                StyledText styledText = (StyledText)StyledTextDropTargetEffect.this.getControl();
                Point point = styledText.getLocationAtOffset(StyledTextDropTargetEffect.this.currentOffset);
                int n2 = styledText.getLineHeight(StyledTextDropTargetEffect.this.currentOffset);
                event.gc.setBackground(event.display.getSystemColor(2));
                event.gc.fillRectangle(point.x, point.y, 2, n2);
            }
        }
    };

    public StyledTextDropTargetEffect(StyledText styledText) {
        super(styledText);
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.currentOffset = -1;
        this.scrollBeginTime = 0L;
        this.scrollX = -1;
        this.scrollY = -1;
        this.getControl().removeListener(9, this.paintListener);
        this.getControl().addListener(9, this.paintListener);
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        StyledText styledText = (StyledText)this.getControl();
        if (this.currentOffset != -1) {
            this.refreshCaret(styledText, this.currentOffset, -1);
        }
        styledText.removeListener(9, this.paintListener);
        this.scrollBeginTime = 0L;
        this.scrollX = -1;
        this.scrollY = -1;
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        int n6 = dropTargetEvent.feedback;
        StyledText styledText = (StyledText)this.getControl();
        Point point = styledText.getDisplay().map(null, styledText, dropTargetEvent.x, dropTargetEvent.y);
        if ((n6 & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollY = -1;
            this.scrollX = -1;
        } else if (styledText.getCharCount() == 0) {
            this.scrollBeginTime = 0L;
            this.scrollY = -1;
            this.scrollX = -1;
        } else if (this.scrollX != -1 && this.scrollY != -1 && this.scrollBeginTime != 0L && (point.x >= this.scrollX && point.x <= this.scrollX + 20 || point.y >= this.scrollY && point.y <= this.scrollY + 20)) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                object = styledText.getClientArea();
                Rectangle rectangle = styledText.getTextBounds(0, 0);
                n5 = rectangle.width;
                n4 = 10 * n5;
                if (point.x < ((Rectangle)object).x + 3 * n5) {
                    n3 = styledText.getHorizontalPixel();
                    styledText.setHorizontalPixel(n3 - n4);
                    if (styledText.getHorizontalPixel() != n3) {
                        styledText.redraw();
                    }
                }
                if (point.x > ((Rectangle)object).width - 3 * n5) {
                    n3 = styledText.getHorizontalPixel();
                    styledText.setHorizontalPixel(n3 + n4);
                    if (styledText.getHorizontalPixel() != n3) {
                        styledText.redraw();
                    }
                }
                if (point.y < ((Rectangle)object).y + (n3 = rectangle.height)) {
                    n2 = styledText.getTopPixel();
                    styledText.setTopPixel(n2 - n3);
                    if (styledText.getTopPixel() != n2) {
                        styledText.redraw();
                    }
                }
                if (point.y > ((Rectangle)object).height - n3) {
                    n2 = styledText.getTopPixel();
                    styledText.setTopPixel(n2 + n3);
                    if (styledText.getTopPixel() != n2) {
                        styledText.redraw();
                    }
                }
                this.scrollBeginTime = 0L;
                this.scrollY = -1;
                this.scrollX = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 100L;
            this.scrollX = point.x;
            this.scrollY = point.y;
        }
        if ((n6 & 1) != 0) {
            object = styledText.getContent();
            int n7 = -1;
            try {
                n7 = styledText.getOffsetAtLocation(point);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                n5 = object.getCharCount();
                Point point2 = styledText.getLocationAtOffset(n5);
                if (point.y >= point2.y) {
                    try {
                        n7 = styledText.getOffsetAtLocation(new Point(point.x, point2.y));
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        n7 = n5;
                    }
                }
                try {
                    n3 = styledText.getOffsetAtLocation(new Point(0, point.y));
                    n2 = n5;
                    int n8 = object.getLineAtOffset(n3);
                    int n9 = object.getLineCount();
                    if (n8 + 1 < n9) {
                        n2 = object.getOffsetAtLine(n8 + 1) - 1;
                    }
                    int n10 = styledText.getLineHeight(n3);
                    int n11 = n2;
                    while (n11 >= n3) {
                        Point point3 = styledText.getLocationAtOffset(n11);
                        if (point3.x < point.x && point3.y < point.y && point3.y + n10 > point.y) {
                            n7 = n11;
                        }
                        --n11;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    n7 = -1;
                }
            }
            if (n7 != -1 && n7 != this.currentOffset) {
                n5 = object.getLineAtOffset(n7);
                n4 = object.getOffsetAtLine(n5);
                n3 = n7 - n4;
                if (n3 > object.getLine(n5).length()) {
                    n7 = Math.max(0, n7 - 1);
                }
                this.refreshCaret(styledText, this.currentOffset, n7);
                this.currentOffset = n7;
            }
        }
    }

    void refreshCaret(StyledText styledText, int n2, int n3) {
        if (n2 != n3) {
            int n4;
            Point point;
            if (n2 != -1) {
                point = styledText.getLocationAtOffset(n2);
                n4 = styledText.getLineHeight(n2);
                styledText.redraw(point.x, point.y, 2, n4, false);
            }
            if (n3 != -1) {
                point = styledText.getLocationAtOffset(n3);
                n4 = styledText.getLineHeight(n3);
                styledText.redraw(point.x, point.y, 2, n4, false);
            }
        }
    }

    public void dropAccept(DropTargetEvent dropTargetEvent) {
        if (this.currentOffset != -1) {
            StyledText styledText = (StyledText)this.getControl();
            styledText.setSelection(this.currentOffset);
            this.currentOffset = -1;
        }
    }
}

