/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.PngChunk;
import org.eclipse.swt.internal.image.PngFileReadState;
import org.eclipse.swt.internal.image.PngIhdrChunk;

public class PngPlteChunk
extends PngChunk {
    int paletteSize;

    PngPlteChunk(PaletteData paletteData) {
        super(paletteData.getRGBs().length * 3);
        this.paletteSize = this.length / 3;
        this.setType(PngChunk.TYPE_PLTE);
        this.setPaletteData(paletteData);
        this.setCRC(this.computeCRC());
    }

    PngPlteChunk(byte[] byArray) {
        super(byArray);
        this.paletteSize = this.length / 3;
    }

    int getChunkType() {
        return 1;
    }

    int getPaletteSize() {
        return this.paletteSize;
    }

    PaletteData getPaletteData() {
        RGB[] rGBArray = new RGB[this.paletteSize];
        for (int i2 = 0; i2 < rGBArray.length; ++i2) {
            int n2 = 8 + i2 * 3;
            int n3 = this.reference[n2] & 0xFF;
            int n4 = this.reference[n2 + 1] & 0xFF;
            int n5 = this.reference[n2 + 2] & 0xFF;
            rGBArray[i2] = new RGB(n3, n4, n5);
        }
        return new PaletteData(rGBArray);
    }

    void setPaletteData(PaletteData paletteData) {
        RGB[] rGBArray = paletteData.getRGBs();
        for (int i2 = 0; i2 < rGBArray.length; ++i2) {
            int n2 = 8 + i2 * 3;
            this.reference[n2] = (byte)rGBArray[i2].red;
            this.reference[n2 + 1] = (byte)rGBArray[i2].green;
            this.reference[n2 + 2] = (byte)rGBArray[i2].blue;
        }
    }

    void validate(PngFileReadState pngFileReadState, PngIhdrChunk pngIhdrChunk) {
        if (!pngFileReadState.readIHDR || pngFileReadState.readPLTE || pngFileReadState.readTRNS || pngFileReadState.readIDAT || pngFileReadState.readIEND) {
            SWT.error(40);
        } else {
            pngFileReadState.readPLTE = true;
        }
        super.validate(pngFileReadState, pngIhdrChunk);
        if (this.getLength() % 3 != 0) {
            SWT.error(40);
        }
        if (1 << pngIhdrChunk.getBitDepth() < this.paletteSize) {
            System.out.println("**** PngDecoding Error! --PaletteSize:" + this.paletteSize + ",BitDepth:" + pngIhdrChunk.getBitDepth() + ", use pngout ??  ****");
        }
        if (256 < this.paletteSize) {
            SWT.error(40);
        }
    }

    void contributeToString(StringBuffer stringBuffer) {
        stringBuffer.append("\n\tPalette size:");
        stringBuffer.append(this.paletteSize);
    }
}

